/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;

public final class IfxToJavaType {
    public static final int DAYS1900 = 693594;
    public static final int DAYS4CENT = 146097;
    public static final int DAYS4YEAR = 1461;
    public static byte[] daymon = new byte[13];
    private static Calendar Cal;

    public static String IfxToJavaChar(byte[] b, short prec) {
        String s = new String(b);
        return s;
    }

    public static String IfxToJavaChar(byte[] b, short prec, String dbEnc) throws IOException {
        String s = null;
        s = dbEnc != null ? new String(b, dbEnc == "ISO2022CN_GB" ? "ISO2022CN" : dbEnc) : new String(b);
        return s;
    }

    public static Date IfxToJavaDate(byte[] b, short prec) {
        int dt = IfxToJavaType.IfxToJavaInt(b, prec);
        if (dt == Integer.MIN_VALUE) {
            return null;
        }
        return IfxToJavaType.convertDaysToDate(dt);
    }

    public static final boolean rleapyear(int yr) {
        return (yr & 3) == 0 && (yr % 400 == 0 || yr % 100 != 0);
    }

    public static Date convertDaysToDate(int dt) {
        int jdate = dt + 693594;
        int lyear = (jdate * 4 + 3) / 146097;
        jdate -= lyear * 146097 / 4;
        int year = lyear * 100;
        lyear = (jdate * 4 + 3) / 1461;
        int day = (jdate -= lyear * 1461 / 4) + 1;
        IfxToJavaType.daymon[2] = IfxToJavaType.rleapyear(year += lyear + 1) ? 29 : 28;
        int mon = 1;
        while (mon <= 12) {
            if (day <= daymon[mon]) break;
            day -= daymon[mon];
            ++mon;
        }
        Date d = new Date(year - 1900, mon - 1, day);
        return d;
    }

    public static synchronized int convertDateToDays(Date dt) {
        Cal.setTime(dt);
        int mon = Cal.get(2) + 1;
        int day = Cal.get(5);
        int year = Cal.get(1);
        IfxToJavaType.daymon[2] = IfxToJavaType.rleapyear(year) ? 29 : 28;
        int lyear = year - 1;
        int jdate = lyear / 100 * 146097 / 4 + lyear % 100 * 1461 / 4 + day - 1 - 693594;
        int i = 1;
        while (i < mon) {
            jdate += daymon[i];
            ++i;
        }
        return jdate;
    }

    public static Timestamp IfxToJavaDateTime(byte[] b, short prec) {
        Decimal d = new Decimal(b, prec, true);
        return d.timestampValue();
    }

    public static Interval IfxToJavaInterval(byte[] b, short prec) {
        Decimal d = new Decimal(b, prec, true);
        if (d.dec_pos == -1) {
            return null;
        }
        return d.intervalValue();
    }

    public static BigDecimal IfxToJavaDecimal(byte[] b, short prec) {
        Decimal d = new Decimal(b, prec);
        return d.numericValue();
    }

    public static double IfxToJavaDouble(byte[] b, short prec) {
        long val = (long)b[0] << 56 | (long)b[1] << 48 & 0xFF000000000000L | (long)b[2] << 40 & 0xFF0000000000L | (long)b[3] << 32 & 0xFF00000000L | (long)b[4] << 24 & 0xFF000000L | (long)b[5] << 16 & 0xFF0000L | (long)b[6] << 8 & 0xFF00L | (long)b[7] & 0xFFL;
        return Double.longBitsToDouble(val);
    }

    public static float IfxToJavaReal(byte[] b, short prec) {
        int val = IfxToJavaType.IfxToJavaInt(b, (short)0);
        return Float.intBitsToFloat(val);
    }

    protected static final short widenByte(byte b) {
        return (short)((short)b & 0xFF);
    }

    public static short IfxToJavaSmallInt(byte[] b, short prec) {
        short s = b[0];
        s = (short)((s << 8) + IfxToJavaType.widenByte(b[1]));
        return s;
    }

    public static int IfxToJavaInt(byte[] b, short prec) {
        int i = b[0];
        i = (((i << 8) + IfxToJavaType.widenByte(b[1]) << 8) + IfxToJavaType.widenByte(b[2]) << 8) + IfxToJavaType.widenByte(b[3]);
        return i;
    }

    public static long IfxToJavaLongInt(byte[] buf, short prec) {
        long l = 0L;
        byte[] bInt = new byte[4];
        byte[] bUInt = new byte[4];
        byte[] bSign = new byte[2];
        byte[] bint8 = new byte[8];
        int mask = 255;
        System.arraycopy(buf, 0, bSign, 0, 2);
        short sign = IfxToJavaType.IfxToJavaSmallInt(bSign, prec);
        System.arraycopy(buf, 2, bInt, 0, 4);
        System.arraycopy(buf, 6, bUInt, 0, 4);
        bint8[0] = bUInt[0];
        bint8[1] = (byte)(mask & (short)bUInt[1]);
        bint8[2] = (byte)(mask & (short)bUInt[2]);
        bint8[3] = (byte)(mask & (short)bUInt[3]);
        bint8[4] = (byte)(mask & (short)bInt[0]);
        bint8[5] = (byte)(mask & (short)bInt[1]);
        bint8[6] = (byte)(mask & (short)bInt[2]);
        bint8[7] = (byte)(mask & (short)bInt[3]);
        BigInteger bi = new BigInteger(bint8);
        l = bi.longValue();
        if (sign == 0) {
            l = Long.MIN_VALUE;
        } else if (sign == -1) {
            l *= -1L;
        }
        return l;
    }

    static {
        IfxToJavaType.daymon[0] = 0;
        IfxToJavaType.daymon[1] = 31;
        IfxToJavaType.daymon[2] = 28;
        IfxToJavaType.daymon[3] = 31;
        IfxToJavaType.daymon[4] = 30;
        IfxToJavaType.daymon[5] = 31;
        IfxToJavaType.daymon[6] = 30;
        IfxToJavaType.daymon[7] = 31;
        IfxToJavaType.daymon[8] = 31;
        IfxToJavaType.daymon[9] = 30;
        IfxToJavaType.daymon[10] = 31;
        IfxToJavaType.daymon[11] = 30;
        IfxToJavaType.daymon[12] = 31;
        Cal = Calendar.getInstance();
    }
}

