/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Decimal {
    private static final int NUM_FRACT_DIGITS = 5;
    public static final String digChar = "0123456789";
    public static final int DEC_T_SIZE = 22;
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    protected short dec_exp;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts;
    protected byte[] dec_dgts;
    protected int lenOfFirstField;
    protected short precStored;
    protected byte pdigs = 0;
    protected byte pscale = 0;
    protected boolean timestamp = false;
    protected byte startCode = 0;
    protected byte endCode = (byte)15;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    public static Hashtable TU_Exp_Table = new Hashtable(12, 1.0f);

    public Decimal() {
    }

    public Decimal(short exp, short pos, short ndgts, byte[] d) {
        this.dec_exp = exp;
        this.dec_pos = pos;
        this.dec_ndgts = ndgts;
        if (d != null) {
            this.dec_dgts = d;
        } else {
            this.dec_dgts = new byte[ndgts > 0 ? ndgts : (short)1];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(byte[] cp) {
        byte[] cpd = new byte[cp.length - 2];
        int i = 2;
        while (i < cp.length) {
            cpd[i - 2] = cp[i];
            ++i;
        }
        this.init(cpd, (short)0);
    }

    public Decimal(byte[] cp, short prec) {
        this.init(cp, prec);
    }

    public Decimal(byte[] cp, short prec, boolean ts) {
        this.timestamp = ts;
        this.init(cp, prec);
    }

    public Decimal(String num) {
        int first = 0;
        int exp = 0;
        int buflen = num.length();
        boolean decPt = false;
        int upnxt = 0;
        this.dec_pos = 1;
        char nxt = num.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
        } else if (nxt == '+') {
            ++first;
        }
        if (first > 0) {
            --buflen;
        }
        int i = first;
        while (i < num.length() && num.charAt(i) != '.') {
            ++exp;
            ++i;
        }
        if (i != num.length()) {
            decPt = true;
            --buflen;
            exp += this.extractExponent(num, i);
        }
        if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        if (buflen % 2 == 1) {
            ++buflen;
        }
        byte[] unpack = new byte[buflen];
        Decimal.byfill(unpack, (byte)0);
        i = 0;
        while (i < num.length() && num.charAt(i) != 'E') {
            int ind = digChar.indexOf(num.charAt(i));
            if (ind != -1) {
                unpack[upnxt] = (byte)ind;
                ++upnxt;
            }
            ++i;
        }
        this.dec_ndgts = (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int j = 0;
        while (j < this.dec_dgts.length) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
            ++j;
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] temp = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(temp, 0, this.dec_dgts, 0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(String num, short inPrec) {
        int first = 0;
        int exp = 0;
        int buflen = num.length();
        boolean decPt = false;
        int upnxt = 0;
        this.dec_pos = 1;
        char nxt = num.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
        } else if (nxt == '+') {
            ++first;
        }
        if (first > 0) {
            --buflen;
        }
        int i = first;
        while (i < num.length() && num.charAt(i) != '.') {
            ++exp;
            ++i;
        }
        if (i != num.length()) {
            decPt = true;
            --buflen;
            exp += this.extractExponent(num, i);
        }
        if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        if (buflen % 2 == 1) {
            ++buflen;
        }
        byte[] unpack = new byte[buflen];
        Decimal.byfill(unpack, (byte)0);
        i = 0;
        while (i < num.length() && num.charAt(i) != 'E') {
            int ind = digChar.indexOf(num.charAt(i));
            if (ind != -1) {
                unpack[upnxt] = (byte)ind;
                ++upnxt;
            }
            ++i;
        }
        this.dec_ndgts = (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int j = 0;
        while (j < this.dec_dgts.length) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
            ++j;
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] temp = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(temp, 0, this.dec_dgts, 0);
        }
        this.dec_exp = (short)((Decimal.tuLen(inPrec) + 10 - Decimal.tuEnd((byte)inPrec) + 1) / 2);
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(BigDecimal n) {
        this(n.toString());
        this.pscale = (byte)n.scale();
    }

    public final void setTimestampQualifier(short qualifier) {
        this.setT();
        this.precStored = qualifier;
        this.unpackPrecision(qualifier);
    }

    public final void setT() {
        this.timestamp = true;
    }

    public final void unpackPrecision(short prec) {
        this.pdigs = (byte)(prec >> 8);
        if (!this.timestamp) {
            this.pscale = (byte)(prec & 0xFF);
        } else {
            byte code = (byte)(prec & 0xF);
            if (code > 10) {
                this.pscale = (byte)(code - 10);
            } else {
                code = 0;
            }
            byte code2 = (byte)(prec & 0xFF);
            this.startCode = (byte)(code2 >> 4 & 0xF);
            this.endCode = (byte)(code2 & 0xF);
            this.lenOfFirstField = Decimal.tuFLen(prec);
        }
    }

    protected void computePrecision() {
        this.pdigs = (byte)(this.dec_ndgts * 2);
    }

    protected void computeScale() {
        this.pscale = (byte)((this.dec_ndgts - this.dec_exp) * 2);
    }

    public byte[] getPrecision() {
        byte[] prec = new byte[]{this.pdigs, this.pscale};
        return prec;
    }

    protected void init(byte[] cp, short prec) {
        if (cp[0] == 0 && cp[1] == 0) {
            return;
        }
        this.precStored = prec;
        this.unpackPrecision(prec);
        this.dec_dgts = new byte[cp.length - 1];
        Decimal.bycopy(cp, 1, this.dec_dgts, 0);
        short expon = cp[0];
        this.dec_pos = 1;
        if ((expon & 0x80) == 0) {
            Decimal.decComplement(this.dec_dgts, 0);
            expon = (short)(expon ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = expon = (short)((expon & 0x7F) - 64);
        boolean allZero = true;
        int i = 1;
        while (i < cp.length) {
            if (cp[i] != 0) {
                allZero = false;
                break;
            }
            ++i;
        }
        this.dec_ndgts = allZero ? (short)0 : (short)(cp.length - 1);
        if (this.pdigs == 0) {
            this.computePrecision();
        }
        if (this.pscale == 0) {
            this.computeScale();
        }
    }

    protected int extractExponent(String num, int start) {
        int exp = 0;
        boolean sign = true;
        int i = start;
        while (i < num.length() && num.charAt(i) != 'E') {
            ++i;
        }
        if (i == num.length()) {
            return exp;
        }
        if (num.charAt(++i) == '+') {
            ++i;
        } else if (num.charAt(i) == '-') {
            ++i;
            sign = false;
        }
        int j = i;
        while (j < num.length()) {
            exp = exp * 10 + digChar.indexOf(num.charAt(j));
            ++j;
        }
        return sign ? exp : -exp;
    }

    public static byte[] byfill(byte[] b, byte f) {
        int i = 0;
        while (i < b.length) {
            b[i] = f;
            ++i;
        }
        return b;
    }

    public static char[] charfill(char[] b, int from, int to, char f) {
        int i = from;
        while (i <= to && i < b.length) {
            b[i] = f;
            ++i;
        }
        return b;
    }

    public static void bycopy(byte[] from, int fromStart, byte[] to, int toStart) {
        int j = toStart;
        int i = fromStart;
        while (i < from.length && j < to.length) {
            to[j] = from[i];
            ++i;
            ++j;
        }
    }

    public static void charcopy(char[] from, int fromStart, int fromEnd, char[] to, int toStart) {
        int j = toStart;
        int i = fromStart;
        while (i < from.length && i <= fromEnd && j < to.length) {
            to[j] = from[i];
            ++i;
            ++j;
        }
    }

    public static byte[] decComplement(byte[] b, int start) {
        int digit = 100;
        int bp = b.length - 1;
        while (bp >= start) {
            if (b[bp] != 0 || digit != 100) {
                b[bp] = (byte)(digit - b[bp]);
                digit = 99;
            }
            --bp;
        }
        return b;
    }

    public byte[] javaToIfx() {
        byte[] cp = new byte[this.dec_ndgts + 3];
        boolean bp = false;
        Decimal.byfill(cp, (byte)0);
        int len = this.dec_ndgts + 1;
        cp[0] = (byte)(len >> 8 & 0xFF);
        cp[1] = (byte)(len & 0xFF);
        if (this.dec_pos == -1) {
            return cp;
        }
        cp[2] = (byte)(this.dec_exp + 64 & 0x7F);
        Decimal.bycopy(this.dec_dgts, 0, cp, 3);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                cp[2] = (byte)(cp[2] | 0x80);
            } else {
                Decimal.decComplement(cp, 3);
                cp[2] = (byte)(cp[2] ^ 0x7F);
            }
        } else {
            cp[2] = (byte)(cp[2] | 0x80);
        }
        return cp;
    }

    public byte[] javaToDec_t() {
        byte[] b = new byte[22];
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_exp), 0, b, 0, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_pos), 0, b, 2, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_ndgts), 0, b, 4, 2);
        if (this.dec_dgts == null) {
            this.dec_dgts = new byte[16];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        System.arraycopy(this.dec_dgts, 0, b, 6, this.dec_dgts.length);
        return b;
    }

    public static Decimal dec_tToJava(byte[] b) {
        byte[] bExp = new byte[2];
        byte[] bPos = new byte[2];
        byte[] bNdgts = new byte[2];
        byte[] bDgts = new byte[16];
        System.arraycopy(b, 0, bExp, 0, 2);
        System.arraycopy(b, 2, bPos, 0, 2);
        System.arraycopy(b, 4, bNdgts, 0, 2);
        System.arraycopy(b, 6, bDgts, 0, 16);
        short dec_exp = IfxToJavaType.IfxToJavaSmallInt(bExp, (short)0);
        short dec_pos = IfxToJavaType.IfxToJavaSmallInt(bPos, (short)0);
        short dec_ndgts = IfxToJavaType.IfxToJavaSmallInt(bNdgts, (short)0);
        return new Decimal(dec_exp, dec_pos, dec_ndgts, bDgts);
    }

    public char[] sigdigToChar() {
        char[] digits = new char[this.dec_ndgts * 2];
        int i = 0;
        while (i < this.dec_ndgts) {
            digits[i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            digits[i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
            ++i;
        }
        return digits;
    }

    public int sigdigToInt(int from, int to) {
        int val = 0;
        int i = from;
        while (i <= to) {
            val = val * 100 + this.dec_dgts[i];
            ++i;
        }
        return val;
    }

    public BigDecimal numericValue() {
        if (this.dec_pos == -1) {
            return new BigDecimal("");
        }
        BigDecimal num = new BigDecimal(this.stringValue());
        return num;
    }

    public boolean isNull() {
        return this.dec_pos == -1;
    }

    public final Double doubleValue() {
        return new Double(this.numericValue().doubleValue());
    }

    public final Float floatValue() {
        return new Float(this.numericValue().floatValue());
    }

    public String stringValue() {
        char[] buf;
        if (this.dec_pos == -1) {
            return "";
        }
        int exp = this.dec_exp * 2;
        int whereDot = -1;
        if (this.dec_ndgts <= 0 && this.dec_exp == 0) {
            return "0.0";
        }
        char[] sigDig = this.sigdigToChar();
        if (exp > 0) {
            if (exp <= sigDig.length) {
                buf = new char[sigDig.length + 2];
                Decimal.charcopy(sigDig, 0, exp - 1, buf, 1);
                buf[exp + 1] = 46;
                if (exp != sigDig.length) {
                    Decimal.charcopy(sigDig, exp, sigDig.length - 1, buf, exp + 2);
                }
            } else {
                buf = new char[exp + 2];
                Decimal.charcopy(sigDig, 0, sigDig.length - 1, buf, 1);
                Decimal.charfill(buf, sigDig.length + 1, exp, '0');
                buf[exp + 1] = 46;
            }
        } else {
            buf = new char[(exp *= -1) + sigDig.length + 3];
            buf[1] = 48;
            buf[2] = 46;
            Decimal.charfill(buf, 3, exp + 2, '0');
            Decimal.charcopy(sigDig, 0, sigDig.length, buf, exp + 3);
        }
        char[] tbuf = Decimal.trimZerosFB(buf, 1);
        tbuf[0] = this.dec_pos == 1 ? 48 : 45;
        return new String(tbuf);
    }

    protected static char[] trimZerosFB(char[] ibuf, int start) {
        int left = start;
        while (left < ibuf.length && ibuf[left] == '0') {
            ++left;
        }
        if (left == ibuf.length) {
            char[] obuf2 = new char[2];
            obuf2[1] = 48;
            return obuf2;
        }
        int right = ibuf.length - 1;
        while (right >= left && ibuf[right] == '0') {
            --right;
        }
        char[] obuf = new char[right - left + 2];
        int j = 1;
        int i = left;
        while (i <= right) {
            obuf[j] = ibuf[i];
            ++i;
            ++j;
        }
        return obuf;
    }

    public static byte[] fromBindToTuple(byte[] bindFormat, short qual) {
        byte dgt_len = (byte)(qual >> 8 & 0xFF);
        byte TU_end = (byte)(qual & 0xF);
        byte len = (byte)((dgt_len + (TU_end & 1) + 1) / 2);
        byte bindExp = (byte)((bindFormat[2] & 0x7F) - 64);
        byte expForTU_end = ((Integer)TU_Exp_Table.get(new Integer(TU_end))).byteValue();
        byte[] ret = new byte[len + 1];
        byte Cnt = len;
        byte i = (byte)(bindExp - expForTU_end + 2);
        while (Cnt > 0) {
            ret[Cnt] = i <= 2 || i >= bindFormat.length ? (byte)0 : bindFormat[i];
            i = (byte)(i - 1);
            Cnt = (byte)(Cnt - 1);
        }
        ret[0] = (byte)(len + expForTU_end + 64);
        ret[0] = (byte)(ret[0] | bindFormat[2] & 0x80);
        return ret;
    }

    public static byte tuEnd(byte c) {
        byte b = (byte)(c & 0xF);
        return b;
    }

    public static byte tuStart(byte c) {
        byte b = (byte)(c >> 4 & 0xF);
        return b;
    }

    public static byte tuLen(short c) {
        byte b = (byte)(c >> 8 & 0xFF);
        return b;
    }

    public static byte[] encodeDateTimePrecision(byte[] b, byte s, byte e) {
        b[0] = (byte)(e - s + (s == 0 ? 4 : 2));
        b[1] = (byte)(s << 4 | e);
        return b;
    }

    public static byte[] encodeIntervalPrecision(byte[] b, byte len, byte s, byte e) {
        b[0] = (byte)(e - s + len);
        b[1] = (byte)(s << 4 | e);
        return b;
    }

    public static int tuFLen(short len) {
        byte b1 = Decimal.tuLen(len);
        byte b2 = Decimal.tuEnd((byte)len);
        byte b3 = Decimal.tuStart((byte)len);
        int i = b1 - (b2 - b3);
        return i;
    }

    public Timestamp timestampValue() {
        if (!this.timestamp) {
            return null;
        }
        if (this.dec_pos == -1) {
            return null;
        }
        int[] timeData = new int[7];
        int i = 0;
        while (i < 7) {
            timeData[i] = 0;
            ++i;
        }
        int start = Interval.getStartCode(this.precStored);
        if (start != 0) {
            Date nowDate = new Date();
            GregorianCalendar now = new GregorianCalendar();
            now.setTime(nowDate);
            int i2 = 0;
            while (i2 < start) {
                switch (i2) {
                    case 0: {
                        timeData[0] = now.get(1);
                        break;
                    }
                    case 2: {
                        timeData[1] = now.get(2) + 1;
                        break;
                    }
                    case 4: {
                        timeData[2] = now.get(5);
                        break;
                    }
                    case 6: {
                        timeData[3] = now.get(11);
                        break;
                    }
                    case 8: {
                        timeData[4] = now.get(12);
                        break;
                    }
                    case 10: {
                        timeData[5] = now.get(13);
                        break;
                    }
                }
                i2 += 2;
            }
        }
        this.fromIfxToArray(timeData);
        GregorianCalendar gcalDate = new GregorianCalendar(timeData[0], timeData[1] - 1, timeData[2], timeData[3], timeData[4], timeData[5]);
        long lTime = gcalDate.getTime().getTime();
        Timestamp ts = new Timestamp(lTime);
        ts.setNanos(timeData[6]);
        return ts;
    }

    public Interval intervalValue() {
        int start = Interval.getStartCode(this.precStored);
        byte end = Interval.getEndCode(this.precStored);
        int[] invFields = new int[7];
        int index = 0;
        while (index < 7) {
            invFields[index] = 0;
            ++index;
        }
        this.fromIfxToArray(invFields);
        index = start > 10 ? 6 : start / 2;
        long total = 0L;
        long nanos = 0L;
        int i = start;
        while (i < 11) {
            switch (i) {
                case 0: {
                    total += (long)invFields[index] * 12L;
                    break;
                }
                case 2: {
                    total += (long)invFields[index];
                    break;
                }
                case 4: {
                    total += (long)invFields[index] * 86400L;
                    break;
                }
                case 6: {
                    total += (long)invFields[index] * 3600L;
                    break;
                }
                case 8: {
                    total += (long)invFields[index] * 60L;
                    break;
                }
                case 10: {
                    total += (long)invFields[index];
                    break;
                }
            }
            i += 2;
            ++index;
        }
        nanos = invFields[6];
        if (this.dec_pos == 0) {
            total *= -1L;
            nanos *= -1L;
        }
        Interval inv = null;
        try {
            inv = start >= 4 ? new IntervalDF(total, nanos, this.precStored) : new IntervalYM((int)total, this.precStored);
        }
        catch (Exception exception) {
            return null;
        }
        return inv;
    }

    void fromIfxToArray(int[] dataArray) {
        short len = Interval.getLength(this.precStored);
        byte start = Interval.getStartCode(this.precStored);
        byte end = Interval.getEndCode(this.precStored);
        short flen = (short)(len - (end - start));
        byte currentField = 0;
        int currentValue = 0;
        int dtbufIndex = 0;
        int dataIndex = 0;
        dataIndex = start > 10 ? 6 : start / 2;
        int i = this.dec_ndgts - 1;
        while (i > 0) {
            if (this.dec_dgts[i] != 0) break;
            this.dec_ndgts = (short)(this.dec_ndgts - 1);
            --i;
        }
        int btimebcnt = (len + (end & 1) + 1) / 2;
        int bexpon = (len + 10 - end + 1) / 2;
        byte[] dtbuf = new byte[btimebcnt];
        Decimal.byfill(dtbuf, (byte)0);
        if (this.dec_ndgts > 0 && bexpon >= this.dec_exp) {
            System.arraycopy(this.dec_dgts, 0, dtbuf, bexpon - this.dec_exp, this.dec_ndgts);
        }
        if ((currentField = start) != 12) {
            int i2 = flen / 2;
            if ((flen & 1) > 0) {
                ++i2;
            }
            while (dtbufIndex < i2) {
                currentValue *= 100;
                currentValue += dtbuf[dtbufIndex];
                ++dtbufIndex;
            }
            currentField = (byte)(currentField + 2);
            dataArray[dataIndex++] = currentValue;
        }
        while (currentField <= end && currentField <= 10) {
            dataArray[dataIndex++] = dtbuf[dtbufIndex];
            currentField = (byte)(currentField + 2);
            ++dtbufIndex;
        }
        currentValue = 0;
        if (end > 10) {
            currentField = 11;
            while (currentField <= end) {
                currentValue *= 100;
                currentValue += dtbuf[dtbufIndex];
                ++dtbufIndex;
                currentField = (byte)(currentField + 2);
            }
            int fractionNumber = 15 - end - 1 + 4;
            if ((fractionNumber & 1) == 0) {
                ++fractionNumber;
            }
            int i3 = 0;
            while (i3 < fractionNumber) {
                currentValue *= 10;
                ++i3;
            }
            dataArray[dataIndex] = currentValue;
        }
    }

    public static Decimal numericToDecimal(BigDecimal n) {
        return new Decimal(n);
    }

    static {
        TU_Exp_Table.put(new Integer(0), new Integer(5));
        TU_Exp_Table.put(new Integer(2), new Integer(4));
        TU_Exp_Table.put(new Integer(4), new Integer(3));
        TU_Exp_Table.put(new Integer(6), new Integer(2));
        TU_Exp_Table.put(new Integer(8), new Integer(1));
        TU_Exp_Table.put(new Integer(10), new Integer(0));
        TU_Exp_Table.put(new Integer(11), new Integer(-1));
        TU_Exp_Table.put(new Integer(12), new Integer(-1));
        TU_Exp_Table.put(new Integer(13), new Integer(-2));
        TU_Exp_Table.put(new Integer(14), new Integer(-2));
        TU_Exp_Table.put(new Integer(15), new Integer(-3));
    }
}

