/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.IfxJNSException;
import com.informix.jns.LdapSqlhosts;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class FileSqlhosts {
    final String bGroupOpt = "g";
    final String eGroupOpt = "e";
    final char cmtChar = (char)35;
    String fileName;
    Vector srvrVect = new Vector();
    Hashtable srvrList = new Hashtable();
    Hashtable grpList = new Hashtable();

    public FileSqlhosts(Properties sqhenv) throws IfxJNSException {
        if (System.getProperty("java.vendor").startsWith("Netscape")) {
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFdRead");
            }
            catch (Exception exception) {}
        }
        String fileName = sqhenv.getProperty("SQLH_FILE");
        InputStreamReader frdr = null;
        try {
            URL url = new URL(fileName);
            frdr = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                frdr = new FileReader(fileName);
            }
            catch (Exception ex) {
                throw new IfxJNSException(-25553, String.valueOf(ex));
            }
        }
        catch (Exception e2) {
            throw new IfxJNSException(-25553, String.valueOf(e2));
        }
        try {
            String sline;
            BufferedReader bfr = new BufferedReader(frdr);
            while ((sline = bfr.readLine()) != null) {
                if (this.isBlank(sline) || this.isComment(sline)) continue;
                ServerInfo srvr = this.parseToSrvrInfo(sline);
                this.srvrVect.addElement(srvr);
                this.srvrList.put(srvr.getSname(), srvr);
            }
            bfr.close();
        }
        catch (Exception e) {
            throw new IfxJNSException(-25553, String.valueOf(e));
        }
        this.collectGroups();
    }

    private void collectGroups() {
        int scount = this.srvrVect.size();
        int i = 0;
        while (i < scount) {
            ServerInfo srvrC = (ServerInfo)this.srvrVect.elementAt(i);
            if (srvrC.isGroupEntry()) {
                Vector<ServerInfo> gvect = new Vector<ServerInfo>();
                String gName = srvrC.getSname();
                String eGname = srvrC.getOption("e");
                boolean eGflag = eGname != null;
                int j = i + 1;
                while (j < scount) {
                    ServerInfo tsrvr = (ServerInfo)this.srvrVect.elementAt(j);
                    String tname = tsrvr.getSname();
                    String goptName = tsrvr.getOption("g");
                    if (gName.equalsIgnoreCase(goptName)) {
                        gvect.addElement(tsrvr);
                    }
                    if (eGflag && eGname.equalsIgnoreCase(tname) || !eGflag && !gName.equalsIgnoreCase(goptName)) break;
                    ++j;
                }
                this.grpList.put(gName, gvect);
            }
            ++i;
        }
    }

    public ServerInfo getServer(String sname) throws IfxJNSException {
        ServerInfo sinfo = (ServerInfo)this.srvrList.get(sname);
        if (sinfo != null) {
            return sinfo;
        }
        throw new IfxJNSException(-25555);
    }

    public ServerGroup getServerGroup(String sname) throws IfxJNSException {
        Vector tvect = (Vector)this.grpList.get(sname);
        Vector<String> nvect = new Vector<String>();
        int vsize = tvect.size();
        int i = 0;
        while (i < vsize) {
            ServerInfo tsrvr = (ServerInfo)tvect.elementAt(i);
            nvect.addElement(tsrvr.getSname());
            ++i;
        }
        return new ServerGroup(nvect);
    }

    public ServerGroup listServers() throws IfxJNSException {
        Vector tvect = new Vector();
        Enumeration tkeys = this.srvrList.keys();
        while (tkeys.hasMoreElements()) {
            tvect.addElement(tkeys.nextElement());
        }
        return new ServerGroup(tvect);
    }

    void uploadToLdap(LdapSqlhosts sqhctx) throws IfxJNSException {
        try {
            int scount = this.srvrVect.size();
            int i = 0;
            while (i < scount) {
                ServerInfo tsrvr = (ServerInfo)this.srvrVect.elementAt(i);
                sqhctx.addServer(tsrvr);
                ++i;
            }
            Enumeration gkeys = this.grpList.keys();
            while (gkeys.hasMoreElements()) {
                String gname = (String)gkeys.nextElement();
                Vector glist = (Vector)this.grpList.get(gname);
                int i2 = 0;
                while (i2 < glist.size()) {
                    Properties ldentry = new Properties();
                    ServerInfo tsrvr = (ServerInfo)glist.elementAt(i2);
                    String gMember = tsrvr.getSname();
                    String gEntry = "cn=" + gMember + "," + "cn=" + gname;
                    ((Hashtable)ldentry).put("cn", gMember);
                    ((Hashtable)ldentry).put("desc", "SqlHost Grp entry");
                    sqhctx.addEntry(gEntry, ldentry);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new IfxJNSException(-80284, String.valueOf(e));
        }
    }

    private boolean isBlank(String line) {
        String nline = line.trim();
        return nline.length() == 0;
    }

    private boolean isComment(String line) {
        String nline = line.trim();
        return nline.charAt(0) == '#';
    }

    private ServerInfo parseToSrvrInfo(String line) {
        String sname = "";
        String ntype = "";
        String hname = "";
        String pname = "";
        String opts = "";
        StringTokenizer stok = new StringTokenizer(line);
        sname = stok.nextToken();
        ntype = stok.nextToken();
        if (stok.hasMoreElements()) {
            hname = stok.nextToken();
        }
        if (stok.hasMoreElements()) {
            pname = stok.nextToken();
        }
        while (stok.hasMoreElements()) {
            opts = String.valueOf(opts) + stok.nextToken() + " ";
        }
        ServerInfo sinfo = new ServerInfo(sname, ntype, hname, pname, opts);
        return sinfo;
    }
}

