/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int MAXVCLEN = 255;
    private String value;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String varchar) throws SQLException {
        this.setIfxType(13);
        this.value = varchar;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            return JavaToIfxType.JavaToIfxChar(this.value, dbEnc);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public byte[] toIfxTuple() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            return JavaToIfxType.JavaToIfxVarChar(this.value, dbEnc, this.encodedLength);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public void fromIfx(byte[] b) throws SQLException {
        try {
            int length = b[0] & 0xFF;
            String dbEnc = this.conn.getdbEncoding();
            if (length == 0) {
                this.value = new String("");
                this.unnullify();
            } else if (length == 1 && b[1] == 0) {
                this.value = null;
                this.nullify();
            } else {
                byte[] barr = new byte[length];
                System.arraycopy(b, 1, barr, 0, length);
                this.value = IfxToJavaType.IfxToJavaChar(barr, (short)0, dbEnc);
                this.unnullify();
            }
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.clearWarning();
            String nstr = str.trim();
            this.value = nstr.length() > 255 ? nstr.substring(0, 255) : nstr;
            this.unnullify();
        }
    }

    public byte toByte() throws SQLException {
        byte b;
        if (this.isNull()) {
            return 0;
        }
        try {
            b = Byte.parseByte(this.value);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return b;
    }

    public void fromByte(Byte b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromByte((byte)b);
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.value = String.valueOf(b);
        this.unnullify();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)b);
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.value = b ? "true" : "false";
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Integer I = new Integer(this.value);
            return I;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.fromInt((int)I);
        }
    }

    public void fromInt(int I) throws SQLException {
        this.value = Integer.toString(I);
        this.unnullify();
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short S = new Short(this.value);
            return S;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
        }
    }

    public void fromShort(short val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
        }
    }

    public void fromLong(long val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float F = Float.valueOf(this.value);
        return F.floatValue();
    }

    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromFloat(val.floatValue());
        }
    }

    public void fromFloat(float val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    public Date toDate() throws SQLException {
        Date d = null;
        if (this.isNull()) {
            return null;
        }
        try {
            d = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return d;
    }

    public void fromDate(Date val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(val, this.conn);
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        Time t;
        if (this.isNull()) {
            return null;
        }
        try {
            t = Time.valueOf(this.value);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return t;
    }

    public void fromTime(Time val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.toString();
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp t;
        if (this.isNull()) {
            return null;
        }
        try {
            t = Timestamp.valueOf(this.value);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return t;
    }

    public void fromTimestamp(Timestamp val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.toString();
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double D = Double.valueOf(this.value);
        return D;
    }

    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromDouble((double)val);
        }
    }

    public void fromDouble(double val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigD;
        if (this.isNull()) {
            return null;
        }
        try {
            bigD = new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return bigD;
    }

    public void fromBigDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.toString();
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar otherVarChar = (IfxVarChar)other;
        if (otherVarChar.isNull()) {
            return false;
        }
        return this.value.equals(otherVarChar.value);
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        byte[] byteArray = this.value.getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        if (x != null) {
            if (length == 0) {
                this.value = "";
            } else {
                byte[] b = new byte[length];
                int offset = 0;
                try {
                    int readLen;
                    do {
                        readLen = x.read(b, offset, length);
                        offset += readLen;
                    } while ((length -= readLen) > 0);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.value = new String(b);
            }
        }
    }

    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }
}

