/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDistinct;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

class IfxValue
extends Trace {
    static Hashtable IfxTypeToObjectTable = null;
    static Hashtable IfxTypeToObjectTable_9x = null;
    private static final int IUS_TYPES = 10;
    private static final int NO_SCALE = -1;
    private static final String DISTINCT_CLASS_NAME = "IfxDistinct";
    private static final String BLOB_CLASS_NAME = "IfxSmBlob";
    private static final String CLOB_CLASS_NAME = "IfxSmBlob";
    private static final String SERVER_BLOB_CLASS_NAME = "IfxDirectBlob";
    private static final String SERVER_CLOB_CLASS_NAME = "IfxDirectClob";
    private static final String BOOLEAN_CLASS_NAME = "IfxBoolean";
    private static final String LVARCHAR_CLASS_NAME = "IfxLvarchar";
    private static final String UDT_CLASS_NAME = "IfxUDT";

    private static String IfxTypeToObject_9x(IfxConnection conn, int ifxType) {
        if (conn.isDirect()) {
            Object className = null;
            switch (ifxType) {
                case 102: {
                    return SERVER_BLOB_CLASS_NAME;
                }
                case 101: {
                    return SERVER_CLOB_CLASS_NAME;
                }
            }
        }
        return (String)IfxTypeToObjectTable_9x.get(new Integer(ifxType));
    }

    private static int getRealIfxType(IfxConnection conn, int ifxtype) {
        if (!conn.isIEEEM() && IfxTypes.IsFloatTypes(ifxtype)) {
            ifxtype = 5;
        } else if (!conn.isUSVER() && ifxtype == 17) {
            ifxtype = 2;
        }
        return ifxtype & 0xFF;
    }

    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo) throws SQLException {
        byte startCode;
        String className = null;
        String IntervalSubtype = null;
        if (colinfo == null) {
            throw IfxErrMsg.getSQLException(-79714, conn);
        }
        Trace trace = conn.getTrace();
        if (trace != null) {
            trace.writeTrace(2, "makeInstance: 1");
        }
        int ifxtype = IfxValue.getRealIfxType(conn, colinfo.SQLtype);
        if (conn.isDirect()) {
            if (ifxtype >= 17) {
                if (colinfo.ExtendedId == 5 || colinfo.SourceType == 5) {
                    className = BOOLEAN_CLASS_NAME;
                    ifxtype = 45;
                } else if (colinfo.ExtendedId == 1 || colinfo.SourceType == 1) {
                    className = LVARCHAR_CLASS_NAME;
                    ifxtype = 43;
                }
                if (className == null) {
                    className = IfxValue.IfxTypeToObject_9x(conn, ifxtype);
                }
            } else {
                className = (String)IfxTypeToObjectTable.get(new Integer(ifxtype));
            }
            if (ifxtype == 14) {
                startCode = (byte)(colinfo.ColLength >> 4 & 0xF);
                IntervalSubtype = startCode == 0 || startCode == 2 ? "YM" : "DF";
            }
        } else if (!colinfo.IsDistinct) {
            if (ifxtype >= 17 && conn.isUSVER()) {
                if (colinfo.ExtendedId == 5) {
                    className = BOOLEAN_CLASS_NAME;
                    ifxtype = 45;
                } else if (colinfo.ExtendedId == 1) {
                    className = LVARCHAR_CLASS_NAME;
                    ifxtype = 43;
                }
                if (colinfo.ExtendedId != 0) {
                    if (colinfo.ExtendedId == 10) {
                        className = "IfxSmBlob";
                        ifxtype = 44;
                    } else if (colinfo.ExtendedId == 11) {
                        className = "IfxSmBlob";
                        ifxtype = 44;
                    } else if (ifxtype == 40 || ifxtype == 41) {
                        className = UDT_CLASS_NAME;
                        ifxtype = 44;
                    }
                }
                if (className == null) {
                    className = IfxValue.IfxTypeToObject_9x(conn, ifxtype);
                }
            } else {
                className = (String)IfxTypeToObjectTable.get(new Integer(ifxtype));
            }
            if (ifxtype == 14) {
                startCode = (byte)(colinfo.ColLength >> 4 & 0xF);
                IntervalSubtype = startCode == 0 || startCode == 2 ? "YM" : "DF";
            }
        } else {
            className = DISTINCT_CLASS_NAME;
        }
        if (className == null) {
            throw IfxErrMsg.getSQLException(-79714, conn);
        }
        IfxObject obj = IfxValue.createInstanceFromClassName(className, IntervalSubtype, conn);
        if (obj != null) {
            obj.setIfxType(ifxtype);
            obj.setExtendedTypeName(colinfo.ExtendedName);
            obj.setExtendedOwner(colinfo.ExtendedOwner);
            obj.setExtendedId(colinfo.ExtendedId);
            obj.setSourceType(colinfo.SourceType);
            obj.setEncodedLength(colinfo.ColLength);
            obj.setConnection(conn);
        }
        if (trace != null) {
            trace.writeTrace(2, "IfxValue.makeInstance:");
            trace.writeTrace(2, "  ColInfo.SQLType = " + ifxtype);
            trace.writeTrace(2, "  ColInfo.ExtendedId = " + colinfo.ExtendedId);
            trace.writeTrace(2, "  This instance is " + obj.getClass().getName());
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo, int sqlType) throws SQLException {
        IfxObject obj;
        Trace trace = conn.getTrace();
        if (trace != null) {
            trace.writeTrace(2, "makeInstance: 2");
        }
        if (colinfo != null) {
            if (sqlType == -1 && colinfo.ExtendedId != 0 && colinfo.ExtendedId != 11) {
                sqlType = 43;
                obj = IfxValue.makeInstanceFromIfxType(conn, sqlType);
            } else {
                obj = IfxValue.makeInstance(conn, colinfo);
            }
        } else {
            obj = IfxValue.makeInstanceFromIfxType(conn, IfxTypes.FromJDBCToIfxType(sqlType));
        }
        return obj;
    }

    private static IfxObject createInstanceFromClassName(String className, String IntervalSubType, IfxConnection conn) throws SQLException {
        IfxObject object = null;
        if (className == null) {
            throw IfxErrMsg.getSQLException(-79728, conn);
        }
        try {
            Class<?> clsRef = IntervalSubType == null ? Class.forName("com.informix.jdbc." + className) : Class.forName("com.informix.jdbc." + className + IntervalSubType);
            object = (IfxObject)clsRef.newInstance();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), conn);
        }
        return object;
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        Trace trace = conn.getTrace();
        if (trace != null) {
            trace.writeTrace(2, "makeInstance: 3");
            if (colinfo == null) {
                trace.writeTrace(2, "colinfo is NULL!");
            }
        }
        if (x == null && colinfo != null) {
            obj = IfxValue.makeInstance(conn, colinfo);
        } else if (x instanceof IfmxSQLData) {
            obj = IfxValue.makeInstance(conn, (IfmxSQLData)x, colinfo);
        } else {
            String clsName = x.getClass().getName();
            int type = IfxTypes.FromJavaToIfxType(clsName);
            if (colinfo != null) {
                if (clsName.equals("java.lang.Boolean")) {
                    obj = IfxValue.makeInstance(conn, (Boolean)x, colinfo);
                } else if (clsName.equals("[B")) {
                    obj = IfxValue.makeInstance(conn, (byte[])x, colinfo);
                }
            }
            if (obj == null) {
                if (colinfo == null || colinfo.ExtendedId != 0) {
                    String tmpstr = null;
                    if (x instanceof IntervalYM) {
                        tmpstr = new String("YM");
                    } else if (x instanceof IntervalDF) {
                        tmpstr = new String("DF");
                    }
                    if (type == -99) {
                        throw IfxErrMsg.getSQLException(-79728, conn);
                    }
                    if (conn.isUSVER() && type == 0) {
                        type = 43;
                    }
                    obj = IfxValue.makeInstanceFromIfxType(conn, type, tmpstr);
                    obj.fromObject(x);
                } else {
                    obj = IfxValue.makeInstance(conn, colinfo);
                    obj.fromObject(x);
                }
            }
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo, int sqltype) throws SQLException {
        Trace trace = conn.getTrace();
        if (trace != null) {
            trace.writeTrace(2, "makeInstance: 4");
        }
        return IfxValue.makeInstance(conn, x, colinfo, -1, sqltype);
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo, int scale, int sqltype) throws SQLException {
        IfxObject obj = null;
        Trace trace = conn.getTrace();
        if (trace != null) {
            trace.writeTrace(2, "makeInstance: 5");
        }
        if (colinfo != null && sqltype == -1 && colinfo.ExtendedId != 0 && colinfo.ExtendedId != 11) {
            sqltype = 43;
            obj = IfxValue.makeInstanceFromIfxType(conn, sqltype);
        } else {
            obj = sqltype == 2000 || sqltype == 2001 || sqltype == 1111 || sqltype == -4 || sqltype == -3 || sqltype == -1 ? IfxValue.makeInstance(conn, x, colinfo) : IfxValue.makeInstanceFromIfxType(conn, IfxTypes.FromJDBCToIfxType(sqltype));
        }
        if (obj != null) {
            if (scale == -1) {
                obj.fromObject(x);
            } else {
                obj.fromObject(x, scale);
            }
        }
        return obj;
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection conn, int ifxtype) throws SQLException {
        return IfxValue.makeInstanceFromIfxType(conn, ifxtype, null);
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection conn, int ifxtype, String IntervalSubType) throws SQLException {
        IfxObject obj = null;
        Trace trace = conn.getTrace();
        obj = (ifxtype = IfxValue.getRealIfxType(conn, ifxtype)) >= 17 && conn.isUSVER() ? IfxValue.createInstanceFromClassName(IfxValue.IfxTypeToObject_9x(conn, ifxtype), null, conn) : IfxValue.createInstanceFromClassName((String)IfxTypeToObjectTable.get(new Integer(ifxtype)), IntervalSubType, conn);
        if (obj != null) {
            if (ifxtype == 101 || ifxtype == 102) {
                obj.setExtendedTypeName(IfxTypes.IfxTypeToName(ifxtype));
                if (!conn.isDirect()) {
                    ifxtype = 44;
                }
            }
            obj.setIfxType(ifxtype);
            obj.setConnection(conn);
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, BigDecimal x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 5);
        obj.fromDecimal(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, boolean x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromBoolean(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, short x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromShort(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, byte x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromByte(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, int x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 2);
        obj.fromInt(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, long x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype < 17 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, conn.isUSVER() ? 17 : 2);
        obj.fromLong(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, float x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 4);
        obj.fromFloat(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, double x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 3);
        obj.fromDouble(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, String x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj;
        Trace trace = conn.getTrace();
        if (colinfo != null) {
            if (colinfo.SQLtype == 13 || colinfo.SQLtype == 16) {
                obj = IfxValue.makeInstanceFromIfxType(conn, 13);
            } else if (colinfo.SQLtype > 18) {
                if (colinfo.ExtendedId == 11) {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 101);
                    obj.extendedID = 11;
                } else if (colinfo.ExtendedId == 5) {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 0);
                } else {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 43);
                    obj.extendedID = 1;
                    if (colinfo.IsDistinct) {
                        colinfo.ExtendedOwner = new String("informix");
                        obj.extendedName = new String("lvarchar");
                    }
                }
            } else {
                String IntervalSubtype = null;
                if (colinfo.SQLtype == 14) {
                    byte startCode = (byte)(colinfo.ColLength >> 4 & 0xF);
                    IntervalSubtype = startCode == 0 || startCode == 2 ? "YM" : "DF";
                }
                obj = IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype, IntervalSubtype);
            }
        } else {
            obj = IfxValue.makeInstanceFromIfxType(conn, 0);
        }
        if (trace != null) {
            trace.writeTrace(2, "makeInstance from String, object created: " + obj.getClass().getName());
        }
        obj.fromString(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, byte[] x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromBytes(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Date x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 7);
        obj.fromDate(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Time x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 10);
        obj.fromTime(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Timestamp x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 10);
        obj.fromTimestamp(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, InputStream x, int length, IfxColumnInfo colinfo) throws SQLException {
        if (x instanceof IfxLobInputStream) {
            InputStream y = ((IfxLobInputStream)x).getStream();
        } else {
            InputStream y = x;
        }
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromInputStream(x, length);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IntervalYM x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 14, "YM");
        obj.fromIntervalYM(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IntervalDF x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 14, "DF");
        obj.fromIntervalDF(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IfmxSQLData x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        IfxUDTInfo typeinfo = null;
        String typename = x.getSQLTypeName();
        if (typename != null) {
            typeinfo = conn.getUDTInfo(colinfo, typename);
        }
        if (typeinfo == null) {
            throw IfxErrMsg.getSQLException(-79770, conn);
        }
        obj = IfxValue.createInstanceByTypeInfo(conn, typeinfo);
        if (obj != null) {
            obj.fromObject(x);
        }
        return obj;
    }

    private static IfxObject createInstanceByTypeInfo(IfxConnection conn, IfxUDTInfo typeinfo) throws SQLException {
        IfxObject obj;
        block10: {
            obj = null;
            try {
                switch (typeinfo.JDBCtype) {
                    case 2000: {
                        obj = new IfxUDT();
                        if (!conn.isDirect()) {
                            obj.setIfxType(44);
                        } else {
                            obj.setIfxType(typeinfo.SQLtype);
                        }
                        break;
                    }
                    case 2001: {
                        obj = new IfxDistinct();
                        obj.setIfxType(typeinfo.SQLtype);
                        obj.isDistinct = true;
                        break;
                    }
                    default: {
                        if (obj == null) break block10;
                    }
                }
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), conn);
            }
            if (obj == null) break block10;
            obj.setExtendedTypeName(typeinfo.name);
            obj.setExtendedOwner(typeinfo.owner);
            obj.setExtendedId(typeinfo.xid);
            obj.setSourceType(typeinfo.source);
            obj.setConnection(conn);
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo, int sqlType, String name) throws SQLException {
        IfxObject obj;
        if (colinfo != null) {
            obj = IfxValue.makeInstance(conn, colinfo);
        } else {
            int ifxType = IfxTypes.FromJDBCToIfxType(sqlType);
            if (ifxType <= 18 || ifxType == 101 || ifxType == 102) {
                obj = IfxValue.makeInstanceFromIfxType(conn, ifxType);
            } else {
                IfxUDTInfo typeinfo = null;
                if (name != null) {
                    typeinfo = conn.getUDTInfo(colinfo, name);
                }
                if (typeinfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, conn);
                }
                obj = IfxValue.createInstanceByTypeInfo(conn, typeinfo);
            }
        }
        return obj;
    }

    IfxValue() {
    }

    static {
        if (IfxTypeToObjectTable == null) {
            IfxTypeToObjectTable = new Hashtable(49, 1.0f);
            IfxTypeToObjectTable.put(new Integer(0), "IfxChar");
            IfxTypeToObjectTable.put(new Integer(1), "IfxShort");
            IfxTypeToObjectTable.put(new Integer(2), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(3), "IfxFloat");
            IfxTypeToObjectTable.put(new Integer(4), "IfxSmallFloat");
            IfxTypeToObjectTable.put(new Integer(5), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(6), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(8), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(7), "IfxDate");
            IfxTypeToObjectTable.put(new Integer(10), "IfxDateTime");
            IfxTypeToObjectTable.put(new Integer(8), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(11), "IfxBlob");
            IfxTypeToObjectTable.put(new Integer(12), "IfxBlob");
            IfxTypeToObjectTable.put(new Integer(13), "IfxVarChar");
            IfxTypeToObjectTable.put(new Integer(14), "IfxInterval");
            IfxTypeToObjectTable.put(new Integer(15), "IfxChar");
            IfxTypeToObjectTable.put(new Integer(16), "IfxVarChar");
            IfxTypeToObjectTable.put(new Integer(17), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(18), "IfxInteger");
        }
        if (IfxTypeToObjectTable_9x == null) {
            IfxTypeToObjectTable_9x = new Hashtable(10, 1.0f);
            IfxTypeToObjectTable_9x.put(new Integer(17), "IfxInt8");
            IfxTypeToObjectTable_9x.put(new Integer(18), "IfxInt8");
            IfxTypeToObjectTable_9x.put(new Integer(19), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(20), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(21), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(22), "IfxRow");
            IfxTypeToObjectTable_9x.put(new Integer(40), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(41), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(43), LVARCHAR_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(45), BOOLEAN_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(44), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(101), "IfxSmBlob");
            IfxTypeToObjectTable_9x.put(new Integer(102), "IfxSmBlob");
        }
    }
}

