/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.SQLUDTOutput;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxUDTOutput
extends IfxSQLOutput
implements SQLUDTOutput,
IfmxUDTSQLOutput {
    private static final int NO_ALIGNMENT = -1;

    IfxUDTOutput() {
    }

    IfxUDTOutput(IfxConnection conn) throws SQLException {
        super(conn);
    }

    private void checkAlignment(int dataSize, int alignment) throws SQLException {
        if (alignment != -1) {
            int nPadded = (this.currentPos + dataSize + (alignment - 1) & ~(alignment - 1)) - (this.currentPos + dataSize);
            this.trace.writeTrace(3, "IfxUDTOutput.checkAlignment(): currentPos = " + this.currentPos);
            this.trace.writeTrace(3, "                               dataSize = " + dataSize);
            this.trace.writeTrace(3, "                               nPadded = " + nPadded);
            try {
                while (nPadded-- > 0) {
                    this.os.write(0);
                    ++this.currentPos;
                }
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    public void writeString(String x, int len) throws SQLException {
        this.checkAlignment(len, -1);
        try {
            int numPadded = len - x.length();
            byte[] b = x.getBytes();
            this.os.write(b, 0, x.length() > len ? len : x.length());
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeByte(byte x) throws SQLException {
        this.checkAlignment(1, -1);
        try {
            this.os.writeByte(x);
            ++this.currentPos;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeBoolean(boolean x) throws SQLException {
        byte b = 0;
        if (x) {
            b = 1;
        }
        try {
            this.writeByte(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeShort(short x) throws SQLException {
        this.checkAlignment(2, 2);
        super.writeShort(x);
    }

    public void writeInt(int x) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeInt(x);
    }

    public void writeLong(long x) throws SQLException {
        try {
            short sign = 1;
            if (x < 0L) {
                sign = -1;
                x = -x;
            }
            long i1 = x & 0xFFFFFFFFL;
            this.writeInt((int)i1);
            int i2 = (int)(x >> 32);
            this.writeInt(i2);
            this.writeShort(sign);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeFloat(float x) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeFloat(x);
    }

    public void writeDouble(double x) throws SQLException {
        this.checkAlignment(8, 8);
        super.writeDouble(x);
    }

    public void writeBigDecimal(BigDecimal x) throws SQLException {
        try {
            this.checkAlignment(2, 2);
            this.os.write(new Decimal(x).javaToDec_t());
            this.currentPos += 22;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] x, int len) throws SQLException {
        try {
            this.checkAlignment(len, -1);
            int numPadded = len - x.length;
            this.os.write(x);
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeTimestamp(Timestamp x) throws SQLException {
        try {
            String ts = JavaToIfxType.convertTimestampToString(x);
            Decimal dec = new Decimal(ts);
            short qual = 4365;
            this.checkAlignment(2, 2);
            this.os.writeShort(qual);
            this.os.write(dec.javaToDec_t());
            this.currentPos += 24;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeCharacterStream(Reader x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeCharacterStream(Reader).", this.conn);
    }

    public void writeAsciiStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeAsciiStream(InputStream).", this.conn);
    }

    public void writeBinaryStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBinaryStream(InputStream).", this.conn);
    }

    public void writeObject(IfmxSQLData x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeObject(SQLData).", this.conn);
    }

    void writeIfxLocator(IfxLocator loc) throws SQLException {
        this.writeBytes(loc.getRawLocator());
    }

    public void writeInterval(Interval x) throws SQLException {
        try {
            String s = null;
            byte[] ii = new byte[2];
            short inPrec = 0;
            if (x instanceof IntervalYM) {
                s = JavaToIfxType.convertIntervalToString((IntervalYM)x);
                long months = ((IntervalYM)x).getMonths();
                if (months < 0L) {
                    months = -months;
                }
                String ms = new Long(months /= 12L).toString();
                ms.trim();
                ii = Decimal.encodeIntervalPrecision(ii, (byte)ms.length(), (byte)0, (byte)2);
            } else {
                s = JavaToIfxType.convertIntervalToString((IntervalDF)x);
                long secs = ((IntervalDF)x).getSeconds();
                if (secs < 0L) {
                    secs = -secs;
                }
                if (secs <= 0L) {
                    ii = Decimal.encodeIntervalPrecision(ii, (byte)2, (byte)12, (byte)15);
                } else {
                    byte flen = 0;
                    flen = s.charAt(0) == '-' ? (byte)(s.length() - 13) : (byte)(s.length() - 12);
                    ii = Decimal.encodeIntervalPrecision(ii, flen, (byte)4, (byte)15);
                }
            }
            inPrec = (short)(ii[0] * 256 + ii[1]);
            Decimal dec = new Decimal(s, inPrec);
            short qual = x.getQualifier();
            this.checkAlignment(2, 2);
            this.os.writeShort(qual);
            this.os.write(dec.javaToDec_t());
            this.currentPos += 24;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.getMessage(), this.conn);
        }
    }
}

