/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLInput;
import com.informix.jdbc.SQLUDTInput;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxUDTInput
extends IfxSQLInput
implements SQLUDTInput,
IfmxUDTSQLInput {
    private static final int NO_ALIGNMENT = -1;

    IfxUDTInput(IfxConnection conn, byte[] b, int index, int length) throws SQLException {
        super(conn, b, index, length);
    }

    public int length() {
        return super.length();
    }

    private void checkAlignment(int dataSize, int alignment) throws SQLException {
        if (alignment != -1) {
            int nbSkip = (this.currentPos + dataSize + (alignment - 1) & ~(alignment - 1)) - (this.currentPos + dataSize);
            this.trace.writeTrace(3, "IfxUDTOutput.checkAlignment(): currentPos = " + this.currentPos);
            this.trace.writeTrace(3, "                               dataSize = " + dataSize);
            this.trace.writeTrace(3, "                               nbSkip = " + nbSkip);
            if (nbSkip > 0) {
                super.checkLength(nbSkip);
                super.skipBytes(nbSkip);
                this.currentPos += nbSkip;
            }
        }
    }

    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readString().", this.conn);
    }

    public byte readByte() throws SQLException {
        this.checkAlignment(1, -1);
        this.checkLength(1);
        ++this.currentPos;
        try {
            return this.is.readByte();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public short readShort() throws SQLException {
        this.checkAlignment(2, 2);
        return super.readShort();
    }

    public int readInt() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readInt();
    }

    public String readString(int len) throws SQLException {
        byte[] b;
        if (this.unreadLength < len) {
            len = this.unreadLength;
        }
        this.checkAlignment(len, -1);
        this.checkLength(len);
        try {
            b = new byte[len];
            this.is.readFully(b, 0, len);
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        String S = IfxToJavaType.IfxToJavaChar(b, (short)0);
        if (S == null) {
            this.isNull = true;
            return null;
        }
        return S.trim();
    }

    public boolean readBoolean() throws SQLException {
        byte b = 0;
        this.checkAlignment(1, -1);
        this.checkLength(1);
        try {
            b = this.is.readByte();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        ++this.currentPos;
        if (b == 1) {
            return true;
        }
        if (b == 0) {
            return false;
        }
        if (b == 255) {
            this.isNull = true;
        }
        return false;
    }

    public long readLong() throws SQLException {
        this.checkAlignment(4, 4);
        try {
            byte[] bint8 = new byte[8];
            long l = 0L;
            int i = 4;
            while (i < 8) {
                bint8[i] = (byte)(0xFF & (short)this.readByte());
                ++i;
            }
            int i2 = 0;
            while (i2 < 4) {
                bint8[i2] = (byte)(0xFF & (short)this.readByte());
                ++i2;
            }
            short sign = this.readShort();
            if (sign == 0) {
                this.isNull = true;
            } else {
                BigInteger b = new BigInteger(bint8);
                l = b.longValue();
                if (sign == -1) {
                    l *= -1L;
                }
            }
            return l;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public float readFloat() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readFloat();
    }

    public double readDouble() throws SQLException {
        this.checkAlignment(8, 8);
        return super.readDouble();
    }

    private Decimal readIfxDecimal() throws SQLException {
        this.checkAlignment(2, 2);
        return Decimal.dec_tToJava(this.readBytes(22));
    }

    public BigDecimal readBigDecimal() throws SQLException {
        try {
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            return dec.numericValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int len) throws SQLException {
        this.checkAlignment(len, -1);
        return super.readBytes(len);
    }

    public Date readDate() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readDate();
    }

    public Timestamp readTimestamp() throws SQLException {
        try {
            short qualifier = this.readShort();
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            dec.setTimestampQualifier(qualifier);
            return dec.timestampValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readCharacterStream().", this.conn);
    }

    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readAsciiStream().", this.conn);
    }

    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readBinaryStream().", this.conn);
    }

    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readObject().", this.conn);
    }

    private IfxLocator readIfxLocator() throws SQLException {
        byte[] b = this.readBytes(72);
        return new IfxLocator(b);
    }

    public Interval readInterval() throws SQLException {
        try {
            short qualifier = this.readShort();
            Decimal dec = this.readIfxDecimal();
            if (dec.isNull()) {
                this.isNull = true;
                return null;
            }
            dec.setTimestampQualifier(qualifier);
            return dec.intervalValue();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.getMessage(), this.conn);
        }
    }
}

