/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxUDTInput;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;

class IfxUDT
extends IfxBaseType {
    IfmxSQLData udtClass;

    IfxUDT() throws SQLException {
        this.setIfxType(44);
    }

    IfxUDT(byte[] b) throws SQLException {
        this.setIfxType(44);
        this.fromBytes(b);
    }

    public void fromObject(Object data) throws SQLException {
        if (data == null) {
            this.nullify();
            this.udtClass = null;
        } else {
            String ename;
            if (!(data instanceof IfmxSQLData)) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.udtClass = (IfmxSQLData)data;
            if (!this.conn.isDirect()) {
                this.outputStream.reset();
                this.udtClass.writeSQL(this.outputStream);
            }
            if ((ename = this.udtClass.getSQLTypeName()) != null) {
                this.setExtendedTypeName(ename);
            }
            this.unnullify();
        }
    }

    public Object toObject() throws SQLException {
        if (this.conn.isDirect()) {
            if (this.isNull()) {
                return null;
            }
            return this.udtClass;
        }
        if (this.typeMap == null && (this.typeMap = this.conn.getTypeMap()) == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        Class cls = (Class)this.typeMap.get(this.extendedName);
        if (cls == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        try {
            this.udtClass = (IfmxSQLData)cls.newInstance();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (this.inputStream == null && this.outputStream != null && this.outputStream.length() > 0) {
            this.inputStream = new IfxUDTInput(this.conn, this.outputStream.toByteArray(), 0, this.outputStream.length());
        }
        this.udtClass.readSQL(this.inputStream, this.extendedName);
        if (this.isNull()) {
            return null;
        }
        return this.udtClass;
    }

    public void fromBytes(byte[] b) throws SQLException {
        this.outputStream.reset();
        this.outputStream.writeBytes(b, b.length);
        this.inputStream = new IfxUDTInput(this.conn, b, 0, b.length);
        this.unnullify();
    }

    public byte[] toBytes() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return this.inputStream.toByteArray();
    }

    public void clear() {
        this.udtClass = null;
        this.nullify();
    }

    public String toString() {
        if (this.conn.isDirect()) {
            if (this.isNull()) {
                return null;
            }
            return this.udtClass.toString();
        }
        return super.toString();
    }
}

