/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.util.IfxErrMsg;
import java.io.File;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxTmpFile {
    private String fileName;
    private int refCount;

    IfxTmpFile(String tempFileName) throws SQLException {
        try {
            File tmpf = new File(tempFileName);
            this.fileName = tmpf.getPath();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), null);
        }
        this.refCount = 0;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected synchronized int incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                File fd = new File(this.fileName);
                fd.delete();
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }
}

