/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxValue;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private String cursorName;
    private int maxRows;
    private Trace trace;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    protected IfxConnection jconn;
    public String commandString;
    protected IfxResultSet savedResult;
    protected boolean escapeProcessing = true;
    protected int numqmarks;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency;
    private int FetchSize;
    private int FetchDirection = 1000;
    protected Vector BatchVector = new Vector();
    protected int[] BatchRowCount = new int[1];
    protected IfxResultSetMetaData outputMetaData;
    protected int statementType;
    private IfxProtocol prot;

    IfxStatement(IfxConnection conn) {
        this.jconn = conn;
        if (this.jconn != null) {
            this.trace = this.jconn.getTrace();
            if (this.trace == null) {
                System.out.println("IfxStatement: Trace is NULL");
            }
            this.trace.writeTrace(99, "IfxStatement: constructor exited");
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.trace.writeTrace(3, "Statement.executeQuery(): sql = " + sql);
        this.validate(sql);
        return this.executeQueryImpl(false);
    }

    public ResultSet executeQuery(String sql, boolean withHold) throws SQLException {
        this.trace.writeTrace(3, "Statement.executeQuery(sql,withHold): sql = " + sql + " , withHold = " + withHold);
        this.validate(sql);
        return this.executeQueryImpl(withHold);
    }

    void validate(String sql) throws SQLException {
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.trace.writeTrace(3, "Statement.executeUpdate(): sql = " + sql);
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
        return this.executeUpdateImpl();
    }

    public void close() throws SQLException {
        this.trace.writeTrace(99, "IfxStatement.close() called");
        if (this.savedResult != null) {
            this.trace.writeTrace(99, "IfxStatement.close(): calling savedResult.closeNow()");
            this.savedResult.closeNow();
            this.savedResult = null;
        }
        this.cursorName = null;
        this.statementWarnings = null;
        this.jconn = null;
        this.commandString = null;
    }

    public int getMaxFieldSize() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getMaxFieldSize() returns 0");
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:setMaxFileldSize() Not Implemented");
        throw IfxErrMsg.getSQLException(-79700, ": Statement.setMaxFieldSize(int).", this.jconn);
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getQueryTimeout() returns 0");
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds != 0) {
            this.trace.writeTrace(2, "IfxStatement:setQueryTimeout() not supported");
            throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
        }
    }

    public void cancel() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:cancel() not supported");
        throw IfxErrMsg.getSQLException(-79700, ": Statement.cancel().", this.jconn);
    }

    void chainWarnings(SQLWarning warn) throws SQLException {
        this.trace.writeTrace(99, "IfxStatement.chainWarnings() called");
        if (warn != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(warn);
            } else {
                this.statementWarnings = warn;
            }
        }
        this.trace.writeTrace(99, "IfxStatement.chainWarnings() exited");
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.savedResult != null) {
            this.chainWarnings(this.savedResult.getWarnings());
        }
        return this.statementWarnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    public void setCursorName(String name) throws SQLException {
        if (name.length() <= 0) {
            throw IfxErrMsg.getSQLException(-79732, this.jconn);
        }
        this.cursorName = name;
    }

    public boolean execute(String sql) throws SQLException {
        this.trace.writeTrace(3, "Statement.execute(): sql = " + sql);
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this instanceof IfxPreparedStatement || this instanceof IfxCallableStatement) {
            throw IfxErrMsg.getSQLException(-79729, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        String string = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        if (this.savedResult != null) {
            this.savedResult.closePrev();
        }
        return this.executeImpl();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.calledgetResultSet) {
            this.trace.writeTrace(2, "IfxStatement:getResultSet():getResultSet called twice");
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
        if (this.savedResult == null) {
            this.trace.writeTrace(2, "IfxStatement:getResultSet():null result set");
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        if (this.savedResult.getUpdateCount() != -1) {
            return null;
        }
        return this.savedResult;
    }

    public int getUpdateCount() throws SQLException {
        if (this.calledgetUpdateCount) {
            this.trace.writeTrace(2, "IfxStatement:getUpdateCount():getUpdateCount called twice");
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.savedResult.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
            this.savedResult.closePrev();
        }
        this.trace.writeTrace(2, "IfxStatement:getMoreResult():result set is null");
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.cursorName != null) {
            this.trace.writeTrace(2, "IfxStatement:getCursorName():" + this.cursorName);
            return this.cursorName;
        }
        return this.getGeneratedCursor();
    }

    private String getGeneratedCursor() throws SQLException {
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        this.cursorName = this.jconn.getGeneratedCursor();
        this.trace.writeTrace(2, "IfxStatement:getGeneratedCursor():" + this.cursorName);
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int count) {
        this.numqmarks = count;
    }

    public Connection getConnection() {
        return this.jconn;
    }

    protected ResultSet executeQueryImpl(boolean withHold) throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.commandString != null) {
            this.trace.writeTrace(3, "Statement: commandString = " + this.commandString + "\nwithHold = " + withHold);
        }
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.outputMetaData != null) {
            this.savedResult.executeQuery(this.outputMetaData, withHold);
        } else {
            this.savedResult.executeQuery(withHold);
        }
        return this.savedResult;
    }

    protected int executeUpdateImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        if (this.commandString != null) {
            this.trace.writeTrace(3, "Statement: commandString = " + this.commandString);
        }
        this.clearWarnings();
        return this.savedResult.executeUpdate();
    }

    protected boolean executeImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.outputMetaData != null) {
            return this.savedResult.executeExecute(this.outputMetaData);
        }
        return this.savedResult.executeExecute();
    }

    public int getSerial() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getSerial()");
        if (this.savedResult == null) {
            return 0;
        }
        return this.savedResult.getSerial();
    }

    public long getSerial8() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getSerial8()");
        if (this.savedResult == null) {
            return 0L;
        }
        return this.savedResult.getSerial8();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:setFetchDirection()");
        if (direction != 1000 || direction != 1001 || direction != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.jconn);
        }
        if (this.getResultSetType() == 1003 && direction != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.jconn);
        }
        this.FetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getFetchDirection()");
        return this.FetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:setFetchSize()");
        if (rows < 0 || this.maxRows != 0 && rows > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getFetchSize()");
        return this.FetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getResultSetConcurrency()");
        return this.ResultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:getResultSetType()");
        return this.ResultSetType;
    }

    public void addBatch(String sql) throws SQLException {
        this.trace.writeTrace(1, "IfxStatement:addBatch()");
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = String.valueOf(this.commandString) + ";";
        }
        this.trace.writeTrace(2, "IfxStatement:commandString is " + this.commandString);
        this.BatchVector.addElement(this.commandString);
    }

    public void clearBatch() throws SQLException {
        this.trace.writeTrace(1, "IfxStatement:clearBatch()");
        this.BatchVector.removeAllElements();
    }

    public int[] executeBatch() throws SQLException {
        this.trace.writeTrace(1, "IfxStatement:executeBatch()");
        this.commandString = "";
        this.BatchRowCount[0] = 0;
        if (this.BatchVector.size() == 0) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        int i = 0;
        while (i < this.BatchVector.size()) {
            this.commandString = String.valueOf(this.commandString) + this.BatchVector.elementAt(i);
            ++i;
        }
        this.trace.writeTrace(2, "IfxStatement:commandString is " + this.commandString);
        this.BatchRowCount[0] = this.executeUpdateImpl();
        return this.BatchRowCount;
    }

    protected void setResultSetType(int resultSetType) throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:setResultSetType()");
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw IfxErrMsg.getSQLException(-79775, this.jconn);
        }
        this.ResultSetType = resultSetType;
    }

    protected void setResultSetConcurrency(int resultSetConcurrencyType) throws SQLException {
        this.trace.writeTrace(2, "IfxStatement:setResultSetConcurrency()");
        if (resultSetConcurrencyType != 1007) {
            throw IfxErrMsg.getSQLException(-79763, this.jconn);
        }
        this.ResultSetConcurrency = resultSetConcurrencyType;
    }

    public void registerOutputParameter(int parameterIndex, int ifxType) throws SQLException {
        this.registerOutputParameter(parameterIndex, ifxType, "");
    }

    public void registerOutputParameter(int parameterIndex, int ifxType, String udtname) throws SQLException {
        if (this.outputMetaData == null) {
            this.outputMetaData = new IfxResultSetMetaData(0, this.jconn);
        }
        switch (ifxType) {
            case 101: {
                this.outputMetaData.setIfxColumnType(parameterIndex, 44);
                this.outputMetaData.setExtendedName(parameterIndex, "clob");
                this.outputMetaData.setColumnExtendedId(parameterIndex, 11);
                this.outputMetaData.setEncodedLength(parameterIndex, 72);
                break;
            }
            case 102: {
                this.outputMetaData.setIfxColumnType(parameterIndex, 44);
                this.outputMetaData.setExtendedName(parameterIndex, "blob");
                this.outputMetaData.setColumnExtendedId(parameterIndex, 10);
                this.outputMetaData.setEncodedLength(parameterIndex, 72);
                break;
            }
            case 45: {
                this.outputMetaData.setIfxColumnType(parameterIndex, 45);
                this.outputMetaData.setExtendedName(parameterIndex, "boolean");
                this.outputMetaData.setColumnExtendedId(parameterIndex, 5);
                this.outputMetaData.setEncodedLength(parameterIndex, 1);
                break;
            }
            case 43: {
                this.outputMetaData.setIfxColumnType(parameterIndex, 43);
                this.outputMetaData.setExtendedName(parameterIndex, "lvarchar");
                this.outputMetaData.setColumnExtendedId(parameterIndex, 1);
                break;
            }
            case 40: 
            case 41: {
                this.outputMetaData.setIfxColumnType(parameterIndex, 44);
                this.outputMetaData.setExtendedName(parameterIndex, udtname);
                this.outputMetaData.setEncodedLength(parameterIndex, 4);
                break;
            }
            default: {
                this.outputMetaData.setIfxColumnType(parameterIndex, ifxType);
            }
        }
    }

    public void clearOutputParameter() {
        this.outputMetaData = null;
    }

    public void setAutoFree(boolean flag) {
        this.autoFree = flag && this.jconn.isAutoFree() ? flag : false;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int stype) {
        this.statementType = stype;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public Vector executeFastPath(String signature, Vector inParams, boolean fParam) throws SQLException {
        this.trace.writeTrace(1, "Statement.executeFastPath() entered");
        this.trace.writeTrace(3, "   executeFastPath(): sign = " + signature);
        if (inParams == null) {
            this.trace.writeTrace(3, "   executeFastPath() inParams is null");
        } else {
            this.trace.writeTrace(3, "   executeFastPath() inParams.size(): " + inParams.size());
        }
        if (signature == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, null);
        }
        if (this.prot == null) {
            try {
                Class<?> classRef = Class.forName(this.jconn.getProtoClassName());
                Class<?> connClassRef = Class.forName(this.jconn.getConnClassName());
                Class[] classArgs = new Class[]{connClassRef};
                Constructor<?> cons = classRef.getConstructor(classArgs);
                Object[] objs = new Object[]{this.jconn};
                this.prot = (IfxProtocol)cons.newInstance(objs);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
            }
        }
        this.trace.writeTrace(3, "   executeFastPath() translated input parameters");
        Vector<IfxObject> inIfxParams = new Vector<IfxObject>();
        IfxObject ifxObj = null;
        Object[] objArray = null;
        if (inParams != null) {
            int i = 0;
            while (i < inParams.size()) {
                objArray = (Object[])inParams.elementAt(i);
                this.trace.writeTrace(3, "   exfp: data class: " + objArray[0].getClass().getName());
                this.trace.writeTrace(3, "   exfp: ifx type: " + (Integer)objArray[1]);
                ifxObj = IfxValue.makeInstanceFromIfxType(this.jconn, (Integer)objArray[1]);
                ifxObj.fromObject(objArray[0]);
                this.trace.writeTrace(3, "   exfp: ifx type added: " + ifxObj.getClass().getName());
                inIfxParams.addElement(ifxObj);
                ++i;
            }
        }
        this.trace.writeTrace(3, "   executeFastPath() call prot.executeFastPath");
        Vector outIfxParams = null;
        Vector outParams = null;
        outIfxParams = this.prot.executeFastPath(signature, inIfxParams, fParam);
        this.trace.writeTrace(3, "   executeFastPath() translate output params");
        if (outIfxParams != null) {
            outParams = new Vector();
            int i = 0;
            while (i < outIfxParams.size()) {
                objArray = new Object[2];
                ifxObj = (IfxObject)outIfxParams.elementAt(i);
                this.trace.writeTrace(3, "   exFP: ifxObject type: " + ifxObj.getIfxType());
                this.trace.writeTrace(3, "   exFP: ifxObject: " + ifxObj.getClass().getName());
                objArray[0] = ifxObj.toObject();
                objArray[1] = new Integer(ifxObj.getIfxType());
                ++i;
            }
        }
        this.trace.writeTrace(1, "Statement.executeFastPath() exited");
        return outParams;
    }
}

