/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.asf.IfxASFRemoteException;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDatabaseMetaData;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxLocales;
import com.informix.jdbc.IfxNativeSQL;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.IxMap;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqliConnect
implements IfxConnection {
    private static final String JDBCExtVer = "9.201";
    private static final int JDBCIntVer = 305;
    private static final String JDBCSerialNo = "RDS#R000000";
    protected static final short HASLOG = 1;
    protected static final short ANSIMODE = 2;
    private static final short FLT2DEC = 8;
    private static final short CHGLOC = 64;
    private static final int ASFVER = 1;
    private static final int DSA722VER = 2;
    private static final int USVER = 4;
    private static final int USVER9_02 = 8;
    private static final int USVER9_03 = 16;
    private static final int USVER9_0301 = 32;
    private static final int DSA723VER = 64;
    private static final int USVER9_0303 = 128;
    private static final int USVER9_0304 = 512;
    private static final int ODS730VER = 256;
    private static final int DSA700VER = 1024;
    private static final int DSA731VER = 2048;
    private static final int DSA720VER = 4096;
    private static final int USVER9_0305 = 8192;
    private static final short NOXACT = 0;
    private static final short SXACT = 1;
    private static final short XACT = 2;
    private static final String PREFIX = "_ifxc";
    private static final String ZEROSTRING = new String("0000000000000");
    private long nextID;
    private SQLWarning connwarn;
    protected boolean isOpen = false;
    private int dbVersion;
    private int internalVersion;
    protected String externalVersion;
    protected String productName;
    private boolean floatToDec = false;
    private boolean onlineSer = false;
    private com.informix.asf.Connection asfconn;
    protected IfxProtocol proto;
    private String URL;
    protected Properties connInfo;
    protected String userName;
    private String passwd;
    private String org_url;
    protected String dbName;
    private String dbLocale;
    private String dbEncoding;
    private String clLocale;
    private String clEncoding;
    private String dbDate;
    private String glDate;
    private String dbCentury;
    private long dbTodayDate = -1L;
    private long dbTodayStart = -1L;
    Hashtable IfxToJdkEncodingTable;
    Hashtable IfxNoToJdkEncodingTable;
    Hashtable IfxToJdkLocaleTable;
    boolean Noansiwarn = true;
    protected boolean delimIdent = false;
    private boolean useV5server = false;
    private int retryCount = 1;
    String servername;
    int fetchBufSize = -1;
    private int lobCacheSize = 4096;
    private Properties PrimEnvVars;
    private Properties SecEnvVars;
    Hashtable fpCache;
    private IfxDataInputStream InputStream;
    private IfxDataOutputStream OutputStream;
    private boolean insqlexec = false;
    Trace traceObj;
    Trace protoTraceObj;
    private boolean autoCommit = true;
    private int transactionLevel = 0;
    private boolean ResetTxLevel = false;
    private short TxState = 0;
    boolean SendCommit = false;
    private boolean isDatabaseOpen = false;
    private boolean db_use_log = false;
    private boolean AnsiDb = false;
    private boolean chgLocale = false;
    private short SerWarn;
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    int CapList;
    int TypeList;
    private boolean autoFree = false;
    private boolean usePut = false;
    private boolean sessionMutexLocked = false;
    private Thread lockThread;
    protected String protoClassName;
    private IfxMap udtMap;
    private IfxMap userMap;
    private boolean useTypeCache = false;
    private int internalQuery;
    private static final int IQstart = 1;
    private static final int IQsendCommit = 2;
    private String tempdir;

    public boolean isDirect() {
        return false;
    }

    public IfxSqliConnect() throws SQLException {
    }

    public IfxSqliConnect(String url, Properties prop) throws SQLException {
        String errtxt;
        String enableCache;
        int i;
        int numPairs;
        StringTokenizer pair_tok;
        String ipAddr = null;
        String portNo = null;
        String traceFile = null;
        String traceLevelString = null;
        String protoFile = null;
        String protoLevelString = null;
        String evar = null;
        short traceLevel = 0;
        short protoLevel = 0;
        int IntVerToBeSent = 305;
        this.IfxToJdkEncodingTable = new Hashtable();
        this.IfxNoToJdkEncodingTable = new Hashtable();
        this.IfxToJdkLocaleTable = new Hashtable();
        this.URL = url;
        this.connInfo = prop;
        this.userName = this.connInfo.getProperty("USER");
        this.passwd = this.connInfo.getProperty("PASSWORD");
        this.dbName = this.connInfo.getProperty("DATABASE");
        this.org_url = this.connInfo.getProperty("USERURL");
        if (this.userName != null) {
            this.userName = this.userName.trim();
        }
        if (this.passwd != null) {
            this.passwd = this.passwd.trim();
        }
        if (this.dbName != null) {
            this.dbName = this.dbName.trim();
        }
        if (this.org_url != null) {
            this.org_url = this.org_url.trim();
        }
        protoFile = this.connInfo.getProperty("PROTOCOLTRACEFILE");
        protoLevelString = this.connInfo.getProperty("PROTOCOLTRACE");
        try {
            protoLevel = Short.parseShort(protoLevelString);
        }
        catch (NumberFormatException numberFormatException) {
            protoLevel = 0;
        }
        this.protoTraceObj = protoFile != null && protoLevel > 0 ? new Trace(protoLevel, protoFile) : new Trace();
        traceFile = this.connInfo.getProperty("TRACEFILE");
        traceLevelString = this.connInfo.getProperty("TRACE");
        try {
            traceLevel = Short.parseShort(traceLevelString);
        }
        catch (NumberFormatException numberFormatException) {
            traceLevel = 0;
        }
        this.traceObj = traceFile != null && traceLevel > 0 ? new Trace(traceLevel, traceFile) : new Trace();
        if (this.URL != null) {
            StringTokenizer urltok = new StringTokenizer(this.URL, ":");
            ipAddr = urltok.nextToken();
            portNo = urltok.nextToken();
        } else {
            ipAddr = null;
            portNo = null;
        }
        evar = this.connInfo.getProperty("DBANSIWARN");
        if (evar != null) {
            this.Noansiwarn = false;
        }
        if ((evar = this.connInfo.getProperty("FET_BUF_SIZE")) != null) {
            try {
                this.fetchBufSize = Integer.parseInt(evar);
            }
            catch (NumberFormatException numberFormatException) {
                this.fetchBufSize = -1;
            }
        }
        if ((evar = this.connInfo.getProperty("NEWLOCALE")) != null) {
            pair_tok = new StringTokenizer(evar, ":");
            numPairs = pair_tok.countTokens();
            i = 0;
            while (i < numPairs) {
                String new_locale = pair_tok.nextToken();
                StringTokenizer loc_tok = new StringTokenizer(new_locale, ",");
                String ifx_loc = loc_tok.nextToken(",");
                if (!loc_tok.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79784, this);
                }
                String jdk_loc = loc_tok.nextToken();
                this.addLocale(ifx_loc, jdk_loc);
                ++i;
            }
        }
        if ((evar = this.connInfo.getProperty("NEWCODESET")) != null) {
            pair_tok = new StringTokenizer(evar, ":");
            numPairs = pair_tok.countTokens();
            i = 0;
            while (i < numPairs) {
                String new_codeset = pair_tok.nextToken();
                StringTokenizer enc_tok = new StringTokenizer(new_codeset, ",");
                String jdkEnc = enc_tok.nextToken();
                if (!enc_tok.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                String ifxEncName = enc_tok.nextToken();
                this.addEncName(ifxEncName, jdkEnc);
                if (!enc_tok.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                String ifxEncNumber = enc_tok.nextToken();
                this.addEncNumber(ifxEncNumber, jdkEnc);
                ++i;
            }
        }
        if ((evar = this.connInfo.getProperty("LOBCACHE")) != null) {
            try {
                this.lobCacheSize = Integer.parseInt(evar);
            }
            catch (NumberFormatException numberFormatException) {
                this.lobCacheSize = 4096;
            }
        }
        if ((evar = this.connInfo.getProperty("INFORMIXCONRETRY")) != null) {
            try {
                int retry = Integer.parseInt(evar);
                if (retry >= 1) {
                    this.retryCount = retry;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.retryCount = 1;
            }
        }
        if ((evar = this.connInfo.getProperty("DELIMIDENT")) != null) {
            this.delimIdent = true;
        }
        if ((evar = this.connInfo.getProperty("USEV5SERVER")) != null) {
            IntVerToBeSent = 0;
            this.useV5server = true;
        }
        this.traceObj.writeTrace(3, "IntVerToBeSent is " + IntVerToBeSent);
        this.servername = this.connInfo.getProperty("INFORMIXSERVER");
        if (this.servername == null) {
            throw IfxErrMsg.getSQLException(-79734, this);
        }
        this.tempdir = this.connInfo.getProperty("JDBCTEMP");
        if (this.tempdir != null) {
            this.tempdir = this.tempdir.trim();
            String fsep = System.getProperty("file.separator");
            if (this.tempdir.lastIndexOf(fsep) != this.tempdir.length() - 1) {
                this.tempdir = String.valueOf(this.tempdir) + fsep;
            }
        }
        Properties optProps = new Properties();
        evar = this.connInfo.getProperty("SQLH_TYPE");
        if (evar != null) {
            ((Hashtable)optProps).put("SQLH_TYPE", evar);
            if (evar.equalsIgnoreCase("FILE")) {
                evar = this.connInfo.getProperty("SQLH_FILE");
                if (evar != null) {
                    ((Hashtable)optProps).put("SQLH_FILE", evar);
                }
            } else if (evar.equalsIgnoreCase("LDAP")) {
                evar = this.connInfo.getProperty("LDAP_URL");
                if (evar != null) {
                    ((Hashtable)optProps).put("LDAP_URL", evar);
                }
                if ((evar = this.connInfo.getProperty("LDAP_IFXBASE")) != null) {
                    ((Hashtable)optProps).put("LDAP_IFXBASE", evar);
                }
                if ((evar = this.connInfo.getProperty("LDAP_USER")) != null) {
                    ((Hashtable)optProps).put("LDAP_USER", evar);
                }
                if ((evar = this.connInfo.getProperty("LDAP_PASSWD")) != null) {
                    ((Hashtable)optProps).put("LDAP_PASSWD", evar);
                }
            }
        }
        if ((evar = this.connInfo.getProperty("SECURITY")) != null) {
            ((Hashtable)optProps).put("SECURITY", evar);
        }
        if ((evar = this.connInfo.getProperty("PROXY")) != null) {
            ((Hashtable)optProps).put("PROXY", evar);
        }
        boolean bl = (enableCache = this.connInfo.getProperty("ENABLE_TYPE_CACHE")) != null && enableCache.equalsIgnoreCase("true");
        this.useTypeCache = true;
        String addr = ipAddr == null || portNo == null ? null : this.formatURL(ipAddr, portNo);
        this.PrimEnvVars = this.SetPrimEVars();
        if (this.dbEncoding != null) {
            ((Hashtable)optProps).put("DBENC", this.dbEncoding);
        }
        try {
            this.asfconn = new com.informix.asf.Connection(this.userName, this.passwd, addr, this.servername, this.dbName, this.PrimEnvVars, JDBCExtVer, IntVerToBeSent, JDBCSerialNo, this.retryCount, optProps);
        }
        catch (IfxASFRemoteException e1) {
            errtxt = e1.toString();
            int sqlcode = e1.getError();
            if (errtxt != null && errtxt.length() > 0) {
                throw new SQLException(IfxMessage.getMessage(sqlcode, errtxt, this.getclLocale()), IfxMessage.getSQLSTATE(sqlcode), sqlcode);
            }
            throw IfxErrMsg.getSQLException(sqlcode, this);
        }
        catch (IfxASFException e2) {
            errtxt = e2.toString();
            int sqlcode = e2.getErrorId();
            if (errtxt != null && errtxt.length() > 0) {
                throw new SQLException(IfxMessage.getMessage(sqlcode, errtxt, this.getclLocale()), IfxMessage.getSQLSTATE(sqlcode), sqlcode);
            }
            throw IfxErrMsg.getSQLException(sqlcode, this);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79999, e.toString(), (IfxConnection)this);
        }
        this.internalVersion = this.asfconn.Cap_1;
        String tmp = this.asfconn.VersionNumber;
        try {
            int split = tmp.indexOf("Version");
            this.productName = tmp.substring(0, split - 1).trim();
            this.externalVersion = tmp.substring(split + 7).trim();
        }
        catch (Exception exception) {
            this.productName = "Informix Dynamic Server";
        }
        this.traceObj.writeTrace(99, "Version Info fromServer:  Internal version = " + this.internalVersion + " external version = " + this.externalVersion + " productName = " + this.productName + " tmp = " + tmp);
        this.SerWarn = this.asfconn.Warnings;
        this.OpenDbInit();
        if (this.dbName == null || this.dbName.length() == 0) {
            this.isDatabaseOpen = false;
        }
        if ((this.SerWarn & 8) != 0) {
            this.floatToDec = true;
        }
        this.isOpen = true;
        try {
            this.InputStream = this.asfconn.getIfxDataInputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        try {
            this.OutputStream = this.asfconn.getIfxDataOutputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        this.traceObj.writeTrace(99, "Instantiating the protocol object...");
        try {
            this.protoClassName = this.connInfo.getProperty("PROTOCOLCLASS");
            this.traceObj.writeTrace(99, "IfxSqliConnect.protoName: " + this.protoClassName);
            String connClassName = this.connInfo.getProperty("CONNECTIONCLASS");
            Class<?> connClass = Class.forName(connClassName);
            Class[] classArgs = new Class[]{connClass};
            Class<?> classRef = Class.forName(this.protoClassName);
            Constructor<?> cons = classRef.getConstructor(classArgs);
            Object[] objs = new Object[]{this};
            this.proto = (IfxProtocol)cons.newInstance(objs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), (IfxConnection)this);
        }
        this.traceObj.writeTrace(99, "Instantiated the protocol object...");
        try {
            this.getServerVer();
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw new SQLException(e.toString());
        }
        if (this.connInfo.getProperty("IFX_AUTOFREE", "0").equals("1") && this.isAutoFree()) {
            this.autoFree = true;
        }
        if (this.connInfo.getProperty("IFX_USEPUT", "0").equals("1")) {
            this.usePut = true;
        }
        this.SecEnvVars = this.SetSecEVars();
        try {
            this.proto.executeEnv(this.SecEnvVars);
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        this.fpCache = new Hashtable();
        if (this.isGLS()) {
            if (this.dbName != null && (this.chgLocale || this.dbEncoding == null)) {
                this.setDatabaseLocale();
            }
        } else {
            if (this.dbEncoding != null || this.clLocale != null || this.glDate != null) {
                throw IfxErrMsg.getSQLException(-79789, this);
            }
            this.dbEncoding = null;
            this.dbLocale = null;
            this.clLocale = null;
            this.clEncoding = null;
            this.glDate = null;
        }
        if (this.useV5server && this.dbName != null) {
            this.set5ServerType();
        }
    }

    public void close() throws SQLException {
        this.traceObj.writeTrace(1, "IfxSqliConnect: close() called");
        if (!this.isOpen) {
            return;
        }
        if (this.isDatabaseOpen) {
            this.CloseDbReset();
        }
        this.clearWarnings();
        this.isOpen = false;
        this.dbName = null;
        this.floatToDec = false;
        this.insqlexec = false;
        this.onlineSer = false;
        this.InputStream = null;
        this.OutputStream = null;
        Object URL2 = null;
        Object userName = null;
        Object passwd = null;
        this.dbVersion = 0;
        this.internalVersion = 0;
        this.externalVersion = null;
        try {
            if (this.asfconn != null) {
                this.asfconn.disconnectOrderly();
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this);
        }
        this.traceObj.writeTrace(1, "IfxSqliConnect: close() exited");
        this.traceObj.closeTraceFile();
    }

    public boolean isClosed() throws SQLException {
        return !this.isOpen;
    }

    public void commit() throws SQLException {
        this.traceObj.writeTrace(1, "IfxSqliConnect: commit() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        try {
            this.proto.executeCommit();
        }
        catch (SQLException e) {
            this.setTxEndState();
            throw e;
        }
        catch (Exception e1) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79716, e1.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
        this.traceObj.writeTrace(1, "IfxSqliConnect: commit() exited");
    }

    public void rollback() throws SQLException {
        this.traceObj.writeTrace(1, "IfxSqliConnect: rollback() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        try {
            this.proto.executeRollback();
        }
        catch (SQLException e) {
            this.setTxEndState();
            throw e;
        }
        catch (Exception e1) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79747, e1.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
        this.traceObj.writeTrace(1, "IfxSqliConnect: rollback() exited");
    }

    public void setAutoCommit(boolean newAC) throws SQLException {
        this.traceObj.writeTrace(1, "IfxSqliConnect: setAutoCommit() called");
        this.traceObj.writeTrace(3, "set autoCommit to " + newAC);
        this.traceObj.writeTrace(3, "current tx state is ", this.TxState);
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        this.autoCommit = newAC;
        if (this.autoCommit) {
            if (this.TxState == 2) {
                try {
                    this.proto.executeRollback();
                }
                catch (SQLException sQLException) {}
                this.setTxEndState();
            }
        } else {
            if (!this.db_use_log) {
                this.autoCommit = true;
                throw IfxErrMsg.getSQLException(-79744, this);
            }
            if (this.TxState == 1) {
                if (this.AnsiDb) {
                    this.TxState = (short)2;
                    this.SendCommit = false;
                } else {
                    try {
                        this.proto.executeBegin();
                    }
                    catch (SQLException sQLException) {
                        this.traceObj.writeTrace(2, "setAutoCommit.executeBegin has failed");
                        return;
                    }
                    this.setTxBeginState();
                }
            }
        }
        this.traceObj.writeTrace(3, "autoCommit now set to " + this.autoCommit);
        this.traceObj.writeTrace(3, "TxState has been changed to ", this.TxState);
        this.traceObj.writeTrace(3, "SendCommit has been changed to " + this.SendCommit);
        this.traceObj.writeTrace(1, "IfxSqliConnect: setAutoCommit() exited");
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void clearWarnings() throws SQLException {
        this.connwarn = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning protoWarn;
        if (this.proto != null && (protoWarn = this.proto.getWarnings()) != null) {
            this.addWarning(protoWarn, null);
            this.proto.clearWarnings();
        }
        return this.connwarn;
    }

    void addWarning(SQLWarning excp, String sqlstate) {
        this.traceObj.writeTrace(99, "IfxSqliConnect.addWarning() called");
        this.traceObj.writeTrace(99, "IfxSqliConnect.sqlstate = " + sqlstate);
        if (excp == null) {
            excp = IfxWarnMsg.getSQLWarning(sqlstate, null, this);
        }
        if (this.connwarn == null) {
            this.connwarn = excp;
        } else {
            this.connwarn.setNextWarning(excp);
        }
    }

    public Statement createStatement() throws SQLException {
        this.traceObj.writeTrace(99, "IfxSqliConnect.createStatement() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement stmt = new IfxStatement(this);
        this.traceObj.writeTrace(99, "IfxSqliConnect.createStatement() exited");
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.traceObj.writeTrace(99, "IfxSqliConnect.createStatement() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement stmt = new IfxStatement(this);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement stmt = new IfxPreparedStatement(this, sql);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.traceObj.writeTrace(99, "IfxSqliConnect.preparedStatement() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement stmt = new IfxPreparedStatement(this, sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement stmt = new IfxCallableStatement((Connection)this, sql);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.traceObj.writeTrace(99, "IfxSqliConnect.CallableStatement() called");
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement stmt = new IfxCallableStatement((Connection)this, sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public IfxMap getTypeMap() throws SQLException {
        if (this.userMap == null) {
            this.userMap = new IxMap(this.isDelimIdentSet());
        }
        return this.userMap;
    }

    public synchronized void setTypeMap(IfxMap map) throws SQLException {
        this.userMap = map;
    }

    public String nativeSQL(String sql) throws SQLException {
        IfxNativeSQL sqlString = new IfxNativeSQL(sql, this);
        return sqlString.getNewString();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new IfxDatabaseMetaData(this);
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.getDbName();
    }

    public void setReadOnly(boolean mode) throws SQLException {
        throw IfxErrMsg.getSQLException(-79745, this);
    }

    public boolean isReadOnly() throws SQLException {
        throw IfxErrMsg.getSQLException(-79745, this);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String TxLevel = null;
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.isDatabaseOpen) {
            throw IfxErrMsg.getSQLException(-349, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79746, this);
        }
        if (level != 1 && level != 2 && level != 4 && level != 8) {
            throw IfxErrMsg.getSQLException(-79747, this);
        }
        if (this.TxState == 1) {
            if (!this.ResetTxLevel && level == this.transactionLevel) {
                return;
            }
            switch (level) {
                case 1: {
                    TxLevel = new String("dirty read");
                    break;
                }
                case 2: {
                    TxLevel = new String("committed read");
                    break;
                }
                case 4: 
                case 8: {
                    TxLevel = new String("repeatable read");
                    break;
                }
            }
            Statement stmt = this.createStatement();
            int rowcount = stmt.executeUpdate("set isolation to " + TxLevel);
            stmt.close();
        } else if (this.TxState == 2) {
            switch (level) {
                case 1: {
                    TxLevel = new String("read uncommitted");
                    break;
                }
                case 2: {
                    TxLevel = new String("read committed");
                    break;
                }
                case 4: {
                    TxLevel = new String("repeatable read");
                    break;
                }
                case 8: {
                    TxLevel = new String("serializable");
                    break;
                }
            }
            Statement stmt = this.createStatement();
            int rowcount = stmt.executeUpdate("set transaction isolation level " + TxLevel);
            stmt.close();
            this.ResetTxLevel = true;
        }
        this.transactionLevel = level;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionLevel;
    }

    public int getDatabaseType() throws SQLException {
        if (!this.isDatabaseOpen) {
            return 0;
        }
        if (this.AnsiDb) {
            return 1;
        }
        if (this.db_use_log) {
            return 2;
        }
        return 3;
    }

    void setCapList(int CapList) {
        this.CapList = CapList;
    }

    void setTypeList(int TypeList) {
        this.TypeList = TypeList;
    }

    public boolean isDbOpen() throws SQLException {
        return this.isDatabaseOpen;
    }

    public String getConnectionDbName() throws SQLException {
        return this.dbName;
    }

    public String getDbName() throws SQLException {
        if (this.dbName != null) {
            return this.dbName;
        }
        if (!this.isSysmaster() || !this.isCurSessInfo()) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxConnection.getDbName().", (IfxConnection)this);
        }
        try {
            String sql = "select scs_currdb from sysmaster:informix.syssqlcurses";
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            String currDb = null;
            if (rs.next()) {
                currDb = rs.getString(1);
            }
            rs.close();
            stmt.close();
            if (currDb != null) {
                currDb = stringUtil.trimTrailings(currDb);
            }
            return currDb;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    void setDatabaseOpen(boolean val, short stmtWarn) throws SQLException {
        this.traceObj.writeTrace(3, "IfxSqliConnect.setDatabaseOpen(): val " + val);
        if (val) {
            this.SerWarn = stmtWarn;
            this.OpenDbInit();
            if (this.isGLS()) {
                this.setDatabaseLocale();
            }
        } else {
            this.CloseDbReset();
        }
    }

    public String getURL() throws SQLException {
        return this.org_url;
    }

    public String getUserName() throws SQLException {
        if (this.asfconn != null) {
            return this.asfconn.getUserName();
        }
        return this.userName;
    }

    public String getJDBCVersion() throws SQLException {
        return IfxDriver.getJDBCVersion();
    }

    public String getDbProductName() throws SQLException {
        return this.productName;
    }

    public String getDbVersion() throws SQLException {
        return this.externalVersion == null ? "unknown" : this.externalVersion;
    }

    private void OpenDbInit() throws SQLException {
        this.traceObj.writeTrace(1, "IfxSqliConnect: OpenDbInit() called");
        this.traceObj.writeTrace(3, "IfxSqliConnect.OpenDbInit(): SerWarn ", this.SerWarn);
        this.CloseDbReset();
        this.isDatabaseOpen = true;
        if ((this.SerWarn & 1) != 0) {
            this.db_use_log = true;
            this.transactionLevel = 2;
        }
        if ((this.SerWarn & 2) != 0) {
            this.AnsiDb = true;
            this.transactionLevel = 8;
        }
        if ((this.SerWarn & 0x40) != 0) {
            this.chgLocale = true;
        }
        this.TxState = !this.db_use_log ? (short)0 : 1;
        if (this.AnsiDb) {
            this.SendCommit = true;
        }
        this.clearWarnings();
        this.setWarnings();
        this.traceObj.writeTrace(1, "IfxSqliConnect: OpenDbInit() exited");
    }

    private void CloseDbReset() {
        this.traceObj.writeTrace(1, "IfxSqliConnect: CloseDbReset() called");
        this.AnsiDb = false;
        this.chgLocale = false;
        this.transactionLevel = 0;
        this.autoCommit = true;
        this.db_use_log = false;
        this.isDatabaseOpen = false;
        this.TxState = 0;
        this.SendCommit = false;
        this.ResetTxLevel = false;
        this.traceObj.writeTrace(1, "IfxSqliConnect: CloseDbReset() exited");
    }

    private void setDatabaseLocale() throws SQLException {
        block5: {
            this.traceObj.writeTrace(1, "IfxSqliConnect: setDatabaseLocale() called");
            try {
                String query_stm = this.onlineSer ? "select site from informix.systables where tabname = ' GL_COLLATE'" : "select dirpath from informix.systables where tabname = ' GL_COLLATE'";
                Statement stmt = this.createStatement();
                ResultSet rs = stmt.executeQuery(query_stm);
                String site = null;
                if (rs.next()) {
                    site = rs.getString(1);
                    rs.close();
                    stmt.close();
                }
                this.parseIfxLocale("db", site.trim());
                String jdkenc = this.getEncNo(this.dbEncoding);
                if (jdkenc == null) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                this.dbEncoding = jdkenc;
                if (this.clLocale != null) break block5;
                this.clEncoding = this.dbEncoding;
                String tempLoc = this.getLocale(this.dbLocale);
                if (tempLoc != null) {
                    this.clLocale = this.dbLocale;
                    break block5;
                }
                throw IfxErrMsg.getSQLException(-79784, this);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString());
            }
        }
    }

    protected Properties SetPrimEVars() throws SQLException {
        String dbtoday;
        String tmpclLocale;
        String[] PEVarList = new String[]{"INFORMIXSTACKSIZE", "DBSPACETEMP", "DBTODAY", "SLABEL", "SINGLELEVEL", "LKNOTIFY", "LOCKDOWN", "NODEFDAC", "DELIMIDENT", "SKINHIBIT", "SKALL", "SKSHOW", "DB_LOCALE", "CLIENT_LOCALE", "DBDATE", "GL_DATE", "DBCENTURY", "RASHELP", "STMT_CACHE", "STMT_CACHE_DEBUG", "IFX_LONGID"};
        Properties pList = new Properties();
        ((Hashtable)pList).put("SINGLELEVEL", "no");
        ((Hashtable)pList).put("LKNOTIFY", "yes");
        ((Hashtable)pList).put("LOCKDOWN", "no");
        ((Hashtable)pList).put("NODEFDAC", "no");
        ((Hashtable)pList).put("SKINHIBIT", "0");
        ((Hashtable)pList).put("SKALL", "0");
        ((Hashtable)pList).put("SKSHOW", "0");
        String evar = null;
        int i = 0;
        while (i < PEVarList.length) {
            evar = this.connInfo.getProperty(PEVarList[i]);
            if (evar != null) {
                ((Hashtable)pList).put(PEVarList[i], evar);
            }
            ++i;
        }
        String tmpdbLocale = pList.getProperty("DB_LOCALE");
        if (tmpdbLocale != null) {
            this.parseIfxLocale("db", tmpdbLocale);
            String tdbEncoding = this.getEncName(this.dbEncoding);
            if (tdbEncoding == null) {
                this.dbEncoding = this.getEncNo(this.dbEncoding);
                if (this.dbEncoding == null) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
            } else {
                this.dbEncoding = tdbEncoding;
            }
            this.dbLocale = this.getLocale(this.dbLocale);
            if (this.dbLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else {
            this.dbLocale = null;
            this.dbEncoding = null;
        }
        if ((tmpclLocale = pList.getProperty("CLIENT_LOCALE")) != null) {
            this.parseIfxLocale("cl", tmpclLocale);
            this.clLocale = this.getLocale(this.clLocale);
            if (this.clLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else if (this.dbLocale != null && this.dbEncoding != null) {
            this.clEncoding = this.dbEncoding;
            this.clLocale = this.dbLocale;
        } else {
            this.clEncoding = null;
            this.clLocale = null;
        }
        this.dbDate = pList.getProperty("DBDATE");
        this.glDate = pList.getProperty("GL_DATE");
        if (this.dbDate == null && this.glDate == null && pList.getProperty("CLIENT_LOCALE") == null && pList.getProperty("DB_LOCALE") == null) {
            this.dbDate = "Y4MD-";
            ((Hashtable)pList).put("DBDATE", "Y4MD-");
        }
        this.dbCentury = pList.getProperty("DBCENTURY");
        if (!(this.dbCentury == null || this.dbCentury.equalsIgnoreCase("R") || this.dbCentury.equalsIgnoreCase("F") || this.dbCentury.equalsIgnoreCase("C") || this.dbCentury.equalsIgnoreCase("P"))) {
            this.dbCentury = null;
        }
        if ((dbtoday = pList.getProperty("DBTODAY")) != null) {
            try {
                this.dbTodayDate = ((Date)Timestamp.valueOf(dbtoday)).getTime();
                this.dbTodayStart = System.currentTimeMillis();
            }
            catch (Exception exception) {
                this.dbTodayDate = -1L;
                this.dbTodayStart = -1L;
            }
        }
        ((Hashtable)pList).put("DBPATH", ".");
        ((Hashtable)pList).put("IFX_UPDDESC", "1");
        return pList;
    }

    private void parseIfxLocale(String prefix, String tmpValue) throws SQLException {
        String tLocale = null;
        String tEncoding = null;
        StringTokenizer itok = new StringTokenizer(tmpValue, "@");
        tmpValue = itok.nextToken();
        itok = new StringTokenizer(tmpValue, ".");
        tLocale = itok.nextToken();
        if (!itok.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79784, this);
        }
        tEncoding = itok.nextToken();
        if (prefix == "cl") {
            this.clLocale = tLocale;
            this.clEncoding = tEncoding;
        } else {
            this.dbLocale = tLocale;
            this.dbEncoding = tEncoding;
        }
    }

    private Properties SetSecEVars() {
        String[] SEVarList = new String[]{"DBMAXPROC", "DBTEMP", "DEBUG", "DUMPCORE", "DUMPDIR", "DUMPMEM", "DUMPSHMEM", "GCORE", "NOSHMSG", "PSORT_DBTEMP", "PSORT_NPROCS", "SHELL", "TZ", "W1", "W2", "NOSORTINDEX", "SORTINDEX", "DBUPSPACE", "SUBQCACHESZ", "NO_KEYFIRST", "NO_PREDPROMOTE", "NO_SUBQF", "PDQPRIORITY", "IFX_DIRECTIVES", "IFX_NO_OROPT", "IFX_UPDDESC", "OPTCOMPIND", "INFORMIXCONRETRY", "INFORMIXOPCACHE", "SQLSTATS", "DBCENTURY", "PLCONFIG", "DBANSIWARN", "PATH", "CR_LOCKBLOB", "LOCKSSFU", "LIGHT_SCANS", "SQL_FROM_DBIMPORT", "PLOAD_LO_PATH", "OPT_GOAL", "OPTOFC"};
        Properties sList = new Properties();
        ((Hashtable)sList).put("DBTEMP", "/tmp");
        ((Hashtable)sList).put("SUBQCACHESZ", "10");
        String evar = null;
        int i = 0;
        while (i < SEVarList.length) {
            evar = this.connInfo.getProperty(SEVarList[i]);
            if (evar != null) {
                ((Hashtable)sList).put(SEVarList[i], evar);
            }
            ++i;
        }
        return sList;
    }

    private void getServerVer() throws SQLException {
        String extVer = null;
        this.traceObj.writeTrace(1, "IfxSqliConnect: getServerVer() called");
        this.traceObj.writeTrace(3, "internalVersion is ", this.internalVersion);
        if (this.useV5server) {
            this.traceObj.writeTrace(99, "useV5server is true");
        } else {
            this.traceObj.writeTrace(99, "useV5server is false");
        }
        if (this.internalVersion == 0) {
            try {
                this.proto.executeVersion();
                extVer = this.proto.getServerVersion();
                if (this.externalVersion == null) {
                    this.externalVersion = extVer;
                }
                this.traceObj.writeTrace(3, "getServerVer.extVer is ", extVer);
            }
            catch (SQLException e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this);
            }
            this.dbVersion = extVer.compareTo("9.03") == 0 ? 5149 : (extVer.compareTo("9.02") >= 0 ? 5133 : (extVer.compareTo("9.00") >= 0 ? 5125 : (extVer.compareTo("7.31") >= 0 && extVer.compareTo("7.z") <= 0 ? 7491 : (extVer.compareTo("7.30") >= 0 && extVer.compareTo("7.z") <= 0 ? 5443 : (extVer.compareTo("7.23") >= 0 && extVer.compareTo("7.z") <= 0 ? 5187 : (extVer.compareTo("7.22") >= 0 && extVer.compareTo("7.z") <= 0 ? 5123 : (extVer.compareTo("7.20") >= 0 && extVer.compareTo("7.z") <= 0 ? 5121 : (extVer.compareTo("7.00") >= 0 ? 1025 : (extVer.compareTo("6.00") >= 0 ? 1 : 0)))))))));
        } else {
            this.dbVersion = 5149;
            if (this.internalVersion >= 305) {
                this.dbVersion |= 0x22A0;
            } else if (this.internalVersion >= 304) {
                this.dbVersion |= 0x2A0;
            } else if (this.internalVersion >= 303) {
                this.dbVersion |= 0xA0;
            } else if (this.internalVersion >= 301) {
                this.dbVersion |= 0x20;
            } else if (this.internalVersion < 300) {
                this.dbVersion = 0;
            }
        }
        this.traceObj.writeTrace(3, "dbVersion is ", this.dbVersion);
        if (this.useV5server && this.dbVersion != 0) {
            throw IfxErrMsg.getSQLException(-79762, this);
        }
        this.traceObj.writeTrace(1, "IfxSqliConnect: getServerVer exited");
    }

    IfxDataOutputStream Ifxproto_send() {
        return this.OutputStream;
    }

    IfxDataInputStream Ifxproto_receive() {
        return this.InputStream;
    }

    void setInSQLExec(boolean value) {
        this.insqlexec = value;
    }

    boolean getInsqlexec() {
        return this.insqlexec;
    }

    void setTxEndState() {
        this.traceObj.writeTrace(1, "IfxSqliConnect: setTxEndState() called");
        this.traceObj.writeTrace(3, "Current TxState is ", this.TxState);
        this.traceObj.writeTrace(3, "Current SendCommit is " + this.SendCommit);
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 2) {
            this.TxState = 1;
            if (this.ResetTxLevel) {
                try {
                    this.setTransactionIsolation(this.transactionLevel);
                }
                catch (SQLException sQLException) {
                    this.traceObj.writeTrace(2, "setTxEndState.setTransactionIsolation has failed");
                }
                this.ResetTxLevel = false;
            }
            if (this.autoCommit) {
                if (this.AnsiDb) {
                    this.SendCommit = true;
                }
            } else if (this.AnsiDb) {
                this.TxState = (short)2;
            } else {
                try {
                    this.proto.executeBegin();
                }
                catch (SQLException sQLException) {
                    this.traceObj.writeTrace(2, "setTxEndState.executeBegin has failed");
                    return;
                }
                this.setTxBeginState();
            }
        }
        this.traceObj.writeTrace(3, "TxState is changed to ", this.TxState);
        this.traceObj.writeTrace(3, "SendCommit is changed to " + this.SendCommit);
        this.traceObj.writeTrace(1, "IfxSqliConnect: setTxEndState() exited");
    }

    void setTxBeginState() {
        this.traceObj.writeTrace(1, "IfxSqliConnect: setTxBeginState() called");
        this.traceObj.writeTrace(3, "Current TxState is ", this.TxState);
        this.traceObj.writeTrace(3, "Current SendCommit is " + this.SendCommit);
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 1) {
            this.TxState = (short)2;
            this.SendCommit = false;
        }
        this.traceObj.writeTrace(3, "TxState is changed to ", this.TxState);
        this.traceObj.writeTrace(3, "SendCommit is changed to " + this.SendCommit);
        this.traceObj.writeTrace(1, "IfxSqliConnect: setTxBeginState() exited");
    }

    public boolean isDelimIdentSet() {
        return this.delimIdent;
    }

    public boolean isGLS() {
        return (this.dbVersion & 0x1000) != 0;
    }

    public boolean isOnLine() {
        return this.onlineSer;
    }

    public boolean isLongID() {
        return (this.dbVersion & 0x200) != 0;
    }

    public boolean is90303() {
        return (this.dbVersion & 0x80) != 0;
    }

    public boolean is9301() {
        return (this.dbVersion & 0x20) != 0;
    }

    public boolean isANSIJoin() {
        return (this.dbVersion & 0xA00) != 0;
    }

    boolean is903() {
        return (this.dbVersion & 0x10) != 0;
    }

    boolean is902() {
        return (this.dbVersion & 8) != 0;
    }

    public boolean isUSVER() {
        return (this.dbVersion & 4) != 0;
    }

    public boolean isIEEEM() {
        return !this.floatToDec;
    }

    public boolean isSysmaster() {
        return this.onlineSer && this.isASF();
    }

    boolean isASF() {
        return (this.dbVersion & 1) != 0;
    }

    public boolean isAutoFree() {
        return (this.dbVersion & 0xA) != 0;
    }

    boolean isDefPrep() {
        return (this.dbVersion & 0x60) != 0;
    }

    boolean isFetchArr() {
        return (this.dbVersion & 0x180) != 0;
    }

    boolean isCurSessInfo() {
        return (this.dbVersion & 0x400) != 0;
    }

    public Trace getTrace() {
        return this.traceObj;
    }

    public Trace getProtoTrace() {
        return this.protoTraceObj;
    }

    synchronized boolean lockSession() {
        return this.lockSession(-1L);
    }

    synchronized boolean lockSession(long timeout) {
        try {
            while (this.sessionMutexLocked) {
                if (timeout == -1L) {
                    Thread.yield();
                    this.wait();
                    continue;
                }
                Thread.yield();
                this.wait(timeout);
            }
            this.sessionMutexLocked = true;
            this.traceObj.writeTrace(99, "Connection.lockSession(): entering critical session");
            return true;
        }
        catch (Exception exception) {
            this.sessionMutexLocked = false;
            return false;
        }
    }

    synchronized boolean unlockSession() {
        this.traceObj.writeTrace(99, "Connection.unlockSession() called");
        if (this.sessionMutexLocked) {
            this.sessionMutexLocked = false;
        }
        this.notify();
        this.traceObj.writeTrace(99, "Connection.unlockSession() exited");
        return true;
    }

    void abortSession() {
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.notify();
    }

    public synchronized String getGeneratedCursor() {
        String cursorName = Long.toString(this.nextID, 36);
        cursorName = PREFIX + ZEROSTRING.substring(0, ZEROSTRING.length() - cursorName.length()) + cursorName;
        if (this.nextID++ >= Long.MAX_VALUE) {
            this.nextID = 0L;
        }
        return cursorName;
    }

    public String getProtoClassName() {
        return this.protoClassName;
    }

    public String getConnClassName() {
        return "com.informix.jdbc.IfxSqliConnect";
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void setWarnings() {
        set = 0;
        if (this.SerWarn == 0) {
            return;
        }
        w = this.SerWarn;
        i = 1;
        while (i <= 6) {
            set = w & 1;
            if (set != 1) ** GOTO lbl30
            this.serverWarningsString.setCharAt(i, 'W');
            switch (i) {
                case 1: {
                    this.addWarning(null, "01I01");
                    break;
                }
                case 2: {
                    this.addWarning(null, "01I03");
                    break;
                }
                case 3: {
                    this.addWarning(null, "01I04");
                    this.onlineSer = true;
                    break;
                }
                case 4: {
                    this.addWarning(null, "01I05");
                    break;
                }
                case 5: {
                    this.addWarning(null, "01I06");
                    break;
                }
                case 6: {
                    this.addWarning(null, "01I10");
                    break;
                }
lbl30:
                // 1 sources

                this.serverWarningsString.setCharAt(i, ' ');
                break;
            }
            w = (short)(w >> 1);
            i = (short)(i + 1);
        }
    }

    private String formatURL(String ipAddr, String portNo) {
        if (ipAddr == null || portNo == null) {
            return null;
        }
        return String.valueOf(ipAddr) + "," + portNo;
    }

    private void setInternalQuery(boolean start) throws SQLException {
        this.traceObj.writeTrace(1, "setInternalQuery() called");
        this.traceObj.writeTrace(3, "start " + start);
        this.traceObj.writeTrace(3, "autoCommit currently " + this.autoCommit);
        this.traceObj.writeTrace(3, "TxState currently " + this.TxState);
        this.traceObj.writeTrace(3, "SendCommit currently " + this.SendCommit);
        if (!this.AnsiDb || !this.autoCommit) {
            return;
        }
        if (this.TxState == 0) {
            return;
        }
        if (start) {
            this.autoCommit = false;
            if (this.SendCommit) {
                this.internalQuery |= 2;
                this.SendCommit = false;
            }
            this.internalQuery |= 1;
        } else if ((this.internalQuery & 1) > 0) {
            this.autoCommit = true;
            if ((this.internalQuery & 2) > 0) {
                this.SendCommit = true;
            }
            this.internalQuery = 0;
        }
    }

    protected IfxUDTInfo addUDTInfo(String udtOwner, String udtName) throws SQLException {
        this.traceObj.writeTrace(1, "Connection.addUDTInfo() entered");
        this.traceObj.writeTrace(3, "  addUDTInfo owner: " + udtOwner + "  addUDTInfo udtName: " + udtName);
        if (udtName == null) {
            return null;
        }
        ResultSet rs = null;
        Object stmt = null;
        IfxUDTInfo udtInfo = null;
        boolean ownedByConnUser = false;
        int numOtherUser = 0;
        int CONN_USER = 0;
        int OTHER_USER = 1;
        IfxUDTInfo[] keepUdtInfo = new IfxUDTInfo[]{null, null};
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.udtMap == null) {
            this.udtMap = new IxMap(this.isDelimIdentSet());
        }
        this.setInternalQuery(true);
        if (udtOwner == null) {
            udtOwner = new String("%");
        }
        try {
            PreparedStatement pstmt = this.prepareStatement("select extended_id, mode, owner, name, type, source, length from informix.sysxtdtypes where mode in ('R','B','D', 'C') and name like ? order by extended_id");
            pstmt.setString(1, udtName);
            rs = pstmt.executeQuery();
            String mode = null;
            String owner = null;
            String name = null;
            while (rs.next()) {
                int cnt;
                int xid = rs.getInt(1);
                mode = rs.getString(2);
                owner = rs.getString(3);
                name = rs.getString(4);
                short IfxType = rs.getShort(5);
                int source = rs.getInt(6);
                int sourceLength = rs.getInt(7);
                udtInfo = this.loadUDT(xid, mode, name, owner, IfxType, source, sourceLength);
                if (mode.equals("R") || mode.equals("C")) {
                    udtInfo.structInfo = this.loadStructInfo(xid);
                }
                if (this.useTypeCache) {
                    if (this.getDatabaseType() == 1) {
                        this.udtMap.put(String.valueOf(owner) + "." + name, udtInfo);
                    } else {
                        this.udtMap.put(name, udtInfo);
                    }
                }
                String connUser = this.getUserName();
                String typeOwner = owner.trim();
                if (typeOwner.equals(connUser)) {
                    ownedByConnUser = true;
                    keepUdtInfo[CONN_USER] = udtInfo;
                    if (this.useTypeCache) continue;
                    break;
                }
                PreparedStatement pstmt2 = this.prepareStatement("select count(*) from informix.sysxtdtypeauth t where t.type = ? and (t.grantee in ('public', ?) or exists (select rolename from informix.sysroleauth r where t.grantee = r.rolename and r.grantee = ?) ) and t.auth in ('-u', '-U')");
                pstmt2.setInt(1, xid);
                pstmt2.setString(2, connUser);
                pstmt2.setString(3, connUser);
                ResultSet rs2 = pstmt2.executeQuery();
                if (rs2.next() && (cnt = rs2.getInt(1)) > 0) {
                    if (numOtherUser == 0) {
                        keepUdtInfo[OTHER_USER] = udtInfo;
                    }
                    ++numOtherUser;
                }
                rs2.close();
                pstmt2.close();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ex) {
            this.setInternalQuery(false);
            throw ex;
        }
        this.setInternalQuery(false);
        this.traceObj.writeTrace(1, "Connection.addUDTInfo() exited");
        if (udtName.equals("%")) {
            return null;
        }
        if (!ownedByConnUser && numOtherUser == 0) {
            return null;
        }
        if (ownedByConnUser) {
            return keepUdtInfo[CONN_USER];
        }
        if (numOtherUser == 1) {
            return keepUdtInfo[OTHER_USER];
        }
        throw IfxErrMsg.getSQLException(-79770, this);
    }

    public Object loadUDTba(int xid, byte[] modeba, byte[] nameba, byte[] ownerba, short IfxType, int source, int sourceLength) {
        String mode = new String(modeba, 0, 129);
        String typename = new String(nameba, 0, 129);
        String owner = new String(ownerba, 0, 129);
        Vector infoVector = new Vector();
        this.traceObj.writeTrace(99, "loadUDTba: mode " + mode + " typename " + typename + " owner " + owner + " xid " + xid + " IfxType " + IfxType + " source " + source + " sourceLength " + sourceLength);
        IfxUDTInfo udtInfo = this.loadUDT(xid, mode, typename, owner, IfxType, source, sourceLength);
        this.traceObj.writeTrace(99, "loadUDTba: udtInfo is " + udtInfo);
        udtInfo.structInfo = infoVector;
        return udtInfo;
    }

    private IfxUDTInfo loadUDT(int xid, String mode, String name, String owner, short IfxType, int source, int sourceLength) {
        this.traceObj.writeTrace(1, "Connection.loadUDT() entered");
        IfxUDTInfo udtInfo = new IfxUDTInfo();
        udtInfo.SQLtype = IfxType & 0xFF;
        udtInfo.xid = xid;
        this.traceObj.writeTrace(99, "loadUDT called: type is " + udtInfo.SQLtype + " xid is " + xid);
        udtInfo.JDBCtype = mode.equals("B") ? (short)2000 : (mode.equals("D") ? (short)2001 : (short)2002);
        udtInfo.name = name;
        udtInfo.owner = owner;
        udtInfo.source = source;
        if (mode.equals("D") && udtInfo.source == 0) {
            udtInfo.source = IfxType & 0xFF;
        }
        udtInfo.sourceLength = sourceLength;
        this.traceObj.writeTrace(99, "loadUDT exits");
        this.traceObj.writeTrace(1, "Connection.loadUDT() exited");
        this.traceObj.writeTrace(1, "Connection.loadUDT() exited");
        return udtInfo;
    }

    private Vector loadStructInfo(int xid) throws SQLException {
        this.traceObj.writeTrace(1, "Connection.loadStructInfo() entered");
        Vector<IfxColumnInfo> parentInfoVector = new Vector<IfxColumnInfo>();
        Vector<IfxColumnInfo> childInfoVector = new Vector<IfxColumnInfo>();
        PreparedStatement pstmt1 = this.prepareStatement("select extended_id, seqno, levelno, parent_no,        fieldname, fieldno, type, length, xtd_type_id from informix.sysattrtypes where extended_id = ? order by seqno");
        pstmt1.setInt(1, xid);
        ResultSet rs1 = pstmt1.executeQuery();
        PreparedStatement pstmt2 = this.prepareStatement("select owner, name from informix.sysxtdtypes where extended_id = ?");
        while (rs1.next()) {
            IfxColumnInfo type = new IfxColumnInfo();
            type.Seqno = rs1.getShort(2);
            type.Levelno = rs1.getShort(3);
            type.Parentno = rs1.getShort(4);
            type.ColName = rs1.getString(5);
            type.Fieldno = rs1.getShort(6);
            type.SQLtype = rs1.getShort(7);
            type.ColLength = rs1.getShort(8);
            type.ExtendedId = rs1.getInt(9);
            this.traceObj.writeTrace(3, "SeqNo: " + type.Seqno);
            this.traceObj.writeTrace(3, "ColName: " + type.ColName);
            this.traceObj.writeTrace(3, "SQLtype: " + type.SQLtype);
            this.traceObj.writeTrace(3, "ExtendedId: " + type.ExtendedId);
            IfxResultSetMetaData.setTypeBooleanFields(type, type.SQLtype);
            type.SQLtype &= 0xFF;
            if (type.ExtendedId != 0) {
                if (type.ExtendedId == 1) {
                    type.SQLtype = 43;
                } else if (type.ExtendedId == 5) {
                    type.SQLtype = 45;
                } else if (type.ExtendedId == 10) {
                    type.SQLtype = 102;
                } else if (type.ExtendedId == 11) {
                    type.SQLtype = 101;
                } else {
                    pstmt2.setInt(1, type.ExtendedId);
                    ResultSet rs2 = pstmt2.executeQuery();
                    rs2.next();
                    type.ExtendedOwner = rs2.getString(1);
                    type.ExtendedName = rs2.getString(2);
                    rs2.close();
                    if (IfxTypes.isComplexType(type.SQLtype)) {
                        Vector v = this.loadStructInfo(type.ExtendedId);
                        type.child = ((IfxColumnInfo)v.elementAt((int)0)).child;
                    }
                }
            } else {
                type.ExtendedOwner = null;
                type.ExtendedName = null;
            }
            type.Alignment = 0;
            type.SourceType = 0;
            if (type.Seqno == 1) {
                parentInfoVector.addElement(type);
                if (type.child != null) continue;
                type.child = childInfoVector;
                continue;
            }
            childInfoVector.addElement(type);
        }
        rs1.close();
        pstmt1.close();
        pstmt2.close();
        this.traceObj.writeTrace(1, "Connection.loadStructInfo() exited");
        return parentInfoVector;
    }

    public void setStructInfo(Object obj_udtInfo, short seqno, short levelno, short parentno, byte[] fieldnameba, short fieldno, short type, short length, int xid, byte[] xidOwnerba, byte[] xidNameba) throws SQLException {
        IfxUDTInfo udtInfo = (IfxUDTInfo)obj_udtInfo;
        IfxColumnInfo typeInfo = new IfxColumnInfo();
        Vector infoVector = udtInfo.structInfo;
        this.traceObj.writeTrace(99, "SqliConnect:setStructInfo enter");
        this.traceObj.writeTrace(99, "    seqno " + seqno + " levelno " + levelno + " parentno " + parentno + " fieldno " + fieldno + " type " + type + " length " + length + " xid " + xid);
        typeInfo.Seqno = seqno;
        typeInfo.Levelno = levelno;
        typeInfo.Parentno = parentno;
        typeInfo.ColName = fieldnameba == null ? null : new String(fieldnameba, 0, 129);
        typeInfo.Fieldno = fieldno;
        typeInfo.SQLtype = type;
        typeInfo.ColLength = length;
        typeInfo.ExtendedId = xid;
        IfxResultSetMetaData.setTypeBooleanFields(typeInfo, typeInfo.SQLtype);
        typeInfo.SQLtype &= 0xFF;
        if (typeInfo.ExtendedId != 0) {
            if (typeInfo.ExtendedId == 1) {
                typeInfo.SQLtype = 43;
            } else if (typeInfo.ExtendedId == 5) {
                typeInfo.SQLtype = 45;
            } else if (typeInfo.ExtendedId == 10) {
                typeInfo.SQLtype = 102;
            } else if (typeInfo.ExtendedId == 11) {
                typeInfo.SQLtype = 101;
            } else {
                typeInfo.ExtendedOwner = xidOwnerba == null ? null : new String(xidOwnerba, 0, 129);
                typeInfo.ExtendedName = xidNameba == null ? null : new String(xidNameba, 0, 129);
                if (IfxTypes.isComplexType(typeInfo.SQLtype)) {
                    IfxUDTInfo tmp_udtInfo = this.getUDTInfo(typeInfo.ExtendedName, typeInfo.ExtendedOwner);
                    typeInfo.child = ((IfxColumnInfo)tmp_udtInfo.structInfo.elementAt((int)0)).child;
                }
            }
        }
        typeInfo.Alignment = 0;
        typeInfo.SourceType = 0;
        this.traceObj.writeTrace(99, "SqliConnect:setStructInfo exit " + typeInfo.toString());
        infoVector.addElement(typeInfo);
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo colinfo) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo colinfo, String name) throws SQLException {
        this.traceObj.writeTrace(1, "Connection.getUDTInfo() called");
        String owner = colinfo == null || colinfo.ExtendedOwner == null ? "%" : colinfo.ExtendedOwner.trim();
        return this.getUDTInfo(name.trim(), owner);
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        this.traceObj.writeTrace(1, "Connection.getUDTInfo(" + name + ", " + owner + ") entered");
        IfxUDTInfo udtInfo = null;
        if (this.useTypeCache) {
            if (this.udtMap != null && (udtInfo = (IfxUDTInfo)this.udtMap.get(name.trim())) == null && this.getDatabaseType() == 1) {
                udtInfo = (IfxUDTInfo)this.udtMap.get(String.valueOf(owner) + "." + name);
            }
        }
        if (udtInfo == null) {
            udtInfo = this.addUDTInfo(owner, name.trim());
        }
        this.traceObj.writeTrace(1, "Connection.getUDTInfo(String, string) exited");
        return udtInfo;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public boolean getUsePut() {
        return this.usePut;
    }

    public int getBlobCacheSize() {
        return this.lobCacheSize;
    }

    protected void finalize() {
        this.traceObj.writeTrace(99, "Connection.finalize GC called");
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.traceObj.writeTrace(99, "Connection.finalize GC exited");
    }

    public String getdbDate() {
        return this.dbDate;
    }

    public String getglDate() {
        return this.glDate;
    }

    public String getdbCentury() {
        return this.dbCentury;
    }

    public String getdbLocale() {
        return this.dbLocale;
    }

    public String getdbEncoding() {
        return this.dbEncoding;
    }

    public String getclLocale() {
        return this.clLocale;
    }

    public String getclEncoding() {
        return this.clEncoding;
    }

    public String getJDBCTempDir() {
        if (this.tempdir == null) {
            this.tempdir = "";
        }
        return this.tempdir;
    }

    public boolean isANSI() {
        return this.AnsiDb;
    }

    /*
     * WARNING - void declaration
     */
    public String getXnameByXid(int xid) throws SQLException {
        this.traceObj.writeTrace(1, "Connection.getXnameByXid() entered");
        this.traceObj.writeTrace(3, "  getXnameByXid xid: " + xid);
        this.setInternalQuery(true);
        String xname = null;
        try {
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery("select name from informix.sysxtdtypes where extended_id = " + xid);
            if (rs.next()) {
                xname = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            void stmt;
            this.setInternalQuery(false);
            throw stmt;
        }
        this.setInternalQuery(false);
        this.traceObj.writeTrace(1, "Connection.getXnameByXid() exited with ");
        this.traceObj.writeTrace(3, "  getXnameByXid xid: " + xid);
        this.traceObj.writeTrace(3, "  getXnameByXid xname: " + xname);
        return xname;
    }

    private void addLocale(String ifxLoc, String jdkLoc) {
        this.IfxToJdkLocaleTable.put(ifxLoc, jdkLoc);
    }

    private void addEncName(String ifxName, String jdkName) {
        this.IfxToJdkEncodingTable.put(ifxName, jdkName);
    }

    private void addEncNumber(String ifxNumber, String jdkName) {
        this.IfxNoToJdkEncodingTable.put(ifxNumber, jdkName);
    }

    private String getEncName(String Encoding) {
        String jdkEnc = (String)this.IfxToJdkEncodingTable.get(Encoding);
        if (jdkEnc == null) {
            jdkEnc = IfxLocales.FromIfxNameToJdkName(Encoding);
        }
        return jdkEnc;
    }

    private String getEncNo(String Encoding) {
        String jdkEnc = (String)this.IfxNoToJdkEncodingTable.get(Encoding);
        if (jdkEnc == null) {
            jdkEnc = IfxLocales.FromIfxNoToJdkName(Encoding);
        }
        return jdkEnc;
    }

    private String getLocale(String Locale2) {
        String tmpLoc = (String)this.IfxToJdkLocaleTable.get(Locale2.toLowerCase());
        if (tmpLoc == null) {
            tmpLoc = IfxLocales.FromIfxToJdkLocale(Locale2);
        }
        return tmpLoc;
    }

    private void set5ServerType() throws SQLException {
        this.traceObj.writeTrace(1, "Connection.set5ServerType() called");
        try {
            String sql = "select colmax from informix.syscolumns c, informix.systables t where c.tabid = t.tabid and t.tabname like 'syscolumns'";
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            this.onlineSer = true;
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -217) {
                this.onlineSer = false;
            }
            throw e;
        }
        this.traceObj.writeTrace(3, "  set5ServerType() onlineSer: " + this.onlineSer);
    }

    void xaSetSerWarnFlags(short flags, String name) throws SQLException {
        block5: {
            block4: {
                int sqlCode = 0;
                IfxPreparedStatement pstmt = null;
                this.dbName = name;
                try {
                    try {
                        String sql = "select * from systables where owner = 'informix'";
                        pstmt = new IfxPreparedStatement(this, sql);
                    }
                    catch (Exception e) {
                        sqlCode = ((SQLException)e).getErrorCode();
                    }
                    Object var6_7 = null;
                    if (sqlCode != -206) break block4;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    flags = sqlCode == -206 ? (short)(flags | 2) : (short)(flags | 1);
                    throw throwable;
                }
                flags = (short)(flags | 2);
                break block5;
            }
            flags = (short)(flags | 1);
        }
        this.SerWarn = (short)(this.SerWarn | flags);
        this.OpenDbInit();
    }

    public IfxProtocol getProto() {
        return this.proto;
    }

    public IfxProtocol createProto() {
        return new IfxSqli(this);
    }

    public int getFetchBufSize() {
        return this.fetchBufSize;
    }

    public long getdbTodayDate() {
        return this.dbTodayDate;
    }

    public long getdbTodayStart() {
        return this.dbTodayStart;
    }
}

