/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.memoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class IfxSqli
implements IfxProtocol {
    IfxResultSetMetaData desc;
    private FileOutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileAmount;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short tupleSize;
    private short statementID;
    private short statementType;
    private IfxSqliConnect conn;
    private Trace trace;
    private Trace protoTrace;
    private String dbEncoding;
    private long serial8Inserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean cursorOpen = false;
    private boolean typeSent = false;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private String sqlerrm;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort;
    private boolean OpenDBStmt = false;
    private String serverVersion;
    private Vector offsetVector = new Vector();
    private int totalTupleSize;
    private int curOffset;
    private int totalTuples;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit = false;
    private int Tupid;
    private int fpHandle;
    private Vector fpRet;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    private final int INFX_BUFSIZE = 4096;
    private final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    private IfxRowColumn rowColumn;
    private IfxDataOutputStream os;
    private IfxDataInputStream is;
    private boolean SQ_CLOSERecvd = false;
    private boolean SQ_CLOSESent = false;
    private boolean first = true;
    private Vector DBList;

    public IfxSqli(IfxSqliConnect conn_arg) {
        this.conn = conn_arg;
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("IfxSqli: trace is NULL");
            }
            this.protoTrace = this.conn.getProtoTrace();
            if (this.protoTrace == null) {
                System.out.println("IfxSqli: Protocol trace is NULL");
            }
            if (this.trace != null) {
                this.trace.writeTrace(1, "IfxSqli: constructor() exited");
            }
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void clear() {
        this.trace.writeTrace(1, "IfxSqli: clear() called");
        this.serial8Inserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        this.sqlerrm = null;
        int i = 0;
        while (i < 10) {
            this.sqlerrd[i] = 0;
            if (i < 8) {
                this.serverWarningsString.setCharAt(i, ' ');
            }
            i = (short)(i + 1);
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.cursorOpen = false;
        this.tupleSize = 0;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
        this.trace.writeTrace(1, "IfxSqli: clear() exited");
    }

    private void resetTuples() {
        this.offsetVector.removeAllElements();
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.totalTupleSize = 0;
        this.curOffset = 0;
        this.curRow = -1;
        this.totalTuples = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
            this.rowColumn = null;
        }
    }

    public void executeBegin() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeBegin() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeBegin() exited");
    }

    private void sendBegin() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendBegin() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_BEGIN");
            this.os.writeSmallInt((short)35);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: executeBegin() exited");
    }

    public void executeCommit() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeCommit() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.statementType != 56) {
            this.cursorOpen = false;
        }
        this.trace.writeTrace(1, "IfxSqli: executeCommit() exited");
    }

    private void sendCommit() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendCommit() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_CMMTWORK");
            this.os.writeSmallInt((short)19);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendCommit() exited");
    }

    public void executeRollback() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeRollback() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.cursorOpen = false;
        this.trace.writeTrace(1, "IfxSqli: executeRollback() exited");
    }

    public void executeGetDBList() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeDBList() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeDBList() exited");
    }

    public Vector getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendGetDbList() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_DBLIST");
            this.os.writeSmallInt((short)26);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendGetDbList() exited");
    }

    private void receiveDBList() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveDBList() called");
        try {
            String dbName;
            this.DBList = new Vector();
            while ((dbName = new String(this.is.readChar(this.dbEncoding))).length() != 0) {
                boolean inserted = false;
                int i = 0;
                while (i < this.DBList.size()) {
                    String lastDBname = (String)this.DBList.elementAt(i);
                    if (dbName.toUpperCase().compareTo(lastDBname) < 0) {
                        this.DBList.insertElementAt(dbName, i);
                        inserted = true;
                        break;
                    }
                    ++i;
                }
                if (inserted) continue;
                this.DBList.insertElementAt(dbName, this.DBList.size());
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveDBList() exited");
    }

    private void sendRollback() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendRollback() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_RBWORK");
            this.os.writeSmallInt((short)20);
            this.protoTrace.writeTrace(2, "\tSavepoint: ", (short)0);
            this.os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendRollback() exited");
    }

    public void executeCommand(Statement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeCommand() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut()) {
                this.sendPut((IfxPreparedStatement)stmt);
            } else {
                this.sendCommand((IfxStatement)stmt);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                this.trace.writeTrace(2, "IfxSqli: END_TX_STMT, return error");
                this.trace.writeTrace(3, "IfxSqli.executeCommand.sqlcode", this.sqlcode);
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            throw e;
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                this.trace.writeTrace(2, "IfxSqli: END_TX_STMT, return error");
                this.trace.writeTrace(3, "IfxSqli.executeCommand.sqlcode", this.sqlcode);
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            throw e;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.SendCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
        this.trace.writeTrace(1, "IfxSqli: executeCommand() exited");
    }

    private void sendCommand(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendCommand() called");
        if (stmt instanceof IfxPreparedStatement) {
            this.sendExecute(stmt);
        } else {
            String s = stmt.commandString;
            try {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_COMMAND");
                this.os.writeSmallInt((short)1);
                this.protoTrace.writeTrace(2, "\t\t# of values: ", 0);
                this.os.writeSmallInt((short)0);
                this.protoTrace.writeTrace(2, "\t\tCommand: " + s);
                this.os.writeChar(s, this.dbEncoding);
                this.protoTrace.writeTrace(1, "\tSQ_NDESCRIBE");
                this.os.writeSmallInt((short)22);
                this.protoTrace.writeTrace(1, "\tSQ_EXECUTE");
                this.os.writeSmallInt((short)7);
                this.protoTrace.writeTrace(1, "\tSQ_RELEASE");
                this.os.writeSmallInt((short)11);
                this.isReleased = true;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        this.trace.writeTrace(1, "IfxSqli: sendCommand() exited");
    }

    private void sendBind(IfxPreparedStatement pstmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendBind(IfxPreparedStatement) called");
        this.sendBind(pstmt.getVector(), pstmt.inputvals);
    }

    private void sendBind(Vector vector, int inputvals) throws SQLException {
        int blobCount = 0;
        this.trace.writeTrace(1, "IfxSqli: sendBind(Vector) called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_BIND");
            this.os.writeSmallInt((short)5);
            this.protoTrace.writeTrace(2, "\t\tCount: ", inputvals);
            this.os.writeSmallInt((short)inputvals);
            int i = 0;
            while (i < inputvals) {
                IfxObject ival = (IfxObject)vector.elementAt(i);
                short type = (short)ival.getIfxType();
                if (type == 11 || type == 12) {
                    if (((IfxBlob)ival).isIfxTextType()) {
                        type = 12;
                    }
                    if (!ival.isNull()) {
                        ++blobCount;
                    }
                }
                this.os.writeSmallInt(type);
                this.trace.writeTrace(2, " sendBind(): SQL type: " + type);
                if (i > 0) {
                    this.protoTrace.writeTrace(2, "");
                }
                this.protoTrace.writeTrace(2, "\t\t\tColumn #: ", i + 1);
                this.protoTrace.writeTrace(2, "\t\t\tType: ", type);
                if (this.conn.isUSVER() && type >= 18) {
                    String owner = null;
                    String name = null;
                    owner = ival.getExtendedOwner();
                    name = ival.getExtendedTypeName();
                    this.protoTrace.writeTrace(2, "\t\t\tExtendedOwner: ", owner);
                    this.protoTrace.writeTrace(2, "\t\t\tExtendedTypeName: ", name);
                    if (owner == null) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeChar(owner);
                    }
                    this.os.writeChar(name);
                }
                if (ival.isNull()) {
                    this.protoTrace.writeTrace(2, "\t\t\tIndicator: ", -1);
                    this.os.writeSmallInt((short)-1);
                    this.protoTrace.writeTrace(2, "\t\t\tPrecision: ", (short)0);
                    this.os.writeSmallInt((short)0);
                } else {
                    this.protoTrace.writeTrace(2, "\t\t\tIndicator: ", (short)0);
                    this.os.writeSmallInt((short)0);
                    short shortVal = ival.getEncodedLength();
                    this.protoTrace.writeTrace(2, "\t\t\tPrecision: ", shortVal);
                    this.os.writeSmallInt(shortVal);
                    String cname = ival.getClass().getName();
                    this.trace.writeTrace(2, "Classname: ", cname);
                    byte[] bData = ival.toIfx();
                    if (type == 11 || type == 12 || type == 40 || type == 41) {
                        this.protoTrace.writeTrace(2, "\t\t\tData (" + bData.length + " bytes): ");
                        this.protoTrace.writeTrace(2, bData, 'H');
                    } else if (type == 44) {
                        this.protoTrace.writeTrace(2, "\t\t\tData (" + bData.length + " bytes): ");
                        this.protoTrace.writeTrace(2, bData, 'B');
                    } else {
                        String s = ival.toString();
                        this.protoTrace.writeTrace(2, "\t\t\tData: ", s);
                    }
                    this.os.writePadded(bData);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        if (blobCount > 0) {
            this.sendBlob(vector, blobCount, inputvals);
        }
        this.trace.writeTrace(1, "IfxSqli: sendBind() exited");
    }

    public void executePrepare(Statement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executePrepare() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)stmt);
            this.receiveMessage();
            ((IfxStatement)stmt).setStatementType(this.statementType);
            if (this.desc != null) {
                this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
        this.trace.writeTrace(1, "IfxSqli: executePrepare() exited");
    }

    private void sendPrepare(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendPrepare() called");
        String s = stmt.commandString;
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_PREPARE");
            this.os.writeSmallInt((short)2);
            this.protoTrace.writeTrace(2, "\t\t# qmarks: ", stmt.numqmarks);
            this.os.writeSmallInt((short)stmt.numqmarks);
            this.protoTrace.writeTrace(2, "\t\tCommand: " + s);
            this.os.writeChar(s, this.dbEncoding);
            this.protoTrace.writeTrace(1, "\tSQ_NDESCRIBE");
            this.os.writeSmallInt((short)22);
            this.protoTrace.writeTrace(1, "\tSQ_WANTDONE");
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendPrepare() exited");
    }

    private void sendStatementExecute(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendStatementExecute() called");
        this.sendExecute(stmt);
        this.receiveMessage();
        this.trace.writeTrace(1, "IfxSqli: sendStatementExecute() exited");
    }

    private void sendExecute(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendExecute() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            if (stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                if (pstmt.inputvals != pstmt.getqmarks()) {
                    this.trace.writeTrace(1, "IfxSqli: sendExecute() number of input values does not match qmarks");
                    this.trace.writeTrace(1, "inputvals: " + pstmt.inputvals + " qmarks: " + pstmt.getqmarks());
                    throw IfxErrMsg.getSQLException(-79749, this.conn);
                }
                if (pstmt.inputvals > 0) {
                    this.sendBind(pstmt);
                }
            }
            this.protoTrace.writeTrace(1, "\tSQ_EXECUTE");
            this.os.writeSmallInt((short)7);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendExecute() exited");
    }

    public void executeStatementQuery(Statement stmt) throws SQLException {
        this.executeStatementQuery(stmt, false, null);
    }

    public void executeStatementQuery(Statement stmt, boolean withHold) throws SQLException {
        this.executeStatementQuery(stmt, withHold, null);
    }

    public void executeStatementQuery(Statement stmt, boolean withHold, ResultSetMetaData outputDesc) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeStatementQuery() called");
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(stmt instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && outputNumber > 0) {
            try {
                this.sendStatementQuery((IfxStatement)stmt, withHold, (IfxResultSetMetaData)outputDesc);
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeStatementQuery() exited");
    }

    private void sendStatementQuery(IfxStatement stmt, boolean withHold, IfxResultSetMetaData outputDesc) throws SQLException {
        this.sendQuery(stmt, withHold, outputDesc);
        if (stmt.getResultSetType() == 1003) {
            if (this.desc.hasVariableLengthColumns) {
                this.receiveMessage();
            }
            this.sendFetch(this.desc.hasVariableLengthColumns, this.desc);
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData outputDesc, short direction) throws SQLException {
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_RET_TYPE");
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(direction);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            this.protoTrace.writeTrace(1, "\tdirection: (1-FETCH, 0-PUT)", direction);
            this.protoTrace.writeTrace(2, "\tCount: ", this.desc.getColumnCount());
            int i = 1;
            while (i <= this.desc.getColumnCount()) {
                IfxResultSetMetaData md;
                if (outputDesc != null && outputDesc.getColumnCount() >= i && outputDesc.getIfxColumnType(i) != -99) {
                    this.trace.writeTrace(99, "sendType(): from output parameter; i = " + i);
                    md = outputDesc;
                    this.desc.setIfxColumnType(i, outputDesc.getIfxColumnType(i));
                    this.desc.setExtendedName(i, outputDesc.getExtendedName(i));
                    this.desc.setColumnExtendedId(i, outputDesc.getColumnExtendedId(i));
                } else {
                    this.trace.writeTrace(99, "sendType(): from describe; i = " + i);
                    md = this.desc;
                }
                short sqltype = (short)md.getIfxColumnType(i);
                boolean isVariableLength = md.isVariableLengthType(i);
                if (isVariableLength) {
                    short xid = md.isDistinct(i) ? (short)md.getSourceType(i) : (short)md.getColumnExtendedId(i);
                    sqltype = xid == 3 ? (short)46 : (xid == 4 ? (short)47 : (xid == 1 ? (short)43 : (xid == 5 ? (short)45 : 44)));
                }
                this.trace.writeTrace(99, "sendType(): i = " + i + "; sqltype = " + sqltype);
                this.protoTrace.writeTrace(2, "\t\t\tColumn #: ", i);
                this.protoTrace.writeTrace(2, "\t\t\t\tType: ", sqltype);
                this.os.writeSmallInt(sqltype);
                if (isVariableLength) {
                    this.protoTrace.writeTrace(2, "\t\t\t\tExtendedOwnerName: ", md.getExtendedOwnerName(i));
                    this.protoTrace.writeTrace(2, "\t\t\t\tExtendedTypeName: ", md.getExtendedName(i));
                    this.os.writeChar(md.getExtendedOwnerName(i));
                    this.os.writeChar(md.getExtendedName(i));
                }
                this.protoTrace.writeTrace(2, "\t\t\t\tLength: ", md.getEncodedLength(i));
                this.os.writeInt(md.getEncodedLength(i));
                ++i;
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendQuery(IfxStatement stmt, boolean withHold, IfxResultSetMetaData outputDesc) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendQuery() called");
        int tupleBufferSize = this.getTupleBufferSize();
        try {
            int curstype;
            IfxPreparedStatement pstmt;
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            this.protoTrace.writeTrace(1, "\tSQ_CURNAME");
            this.os.writeSmallInt((short)3);
            String cursorname = stmt.getCursorName();
            this.protoTrace.writeTrace(2, "\t\tCursor name: " + cursorname);
            this.os.writeChar(cursorname, this.dbEncoding);
            if (stmt instanceof IfxPreparedStatement && !(pstmt = (IfxPreparedStatement)stmt).usePut() && pstmt.inputvals > 0) {
                this.sendBind(pstmt);
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (this.conn.getAutoFree() || stmt.getAutoFree()) {
                this.protoTrace.writeTrace(1, "\tSQ_AUTOFREE");
                this.os.writeSmallInt((short)108);
            }
            if ((curstype = stmt.getResultSetType()) == 1004) {
                this.protoTrace.writeTrace(1, "\tSQ_SCROLL");
                this.os.writeSmallInt((short)24);
            }
            if (withHold) {
                this.protoTrace.writeTrace(1, "\tSQ_HOLD");
                this.os.writeSmallInt((short)43);
            }
            this.protoTrace.writeTrace(1, "\tSQ_OPEN");
            this.os.writeSmallInt((short)6);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
        this.trace.writeTrace(1, "IfxSqli: sendQuery() exited");
    }

    public void executeOpenDatabase(String dbName, int flags) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeOpenDatabase() called");
        if (dbName == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_DBOPEN");
            this.os.writeSmallInt((short)36);
            this.os.writeChar(dbName);
            this.os.writeSmallInt((short)flags);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
        this.trace.writeTrace(1, "IfxSqli: executeOpenDatabase() exitted");
    }

    public void executeClose(Statement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeClose() called");
        if (this.conn.SendCommit && !this.doneCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (this.cursorOpen) {
            if (!this.conn.lockSession()) {
                throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
            }
            this.cursorOpen = false;
            if (!this.SQ_CLOSERecvd) {
                try {
                    this.trace.writeTrace(3, "IfxSqli: executeClose() cursorOpen = ", this.cursorOpen);
                    this.sendClose((IfxStatement)stmt);
                    this.receiveMessage();
                }
                catch (SQLException e) {
                    this.conn.unlockSession();
                    throw e;
                }
                catch (Exception e) {
                    this.conn.unlockSession();
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
            }
            this.conn.unlockSession();
        }
        if (this.conn.getAutoFree() || ((IfxStatement)stmt).getAutoFree()) {
            this.clearAll();
        } else {
            this.clear();
        }
        this.trace.writeTrace(1, "IfxSqli: executeClose() exited");
    }

    public void executeRelease(Statement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeRelease() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.getAutoFree() || !((IfxStatement)stmt).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)stmt).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased) {
                    this.sendRelease((IfxStatement)stmt);
                    this.receiveMessage();
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        this.conn.unlockSession();
        this.cursorOpen = false;
        this.clearAll();
        this.trace.writeTrace(1, "IfxSqli: executeRelease() exited");
    }

    void executeFetch() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeFetch() called");
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetch(false, this.desc);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeFetch() exited");
    }

    private void sendFetch(boolean sendRetType, IfxResultSetMetaData desc) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendFetch() called");
        int tupleBufferSize = this.getTupleBufferSize();
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            if (sendRetType) {
                this.sendType(desc, (short)1);
            }
            this.protoTrace.writeTrace(1, "\tSQ_NFETCH");
            this.os.writeSmallInt((short)9);
            this.protoTrace.writeTrace(2, "\t\tTuple Buffer Size: ", this.getTupleBufferSize());
            this.os.writeSmallInt((short)tupleBufferSize);
            if (this.conn.isFetchArr()) {
                this.protoTrace.writeTrace(2, "\t\tFetch Array Size: ", (short)0);
                this.os.writeSmallInt((short)0);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, desc, tupleBufferSize);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
        this.trace.writeTrace(1, "IfxSqli: sendFetch() exited");
    }

    private void sendClose(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendClose() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            this.protoTrace.writeTrace(2, "\tSQ_CLOSE");
            this.os.writeSmallInt((short)10);
            this.SQ_CLOSESent = true;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendClose() exited");
    }

    private void sendRelease(IfxStatement stmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendRelease() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            this.protoTrace.writeTrace(2, "\tSQ_RELEASE");
            this.os.writeSmallInt((short)11);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendRelease() exited");
    }

    public void executeCloseDatabase() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeCloseDatabase() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        String dbName = this.conn.getConnectionDbName();
        if (dbName != null && dbName.length() != 0) {
            return;
        }
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_DBCLOSE");
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeCloseDatabase() exited");
    }

    public void executeExecute(Statement stmt) throws SQLException {
        this.executeExecute(stmt, null);
    }

    public void executeExecute(Statement stmt, ResultSetMetaData outputDesc) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeExecute() called");
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(stmt instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
        }
        try {
            if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                this.sendStatementQuery((IfxStatement)stmt, false, (IfxResultSetMetaData)outputDesc);
            } else {
                this.sendStatementExecute((IfxStatement)stmt);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                this.trace.writeTrace(2, "IfxSqli: END_TX_STMT, return err");
                this.trace.writeTrace(3, "IfxSqli.executeExecute.sqlcode", this.sqlcode);
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            throw e;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.SendCommit && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
        this.trace.writeTrace(1, "IfxSqli: executeExecute() exited");
    }

    private void receiveMessage() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveMessage() called");
        short msg = 0;
        try {
            this.flip();
            this.protoTrace.writeTrace(1, "\nS->C");
            do {
                msg = this.is.readSmallInt();
                switch (msg) {
                    case 56: {
                        this.protoTrace.writeTrace(1, "\tSQ_EXIT");
                        this.sendExit();
                        break;
                    }
                    case 8: {
                        this.protoTrace.writeTrace(1, "\tSQ_DESCRIBE");
                        this.receiveDescribe();
                        break;
                    }
                    case 14: {
                        this.protoTrace.writeTrace(1, "\tSQ_TUPLE");
                        this.receiveTuple();
                        break;
                    }
                    case 25: {
                        this.protoTrace.writeTrace(1, "\tSQ_TUPID");
                        this.receiveTupleId();
                        break;
                    }
                    case 15: {
                        this.protoTrace.writeTrace(1, "\tSQ_DONE");
                        this.receiveDone();
                        break;
                    }
                    case 39: {
                        this.protoTrace.writeTrace(1, "\tSQ_BLOB");
                        this.receiveBlob();
                        break;
                    }
                    case 97: {
                        this.protoTrace.writeTrace(1, "\tSQ_LODATA");
                        this.receiveLODATA();
                        break;
                    }
                    case 13: {
                        this.protoTrace.writeTrace(1, "\tSQ_ERR");
                        this.sqlerrm = null;
                        this.receiveError();
                        break;
                    }
                    case 55: {
                        this.protoTrace.writeTrace(1, "\tSQ_COST");
                        this.receiveCost();
                        break;
                    }
                    case 94: {
                        this.protoTrace.writeTrace(1, "\tSQ_INSERTDONE");
                        this.receiveInsertDone();
                        break;
                    }
                    case 99: {
                        this.protoTrace.writeTrace(1, "\tSQ_XACTSTAT");
                        this.receiveXactstat();
                        break;
                    }
                    case 10: {
                        this.protoTrace.writeTrace(1, "\tSQ_CLOSE");
                        this.SQ_CLOSERecvd = true;
                        break;
                    }
                    case 81: {
                        this.protoTrace.writeTrace(1, "\tSQ_INFO");
                        this.receiveInfo();
                        break;
                    }
                    case 53: {
                        this.protoTrace.writeTrace(1, "\tSQ_VERSION");
                        this.receiveVersion();
                        break;
                    }
                    case 12: {
                        this.protoTrace.writeTrace(1, "\tSQ_EOT");
                        break;
                    }
                    case 101: {
                        this.protoTrace.writeTrace(1, "\tSQ_GETROUTINE");
                        this.receiveHandle();
                        break;
                    }
                    case 103: {
                        this.protoTrace.writeTrace(1, "\tSQ_FPROUTINE");
                        this.receiveFastPath();
                        break;
                    }
                    case 98: {
                        this.protoTrace.writeTrace(1, "\tSQ_FILE");
                        this.receiveSQFILE();
                        break;
                    }
                    case 26: {
                        this.protoTrace.writeTrace(1, "\tSQ_DBLIST");
                        this.receiveDBList();
                        break;
                    }
                    case 73: {
                        this.protoTrace.writeTrace(1, "\tSQ_XERR");
                        break;
                    }
                    default: {
                        this.protoTrace.writeTrace(1, "\t*** UNknown error message ***\n");
                        this.setError(-408);
                        return;
                    }
                    case 18: 
                    case 86: 
                    case 104: 
                }
            } while (msg != 12 && msg != 56);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveMessage() exited");
    }

    private void flip() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: flip() called");
        try {
            this.protoTrace.writeTrace(1, "\tSQ_EOT");
            this.os.writeSmallInt((short)12);
            this.os.flush();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: flip() exited");
    }

    private void sendExit() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendExit() called");
        if (this.conn != null && !this.conn.isASF()) {
            this.conn.setDatabaseOpen(false, this.serverWarningsShort);
        }
        this.conn.close();
        this.trace.writeTrace(1, "IfxSqli: sendExit() exited");
    }

    private void callsetDatabaseOpen() throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int errcode) throws SQLException {
        throw IfxErrMsg.getSQLException(errcode, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveDescribe() called");
        short nfields = 0;
        int intVal = 0;
        String strtab = null;
        short[] fieldIndex = null;
        try {
            this.statementType = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tStatement Type: ", this.statementType);
            this.statementID = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            intVal = this.is.readInt();
            this.setSQLerrd((short)3, intVal);
            this.protoTrace.writeTrace(2, "\t\tEstimated Cost: ", intVal);
            this.tupleSize = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tTuplesize: ", this.tupleSize);
            nfields = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\t# of fields: ", (int)nfields);
            this.desc = new IfxResultSetMetaData(nfields, this.conn);
            short stringTableSize = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tString table: ", stringTableSize);
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            if (nfields > 0) {
                fieldIndex = new short[nfields];
                short i = 1;
                while (i <= nfields) {
                    short shortVal;
                    fieldIndex[i - 1] = this.is.readSmallInt();
                    this.protoTrace.writeTrace(2, "\t\t    Field Index: ", fieldIndex[i - 1]);
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        this.protoTrace.writeTrace(2, "\t\t\tColumn Start Pos: ", intVal);
                        this.desc.setColumnStartPosition(i, intVal);
                    } else {
                        shortVal = this.is.readSmallInt();
                        this.protoTrace.writeTrace(2, "\t\t\tColumn Start Pos: ", shortVal);
                        this.desc.setColumnStartPosition(i, shortVal);
                    }
                    shortVal = this.is.readSmallInt();
                    this.protoTrace.writeTrace(2, "\t\t\tColumn type: ", shortVal);
                    this.desc.setIfxColumnType(i, shortVal);
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        this.protoTrace.writeTrace(2, "\t\t\tColumn Extended Id: ", intVal);
                        this.desc.setColumnExtendedId(i, intVal);
                        String stringData = new String(this.is.readChar(this.dbEncoding));
                        this.protoTrace.writeTrace(2, "\t\t\tOwner name: " + stringData);
                        this.desc.setExtendedOwnerName(i, stringData);
                        stringData = new String(this.is.readChar());
                        this.protoTrace.writeTrace(2, "\t\t\tExtended name: " + stringData);
                        this.desc.setExtendedName(i, stringData);
                        shortVal = this.is.readSmallInt();
                        this.protoTrace.writeTrace(2, "\t\t\tReference: ", shortVal);
                        this.desc.setReference(i, shortVal);
                        shortVal = this.is.readSmallInt();
                        this.protoTrace.writeTrace(2, "\t\t\tAlignment: ", shortVal);
                        this.desc.setAlignment(i, shortVal);
                        intVal = this.is.readInt();
                        this.protoTrace.writeTrace(2, "\t\t\tSource type: ", intVal);
                        this.desc.setSourceType(i, intVal);
                        intVal = this.is.readInt();
                        this.protoTrace.writeTrace(2, "\t\t\tLength: ", intVal);
                        this.desc.setEncodedLength(i, intVal);
                    } else {
                        shortVal = this.is.readSmallInt();
                        this.protoTrace.writeTrace(2, "\t\t\tLength: ", shortVal);
                        this.desc.setEncodedLength(i, shortVal);
                    }
                    i = (short)(i + 1);
                }
                this.desc.setTextByteColumnCount();
            }
            if (stringTableSize > 0) {
                byte[] b = new byte[stringTableSize];
                this.is.readPadded(b);
                strtab = IfxToJavaType.IfxToJavaChar(b, (short)0, this.dbEncoding);
                this.protoTrace.writeTrace(2, "\t\tData in String table: ", strtab);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "Describe packet received");
        if (strtab != null) {
            String colName = null;
            StringTokenizer itok = new StringTokenizer(strtab, "\u0000");
            short i = 0;
            while (i < nfields) {
                if (itok.hasMoreTokens()) {
                    colName = itok.nextToken();
                    this.desc.setColumnName(i + 1, colName);
                }
                i = (short)(i + 1);
            }
        }
        if (this.conn != null) {
            this.desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
        this.trace.writeTrace(1, "IfxSqli: receiveDescribe() exited");
    }

    void setSQLerrd(short i, int val) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: setSQLerrd() called");
        try {
            this.sqlerrd[i] = val;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: setSQLerrd() exited");
    }

    private void receiveInsertDone() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveInsertDone() called");
        try {
            this.serial8Inserted = this.is.readLongInt();
            this.protoTrace.writeTrace(2, "\t\tSerial8: ", this.serial8Inserted);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveInsertDone() called");
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    private void receiveDone() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveDone() called");
        this.OpenDBStmt = false;
        try {
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            short warnings = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tWarning: ", warnings);
            this.setWarnings(warnings, this.OpenDBStmt);
            int intVal = this.is.readInt();
            this.protoTrace.writeTrace(2, "\t\t# rows: ", intVal);
            this.setSQLerrd((short)2, intVal);
            intVal = this.is.readInt();
            this.protoTrace.writeTrace(2, "\t\tRowid: ", intVal);
            this.setSQLerrd((short)5, intVal);
            intVal = this.is.readInt();
            this.protoTrace.writeTrace(2, "\t\tSerial id: ", intVal);
            this.setSQLerrd((short)1, intVal);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveDone() exited");
    }

    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    public int getSerialInsert() {
        return this.sqlerrd[1];
    }

    int getISAMCode() {
        return this.isamcode;
    }

    public int getNumberOfRowsProcessed() {
        return this.sqlerrd[2];
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    int getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    int getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveCost() called");
        try {
            int intVal = this.is.readInt();
            this.protoTrace.writeTrace(2, "\t\tEstimated #rows: ", intVal);
            this.setSQLerrd((short)0, intVal);
            intVal = this.is.readInt();
            this.protoTrace.writeTrace(2, "\t\tEstimated i/o: ", intVal);
            this.setSQLerrd((short)3, intVal);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveCost() exited");
    }

    private void receiveXactstat() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveXactstat() called");
        try {
            this.xcEvent = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\txcEvent: ", this.xcEvent);
            this.xcNewLevel = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\txcNewLevel: ", this.xcNewLevel);
            this.xcOldLevel = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\txcOldLevel: ", this.xcOldLevel);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "XA State package received");
        this.trace.writeTrace(1, "IfxSqli: receiveXactstat() exited");
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveTuple() called");
        this.trace.writeTrace(2, "    totalTupleSize = " + this.totalTupleSize);
        this.trace.writeTrace(2, "    totalTuples = " + this.totalTuples);
        try {
            short warn = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tWarning: ", warn);
            int size = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (size > 0) {
                this.protoTrace.writeTrace(2, "\t\tTuple Size :", size);
                this.rowColumn.readTuple(this.is, this.totalTupleSize, size);
                this.protoTrace.writeTrace(2, "\t\tTuple data: ");
                this.protoTrace.writeTrace(2, this.rowColumn.getTupleData(), this.totalTupleSize, 'B', size);
                this.totalTupleSize += size;
                if (++this.totalTuples >= this.offsetVector.size()) {
                    this.offsetVector.setSize(this.totalTuples + 100);
                }
                this.offsetVector.setElementAt(new Integer(this.totalTupleSize), this.totalTuples);
                this.trace.writeTrace(2, "IfxSqli:receiveTuple(): tuple size = " + size);
                this.trace.writeTrace(2, "IfxSqli:receiveTuple(): totalTupleSize = " + this.totalTupleSize);
                this.trace.writeTrace(2, "IfxSqli:receiveTuple(): totalTuples = " + this.totalTuples);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveTuple() exited");
    }

    private void addWarning(String message, String sqlstate) {
        if (this.warn == null) {
            this.warn = sqlstate != null ? IfxWarnMsg.getSQLWarning(sqlstate, message, this.conn) : IfxWarnMsg.getSQLWarning(message, this.conn);
        } else if (sqlstate != null) {
            SQLWarning nextWarn = IfxWarnMsg.getSQLWarning(sqlstate, message, this.conn);
            this.warn.setNextWarning(nextWarn);
        } else {
            SQLWarning nextWarn = IfxWarnMsg.getSQLWarning(message, this.conn);
            this.warn.setNextWarning(nextWarn);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void setWarnings(short w, boolean OpenDBStmt) {
        this.trace.writeTrace(1, "IfxSqli: setWarnings() called");
        set = 0;
        this.SQLState = null;
        this.serverWarningsShort = w;
        i = 1;
        while (i <= 6) {
            set = w & 1;
            if (set != 1) ** GOTO lbl41
            this.serverWarningsString.setCharAt(i, 'W');
            switch (i) {
                case 1: {
                    if (OpenDBStmt) {
                        this.addWarning(null, "01I01");
                        break;
                    }
                    this.addWarning(null, "01006");
                    break;
                }
                case 2: {
                    if (OpenDBStmt) {
                        this.addWarning(null, "01I03");
                        break;
                    }
                    this.addWarning(null, "01003");
                    break;
                }
                case 3: {
                    if (OpenDBStmt) {
                        this.addWarning(null, "01I04");
                        break;
                    }
                    this.addWarning(null, "01003");
                    break;
                }
                case 4: {
                    this.addWarning(null, "01I05");
                    break;
                }
                case 5: {
                    this.addWarning(null, "01I06");
                    break;
                }
                case 6: {
                    if (OpenDBStmt) {
                        this.addWarning(null, "01I10");
                        break;
                    }
                    this.addWarning(null, "01I11");
                    break;
                }
lbl41:
                // 1 sources

                this.serverWarningsString.setCharAt(i, ' ');
                break;
            }
            w = (short)(w >> 1);
            i = (short)(i + 1);
        }
        this.trace.writeTrace(1, "IfxSqli: setWarnings() exited");
    }

    public void chainWarnings(SQLWarning cwarn) {
        this.trace.writeTrace(1, "IfxSqli: chainWarnings() called");
        if (cwarn != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(cwarn);
            } else {
                this.warn = cwarn;
            }
        }
        this.trace.writeTrace(1, "IfxSqli: chainWarnings() exited");
    }

    public void clearWarnings() {
        this.trace.writeTrace(1, "IfxSqli: clearWarnings() called");
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.warn = null;
        this.trace.writeTrace(1, "IfxSqli: clearWarnings() exited");
    }

    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receiveError() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveError() called");
        try {
            this.sqlcode = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tSQLcode: ", this.sqlcode);
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                this.is.readChar();
                this.trace.writeTrace(2, "Error Code 619, resyncing data");
                this.errorDone();
            }
            this.isamcode = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tISAM/RSAM error: ", this.isamcode);
            this.setSQLerrd((short)1, this.isamcode);
            if (this.sqlcode == 0) {
                this.isamcode = 0;
            }
            short shortVal = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tOffset into statement: ", (int)shortVal);
            this.setSQLerrd((short)4, shortVal);
            if (this.sqlcode != -368) {
                this.sqlerrm = this.is.readChar(this.dbEncoding);
                this.protoTrace.writeTrace(2, "\t\tsqlerrm: " + this.sqlerrm);
            }
            if (this.sqlcode == 0 && !this.conn.isUSVER()) {
                this.sqlcode = -407;
                this.errorDone();
            }
            if (this.sqlcode == 0 || this.sqlcode == -937) {
                byte[] b = new byte[5];
                this.is.readPadded(b);
                this.SQLState = IfxToJavaType.IfxToJavaChar(b, (short)0);
                this.protoTrace.writeTrace(2, "\t\tSQLState: ", this.SQLState);
                this.message = this.is.readChar(this.dbEncoding);
                this.protoTrace.writeTrace(2, "\t\tMI message:", this.message);
            }
            this.errorDone();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveError() exited");
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    void errorDone() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: errorDone() called");
        String loc = this.conn.getclLocale();
        if (this.sqlcode == 100) {
            this.SQLState = IfxErrMsg.getSQLSTATE(100);
            this.message = IfxErrMsg.getMessage(36007, loc);
        } else {
            this.gobbleSmallInts(1);
            this.protoTrace.writeTrace(1, "\tSQ_EOT");
        }
        if (this.sqlcode == 0 || this.sqlcode == 100) {
            if (this.SQLState != null) {
                this.addWarning(this.message, this.SQLState);
            } else if (this.message != null) {
                this.addWarning(this.message, null);
            }
        } else {
            if (this.sqlerrm != null && this.sqlerrm.length() > 0) {
                if (this.isamcode != 0) {
                    throw new SQLException(String.valueOf(IfxMessage.getMessage(this.sqlcode, this.sqlerrm, loc)) + "\n(" + this.isamcode + ")" + IfxMessage.getMessage(this.isamcode, loc), IfxMessage.getSQLSTATE(this.sqlcode), this.sqlcode);
                }
                throw new SQLException(IfxMessage.getMessage(this.sqlcode, this.sqlerrm, loc), IfxMessage.getSQLSTATE(this.sqlcode), this.sqlcode);
            }
            throw IfxErrMsg.getSQLException(this.sqlcode, this.isamcode, (IfxConnection)this.conn);
        }
        this.sqlerrm = null;
        this.trace.writeTrace(1, "IfxSqli: errorDone() exited");
    }

    private void receiveTupleId() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveTupleId() called");
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                this.protoTrace.writeTrace(2, "\t\tTuple ID: ", this.firstTuple);
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
            } else {
                int intVal = this.Tupid;
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveTupleId() exited");
    }

    void executeInfo(short regflag) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeInfo() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(regflag);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeInfo() exited");
    }

    private void sendInfo(short regflag) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendInfo() called");
        try {
            this.protoTrace.writeTrace(1, "C->S");
            this.protoTrace.writeTrace(1, "\tSQ_INFO ", (short)81);
            this.os.writeSmallInt((short)81);
            if (regflag != 0) {
                this.os.writeSmallInt((short)1);
                this.protoTrace.writeTrace(2, "\t\tINFO_REQUEST");
                this.os.writeSmallInt((short)0);
                this.protoTrace.writeTrace(2, "\t\t\tData: ", (short)0);
            }
            this.os.writeSmallInt((short)0);
            this.protoTrace.writeTrace(2, "\t\tINFO_DONE");
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendInfo() called");
    }

    private void receiveInfo() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveInfo() called");
        try {
            short message;
            while ((message = this.is.readSmallInt()) > 0) {
                int length = this.is.readSmallInt();
                switch (message) {
                    case 2: {
                        this.protoTrace.writeTrace(2, "\t\tINFO_VERSION");
                        this.protoTrace.writeTrace(2, "\t\t\tLength: ", length);
                        if (length < 4) {
                            this.setError(-408);
                            break;
                        }
                        byte[] b = new byte[length - 4];
                        length -= 4;
                        break;
                    }
                    case 3: {
                        int intVal;
                        this.protoTrace.writeTrace(2, "\t\tINFO_TYPE");
                        int TypeList = 0;
                        int i = 0;
                        while (i < length / 4) {
                            intVal = this.is.readInt();
                            this.protoTrace.writeTrace(2, "\t\t\tData:  ", intVal);
                            TypeList |= intVal;
                            ++i;
                        }
                        this.conn.setTypeList(TypeList);
                        break;
                    }
                    case 4: {
                        int intVal;
                        this.protoTrace.writeTrace(2, "\t\tINFO_CAPABILITY");
                        int CapList = 0;
                        int i = 0;
                        while (i < length / 4) {
                            intVal = this.is.readInt();
                            this.protoTrace.writeTrace(2, "\t\t\tData:  ", intVal);
                            CapList |= intVal;
                            ++i;
                        }
                        this.conn.setCapList(CapList);
                        break;
                    }
                    default: {
                        this.gobbleChars(length);
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveInfo() exited");
    }

    public void executeEnv(Properties EnvVars) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeEnv() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(EnvVars);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeEnv() exited");
    }

    private void sendEnv(Properties EnvVars) throws SQLException {
        short totLen = 0;
        short nameLen = 0;
        short valueLen = 0;
        short LongNameLen = 0;
        short LongValueLen = 0;
        String name = null;
        String value = null;
        int len = 0;
        this.trace.writeTrace(1, "IfxSqli: sendEnv() called");
        IfxDataOutputStream os2 = this.conn.Ifxproto_send();
        if (!this.conn.isASF()) {
            return;
        }
        totLen = 4;
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            nameLen = (short)name.length();
            valueLen = (short)value.length();
            len = nameLen & 1;
            if (len == 1) {
                nameLen = (short)(nameLen + 1);
            }
            if ((len = valueLen & 1) == 1) {
                valueLen = (short)(valueLen + 1);
            }
            totLen = (short)(totLen + (nameLen + valueLen + 4));
            if (nameLen > LongNameLen) {
                LongNameLen = nameLen;
            }
            if (valueLen <= LongValueLen) continue;
            LongValueLen = valueLen;
        }
        totLen = (short)(totLen + 2);
        try {
            this.protoTrace.writeTrace(1, "C->S");
            this.protoTrace.writeTrace(1, "\tSQ_INFO ", (short)81);
            os2.writeSmallInt((short)81);
            os2.writeSmallInt((short)6);
            this.protoTrace.writeTrace(2, "\t\tINFO_ENV");
            os2.writeSmallInt(totLen);
            this.protoTrace.writeTrace(2, "\t\t\tTotal Length: ", totLen);
            os2.writeSmallInt(LongNameLen);
            this.protoTrace.writeTrace(2, "\t\t\tLong Name Length: ", LongNameLen);
            os2.writeSmallInt(LongValueLen);
            this.protoTrace.writeTrace(2, "\t\t\tLong Value Length: ", LongValueLen);
            Enumeration<?> e2 = EnvVars.propertyNames();
            while (e2.hasMoreElements()) {
                name = (String)e2.nextElement();
                value = EnvVars.getProperty(name);
                os2.writeChar(name, this.dbEncoding);
                this.protoTrace.writeTrace(2, "\t\t\tName: ", name);
                os2.writeChar(value, this.dbEncoding);
                this.protoTrace.writeTrace(2, "\t\t\tValue: ", value);
            }
            os2.writeSmallInt((short)0);
            this.protoTrace.writeTrace(2, "\t\t\tNull Terminator: ", (short)0);
            os2.writeSmallInt((short)0);
            this.protoTrace.writeTrace(2, "\t\tINFO_DONE");
        }
        catch (Exception e3) {
            throw IfxErrMsg.getSQLException(-79716, e3.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendEnv() called");
    }

    private void gobbleChars(int length) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: gobbleChars() called");
        try {
            byte[] b = new byte[length];
            this.is.readPadded(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: gobbleChars() exited");
    }

    private void gobbleSmallInts(int number) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: gobbleSmallInts() called");
        try {
            int i = 0;
            while (i < number) {
                this.is.readSmallInt();
                ++i;
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: gobbleSmallInts() exited");
    }

    public void executeVersion() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeVersion() called");
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeVersion() exited");
    }

    private void sendVersion() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendVersion() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_VERSION");
            this.os.writeSmallInt((short)53);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendVersion() exited");
    }

    private void receiveVersion() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: receiveVersion() called");
        try {
            this.serverVersion = new String(this.is.readChar());
            this.protoTrace.writeTrace(2, "\t\tServer Version: " + this.serverVersion);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: receiveVersion() exited");
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize() {
        this.trace.writeTrace(1, "IfxSqli: getTupleBufferSize() called");
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.tupleSize <= 2048 ? 4096 : (this.tupleSize <= 4096 ? 8192 : (int)this.tupleSize);
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.fetchBufSize > Short.MAX_VALUE ? Short.MAX_VALUE : this.conn.fetchBufSize;
        }
        this.trace.writeTrace(1, "IfxSqli: getTupleBufferSize() exited");
        return this.tupleBufferSize;
    }

    public boolean isResultSet() throws SQLException {
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && outputNumber > 0;
    }

    public boolean isCursorOpen() {
        return this.cursorOpen;
    }

    public int getTupleCount() {
        this.trace.writeTrace(1, "IfxSqli: getTupleCount() called");
        this.trace.writeTrace(3, "IfxSqli.getTupleCount(): size", this.totalTuples - (this.curRow + 1));
        this.trace.writeTrace(1, "IfxSqli: getTupleCount() exited");
        return this.totalTuples - (this.curRow + 1);
    }

    public boolean getaRow(int direction, int count, int scrolltype, int isscrollcurs) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: getNextRow() called");
        if (direction != 1000 && count != 1) {
            throw IfxErrMsg.getSQLException(-79751, this.conn);
        }
        int tcount = this.getTupleCount();
        if (this.first) {
            if (!this.SQ_CLOSERecvd && (tcount == 0 && this.totalTuples > 0 || isscrollcurs == 1)) {
                if (isscrollcurs == 1) {
                    this.executeScrollFetch(scrolltype, count);
                } else {
                    this.executeFetch();
                }
                tcount = this.getTupleCount();
            }
        } else {
            if (this.SQ_CLOSERecvd) {
                return false;
            }
            if (tcount == 0 && this.totalTuples > 0 || isscrollcurs == 1) {
                if (isscrollcurs == 1) {
                    this.executeScrollFetch(scrolltype, count);
                } else {
                    this.executeFetch();
                }
                tcount = this.getTupleCount();
            }
        }
        if (tcount == 0) {
            if (this.conn.SendCommit && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        this.curOffset = (Integer)this.offsetVector.elementAt(this.curRow);
        this.trace.writeTrace(1, "curRow = " + this.curRow);
        this.trace.writeTrace(1, "currOffset = " + this.curOffset);
        this.rowColumn.setOffsetInTuple(this.curOffset);
        this.trace.writeTrace(1, "IfxSqli: getTuple() exited");
        return true;
    }

    public int getTupleSize() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: getTupleSize() called");
        return this.tupleSize;
    }

    public IfxObject getColumnInRow(int colIndex) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(colIndex);
    }

    public void loadColumnData(int colIndex, IfxObject val) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(colIndex, val);
    }

    private void sendBlob(Vector vector, int count, int inputvals) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendBlob() called");
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 1");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_BBIND");
            this.os.writeSmallInt((short)41);
            this.protoTrace.writeTrace(1, "\t\t# of blobs: ", count);
            this.os.writeSmallInt((short)count);
            this.os.flush();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        int i = 0;
        while (i < inputvals) {
            IfxObject ival = (IfxObject)vector.elementAt(i);
            short type = (short)ival.getIfxType();
            if (type == 11 || type == 12) {
                IfxBlob BlobObject = (IfxBlob)ival;
                if (BlobObject.isBlobByteType()) {
                    this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                } else {
                    this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                }
            }
            ++i;
        }
        this.trace.writeTrace(1, "IfxSqli: sendBlob() exited");
    }

    private void sendBytesBlob(IfxDataOutputStream os2, byte[] buffer) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendBytesBlob() called");
        int dataLength = buffer.length;
        int dataOffset = 0;
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 2");
        this.protoTrace.writeTrace(1, "\nC->S");
        this.trace.writeTrace(3, "  sendBytesBlob(): datalength = ", dataLength);
        while (dataLength > 0) {
            try {
                this.protoTrace.writeTrace(1, "\tSQ_BLOB");
                os2.writeSmallInt((short)39);
                if (dataLength > 1024) {
                    this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 3.0");
                    this.protoTrace.writeTrace(2, "\t\tSize: ", (short)1024);
                    os2.writeSmallInt((short)1024);
                    os2.writePadded(buffer, dataOffset, 1024);
                    dataLength -= 1024;
                    dataOffset += 1024;
                    continue;
                }
                this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 3.1");
                this.protoTrace.writeTrace(2, "\t\tSize: ", dataLength);
                os2.writeSmallInt((short)dataLength);
                os2.writePadded(buffer, dataOffset, dataLength);
                dataLength = 0;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        try {
            this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 4");
            this.protoTrace.writeTrace(1, "\tSQ_BLOB");
            os2.writeSmallInt((short)39);
            this.protoTrace.writeTrace(2, "\t\tSize: ", 0);
            os2.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendBytesBlob() exited");
    }

    private void sendStreamBlob(IfxDataOutputStream os2, InputStream fd, int length) throws SQLException {
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 5");
        this.trace.writeTrace(1, "IfxSqli: sendStreamBlob() called");
        int dataLength = length;
        byte[] buffer = new byte[1024];
        int readLength = 0;
        this.trace.writeTrace(3, "    sendStreamBlob():length = ", length);
        this.protoTrace.writeTrace(1, "\nC->S");
        while (dataLength > 0) {
            try {
                if (dataLength > 1024) {
                    this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 6");
                    readLength = fd.read(buffer, 0, 1024);
                    if (readLength <= 0) break;
                    this.protoTrace.writeTrace(1, "\tSQ_BLOB");
                    os2.writeSmallInt((short)39);
                    this.protoTrace.writeTrace(2, "\t\tSize: ", readLength);
                    os2.writeSmallInt((short)readLength);
                    this.protoTrace.writeTrace(2, "\t\tData:");
                    this.protoTrace.writeTrace(2, buffer, 'H');
                    os2.writePadded(buffer, 0, readLength);
                    dataLength -= readLength;
                    continue;
                }
                this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 7");
                readLength = fd.read(buffer, 0, dataLength);
                this.trace.writeTrace(99, "sendStreamBlob().readLength: ", readLength);
                if (readLength <= 0) break;
                this.protoTrace.writeTrace(1, "\tSQ_BLOB");
                os2.writeSmallInt((short)39);
                this.protoTrace.writeTrace(2, "\t\tSize: ", readLength);
                os2.writeSmallInt((short)readLength);
                this.protoTrace.writeTrace(2, "\t\tData:");
                this.protoTrace.writeTrace(2, buffer, 'H');
                os2.writePadded(buffer, 0, readLength);
                dataLength -= readLength;
            }
            catch (Exception exception) {
                break;
            }
        }
        if (fd instanceof IfxInputStream) {
            try {
                os2.flush();
                fd.close();
            }
            catch (Exception exception) {}
        }
        this.trace.writeTrace(99, "sendStreamBlob().dataLength: ", dataLength);
        if (dataLength == 0) {
            this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 8");
            try {
                this.protoTrace.writeTrace(1, "\tSQ_BLOB");
                os2.writeSmallInt((short)39);
                this.protoTrace.writeTrace(2, "\t\tSize: ", 0);
                os2.writeSmallInt((short)0);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 9");
        try {
            this.protoTrace.writeTrace(1, "\tSQ_FERR");
            os2.writeSmallInt((short)40);
        }
        catch (Exception exception) {}
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                this.trace.writeTrace(2, "IfxBlob: END_TX_STMT, return error");
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 10");
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendStreamBlob() exited");
    }

    public void executeFetchBlob(IfxObject blobDesc) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeFetchBlob() called");
        int bufferSize = this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 10");
        IfxBlob blobInfo = (IfxBlob)blobDesc;
        int blobLength = blobInfo.getBlobLength();
        if (bufferSize < 0 || bufferSize > 0 && blobLength <= bufferSize) {
            try {
                this.BlobBuffer = memoryUtil.allocateMemory(blobLength);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79753, e.toString(), (IfxConnection)this.conn);
            }
            blobInfo.setBlobBuffer(this.BlobBuffer);
            blobInfo.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            try {
                this.BlobFd = new FileOutputStream(((IfxBlob)blobDesc).getBlobFileName());
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception exception) {
                if (bufferSize == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = memoryUtil.allocateMemory(blobLength);
                this.BlobFd = null;
                blobInfo.setBlobBuffer(this.BlobBuffer);
                blobInfo.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetchBlob((IfxBlob)blobDesc);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {}
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: executeFetchBlob() exited");
    }

    private void sendFetchBlob(IfxBlob blobDesc) throws SQLException {
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 11");
        this.trace.writeTrace(1, "IfxSqli: sendFetchBlob() called");
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            this.protoTrace.writeTrace(1, "\tSQ_FETCHBLOB");
            this.os.writeSmallInt((short)38);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        try {
            this.protoTrace.writeTrace(2, "\t\tDescriptor:");
            this.protoTrace.writeTrace(2, blobDesc.toIfx(), 'H');
            this.os.writePadded(blobDesc.toIfx());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendFetchBlob() exited");
    }

    private void receiveBlob() throws SQLException {
        int strtab;
        short datalen;
        this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 12");
        this.trace.writeTrace(1, "IfxSqli: receiveBlob() called");
        byte[] blobBuffer = null;
        try {
            datalen = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tSize: ", (int)datalen);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        try {
            blobBuffer = new byte[datalen];
            strtab = this.is.readPadded(blobBuffer);
            this.protoTrace.writeTrace(2, "\t\tData:");
            this.protoTrace.writeTrace(2, blobBuffer, 'H');
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 13");
            try {
                this.blobDataWrite(blobBuffer, this.BlobWriteOffset, strtab);
                this.BlobWriteOffset += strtab;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (strtab < datalen) {
            int remaining = 0;
            while (strtab < datalen) {
                try {
                    blobBuffer = new byte[datalen - strtab];
                    remaining = this.is.readPadded(blobBuffer);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(blobBuffer, this.BlobWriteOffset, remaining);
                        this.BlobWriteOffset += remaining;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                strtab += remaining;
            }
        }
        this.trace.writeTrace(1, "IfxSqli: receiveBlob() exited");
    }

    private int blobDataWrite(byte[] buffer, int BlobWriteOffset, int length) {
        this.trace.writeTrace(1, "IfxSqli: blobDataWrite() called");
        if (this.BufferOrStream == 1) {
            try {
                this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 14");
                this.BlobFd.write(buffer, 0, length);
            }
            catch (Exception exception) {
                return 1;
            }
        } else {
            this.trace.writeTrace(99, "IfxSqli.IfxBlob() : - 15");
            if (length > 0) {
                System.arraycopy(buffer, 0, this.BlobBuffer, BlobWriteOffset, length);
            }
        }
        this.trace.writeTrace(1, "IfxSqli: blobDataWrite() exited");
        return 0;
    }

    public void executeScrollFetch(int scrolltype, int index) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: executeScrollFetch() called");
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendScrollFetch(scrolltype, index);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "IfxSqli: executeScrollFetch() exited");
    }

    private void sendScrollFetch(int scrolltype, int index) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendScrollFetch() called");
        int tupleBufferSize = this.getTupleBufferSize();
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_ID");
            this.os.writeSmallInt((short)4);
            this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
            this.os.writeSmallInt(this.statementID);
            if (this.desc.hasVariableLengthColumns) {
                this.sendType(this.desc, (short)1);
            }
            this.protoTrace.writeTrace(1, "\tSQ_SFETCH");
            this.os.writeSmallInt((short)23);
            this.protoTrace.writeTrace(2, "\t\tDirection: ", scrolltype);
            this.os.writeSmallInt((short)scrolltype);
            this.protoTrace.writeTrace(2, "\t\tOffset: ", index);
            this.os.writeInt(index);
            this.protoTrace.writeTrace(2, "\t\tTuple Buffer Size: ", tupleBufferSize);
            this.os.writeSmallInt((short)tupleBufferSize);
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, this.desc, tupleBufferSize);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
        this.trace.writeTrace(1, "IfxSqli: sendScrollFetch() exited");
    }

    public int getTupid() throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: getTupid() entered");
        this.trace.writeTrace(1, "IfxSqli: Tupid is  " + this.Tupid);
        return this.Tupid;
    }

    public Vector executeFastPath(String signature, Vector inParams, boolean fParam) throws SQLException {
        this.trace.writeTrace(1, "  executeFastPath() called");
        if (signature == null || !this.conn.isUSVER()) {
            return null;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        short xcNewLevelSave = this.xcNewLevel;
        this.trace.writeTrace(3, "  eFP() xcNewLevelSave: " + xcNewLevelSave);
        try {
            this.getHandle(signature);
            this.sendFastPath(this.fpHandle, inParams);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.trace.writeTrace(1, "  exFP() conn.SendCommit: " + this.conn.SendCommit);
        this.trace.writeTrace(3, "  exFP() xcNewLevel: " + this.xcNewLevel);
        if (this.conn.SendCommit && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
        this.trace.writeTrace(1, "IfxSqli: executeFastPath() exited");
        return this.fpRet;
    }

    private void getHandle(String signature) throws SQLException {
        Object cacheObj = this.conn.fpCache.get(signature);
        if (cacheObj != null) {
            this.fpHandle = (Integer)cacheObj;
            this.trace.writeTrace(2, "\tSQ_GETROUTINE (cached locally)");
            this.trace.writeTrace(2, "\t\tHandle (CACHED): ", this.fpHandle);
        } else {
            try {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_GETROUTINE");
                this.os.writeSmallInt((short)101);
                this.protoTrace.writeTrace(2, "\t\tSignature: ", signature);
                this.os.writeChar(signature);
                this.protoTrace.writeTrace(1, "\t\tfparam: false");
                this.os.writeSmallInt((short)0);
                this.receiveMessage();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
            this.conn.fpCache.put(signature, new Integer(this.fpHandle));
        }
    }

    private void sendFastPath(int handle, Vector inParams) throws SQLException {
        int paramCount = inParams != null ? inParams.size() : 0;
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_EXFPROUTINE");
            this.os.writeSmallInt((short)102);
            this.protoTrace.writeTrace(2, "\t\tFastPath Handle: ", handle);
            this.os.writeInt(handle);
            this.protoTrace.writeTrace(2, "\t\tParam Count: ", paramCount);
            this.os.writeSmallInt((short)paramCount);
            this.protoTrace.writeTrace(2, "\t\tfparam: false");
            this.os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        if (paramCount != 0) {
            this.sendBind(inParams, paramCount);
        }
    }

    private void receiveFastPath() throws SQLException {
        Object data = null;
        this.fpRet = new Vector();
        IfxColumnInfo colInfo = new IfxColumnInfo();
        try {
            short numParams = this.is.readSmallInt();
            this.protoTrace.writeTrace(2, "\t\tReturn Count: ", numParams);
            short count = 0;
            while (count < numParams) {
                int type = this.is.readSmallInt();
                this.protoTrace.writeTrace(2, "\t\t\tType: ", type);
                if ((type & 0x800) > 0) {
                    colInfo.IsDistinct = true;
                }
                colInfo.SQLtype = type &= 0xFF;
                if (type >= 18 || colInfo.IsDistinct) {
                    colInfo.ExtendedOwner = new String(this.is.readChar());
                    colInfo.ExtendedName = new String(this.is.readChar());
                    this.protoTrace.writeTrace(2, "\t\t\tOwner: ", colInfo.ExtendedOwner);
                    this.protoTrace.writeTrace(2, "\t\t\tExtended: ", colInfo.ExtendedName);
                }
                colInfo.Nullable = true;
                short ind = this.is.readSmallInt();
                this.protoTrace.writeTrace(2, "\t\t\tIndicator: ", ind);
                IfxObject obj = IfxValue.makeInstance(this.conn, colInfo);
                if (ind == -1) {
                    obj.nullify();
                } else {
                    short prec = this.is.readSmallInt();
                    this.protoTrace.writeTrace(2, "\t\t\tPrecision: ", prec);
                    switch (type) {
                        case 0: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 43: {
                            obj.fromString(this.is.readChar(this.dbEncoding));
                            break;
                        }
                        case 2: 
                        case 6: {
                            obj.fromInt(this.is.readInt());
                            break;
                        }
                        case 7: {
                            obj.fromDate(this.is.readDate());
                            break;
                        }
                        case 1: {
                            obj.fromShort(this.is.readSmallInt());
                            break;
                        }
                        case 17: 
                        case 18: {
                            obj.fromLong(this.is.readLongInt());
                            break;
                        }
                        case 4: {
                            obj.fromFloat(this.is.readReal(prec));
                            break;
                        }
                        case 3: {
                            obj.fromDouble(this.is.readDouble(prec));
                            break;
                        }
                        case 5: 
                        case 8: {
                            obj.fromDecimal(this.is.readDecimal(prec));
                            break;
                        }
                        case 14: {
                            obj.fromTimestamp(this.is.readDateTime(prec));
                            break;
                        }
                        case 10: {
                            obj.fromTimestamp(this.is.readDateTime(prec));
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 44: {
                            int datalen = this.is.readInt();
                            if (datalen <= 0) break;
                            byte[] b = new byte[datalen];
                            this.is.readPadded(b);
                            obj.fromBytes(b);
                            break;
                        }
                    }
                    String s = obj.toString();
                    this.protoTrace.writeTrace(2, "\t\t\tData: ", s);
                    this.protoTrace.writeTrace(2, "");
                    this.fpRet.addElement(obj);
                }
                count = (short)(count + 1);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveHandle() throws IOException {
        this.fpHandle = this.is.readInt();
        this.protoTrace.writeTrace(1, "\t\t Handle: ", this.fpHandle);
    }

    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes) throws SQLException {
        this.BlobBuffer = buffer;
        this.BlobRequestSize = nbytes;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData(lofd, nbytes);
    }

    public int executeReadSmBlob(int lofd, FileOutputStream fileFd, int nbytes) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = nbytes;
        this.BlobFd = fileFd;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData(lofd, nbytes);
    }

    private int doLoData(int loFd, int dataLength) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: doLoData() called");
        this.sendLoData((short)0, loFd, dataLength);
        try {
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        this.trace.writeTrace(1, "IfxSqli: doLoData() exited");
        return this.amountRW;
    }

    public int executeWriteSmBlob(int loFd, byte[] buffer) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli:executeWriteSmartBlob() called");
        int dataLength = buffer.length;
        int dataOffset = 0;
        int size = 0;
        this.amountRW = 0;
        this.sendLoData((short)2, loFd, dataLength);
        while (dataLength > 0) {
            try {
                size = dataLength < 32000 ? dataLength : 32000;
                this.os.writeSmallInt((short)size);
                this.os.writePadded(buffer, dataOffset, size);
                dataLength -= size;
                dataOffset += size;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
        }
        this.receiveMessage();
        this.trace.writeTrace(1, "IfxSqli:executeWriteSmBlob() exited");
        return this.amountRW;
    }

    public int executeWriteSmBlob(int loFd, InputStream fin, int length) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli:executeWriteSmBlob() called");
        InputStream fd = fin instanceof IfxLobInputStream ? ((IfxLobInputStream)fin).getStream() : fin;
        int dataLength = length;
        boolean dataOffset = false;
        int size = 0;
        this.amountRW = 0;
        int readLength = 0;
        byte[] buffer = new byte[32000];
        boolean readFault = false;
        this.sendLoData((short)2, loFd, dataLength);
        while (dataLength > 0) {
            try {
                size = dataLength < 32000 ? dataLength : 32000;
                readLength = fd.read(buffer, 0, size);
                if (readLength <= 0) {
                    readFault = true;
                    readLength = size;
                }
                this.os.writeSmallInt((short)readLength);
                this.os.writePadded(buffer, 0, readLength);
                dataLength -= readLength;
            }
            catch (Exception exception) {
                readFault = true;
            }
        }
        this.receiveMessage();
        if (readFault) {
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli:executeWriteSmBlob() exited");
        return this.amountRW;
    }

    private void sendLoData(short subCom, int loFd, int length) throws SQLException {
        try {
            this.protoTrace.writeTrace(1, "\nC->S");
            this.protoTrace.writeTrace(1, "\tSQ_LODATA");
            this.os.writeSmallInt((short)97);
            if (subCom == 0) {
                this.protoTrace.writeTrace(2, "\tLO_READ");
            } else if (subCom == 2) {
                this.protoTrace.writeTrace(2, "\tLO_WRITE");
            }
            this.os.writeSmallInt(subCom);
            this.protoTrace.writeTrace(2, "\tLO_FD: ", loFd);
            this.os.writeSmallInt((short)loFd);
            this.protoTrace.writeTrace(2, "\tNo. of Bytes: ", length);
            this.os.writeInt(length);
            this.protoTrace.writeTrace(2, "\tR_W_BUFSIZE: ", (short)32000);
            this.os.writeSmallInt((short)32000);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short optype = 0;
        int fileSize = 0;
        try {
            optype = this.is.readSmallInt();
            fileSize = this.is.readInt();
            this.protoTrace.writeTrace(1, "\tOpType : ", optype);
            this.protoTrace.writeTrace(1, "\tTotal Size : ", fileSize);
        }
        catch (Exception exception) {}
        if (optype == 2) {
            this.amountRW = fileSize;
            return;
        }
        if (fileSize < 1) {
            try {
                short dummy = this.is.readSmallInt();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] readBuffer = null;
        if (this.BlobRequestSize > fileSize) {
            this.BlobRequestSize = fileSize;
        }
        short size = 0;
        while (this.BlobRequestSize > 0) {
            try {
                size = this.is.readSmallInt();
                if (size < 0) {
                    this.amountRW = -1;
                    return;
                }
                readBuffer = new byte[size];
                int n = this.is.readPadded(readBuffer);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(readBuffer, this.BlobWriteOffset, size);
                this.BlobWriteOffset += size;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += size;
            this.BlobRequestSize -= size;
        }
        this.protoTrace.writeTrace(1, "\tNo. of Bytes Read : ", this.amountRW);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveSQFILE() throws SQLException {
        short optype = -1;
        byte[] buf = null;
        int bufSize = -1;
        long readAmount = 0L;
        int message = -1;
        int err = 0;
        this.trace.writeTrace(1, "IfxSqli: receiveSQFILE() called");
        try {
            optype = this.is.readSmallInt();
            this.protoTrace.writeTrace(1, "\t\tOpType : ", optype);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        switch (optype) {
            case 0: {
                try {
                    short length = this.is.readSmallInt();
                    byte[] b = new byte[length];
                    this.is.readPadded(b);
                    this.copyToFileName = new String(b);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
                this.protoTrace.writeTrace(1, "\t\tFile Name : ", this.copyToFileName);
                this.protoTrace.writeTrace(1, "\t\tMode ", this.copyToFileMode);
                this.protoTrace.writeTrace(1, "\t\tFlags ", this.copyToFileFlags);
                this.protoTrace.writeTrace(1, "\t\tOffset ", this.copyToFileOffset);
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                this.protoTrace.writeTrace(1, "\tSQ_EOT");
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {}
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException nullPointerException) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0 && !this.copyToFileFd.exists()) {
                        this.copyToFileFd = null;
                        this.sendSQFILEError(2);
                        break;
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
            }
            case 2: {
                long totalSize;
                message = 0;
                long nbytes = 0L;
                boolean sysError = false;
                try {
                    bufSize = this.is.readSmallInt();
                    readAmount = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-408);
                    break;
                }
                this.protoTrace.writeTrace(1, "\t\tChunk Size ", bufSize);
                this.protoTrace.writeTrace(1, "\t\tAmount to Read ", readAmount);
                this.protoTrace.writeTrace(1, "\tSQ_EOT");
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    totalSize = this.loFile.length();
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > totalSize) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    buf = new byte[bufSize];
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-406);
                    break;
                }
                this.protoTrace.writeTrace(1, "\nC->S");
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
                this.protoTrace.writeTrace(1, "\tSQ_FILE_READ");
                readAmount = readAmount == -1L ? totalSize - (long)this.copyToFileOffset : (totalSize - (long)this.copyToFileOffset < readAmount ? totalSize - (long)this.copyToFileOffset : readAmount);
                try {
                    this.os.writeInt((int)readAmount);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
                this.protoTrace.writeTrace(1, "\tAmount", readAmount);
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(29);
                    break;
                }
                int size = 0;
                try {
                    while (readAmount > 0L) {
                        nbytes = (long)bufSize < readAmount ? (long)bufSize : readAmount;
                        try {
                            size = this.loFile.read(buf, 0, (int)nbytes);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)size);
                        this.os.writePadded(buf, 0, size);
                        readAmount -= (long)size;
                    }
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
                if (readAmount <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                err = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                }
                catch (Exception exception) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 2) != 0) {
                        this.loFile.seek(this.copyToFileOffset);
                    }
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(5);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        message = s;
                        if (s == 107) {
                            bufSize = this.is.readSmallInt();
                            byte[] buffer = new byte[bufSize];
                            this.is.readPadded(buffer);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(buffer));
                                continue;
                            }
                            this.loFile.write(buffer, 0, bufSize);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    err = 2;
                    break;
                }
                try {
                    if (message == 13) {
                        err = this.is.readSmallInt();
                    }
                    if (err != 0) {
                        this.sendSQFILEError(err);
                        break;
                    }
                    long TotalSize = this.loFile.length();
                    this.protoTrace.writeTrace(1, "\tSQ_FILE_WRITE");
                    this.protoTrace.writeTrace(1, "\t\tTotal Size:" + TotalSize);
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)TotalSize);
                    break;
                }
                catch (IOException e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                }
            }
            case 1: {
                try {
                    message = this.is.readSmallInt();
                }
                catch (IOException iOException) {
                    message = 0;
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                this.protoTrace.writeTrace(1, "\tSQ_EOT");
                try {
                    if (this.copyToFileFd == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        this.protoTrace.writeTrace(1, "\nC->S");
        this.flip();
        this.trace.writeTrace(1, "IfxSqli: receiveSQFILE() exit");
    }

    private void sendSQFILEError(int error) throws SQLException {
        this.protoTrace.writeTrace(1, "\nC->S");
        this.protoTrace.writeTrace(1, "\tSQ_ERR");
        this.protoTrace.writeTrace(1, "\tSQL error : " + error);
        this.protoTrace.writeTrace(1, "\tISAM/RSAM error : " + 0);
        this.protoTrace.writeTrace(1, "\tOffset  : " + 0);
        this.protoTrace.writeTrace(1, "\tError message  : " + 0);
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)error);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement pstmt) throws SQLException {
        this.trace.writeTrace(1, "IfxSqli: sendPut() called");
        IfxResultSetMetaData putRsmd = (IfxResultSetMetaData)pstmt.getPutMetaData();
        try {
            if (!this.cursorOpen) {
                this.sendQuery(pstmt, false, null);
            } else {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_ID");
                this.os.writeSmallInt((short)4);
                this.protoTrace.writeTrace(2, "\t\tStatement ID: ", this.statementID);
                this.os.writeSmallInt(this.statementID);
            }
            if (!putRsmd.hasVariableLengthColumns && putRsmd.textByteColumnCount <= 0) {
                this.protoTrace.writeTrace(1, "\tFixed Row Size:");
                this.protoTrace.writeTrace(1, "\tSQ_PUT");
                this.os.writeSmallInt((short)17);
                this.protoTrace.writeTrace(1, "\t\tTupleSize: ", this.tupleSize);
                if (!this.conn.isUSVER()) {
                    this.trace.writeTrace(2, "os.writeSmallInt(tupleSize)");
                    this.os.writeSmallInt(this.tupleSize);
                } else {
                    this.trace.writeTrace(2, "os.writeInt(tupleSize)");
                    this.os.writeInt(this.tupleSize);
                }
                this.protoTrace.writeTrace(2, "\t\tCount: ", pstmt.getBatchCount());
                this.os.writeSmallInt(pstmt.getBatchCount());
                byte[] bData = pstmt.getAllRows();
                this.protoTrace.writeTrace(2, "\t\t\tData: ");
                this.protoTrace.writeTrace(2, bData, 0, 'B', bData.length);
                this.os.write(bData);
            } else {
                if (putRsmd.textByteColumnCount > 0) {
                    this.protoTrace.writeTrace(1, "\tRow with Text/Bytes Columns");
                }
                if (putRsmd.hasVariableLengthColumns) {
                    this.protoTrace.writeTrace(1, "\tvar-size rows");
                    if (!this.typeSent) {
                        this.sendType(pstmt.putRsmd, (short)0);
                        this.typeSent = true;
                    }
                }
                int i = 0;
                while (i < pstmt.getBatchCount()) {
                    this.protoTrace.writeTrace(1, "\tSQ_PUT");
                    this.os.writeSmallInt((short)17);
                    byte[] bData = pstmt.getNextRow();
                    this.protoTrace.writeTrace(1, "\t\tTupleSize: ", bData.length);
                    if (!this.conn.isUSVER()) {
                        this.trace.writeTrace(2, "os.writeSmallInt((short) bData.length)");
                        this.os.writeSmallInt((short)bData.length);
                    } else {
                        this.trace.writeTrace(2, "os.writeInt( bData.length)");
                        this.os.writeInt(bData.length);
                    }
                    this.protoTrace.writeTrace(2, "\t\tCount: ", 1);
                    this.os.writeSmallInt((short)1);
                    this.protoTrace.writeTrace(2, "\t\t\tData: ");
                    this.protoTrace.writeTrace(2, bData, 0, 'B', bData.length);
                    this.os.writePadded(bData);
                    int j = i * putRsmd.textByteColumnCount;
                    while (j < i * putRsmd.textByteColumnCount + putRsmd.textByteColumnCount) {
                        this.trace.writeTrace(2, "i: " + i + " j: " + j + " textByteColumnCount: " + putRsmd.textByteColumnCount);
                        this.trace.writeTrace(2, "BlobArraySize: " + pstmt.getIfxBlobArraySize());
                        IfxBlob BlobObject = pstmt.getIfxBlobAt(j);
                        if (BlobObject != null) {
                            if (BlobObject.isBlobByteType()) {
                                this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                            } else {
                                this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.trace.writeTrace(1, "IfxSqli: sendPut() exited");
    }
}

