/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInt8;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxUDT;
import com.informix.util.IfxErrMsg;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class IfxSmartBlob {
    public static final int LO_APPEND = 1;
    public static final int LO_WRONLY = 2;
    public static final int LO_RDONLY = 4;
    public static final int LO_RDWR = 8;
    public static final int LO_SEEK_SET = 0;
    public static final int LO_SEEK_CUR = 1;
    public static final int LO_SEEK_END = 2;
    private static final String IFX_LO_COL_INFO = "function informix.ifx_lo_col_s binfo(lvarchar,ifx_lo_spec)";
    private static final String IFX_LO_CREATE = "function informix.ifx_lo_create( ifx_lo_spec,integer,blob)";
    private static final String IFX_LO_RELEASE = "function informix.ifx_lo_release(blob)";
    private static final String IFX_LO_OPEN = "function informix.ifx_lo_open(blob ,integer)";
    private static final String IFX_LO_CLOSE = "function informix.ifx_lo_close(integer)";
    private static final String IFX_LO_SEEK = "function informix.ifx_lo_seek(integer,int8,integer,int8)";
    private static final String IFX_LO_LOCK = "function informix.ifx_lo_lock(integer,integer,int8,int8,integer)";
    private static final String IFX_LO_UNLOCK = "function informix.ifx_lo_unlock( integer,integer,int8,int8)";
    private static final String IFX_LO_TELL = "function informix.ifx_lo_tell(int, int8)";
    private static final String IFX_LO_TRUNCATE = "function informix.ifx_lo_truncate(integer,int8)";
    private static final String IFX_LO_COPY_TO_LO = "function informix.ifx_lo_from_file(int,lvarchar,int,int,int)";
    private static final String IFX_LO_COPY_TO_FILE = "function informix.ifx_lo_to_file(blob,lvarchar,int, int)";
    private static final String IFX_LO_FILENAME = "function informix.ifx_lo_filename(blob,lvarchar)";
    private static final String IFX_LO_ALTER = "function informix.ifx_lo_alter(blob,ifx_lo_spec)";
    private static final String IFX_LO_STAT = "function informix.ifx_lo_stat(int, ifx_lo_stat)";
    private static final String LO_CREATE_SPEC_NAME = "ifx_lo_spec";
    private static final String LO_COL_NAME = "lvarchar";
    private static final String LO_STAT_NAME = "ifx_lo_stat";
    private static final String LO_NAME = "blob";
    private static final int LO_STAT_SIZE = 644;
    private static final int PRE_LONG_ID_LO_STAT_SIZE = 212;
    IfxLocator lo_ptr;
    private IfxConnection conn;
    private IfxProtocol prot;

    public IfxSmartBlob(Connection conn) throws SQLException {
        this.conn = (IfxConnection)conn;
        try {
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Class<?> connClassRef = Class.forName(this.conn.getConnClassName());
            Class[] classArgs = new Class[]{connClassRef};
            Constructor<?> cons = classRef.getConstructor(classArgs);
            Object[] objs = new Object[]{this.conn};
            this.prot = (IfxProtocol)cons.newInstance(objs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
    }

    public IfxLobDescriptor IfxLoColInfo(String name) throws SQLException {
        if (name == null) {
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        byte[] byteVar = new byte[IfxLobDescriptor.size(this.conn)];
        IfxLvarchar ip1 = new IfxLvarchar(name);
        ip1.setExtendedTypeName(LO_COL_NAME);
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ip2.fromBytes(byteVar);
        Vector<IfxBaseType> inVec = new Vector<IfxBaseType>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_COL_INFO, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(1);
        byte[] byteV = op1.toBytes();
        IfxInteger op2 = (IfxInteger)outVec.elementAt(2);
        int retcode = op2.toInt();
        return new IfxLobDescriptor(this.conn, byteV);
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxLocator locator) throws SQLException {
        byte[] tempLoPtr = new byte[72];
        boolean loFD = false;
        byte[] myDesc = lodesc.getRawLobDescriptor();
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ip1.fromBytes(myDesc);
        IfxInteger ip2 = new IfxInteger(mode);
        IfxUDT ip3 = new IfxUDT();
        ip3.setConnection(this.conn);
        ip3.setExtendedTypeName(LO_NAME);
        ip3.fromBytes(tempLoPtr);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        outVec = this.prot.executeFastPath(IFX_LO_CREATE, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(0);
        byte[] tempLo = op1.toBytes();
        IfxInteger op2 = (IfxInteger)outVec.elementAt(1);
        locator.setRawLocator(tempLo);
        return op2.toInt();
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxBblob blob) throws SQLException {
        IfxLocator loPtr = new IfxLocator();
        blob.setLocator(loPtr);
        blob.setConnection(this.conn);
        return this.IfxLoCreate(lodesc, mode, loPtr);
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxCblob clob) throws SQLException {
        IfxLocator loPtr = new IfxLocator();
        clob.setLocator(loPtr);
        clob.setConnection(this.conn);
        return this.IfxLoCreate(lodesc, mode, loPtr);
    }

    public int IfxLoOpen(IfxLocator locator, int mode) throws SQLException {
        byte[] loptr = locator.getRawLocator();
        boolean loFd = false;
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(loptr);
        IfxInteger ip2 = new IfxInteger(mode);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_OPEN, inVec, false);
        IfxInteger op2 = (IfxInteger)outVec.elementAt(0);
        return op2.toInt();
    }

    public int IfxLoOpen(IfxBblob blob, int mode) throws SQLException {
        IfxLocator loc = blob.getLocator();
        return this.IfxLoOpen(loc, mode);
    }

    public int IfxLoOpen(IfxCblob clob, int mode) throws SQLException {
        IfxLocator loc = clob.getLocator();
        return this.IfxLoOpen(loc, mode);
    }

    public void IfxLoRelease(IfxLocator locator) throws SQLException {
        byte[] LoPtr = locator.getRawLocator();
        int retcode = 0;
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(LoPtr);
        Vector<IfxUDT> inVec = new Vector<IfxUDT>();
        Vector outVec = null;
        inVec.addElement(ip1);
        outVec = this.prot.executeFastPath(IFX_LO_RELEASE, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        retcode = op1.toInt();
    }

    public void IfxLoRelease(IfxBblob blob) throws SQLException {
        IfxLocator loc = blob.getLocator();
        this.IfxLoRelease(loc);
    }

    public void IfxLoRelease(IfxCblob clob) throws SQLException {
        IfxLocator loc = clob.getLocator();
        this.IfxLoRelease(loc);
    }

    public void IfxLoClose(int lofd) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        Vector<IfxInteger> inVec = new Vector<IfxInteger>();
        Vector outVec = null;
        inVec.addElement(ip1);
        outVec = this.prot.executeFastPath(IFX_LO_CLOSE, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        int retcode = op1.toInt();
    }

    public long IfxLoSeek(int lofd, long offset, int whence) throws SQLException {
        long position = 0L;
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(offset);
        IfxInteger ip3 = new IfxInteger(whence);
        IfxInt8 ip4 = new IfxInt8(position);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        outVec = this.prot.executeFastPath(IFX_LO_SEEK, inVec, false);
        IfxInt8 op1 = (IfxInt8)outVec.elementAt(0);
        IfxInteger op2 = (IfxInteger)outVec.elementAt(1);
        return op1.toLong();
    }

    public void IfxLoTruncate(int lofd, long size) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(size);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_TRUNCATE, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
    }

    public long IfxLoSize(int lofd) throws SQLException {
        IfxLoStat loStat = this.IfxLoGetStat(lofd);
        return loStat.getSize();
    }

    public IfxLoStat IfxLoGetStat(int lofd) throws SQLException {
        long value = 0L;
        int loStat_sz = this.conn.isLongID() ? 644 : 212;
        byte[] ifxLoStat = new byte[loStat_sz];
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_STAT_NAME);
        ip2.fromBytes(ifxLoStat);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_STAT, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(0);
        ifxLoStat = op1.toBytes();
        return new IfxLoStat(this.conn, ifxLoStat);
    }

    public long IfxLoTell(int lofd) throws SQLException {
        long value = 0L;
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(value);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_TELL, inVec, false);
        IfxInt8 op1 = (IfxInt8)outVec.elementAt(0);
        return op1.toLong();
    }

    public byte[] IfxLoRead(int lofd, int nbytes) throws SQLException {
        if (nbytes < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        byte[] b = new byte[nbytes];
        this.prot.executeReadSmBlob(lofd, b, nbytes);
        return b;
    }

    public int IfxLoRead(int lofd, byte[] buffer, int nbytes) throws SQLException {
        if (buffer == null || buffer.length < nbytes || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(lofd, buffer, nbytes);
    }

    public int IfxLoRead(int lofd, FileOutputStream fout, int nbytes) throws SQLException {
        if (nbytes < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(lofd, fout, nbytes);
    }

    public int IfxLoWrite(int lofd, byte[] buffer) throws SQLException {
        int n = 0;
        if (buffer == null || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n = this.prot.executeWriteSmBlob(lofd, buffer);
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n;
    }

    public int IfxLoWrite(int lofd, InputStream fin, int length) throws SQLException {
        int n = 0;
        if (length < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n = this.prot.executeWriteSmBlob(lofd, fin, length);
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n;
    }
}

