/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxSmallFloat
extends IfxObject {
    private float value;
    private static final int IFX_SMFLOAT_SIZE = 4;

    IfxSmallFloat() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat() constructor called");
        this.writeTrace(1, "IfxSmallFloat() constructor exited");
        this.setIfxType(4);
    }

    IfxSmallFloat(float f) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat(float) constructor called");
        this.setIfxType(4);
        this.value = f;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat(float) constructor exited");
    }

    IfxSmallFloat(Float F) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat(Float) constructor called");
        this.setIfxType(4);
        if (F != null) {
            this.value = F.floatValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxSmallFloat(Float) constructor exited");
    }

    IfxSmallFloat(double d) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat(double) constructor called");
        this.setIfxType(4);
        this.value = (float)d;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat(double) constructor exited");
    }

    IfxSmallFloat(Double D) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat(Double) constructor called");
        this.setIfxType(4);
        if (D != null) {
            this.value = (float)D.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxSmallFloat(Double) constructor exited");
    }

    public byte[] toIfx() {
        this.writeTrace(1, "IfxSmallFloat: toIfx() called/exited");
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[4];
            memoryUtil.byfill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    public void fromIfx(byte[] b) {
        boolean null_flg = true;
        this.writeTrace(1, "IfxSmallFloat: fromIfx() called");
        null_flg = IfxSmallFloat.isIfxNull(b);
        if (!null_flg) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaReal(b, (short)0);
        } else {
            this.nullify();
        }
        this.writeTrace(1, "IfxSmallFloat: fromIfx() exited");
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxSmallFloat) {
            IfxSmallFloat floatOther = (IfxSmallFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    public byte toByte() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toByte() called");
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        this.writeTrace(1, "IfxSmallFloat: toByte() exited");
        return b;
    }

    public void fromByte(Byte b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromByte((byte)b);
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromByte() called");
        this.value = b;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromByte() exited");
    }

    public short toShort() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toShort() called");
        this.clearWarning();
        short s = this.isNull() ? (short)0 : (short)this.value;
        this.writeTrace(1, "IfxSmallFloat: toShort() exited");
        return s;
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    public void fromShort(short s) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromShort() called");
        this.value = s;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromShort() exited");
    }

    public int toInt() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toInt() called");
        this.clearWarning();
        int i = this.isNull() ? 0 : (int)this.value;
        this.writeTrace(1, "IfxSmallFloat: toInt() exited");
        return i;
    }

    public void fromInt(Integer i) throws SQLException {
        if (i == null) {
            this.nullify();
        } else {
            this.fromInt((int)i);
        }
    }

    public void fromInt(int i) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromInt() called");
        this.value = i;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromInt() exited");
    }

    public long toLong() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toLong() called");
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        this.writeTrace(1, "IfxSmallFloat: toLong() called");
        return l;
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    public void fromLong(long l) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromLong() called");
        this.value = l;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromLong() exited");
    }

    public double toDouble() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toDouble() called");
        double d = this.isNull() ? 0.0 : (double)this.value;
        this.writeTrace(1, "IfxSmallFloat: toDouble() exited");
        return d;
    }

    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromDouble() called");
        this.value = (float)d;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromDouble() exited");
    }

    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toDecimal() called/exited");
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromDecimal() called");
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.floatValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxSmallFloat: fromDecimal() exited");
    }

    public boolean toBoolean() throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: toBoolean() called");
        boolean b = this.isNull() ? false : this.value != 0.0f;
        this.writeTrace(1, "IfxSmallFloat: toBoolean() exited");
        return b;
    }

    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)b);
            this.unnullify();
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromBoolean() called");
        this.value = b ? 1 : 0;
        this.unnullify();
        this.writeTrace(1, "IfxSmallFloat: fromBoolean() exited");
    }

    public String toString() {
        this.writeTrace(1, "IfxSmallFloat: toString() called");
        String s = this.isNull() ? null : Float.toString(this.value);
        this.writeTrace(1, "IfxSmallFloat: toString() exited");
        return s;
    }

    public void fromString(String str) throws SQLException {
        this.writeTrace(1, "IfxSmallFloat: fromString() called");
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Float.valueOf(str.trim()).floatValue();
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        this.writeTrace(1, "IfxSmallFloat: fromString() called");
    }

    static boolean isIfxNull(float f) {
        byte[] b = JavaToIfxType.JavaToIfxReal(f);
        return IfxSmallFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        int i = 0;
        while (i < 4) {
            if (b[i] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static float getIfxNull() {
        byte[] b = new byte[4];
        float f = 0.0f;
        int i = 0;
        while (i < 4) {
            b[i] = -1;
            f = IfxToJavaType.IfxToJavaReal(b, (short)0);
            ++i;
        }
        return f;
    }
}

