/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxSmBlob
extends IfxBaseType {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    private static final short BLOB_TYPE_BYTES = 0;
    private static final short BLOB_TYPE_STREAM = 1;
    protected IfxLocator locator;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection conn, IfxLocator loc) throws SQLException {
        this.conn = conn;
        this.locator = loc;
        this.fromLocator();
    }

    public IfxSmBlob(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
    }

    public IfxSmBlob(byte[] blobBuffer) throws SQLException {
        this.fromBytes(blobBuffer);
    }

    private void fromLocator() throws SQLException {
        try {
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            this.loFd = smb.IfxLoOpen(this.locator, 8);
            this.sm_size = smb.IfxLoSize(this.loFd);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79701, this.conn);
        }
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public void fromIfx(byte[] b) throws SQLException {
        super.fromIfx(b);
        if (!this.isNull()) {
            byte[] tempLoc = this.inputStream.toByteArray();
            this.locator = new IfxLocator(tempLoc);
            this.fromLocator();
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfxTuple();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream lobStream = new IfxLobInputStream(this.conn, this.locator);
                return lobStream;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                IfxInputStream fd = new IfxInputStream(this.tempBlobFile);
                return fd;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
        }
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.blobBuffer);
        return barrayIS;
    }

    /*
     * WARNING - void declaration
     */
    public void fromInputStream(InputStream fin, int length) throws SQLException {
        this.sm_size = length;
        this.BlobInputStream = fin;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
        try {
            IfxLobDescriptor loDesc = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            this.loFd = smb.IfxLoCreate(loDesc, 8, this.locator);
            if (length > 0) {
                int n = smb.IfxLoWrite(this.loFd, fin, length);
            }
            smb.IfxLoClose(this.loFd);
        }
        catch (SQLException e) {
            void loDesc;
            this.sm_size = 0L;
            this.nullify();
            throw loDesc;
        }
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.IfxSmBlobType = (short)3;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.IfxSmBlobType = (short)2;
    }

    public String toString() {
        IfxCblob cb = new IfxCblob(this.conn, this.locator);
        cb.setSize(this.sm_size);
        return cb.getSubString(1L, (int)this.sm_size);
    }

    /*
     * WARNING - void declaration
     */
    public void fromString(String S) throws SQLException {
        if (S == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = S.length();
        this.blobBuffer = S.getBytes();
        int noOfBytes = 0;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
        try {
            IfxLobDescriptor loDesc = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            this.loFd = smb.IfxLoCreate(loDesc, 8, this.locator);
            if (this.sm_size > 0L) {
                noOfBytes = smb.IfxLoWrite(this.loFd, this.blobBuffer);
            }
            smb.IfxLoClose(this.loFd);
        }
        catch (SQLException e) {
            void loDesc;
            this.sm_size = 0L;
            this.nullify();
            throw loDesc;
        }
    }

    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    public byte[] toBytes() throws SQLException {
        IfxBblob bb = new IfxBblob(this.conn, this.locator);
        bb.setSize(this.sm_size);
        return bb.getPortion(1L, this.sm_size);
    }

    /*
     * WARNING - void declaration
     */
    public void fromBytes(byte[] blobBuffer) throws SQLException {
        if (blobBuffer == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = blobBuffer.length;
        this.blobBuffer = blobBuffer;
        this.unnullify();
        int noOfBytes = 0;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        try {
            IfxLobDescriptor loDesc = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            this.loFd = smb.IfxLoCreate(loDesc, 8, this.locator);
            if (this.sm_size > 0L) {
                noOfBytes = smb.IfxLoWrite(this.loFd, blobBuffer);
            }
            smb.IfxLoClose(this.loFd);
        }
        catch (SQLException e) {
            void loDesc;
            this.sm_size = 0L;
            this.nullify();
            throw loDesc;
        }
    }

    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {}
        }
        this.tempBlobFile = null;
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {}
    }
}

