/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxShort
extends IfxObject {
    private short value;
    public static final short IFX_SMINT_NULL = Short.MIN_VALUE;

    IfxShort() throws SQLException {
        this.setIfxType(1);
    }

    IfxShort(short s) throws SQLException {
        this.setIfxType(1);
        this.value = s;
        this.unnullify();
    }

    IfxShort(Short S) throws SQLException {
        this.setIfxType(1);
        this.value = S;
        this.unnullify();
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[]{-128, 0};
            return b;
        }
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    public void fromIfx(byte[] b) {
        this.value = IfxToJavaType.IfxToJavaSmallInt(b, (short)0);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Short(this.value);
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    public void fromInt(int val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    public void fromInt(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    public void fromLong(long val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(float val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double val) {
        this.value = (short)val;
        this.unnullify();
    }

    public void fromDouble(Double val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)val.intValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    public void fromBoolean(boolean val) throws SQLException {
        this.value = (short)(val ? 1 : 0);
        this.unnullify();
    }

    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)(val == true ? 1 : 0);
            this.unnullify();
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Short.valueOf(str.trim());
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxShort && this.value == ((IfxShort)other).value;
    }

    public short getEncodedLength() {
        short encodedLength = 1280;
        this.writeTrace(3, "IfxShort ecodedLength = " + encodedLength);
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Short.MIN_VALUE;
    }
}

