/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxStatement;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;

public class IfxScrollableResultSet
extends IfxResultSet {
    Vector insertRowVector;
    boolean insertMode = false;
    IfxRowColumn rowColumn;

    IfxScrollableResultSet() throws SQLException {
    }

    IfxScrollableResultSet(IfxStatement stmt) throws SQLException {
        super(stmt);
    }

    public void moveToInsertRow() throws SQLException {
        this.insertMode = true;
    }

    public int getRow() throws SQLException {
        return this.curRowID;
    }

    IfxObject getValue(int columnIndex) throws SQLException {
        try {
            if (this.insertRowVector == null) {
                this.insertRowVector = new Vector();
                if (this.rsmd == null) {
                    this.rsmd = (IfxResultSetMetaData)this.getMetaData();
                }
                this.insertRowVector.setSize(this.rsmd.getColumnCount());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (columnIndex < 1 || columnIndex > this.insertRowVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject value = (IfxObject)this.insertRowVector.elementAt(columnIndex - 1);
        if (value == null) {
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, this.rsmd);
            }
            value = this.rowColumn.getColumn(columnIndex);
            this.insertRowVector.setElementAt(value, columnIndex - 1);
        }
        this.lastColWasNull = value.isNull();
        return value;
    }

    public int findColumn(String columnName) throws SQLException {
        Integer idx;
        this.trace.writeTrace(1, "IfxScrollableResultSet.findColumn() called");
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int numCols = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(numCols);
            int i = 1;
            while (i <= numCols) {
                if (!this.conn.isDelimIdentSet()) {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(i).toLowerCase(), new Integer(i));
                } else {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(i), new Integer(i));
                }
                ++i;
            }
        }
        if ((idx = !this.conn.isDelimIdentSet() ? (Integer)this.nameToIdxTable.get(columnName.toLowerCase()) : (Integer)this.nameToIdxTable.get(columnName)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        this.trace.writeTrace(1, "IfxScrollableResultSet.findColumn() exited");
        return idx;
    }

    public void updateNull(int columnIndex) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.nullify();
    }

    public void updateNull(String column) throws SQLException {
        this.updateNull(this.findColumn(column));
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromBoolean(x);
    }

    public void updateBoolean(String column, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(column), x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromByte(x);
    }

    public void updateByte(String column, byte x) throws SQLException {
        this.updateByte(this.findColumn(column), x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromShort(x);
    }

    public void updateShort(String column, short x) throws SQLException {
        this.updateShort(this.findColumn(column), x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromInt(x);
    }

    public void updateInt(String column, int x) throws SQLException {
        this.updateInt(this.findColumn(column), x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromLong(x);
    }

    public void updateLong(String column, long x) throws SQLException {
        this.updateLong(this.findColumn(column), x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromFloat(x);
    }

    public void updateFloat(String column, float x) throws SQLException {
        this.updateFloat(this.findColumn(column), x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromDouble(x);
    }

    public void updateDouble(String column, double x) throws SQLException {
        this.updateDouble(this.findColumn(column), x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromDecimal(x);
    }

    public void updateBigDecimal(String column, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(column), x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromString(x);
    }

    public void updateString(String column, String x) throws SQLException {
        this.updateString(this.findColumn(column), x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromBytes(x);
    }

    public void updateBytes(String column, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(column), x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromDate(x);
    }

    public void updateDate(String column, Date x) throws SQLException {
        this.updateDate(this.findColumn(column), x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromTime(x);
    }

    public void updateTime(String column, Time x) throws SQLException {
        this.updateTime(this.findColumn(column), x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromTimestamp(x);
    }

    public void updateTimestamp(String column, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(column), x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromAsciiStream(x, length);
    }

    public void updateAsciiStream(String column, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(column), x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromBinaryStream(x, length);
    }

    public void updateBinaryStream(String column, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(column), x, length);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        IfxObject value = this.insertMode ? this.getValue(columnIndex) : super.getValue(columnIndex);
        value.fromObject(x);
    }

    public void updateObject(String column, Object x) throws SQLException {
        this.updateObject(this.findColumn(column), x);
    }

    protected void finalize() {
        if (this.insertRowVector != null) {
            this.insertRowVector.removeAllElements();
            this.insertRowVector = null;
        }
    }
}

