/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfmxSQLOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class IfxSQLOutput
implements IfmxSQLOutput {
    ByteArrayOutputStream bStream = new ByteArrayOutputStream();
    IfxDataOutputStream os = new IfxDataOutputStream(this.bStream);
    protected int currentPos;
    protected IfxConnection conn;
    protected Trace trace;

    IfxSQLOutput() {
    }

    IfxSQLOutput(IfxConnection conn) throws SQLException {
        this.setConnection(conn);
    }

    void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
        this.trace = conn.getTrace();
        if (this.trace == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
    }

    void reset() {
        this.bStream.reset();
        this.currentPos = 0;
    }

    int length() {
        return this.bStream.size();
    }

    byte[] toByteArray() {
        return this.bStream.toByteArray();
    }

    public void writeString(String x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeString(String).", this.conn);
    }

    public void writeBoolean(boolean x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBoolean(boolean).", this.conn);
    }

    public void writeByte(byte x) throws SQLException {
        this.writeShort(x);
    }

    public void writeShort(short x) throws SQLException {
        try {
            this.os.writeShort(x);
            this.currentPos += 2;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeInt(int x) throws SQLException {
        try {
            this.os.writeInt(x);
            this.currentPos += 4;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeLong(long x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeLong(long).", this.conn);
    }

    public void writeFloat(float x) throws SQLException {
        try {
            this.os.writeReal(x);
            this.currentPos += 4;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeDouble(double x) throws SQLException {
        try {
            this.os.writeDouble(x);
            this.currentPos += 8;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeBigDecimal(BigDecimal x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBigDecimal(BigDecimal).", this.conn);
    }

    public void writeBytes(byte[] x) throws SQLException {
        try {
            this.os.write(x);
            this.currentPos += x.length;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] x, int len) throws SQLException {
        try {
            int numPadded = len - x.length;
            this.os.write(x);
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeDate(Date x) throws SQLException {
        try {
            this.os.writeDate(x);
            this.currentPos += 4;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeTime(Time x) throws SQLException {
        try {
            this.writeTimestamp(new Timestamp(x.getTime()));
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public void writeTimestamp(Timestamp x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeTimestamp(Timestamp).", this.conn);
    }

    public void writeCharacterStream(Reader x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeCharacterStream(Reader).", this.conn);
    }

    public void writeAsciiStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeAsciiStream(InputStream).", this.conn);
    }

    public void writeBinaryStream(InputStream x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBinaryStream(InputStream).", this.conn);
    }

    public void writeObject(IfmxSQLData x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeObject(SQLData).", this.conn);
    }
}

