/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Vector;

class IfxRowColumn {
    IfxConnection conn;
    ByteArrayOutputStream bStream;
    byte[] tuple;
    IfxResultSetMetaData rsmd;
    int offset;
    Vector colInfoVector;
    private int initialSize;
    private int currDataSize;
    private boolean dataInStream = false;
    Trace trace;

    IfxRowColumn(IfxConnection thisConn, IfxResultSetMetaData metaData, int initialSize) throws SQLException {
        this.rsmd = metaData;
        this.conn = thisConn;
        try {
            if (this.rsmd.hasVariableLengthColumns) {
                initialSize += 1024;
            }
            this.initialSize = initialSize;
            this.tuple = new byte[this.initialSize];
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    IfxRowColumn(IfxConnection conn, IfxResultSetMetaData metaData) {
        this.conn = conn;
        this.rsmd = metaData;
    }

    void readTuple(IfxDataInputStream is, int offset, int size) throws SQLException {
        this.writeTrace(1, "IfxRowColumn.readTuple() entered");
        this.writeTrace(2, "    currDataSize = " + this.currDataSize);
        this.writeTrace(2, "    initialSize = " + this.initialSize);
        this.writeTrace(2, "    offset = " + offset);
        this.writeTrace(2, "    size = " + size);
        if (this.dataInStream || this.currDataSize + size > this.initialSize) {
            byte[] tmpTuple = new byte[size];
            try {
                if (!this.dataInStream) {
                    if (this.bStream == null) {
                        this.bStream = new ByteArrayOutputStream();
                    }
                    if (this.currDataSize > 0) {
                        this.bStream.write(this.tuple, 0, this.currDataSize);
                    }
                    this.dataInStream = true;
                }
                is.readPadded(tmpTuple, 0, size);
                this.bStream.write(tmpTuple, 0, size);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        try {
            is.readPadded(this.tuple, offset, size);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        this.currDataSize += size;
        this.writeTrace(2, "    currDataSize: " + this.currDataSize);
        this.writeTrace(1, "IfxRowColumn.readTuple() exited");
    }

    void setOffsetInTuple(int offset) throws SQLException {
        this.offset = offset;
        if (this.rsmd.hasVariableLengthColumns) {
            int rowOffset = offset;
            int colOffset = 0;
            if (this.colInfoVector == null) {
                this.colInfoVector = new Vector();
                this.colInfoVector.setSize(this.rsmd.getColumnCount());
            }
            int i = 1;
            while (i <= this.rsmd.getColumnCount()) {
                int dataLen;
                byte[] b;
                int colType = this.rsmd.getIfxColumnType(i);
                int colLen = this.rsmd.getColumnLength(i);
                if (colType == 40 || colType == 41 || colType == 45 || colType == 43) {
                    b = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, rowOffset + 1, b, 0, 4);
                    dataLen = IfxToJavaType.IfxToJavaInt(b, (short)0);
                    colLen = 5 + dataLen;
                } else if (colType == 13 || colType == 16) {
                    ++colLen;
                } else if (IfxTypes.isComplexType(colType)) {
                    b = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, rowOffset, b, 0, 4);
                    dataLen = IfxToJavaType.IfxToJavaInt(b, (short)0);
                    colLen = dataLen + 4;
                    this.writeTrace(2, "data length: " + colLen);
                }
                rowOffset += colLen;
                columnInfo ci = new columnInfo();
                ci.startPos = colOffset;
                ci.len = colLen;
                this.colInfoVector.setElementAt(ci, i - 1);
                colOffset += colLen;
                ++i;
            }
        }
    }

    void setMetaData(IfxResultSetMetaData metaData) {
        this.rsmd = metaData;
    }

    void setTrace(Trace traceObj) {
        this.trace = traceObj;
    }

    IfxObject getColumn(int idx) throws SQLException {
        this.writeTrace(99, "Entering IfxRowColumn.getRowColumn()");
        IfxObject obj = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(idx));
        this.loadColumnData(idx, obj);
        return obj;
    }

    void loadColumnData(int idx, IfxObject val) throws SQLException {
        int ifxColLen;
        int columnType = this.rsmd.getIfxColumnType(idx);
        int columnOffset = 0;
        short prec = (short)this.rsmd.getEncodedLength(idx);
        val.clear();
        if (this.colInfoVector != null) {
            if (idx > this.colInfoVector.size()) {
                throw IfxErrMsg.getSQLException(-79703, this.conn);
            }
            columnInfo ci = (columnInfo)this.colInfoVector.elementAt(idx - 1);
            ifxColLen = ci.len;
            columnOffset = ci.startPos;
        } else {
            ifxColLen = this.rsmd.getColumnLength(idx);
            columnOffset = this.rsmd.getColumnStartPosition(idx);
        }
        String traceMessage = new String("IfxRowData.getAllColumns(): idx = " + idx + ", SQLType = " + this.rsmd.getIfxColumnType(idx) + ", Column Length = " + ifxColLen);
        this.writeTrace(3, traceMessage);
        byte[] thisTuple = this.tuple;
        if (this.dataInStream) {
            thisTuple = this.bStream.toByteArray();
        }
        if (thisTuple != null && ifxColLen > 0) {
            if (columnType == 13 || columnType == 16) {
                ++ifxColLen;
            }
            try {
                byte[] b = new byte[ifxColLen];
                if (thisTuple != null) {
                    System.arraycopy(thisTuple, this.offset + columnOffset, b, 0, ifxColLen);
                    if (columnType == 5 || columnType == 8 || columnType == 14 || columnType == 10) {
                        val.fromIfx(b, prec);
                    } else {
                        val.fromIfx(b);
                    }
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        this.writeTrace(99, "Exiting IfxRowColumn.getRowColumn()");
    }

    private void writeTrace(int level, String message) {
        if (this.trace != null) {
            this.trace.writeTrace(level, message);
        }
    }

    byte[] getTupleData() {
        if (!this.dataInStream) {
            return this.tuple;
        }
        return this.bStream.toByteArray();
    }

    void reset() {
        if (this.dataInStream) {
            this.dataInStream = false;
            this.bStream.reset();
        }
        this.currDataSize = 0;
    }

    void clear() {
        this.reset();
        this.rsmd = null;
    }

    class columnInfo {
        int startPos;
        int len;

        columnInfo() {
            IfxRowColumn.this = IfxRowColumn.this;
        }
    }
}

