/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxResultSetMetaData
implements ResultSetMetaData {
    Vector cinfoVector = new Vector();
    boolean hasVariableLengthColumns;
    short textByteColumnCount;
    private int numberofcol;
    private boolean delimIdent = false;
    private IfxConnection conn;
    protected Trace trace;

    public IfxResultSetMetaData(int numcol, IfxConnection thisconn) {
        try {
            this.setColumnCount(numcol);
        }
        catch (SQLException sQLException) {}
        this.textByteColumnCount = 0;
        this.conn = thisconn;
        this.trace = this.conn.getTrace();
    }

    IfxResultSetMetaData(IfxResultSetMetaData rsmd) throws SQLException {
        this.numberofcol = rsmd.numberofcol;
        if (this.numberofcol > 0) {
            this.cinfoVector.setSize(this.numberofcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        int i = 0;
        while (i < this.numberofcol) {
            this.cinfoVector.setElementAt(rsmd.getColumnInfo(i + 1).clone(), i);
            ++i;
        }
        this.hasVariableLengthColumns = rsmd.hasVariableLengthColumns;
        this.textByteColumnCount = rsmd.textByteColumnCount;
        this.delimIdent = rsmd.delimIdent;
        this.conn = rsmd.conn;
        this.trace = rsmd.trace;
    }

    public int getColumnCount() throws SQLException {
        return this.numberofcol;
    }

    IfxColumnInfo getColumnInfo(int column) throws SQLException {
        if (column < 1 || column > this.numberofcol) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return (IfxColumnInfo)this.cinfoVector.elementAt(column - 1);
    }

    private IfxColumnInfo getColumnInfo(int column, boolean add) throws SQLException {
        if (add && column > this.numberofcol) {
            if (column > this.cinfoVector.size()) {
                this.cinfoVector.setSize(column + 20);
            }
            int i = 0;
            while (i < column - this.numberofcol) {
                this.cinfoVector.setElementAt(new IfxColumnInfo(), this.numberofcol + i);
                ++i;
            }
            this.numberofcol = column;
        }
        return this.getColumnInfo(column);
    }

    public int getColumnLength(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        int colLen = cinfo.ColLength;
        int columnType = cinfo.SQLtype;
        if (colLen != -1 && (columnType == 10 || columnType == 14 || columnType == 5 || columnType == 8)) {
            colLen = ((colLen >> 8 & 0xFF) + (colLen & 0xFF & 1) + 3) / 2;
        }
        return colLen;
    }

    public int getColumnStartPosition(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ColStartPos;
    }

    public int getColumnExtendedId(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ExtendedId;
    }

    public String getExtendedName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ExtendedName;
    }

    public String getExtendedOwnerName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ExtendedOwner;
    }

    public short getReference(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Reference;
    }

    public int getAlignment(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Alignment;
    }

    public int getSourceType(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.SourceType;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.SQLtype == 6 || cinfo.SQLtype == 18;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return this.delimIdent;
    }

    public boolean isSearchable(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        switch (cinfo.SQLtype) {
            case 11: 
            case 12: 
            case 40: 
            case 41: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.SQLtype == 8;
    }

    public int isNullable(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Nullable ? 1 : 0;
    }

    public boolean isSigned(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        switch (cinfo.SQLtype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int dec_width = 1;
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        switch (cinfo.SQLtype) {
            case 13: {
                return cinfo.ColLength & 0xFF;
            }
            case 45: {
                return 1;
            }
            case 1: {
                return 6;
            }
            case 10: 
            case 14: {
                int tu_len = cinfo.ColLength >> 8 & 0xFF;
                int tu_start = cinfo.ColLength >> 4 & 0xF;
                int tu_end = cinfo.ColLength & 0xF;
                int width = tu_len + ((tu_end > 10 ? 12 : tu_end) - tu_start) / 2 + (tu_start == 12 ? 1 : 0);
                if (cinfo.SQLtype == 10) {
                    return width;
                }
                return width + 1;
            }
            case 7: {
                return 23;
            }
            case 2: 
            case 6: {
                return 11;
            }
            case 17: 
            case 18: {
                return 20;
            }
            case 3: 
            case 4: {
                return 14;
            }
            case 8: {
                int precision = cinfo.ColLength >> 8 & 0xFF;
                int scale = cinfo.ColLength & 0xFF;
                int width = precision + 3;
                if (precision == scale) {
                    ++width;
                }
                return width;
            }
            case 5: {
                int width;
                int precision = cinfo.ColLength >> 8 & 0xFF;
                int scale = cinfo.ColLength & 0xFF;
                if (scale == 255) {
                    width = 1 + precision + dec_width + 1 + 4;
                } else {
                    width = precision + 1 + dec_width;
                    if (precision == scale) {
                        ++width;
                    }
                }
                return width;
            }
        }
        return cinfo.ColLength;
    }

    public String getColumnLabel(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ColName;
    }

    public String getColumnName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ColName;
    }

    public String getSchemaName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.SQLtype == 8 || cinfo.SQLtype == 5) {
            return cinfo.ColLength >> 8 & 0xFF;
        }
        return 0;
    }

    int getEncodedLength(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ColLength;
    }

    public int getScale(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.SQLtype == 8 || cinfo.SQLtype == 5) {
            return cinfo.ColLength & 0xFF;
        }
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.TableName;
    }

    public String getCatalogName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.ExtendedName.equals("boolean")) {
            return 1111;
        }
        if (cinfo.ExtendedName.equals("lvarchar")) {
            return -1;
        }
        if (cinfo.IsDistinct) {
            return 2001;
        }
        return IfxTypes.FromIfxToJDBCType(cinfo.SQLtype);
    }

    public int getIfxColumnType(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.SQLtype;
    }

    public String getColumnTypeName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.SQLtype > 18 || cinfo.IsDistinct) {
            return cinfo.ExtendedName;
        }
        return cinfo.DataSourceName;
    }

    public boolean isReadOnly(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return true;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return true;
    }

    void setEncodedLength(int colnum, int len) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColLength = len;
        if (cinfo.SQLtype == 10) {
            cinfo.DataSourceName = String.valueOf(cinfo.DataSourceName) + " " + IfxDateTime.getQualifierName((short)len);
        }
    }

    public void setNullable(int colnum, boolean Xnull) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Nullable = Xnull;
    }

    void setMaxWidth(int colnum, int Xwidth) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.MaxWidth = Xwidth;
    }

    void setColtitle(int colnum, String Xtitle) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Coltitle = Xtitle == null ? new String("") : new String(Xtitle);
    }

    public void setColumnName(int colnum, String Xname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColName = Xname == null ? new String("") : new String(Xname);
    }

    public void setDecimalDigits(int colnum, int Xdigits) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.DecimalDigits = Xdigits;
    }

    public void setRightDecimal(int colnum, int Xright) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.RightDecimal = Xright;
    }

    public void setTableName(int colnum, String Xtname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.TableName = Xtname == null ? new String("") : new String(Xtname);
    }

    boolean isVariableLengthType(int colnum) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        return cinfo.SQLtype > 18;
    }

    public void setIfxColumnType(int colnum, int Xtype) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        if (IfxResultSetMetaData.setTypeBooleanFields(cinfo, Xtype)) {
            this.hasVariableLengthColumns = true;
        }
        if (!this.hasVariableLengthColumns && this.isVariableLengthType(colnum)) {
            this.hasVariableLengthColumns = true;
        }
        this.setDataSourceName(colnum, IfxTypes.IfxTypeToName(cinfo.SQLtype));
    }

    public static boolean setTypeBooleanFields(IfxColumnInfo cinfo, int Xtype) {
        boolean hasVariableLengthColumns = false;
        if ((Xtype & 0x100) > 0) {
            cinfo.Nullable = false;
        }
        if ((Xtype & 0x800) > 0) {
            cinfo.IsDistinct = true;
            hasVariableLengthColumns = true;
        }
        if ((Xtype & 0x1000) > 0) {
            cinfo.IsNamedRow = true;
        }
        cinfo.SQLtype = Xtype & 0xFF;
        return hasVariableLengthColumns;
    }

    public void setDataSourceName(int colnum, String Xstype) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.DataSourceName = Xstype == null ? new String("") : new String(Xstype);
    }

    void setSourceType(int colnum, int sourceType) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.SourceType = sourceType;
    }

    void setColumnStartPosition(int colnum, int pos) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColStartPos = pos;
    }

    void setColumnExtendedId(int colnum, int id) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ExtendedId = id;
    }

    void setExtendedName(int colnum, String Xname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ExtendedName = Xname == null ? new String("") : new String(Xname);
    }

    void setExtendedOwnerName(int colnum, String s) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ExtendedOwner = s == null ? new String("") : new String(s);
    }

    void setReference(int colnum, short ref) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Reference = ref;
    }

    void setAlignment(int colnum, short alignment) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Alignment = alignment;
    }

    public void setColumnCount(int numcol) throws SQLException {
        this.numberofcol = numcol;
        if (numcol > 0) {
            this.cinfoVector.setSize(numcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        int i = 0;
        while (i < numcol) {
            this.cinfoVector.setElementAt(new IfxColumnInfo(), i);
            ++i;
        }
    }

    void setColInfo(int colnum, int maxWidth, String colName, String tableName, int sqlType, String dataSourceName, int sourceType, int colLength, int extendedId, String extendedOwner, String extendedName, int nullable, int delimident) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColLength = colLength;
        cinfo.MaxWidth = maxWidth;
        cinfo.Coltitle = colName == null ? new String("") : new String(colName);
        cinfo.ColName = cinfo.Coltitle;
        cinfo.TableName = tableName == null ? new String("") : new String(tableName);
        if (sqlType == 41 && extendedId == 10) {
            this.setIfxColumnType(colnum, 102);
        } else if (sqlType == 41 && extendedId == 11) {
            this.setIfxColumnType(colnum, 101);
        } else {
            this.setIfxColumnType(colnum, sqlType);
        }
        cinfo.DataSourceName = dataSourceName == null ? new String("") : new String(dataSourceName);
        cinfo.SourceType = sourceType;
        cinfo.ExtendedId = extendedId;
        cinfo.ExtendedName = extendedName == null ? new String("") : new String(extendedName);
        cinfo.ExtendedOwner = extendedOwner == null ? new String("") : new String(extendedOwner);
        cinfo.Nullable = nullable == 1;
        this.delimIdent = delimident == 1;
    }

    boolean isDistinct(int colnum) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        return cinfo.IsDistinct;
    }

    void setDistinct(int colnum, boolean isDistinct) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.IsDistinct = isDistinct;
    }

    public void setDelimIdent(boolean value) {
        this.delimIdent = value;
    }

    void copyColumnInfo(int colnum, IfxColumnInfo from) throws SQLException {
        IfxColumnInfo to = this.getColumnInfo(colnum, true);
        this.cinfoVector.setElementAt(from, colnum - 1);
    }

    public String getColumnClassName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        IfxMap typemap = this.conn.getTypeMap();
        if (cinfo.IsDistinct) {
            Class distinctClass = null;
            if (typemap != null && !typemap.isEmpty() && (distinctClass = (Class)typemap.get(cinfo.ExtendedName)) != null) {
                return distinctClass.getName();
            }
        }
        if (cinfo.SQLtype <= 18) {
            return IfxTypes.FromIfxTypeToJava(cinfo.SQLtype);
        }
        if (cinfo.ExtendedName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (cinfo.ExtendedName.equals("lvarchar")) {
            return "java.lang.String";
        }
        if (cinfo.ExtendedName.equals("clob")) {
            return "com.informix.jdbc.IfxCblob";
        }
        if (cinfo.ExtendedName.equals("blob")) {
            return "com.informix.jdbc.IfxBblob";
        }
        if (cinfo.SQLtype == 41 || cinfo.SQLtype == 40) {
            if (cinfo.SourceType == 5) {
                return "java.lang.Boolean";
            }
            if (cinfo.SourceType == 1) {
                return "java.lang.String";
            }
            if (cinfo.SourceType == 11) {
                return "com.informix.jdbc.IfxCblob";
            }
            if (cinfo.SourceType == 10) {
                return "com.informix.jdbc.IfxBblob";
            }
            Class udtClass = null;
            if (typemap != null && !typemap.isEmpty() && (udtClass = (Class)typemap.get(cinfo.ExtendedName)) != null) {
                return udtClass.getName();
            }
            return "java.sql.SQLData";
        }
        return "unknown classname";
    }

    void setTextByteColumnCount() throws SQLException {
        this.textByteColumnCount = 0;
        int i = 1;
        while (i <= this.getColumnCount()) {
            IfxColumnInfo cinfo = this.getColumnInfo(i, true);
            if (cinfo.SQLtype == 11 || cinfo.SQLtype == 12 || cinfo.SQLtype == 41 && (cinfo.ExtendedId == 10 || cinfo.ExtendedId == 11)) {
                this.textByteColumnCount = (short)(this.textByteColumnCount + 1);
            }
            ++i;
        }
    }

    boolean needSvrConv() throws SQLException {
        int i = 1;
        while (i <= this.numberofcol) {
            int colType = this.getIfxColumnType(i);
            if (colType == 41 || colType == 40 && this.getColumnExtendedId(i) != 1 || colType == 19 || colType == 21 || colType == 20 || colType == 22) {
                this.trace.writeTrace(2, "needSvrConv(): true");
                return true;
            }
            ++i;
        }
        this.trace.writeTrace(2, "needSvrConv(): false");
        return false;
    }

    boolean needSvrConv(int i) throws SQLException {
        int colType = this.getIfxColumnType(i);
        this.trace.writeTrace(2, "needSvrConv(i): colType: " + colType);
        this.trace.writeTrace(2, "needSvrConv(i): ExtendedId: " + this.getColumnExtendedId(i));
        if (colType == 41 || colType == 40 && this.getColumnExtendedId(i) != 1 || colType == 19 || colType == 21 || colType == 20 || colType == 22) {
            this.trace.writeTrace(2, "needSvrConv(i) for " + i + ": true");
            return true;
        }
        this.trace.writeTrace(2, "needSvrConv(i) for " + i + ": false");
        return false;
    }

    public static String parseTableName(String command) {
        String value = null;
        if (command == null) {
            return null;
        }
        try {
            String str = command.toUpperCase().trim();
            int scanptr = -1;
            boolean isSelect = true;
            if (str.startsWith("SELECT")) {
                scanptr = str.indexOf("FROM");
                isSelect = true;
            } else if (str.startsWith("UPDATE")) {
                scanptr = 0;
            } else if (str.startsWith("INSERT")) {
                scanptr = str.indexOf("INTO");
            }
            if (scanptr > -1) {
                String tmpstr = command.substring(scanptr);
                StringTokenizer st = new StringTokenizer(tmpstr);
                String next = st.nextToken();
                next = st.nextToken();
                value = isSelect && (next.equals(",") || next.endsWith(",")) ? null : next;
            }
        }
        catch (Exception exception) {}
        return value;
    }

    public void parseSetTableName(String command) throws SQLException {
        String tableName = IfxResultSetMetaData.parseTableName(command);
        if (tableName != null) {
            int i = 1;
            while (i <= this.numberofcol) {
                this.setTableName(i, tableName);
                ++i;
            }
        }
    }
}

