/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.ResultSet2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class IfxResultSet
implements IfmxResultSet,
ResultSet2 {
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    private IfxProtocol prot;
    protected Hashtable nameToIdxTable;
    protected IfxConnection conn;
    protected IfxStatement stmt;
    protected int curRowID;
    protected int LastRowID;
    protected IfxResultSetMetaData rsmd;
    protected Vector colVector;
    protected Trace trace;
    protected boolean lastColWasNull = false;

    IfxResultSet(IfxStatement thisStatement) throws SQLException {
        this.conn = (IfxConnection)thisStatement.getConnection();
        try {
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Class<?> connClassRef = Class.forName(this.conn.getConnClassName());
            Class[] classArgs = new Class[]{connClassRef};
            Constructor<?> cons = classRef.getConstructor(classArgs);
            Object[] objs = new Object[]{this.conn};
            this.prot = (IfxProtocol)cons.newInstance(objs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
        this.stmt = thisStatement;
        this.setTrace(this.conn.getTrace());
        this.trace.writeTrace(99, "IfxResultSet: constructor exited");
    }

    public IfxResultSet() throws SQLException {
    }

    void setTrace(Trace traceObj) {
        this.trace = traceObj;
    }

    void executePrepare() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executePrepare() called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executePrepare(this.stmt);
        this.trace.writeTrace(1, "IfxResultSet.executePrepare() exited");
    }

    public void executeQuery() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executeQuery() called");
        this.executeQuery(false);
        this.trace.writeTrace(1, "IfxResultSet.executeQuery() exited");
    }

    void executeQuery(boolean withHold) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(boolean) called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeStatementQuery(this.stmt, withHold);
        this.curRowID = 0;
        this.LastRowID = 0;
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(boolean) exited");
    }

    void executeQuery(IfxResultSetMetaData outputMetaData) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData) called");
        this.executeQuery(outputMetaData, false);
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData) exited");
    }

    void executeQuery(IfxResultSetMetaData outputMetaData, boolean withHold) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData,boolean) called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeStatementQuery(this.stmt, withHold, outputMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
        this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData,boolean) exited");
    }

    int executeUpdate() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.executeUpdate() called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.LastRowID = 0;
        this.trace.writeTrace(1, "IfxResultSet.executeUpdate() exited");
        return this.prot.getNumberOfRowsProcessed();
    }

    boolean executeExecute() throws SQLException {
        boolean haveResultSet = false;
        this.trace.writeTrace(1, "IfxResultSet.executeExecute() called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeExecute(this.stmt);
        if (!this.isEmptyResultSet()) {
            haveResultSet = true;
        }
        this.curRowID = 0;
        this.LastRowID = 0;
        this.trace.writeTrace(1, "IfxResultSet.executeExecute() exited");
        return haveResultSet;
    }

    boolean executeExecute(IfxResultSetMetaData outputMetaData) throws SQLException {
        boolean haveResultSet = false;
        this.trace.writeTrace(1, "IfxResultSet.executeExecute() called");
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executeExecute(this.stmt, outputMetaData);
        if (!this.isEmptyResultSet()) {
            haveResultSet = true;
        }
        this.curRowID = 0;
        this.LastRowID = 0;
        this.trace.writeTrace(1, "IfxResultSet.executeExecute() exited");
        return haveResultSet;
    }

    public boolean next() throws SQLException {
        int scrollable;
        int maxRows = this.stmt.getMaxRows();
        boolean isMore = false;
        this.trace.writeTrace(1, "IfxResultSet.next() called " + this.stmt.commandString);
        if (this.prot == null) {
            return false;
        }
        this.clearWarnings();
        if (maxRows != 0 && this.curRowID >= maxRows) {
            this.trace.writeTrace(3, "ResultSet.next(): exceed maxRows", maxRows);
            return false;
        }
        int n = scrollable = this.stmt.getResultSetType() == 1004 ? 1 : 0;
        if (scrollable == 1) {
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 6, scrollable);
            this.curRowID = this.prot.getTupid();
        } else {
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, scrollable);
        }
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.next(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        if (scrollable != 1) {
            ++this.curRowID;
        }
        this.trace.writeTrace(3, "ResultSet.next(): curRowID ", this.curRowID);
        this.trace.writeTrace(1, "IfxResultSet.next() exited");
        return true;
    }

    public int findColumn(String columnName) throws SQLException {
        Integer idx;
        this.trace.writeTrace(1, "IfxResultSet.findColumn() called");
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int numCols = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(numCols);
            int i = 1;
            while (i <= numCols) {
                this.nameToIdxTable.put(this.rsmd.getColumnName(i), new Integer(i));
                ++i;
            }
        }
        if ((idx = !this.conn.isDelimIdentSet() ? (Integer)this.nameToIdxTable.get(columnName.toLowerCase()) : (Integer)this.nameToIdxTable.get(columnName)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        this.trace.writeTrace(1, "IfxResultSet.findColumn() exited");
        return idx;
    }

    IfxObject getValue(int columnIndex) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.getValue(int) called");
        if (this.colVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (columnIndex < 1 || columnIndex > this.colVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject value = (IfxObject)this.colVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = this.prot.getColumnInRow(columnIndex);
            this.colVector.setElementAt(value, columnIndex - 1);
        } else {
            this.prot.loadColumnData(columnIndex, value);
        }
        if (value.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        this.lastColWasNull = false;
        this.trace.writeTrace(1, "IfxResultSet.getValue() exited");
        return value;
    }

    public String getString(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        String S = null;
        this.trace.writeTrace(1, "IfxResultSet.getString(int) called. ColumnIndex: ", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        this.blobCheck(value);
        S = value.toString();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getString() exited.");
        return S;
    }

    public String getString(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getString(idx);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.getObject(int) called. ColumnIndex: ", columnIndex);
        Object res = null;
        res = this.conn != null ? this.getObject(columnIndex, this.conn.getTypeMap()) : this.getObject(columnIndex, (IfxMap)null);
        return res;
    }

    public Object getObject(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getObject(idx);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getAsciiStream() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        this.blobCheck(value);
        InputStream is = value.toAsciiStream();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getAsciiStream() exited.");
        return is;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getAsciiStream(idx);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String tmpst = this.getString(columnIndex);
        if (tmpst != null) {
            return new StringReader(tmpst);
        }
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getCharacterStream(idx);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. ColumnIndex", columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. Scale", scale);
        if (value == null || value.isNull()) {
            return null;
        }
        BigDecimal B = value.toDecimal().setScale(scale, 4);
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() exited.");
        return B;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBigDecimal(idx, scale);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toDecimal();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBigDecimal(idx);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBoolean() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return false;
        }
        boolean b = value.toBoolean();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getBoolean() exited");
        return b;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBoolean(idx);
    }

    public short getShort(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getShort() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        short s = value.toShort();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(3, "short value", s);
        this.trace.writeTrace(1, "IfxResultSet.getShort() exited");
        return s;
    }

    public short getShort(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getShort(idx);
    }

    public int getInt(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getInt() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        int i = value.toInt();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getInt() exited");
        return i;
    }

    public int getInt(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getInt(idx);
    }

    public long getLong(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getLong() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0L;
        }
        long l = value.toLong();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getLong() exited");
        return l;
    }

    public long getLong(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getLong(idx);
    }

    public float getFloat(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getFloat() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0.0f;
        }
        float f = value.toFloat();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getFloat() exited");
        return f;
    }

    public float getFloat(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getFloat(idx);
    }

    public byte getByte(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getByte() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        byte b = value.toByte();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getByte() exited");
        return b;
    }

    public byte getByte(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getByte(idx);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBytes() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        this.blobCheck(value);
        byte[] b = value.toBytes();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getBytes() exited");
        return b;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBytes(idx);
    }

    public Date getDate(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getDate() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        Date D = value.toDate();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getDate() exited");
        return D;
    }

    public Date getDate(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDate(idx);
    }

    public double getDouble(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getDouble() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return 0.0;
        }
        double d = value.toDouble();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getDouble() exited");
        return d;
    }

    public double getDouble(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDouble(idx);
    }

    public Time getTime(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getTime() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        Time T = value.toTime();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getTime() exited");
        return T;
    }

    public Time getTime(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTime(idx);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getTimestamp() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        Timestamp T = value.toTimestamp();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getTimestmap() exited");
        return T;
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTimestamp(idx);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getBinaryStream() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        this.blobCheck(value);
        InputStream is = value.toBinaryStream();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getBinaryStream() exited");
        return is;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBinaryStream(idx);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.prot != null) {
            return this.prot.getWarnings();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (this.prot != null) {
            this.prot.clearWarnings();
        }
    }

    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw IfxErrMsg.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    public Object getObject(int colIdx, IfxMap map) throws SQLException {
        IfxObject value = this.getValue(colIdx);
        Object Obj = null;
        this.trace.writeTrace(1, "IfxResultSet.getObject(int, Map) entered.");
        if (value != null && !value.isNull()) {
            this.blobCheck(value);
            value.setTypeMap(map);
            Obj = value.toObject();
            DataTruncation dt = value.getWarning();
            if (dt != null) {
                this.prot.chainWarnings(new DataTruncation(colIdx, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
        }
        this.trace.writeTrace(1, "IfxResultSet.getObject() exited.");
        return Obj;
    }

    public Object getObject(String columnName, IfxMap map) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.getObject(String, Map) called.");
        int idx = this.findColumn(columnName);
        return this.getObject(idx, map);
    }

    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    boolean isEmptyResultSet() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return !this.prot.isResultSet() || this.prot.getTupleCount() <= 0;
    }

    public void close() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.close() called");
        if (this.prot != null && this.prot.isCursorOpen()) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
        } else {
            this.clear();
        }
        this.trace.writeTrace(1, "IfxResultSet.close() exited");
    }

    void clear() {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.LastRowID = 0;
        this.clearColumnVector();
    }

    void closePrev() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.closePrev() called");
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int i = 0;
            while (i < this.colVector.size()) {
                IfxObject obj = (IfxObject)this.colVector.elementAt(i);
                if (obj != null) {
                    obj.clear();
                }
                ++i;
            }
        }
    }

    void closeNow() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.closeNow() called");
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        this.prot = null;
        this.stmt = null;
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
        this.trace.writeTrace(99, "IfxResultSet.closeNow() exited");
    }

    private void blobCheck(IfxObject obj) throws SQLException {
        if (obj instanceof IfxBlob) {
            IfxBlob BlobObject = (IfxBlob)obj;
            if (!BlobObject.isBlobLoaded()) {
                this.trace.writeTrace(99, "IfxResultSet.IfxBlob() : - 1");
                try {
                    this.prot.executeFetchBlob(BlobObject);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79701, this.conn);
                }
                BlobObject.setLoaded();
            } else {
                this.trace.writeTrace(99, "IfxResultSet.IfxBlob() : - 2");
            }
        }
    }

    int getSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerialInsert();
    }

    long getSerial8() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerial8Inserted();
    }

    public Interval getInterval(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getInterval() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        Interval I = value.toInterval();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getInterval() exited");
        return I;
    }

    public Interval getInterval(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getInterval(idx);
    }

    public IntervalYM getIntervalYM(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getIntervalYM() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        IntervalYM I = value.toIntervalYM();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getIntervalYM() exited");
        return I;
    }

    public IntervalYM getIntervalYM(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getIntervalYM(idx);
    }

    public IntervalDF getIntervalDF(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        this.trace.writeTrace(1, "IfxResultSet.getIntervalDF() called. ColumnIndex", columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        IntervalDF I = value.toIntervalDF();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        this.trace.writeTrace(1, "IfxResultSet.getIntervalDF() exited");
        return I;
    }

    public IntervalDF getIntervalDF(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getIntervalDF(idx);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.isBeforeFirst() called");
        this.clearWarnings();
        return this.curRowID == 0;
    }

    public boolean isAfterLast() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.isAfterLast() called");
        this.clearWarnings();
        if (this.LastRowID == 0) {
            int svcurRowID = this.curRowID;
            boolean b = this.last();
            this.LastRowID = this.curRowID;
            if (svcurRowID == 0) {
                this.curRowID = 0;
            } else {
                b = this.absolute(svcurRowID);
            }
        } else if (this.curRowID == this.LastRowID + 1) {
            return true;
        }
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.isFirst() called");
        this.clearWarnings();
        return this.curRowID == 1;
    }

    public boolean isLast() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.isLast() called");
        this.clearWarnings();
        return this.curRowID > 0 && this.curRowID == this.LastRowID;
    }

    public void beforeFirst() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.beforeFirst() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
    }

    public void afterLast() throws SQLException {
        this.trace.writeTrace(99, "IfxResultSet.afterLast() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID != 0) {
            this.curRowID = this.LastRowID + 1;
        } else {
            boolean b = this.last();
            if (b) {
                this.curRowID = this.LastRowID + 1;
            }
        }
    }

    public boolean first() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.first() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, 1);
        this.curRowID = this.prot.getTupid();
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.first(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        this.trace.writeTrace(1, "IfxResultSet.first() exited");
        return true;
    }

    public boolean last() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.last() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1);
        this.LastRowID = this.curRowID = this.prot.getTupid();
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.last(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        this.trace.writeTrace(1, "IfxResultSet.last() exited");
        return true;
    }

    public int getRow() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.getRow() called");
        return this.curRowID;
    }

    public boolean absolute(int row) throws SQLException {
        boolean isMore = false;
        this.trace.writeTrace(1, "IfxResultSet.absolute() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (row == 0) {
            throw IfxErrMsg.getSQLException(-79768, this.conn);
        }
        if (row > 0) {
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), row, 6, 1);
        } else if (row < 0) {
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1);
            this.curRowID = this.prot.getTupid();
            if (row != -1) {
                isMore = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + row + 1, 6, 1);
            }
        }
        this.curRowID = this.prot.getTupid();
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.next(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        this.trace.writeTrace(1, "IfxResultSet.absolute() exited");
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.relative() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.curRowID == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (rows == 0) {
            return true;
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + rows, 6, 1);
        this.curRowID = this.prot.getTupid();
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.relative(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        this.trace.writeTrace(1, "IfxResultSet.relative() exited");
        return true;
    }

    public boolean current() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.current() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        return this.curRowID != 0;
    }

    public boolean previous() throws SQLException {
        this.trace.writeTrace(1, "IfxResultSet.previous() called");
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID > 0 && this.curRowID > this.LastRowID) {
            return this.last();
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 2, 1);
        this.curRowID = this.prot.getTupid();
        if (!isMore) {
            this.trace.writeTrace(3, "ResultSet.previous(): tuple is null");
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
        }
        this.trace.writeTrace(1, "IfxResultSet.absolute() exited");
        return true;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getType() throws SQLException {
        this.trace.writeTrace(2, "IfxResultSet:getType()");
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        this.trace.writeTrace(2, "IfxResultSet:getConcurrency()");
        return this.stmt.getResultSetConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowUpdated().", this.conn);
    }

    public boolean rowInserted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowInserted().", this.conn);
    }

    public boolean rowDeleted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowDeleted().", this.conn);
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateNull(int).", this.conn);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBoolean(int,boolean).", this.conn);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateByte(int,byte).", this.conn);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateShort(int,short).", this.conn);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateInt(int,int).", this.conn);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateLong(int,long).", this.conn);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateFloat(int,float).", this.conn);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDouble(int,double).", this.conn);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBigDecimal(int,BigDecimal).", this.conn);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateString(int,String).", this.conn);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBytes(int,byte[]).", this.conn);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDate(int,Date).", this.conn);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTime(int,Time).", this.conn);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTimestamp(int,Timestamp).", this.conn);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateAsciiStream(int,InputStream,int).", this.conn);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBinaryStream(int,InputStream,int).", this.conn);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateCharacterStream(int,Reader,int).", this.conn);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(int,Object,int).", this.conn);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(int,Object).", this.conn);
    }

    public void updateNull(String columnName) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateNull(String).", this.conn);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBoolean(String,boolean).", this.conn);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateByte(String,byte).", this.conn);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateShort(String,short).", this.conn);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateInt(String,int).", this.conn);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateLong(String,long).", this.conn);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateFloat(String,float).", this.conn);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDouble(String,double).", this.conn);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBigDecimal(String,BigDecimal).", this.conn);
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateString(String,String).", this.conn);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBytes(String,byte[]).", this.conn);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateDate(String,java.sql.Date).", this.conn);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTime(String,Time).", this.conn);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateTimestamp(String,Timestamp).", this.conn);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateAsciiStream(String,InputStream,int).", this.conn);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateBinaryStream(String,InputStream,int).", this.conn);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateCharacterStream(String,Reader,int).", this.conn);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(String,Object,int).", this.conn);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateObject(String,Object).", this.conn);
    }

    public void insertRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.insertRow().", this.conn);
    }

    public void updateRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.updateRow().", this.conn);
    }

    public void deleteRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.deleteRow().", this.conn);
    }

    public void refreshRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.refreshRow().", this.conn);
    }

    public void cancelRowUpdates() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.cancelRowUpdates().", this.conn);
    }

    public void moveToInsertRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.moveToInsertRow().", this.conn);
    }

    public void moveToCurrentRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.moveToCurrentRow().", this.conn);
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date tmpdate = this.getDate(columnIndex);
        if (tmpdate == null) {
            return null;
        }
        long tm = tmpdate.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return new Date(tm);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDate(idx, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time tmptime = this.getTime(columnIndex);
        if (tmptime == null) {
            return null;
        }
        long tm = tmptime.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return new Time(tm);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTime(idx, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp tmptime = this.getTimestamp(columnIndex);
        if (tmptime == null) {
            return null;
        }
        long tm = ((java.util.Date)tmptime).getTime() + (long)cal.get(15) + (long)cal.get(16);
        Timestamp localt = new Timestamp(tm);
        localt.setNanos(tmptime.getNanos());
        return localt;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTimestamp(idx, cal);
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize();
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }
}

