/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.PreparedStatement2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxByteArrayOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class IfxPreparedStatement
extends IfxStatement
implements IfmxPreparedStatement,
PreparedStatement2 {
    String baseStatement;
    private Vector vector = new Vector();
    private InputStream blob_inputstr;
    private int blob_length;
    Trace trace;
    IfxResultSetMetaData rsmd;
    private int inputcount;
    private boolean canUsePut = false;
    private boolean usePut = false;
    private IfxByteArrayOutputStream bStream;
    short batchCount;
    static final int ONE = 1;
    private int[] putIndexArray;
    private int curRow;
    private Vector textObjArray = new Vector();
    private int textObjArrayIdx;
    IfxResultSetMetaData putRsmd;
    static final int INIT_IDX_SIZE = 1000;
    static final int INC_IDX_SIZE = 1000;
    int inputvals;

    IfxPreparedStatement(IfxConnection myconn) {
        super(myconn);
        if (myconn != null) {
            this.trace = myconn.getTrace();
            if (this.trace == null) {
                System.out.println("IfxPreparedStatement: Trace is NULL");
            }
        }
    }

    void setSqlString(String sql) throws SQLException {
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        this.baseStatement = sql;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        String string = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    IfxPreparedStatement(IfxConnection myconn, String sql) throws SQLException {
        super(myconn);
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, myconn);
        }
        this.baseStatement = sql;
        if (myconn != null) {
            this.trace = myconn.getTrace();
            if (this.trace == null) {
                System.out.println("IfxPreparedStatement: Trace is NULL");
            }
        }
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(sql) : sql;
        this.setupExecutePrepare();
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    void setupExecutePrepare() throws SQLException {
        this.trace.writeTrace(2, "IfxPreparedStatement:setupPrepare()");
        this.savedResult = new IfxResultSet(this);
        this.savedResult.executePrepare();
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        this.rsmd = (IfxResultSetMetaData)this.savedResult.getMetaData();
        this.trace.writeTrace(2, "Stetement Type: " + this.getStatementType());
        this.trace.writeTrace(2, "numqmarks: " + this.numqmarks);
        this.trace.writeTrace(2, "columnCount: " + this.rsmd.getColumnCount());
        this.trace.writeTrace(2, "((IfxSqliConnect)jconn).getUsePut(): " + ((IfxSqliConnect)this.jconn).getUsePut());
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).getUsePut() && this.getStatementType() == 6 && this.numqmarks == this.rsmd.getColumnCount()) {
            this.canUsePut = true;
            this.trace.writeTrace(2, "IfxPreparedStatement: canUsePut is set to true");
            this.putRsmd = new IfxResultSetMetaData(this.rsmd);
        }
        this.trace.writeTrace(2, "canUsePut value: " + this.canUsePut + ", numqmarks: " + this.numqmarks + ", rsmd.getColumnCount(): " + this.rsmd.getColumnCount());
    }

    Vector getVector() {
        return this.vector;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeQueryImpl(false);
    }

    public ResultSet executeQuery(boolean withHold) throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeQueryImpl(withHold);
    }

    public int executeUpdate() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeUpdateImpl();
    }

    public boolean execute() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeImpl();
    }

    public void setNull(int i, int sqlType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setNull: obj reused");
                val.clear();
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, this.getColumnInfo(i), sqlType);
                this.set(i, val);
                this.trace.writeTrace(2, "setNull for " + i + " type: " + val.getClass().getName());
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setNull(int i, int sqlType, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setNull: obj reused");
                val.clear();
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setNull(int i, int sqlType, String name) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setNull: obj reused");
                val.clear();
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, this.getColumnInfo(i), sqlType, name);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setBigDecimal: obj reused");
                val.clear();
                val.fromDecimal(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setBigDecimal(int i, BigDecimal x, int ifxType) throws SQLException {
        this.setBigDecimal(i, x);
    }

    public void setBoolean(int i, boolean x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setBoolean: obj reused");
                val.clear();
                val.fromBoolean(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBoolean() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBoolean() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setBoolean(int i, boolean x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setBoolean: obj reused");
                val.clear();
                val.fromBoolean(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBoolean(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBoolean() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setByte(int i, byte x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setByte: obj reused");
                val.clear();
                val.fromByte(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setByte() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setByte() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setByte(int i, byte x, int ifxType) throws SQLException {
        this.setByte(i, x);
    }

    public void setShort(int i, short x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setShort: obj reused");
                val.clear();
                val.fromShort(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setShort() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setShort() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setShort(int i, short x, int ifxType) throws SQLException {
        this.setShort(i, x);
    }

    public void setInt(int i, int x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setInt: obj reused");
                val.clear();
                val.fromInt(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setInt() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setInt() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setInt(int i, int x, int ifxType) throws SQLException {
        this.setInt(i, x);
    }

    public void setLong(int i, long x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setLong: obj reused");
                val.clear();
                val.fromLong(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setLong() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setLong() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setLong(int i, long x, int ifxType) throws SQLException {
        this.setLong(i, x);
    }

    public void setFloat(int i, float x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setFloat: obj reused");
                val.clear();
                val.fromFloat(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setFloat() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setFloat() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setFloat(int i, float x, int ifxType) throws SQLException {
        this.setFloat(i, x);
    }

    public void setDouble(int i, double x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setDouble: obj reused");
                val.clear();
                val.fromDouble(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setDouble() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setDouble() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setDouble(int i, double x, int ifxType) throws SQLException {
        this.setDouble(i, x);
    }

    public void setString(int i, String x) throws SQLException {
        try {
            this.trace.writeTrace(1, "IfxPreparedStatement.setString() entered");
            this.trace.writeTrace(2, "usePut is: " + this.usePut);
            this.trace.writeTrace(2, "i: " + i + "numqmarks: " + this.numqmarks);
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setString: obj reused");
                val.clear();
                val.fromString(x);
                ++this.inputvals;
            } else {
                val = this.usePut ? IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i)) : IfxValue.makeInstance(this.jconn, x, null);
                this.set(i, val);
                this.trace.writeTrace(2, "IfxPreparedStatement:setString()-- " + val.getClass().getName());
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setString() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setString() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement.setString() exited");
    }

    public void setString(int i, String x, int ifxType) throws SQLException {
        this.setString(i, x);
    }

    public void setBytes(int i, byte[] x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setBytes: obj reused");
                val.clear();
                val.fromBytes(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBytes() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBytes() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setBytes(int i, byte[] x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setBytes: obj reused");
                val.clear();
                val.fromBytes(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBytes(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setNull() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setDate(int i, Date x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setDate: obj reused");
                val.clear();
                val.fromDate(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setDate() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setDate() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setDate(int i, Date x, int ifxType) throws SQLException {
        this.setDate(i, x);
    }

    public void setTime(int i, Time x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setTime: obj reused");
                val.clear();
                val.fromTime(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setTime() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setTime() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setTime(int i, Time x, int ifxType) throws SQLException {
        this.setTime(i, x);
    }

    public void setTimestamp(int i, Timestamp x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setTimestamp: obj reused");
                val.clear();
                val.fromTimestamp(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setTimestamp()exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setTimestamp()exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setTimestamp(int i, Timestamp x, int ifxType) throws SQLException {
        this.setTimestamp(i, x);
    }

    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setAsciiStream: obj reused");
                val.clear();
                val.fromAsciiStream(x, length);
                ++this.inputvals;
            } else {
                this.trace.writeTrace(99, "IfxPreparedStatement:setAsciiStream(): length = ", length);
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setAsciiStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setAsciiStream: obj reused");
                val.clear();
                val.fromAsciiStream(x, length);
                ++this.inputvals;
            } else {
                this.trace.writeTrace(99, "IfxPreparedStatement:setAsciiStream(): length = ", length);
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromAsciiStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setUnicodeStream(int,InputStream,int).", this.jconn);
    }

    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setBinaryStream: obj reused");
                val.clear();
                this.trace.writeTrace(2, "setBinaryStream: obj cleared");
                val.fromBinaryStream(x, length);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBinaryStream() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setBinaryStream() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setBinaryStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setBinaryStream: obj reused");
                val.clear();
                val.fromBinaryStream(x, length);
                ++this.inputvals;
            } else {
                this.trace.writeTrace(99, "IfxPreparedStatement:setBinaryStream(): length = ", length);
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBinaryStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setAsciiStream() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setInterval(int i, Interval x) throws SQLException {
        if (x instanceof IntervalYM) {
            this.setIntervalYM(i, (IntervalYM)x);
        } else if (x instanceof IntervalDF) {
            this.setIntervalDF(i, (IntervalDF)x);
        }
    }

    public void setIntervalYM(int i, IntervalYM x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setIntervalYM: obj reused");
                val.clear();
                val.fromIntervalYM(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setIntervalYM() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setIntervalYM() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setIntervalDF(int i, IntervalDF x) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                this.trace.writeTrace(2, "setIntervalDF: obj reused");
                val.clear();
                val.fromIntervalDF(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setIfxIntervalDF() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setIntervalDF() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.vector = new Vector();
            this.vector.setSize(this.numqmarks);
            this.inputvals = 0;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
    }

    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement.setObject(int, Object, targetSQLType, scale entered");
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setObject: obj reused");
                val.clear();
                val.fromObject(x);
                ++this.inputvals;
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i), scale, targetSqlType);
                val.setTrace(this.trace);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception: ");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement.setObject(int, Object, targetSQLType, scale exited");
    }

    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement.setObject(int, Object, targetSQLType");
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setObject: obj reused");
                val.clear();
                val.fromObject(x);
                ++this.inputvals;
            } else {
                this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, int) called");
                this.trace.writeTrace(3, "    setObject(): col # = ", i);
                this.trace.writeTrace(3, "    setObject(): type = ", targetSqlType);
                if (x == null) {
                    this.trace.writeTrace(3, "    object is null");
                } else {
                    this.trace.writeTrace(3, "    object type is" + x.getClass().getName());
                }
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i), targetSqlType);
                val.setTrace(this.trace);
                this.trace.writeTrace(3, "    setObject() after makeInstance");
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.trace.writeTrace(3, "    setObject() before set");
                this.set(i, val);
                this.trace.writeTrace(3, "    setObject() after set");
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, targetSQLType) leaving");
    }

    public void setObject(int i, Object x) throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object) entered");
        if (x != null) {
            this.trace.writeTrace(3, "    setObject() Class name = ", x.getClass().getName());
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "setObject: obj reused");
                val.clear();
                val.fromObject(x);
                ++this.inputvals;
            } else {
                this.trace.writeTrace(3, "    setObject() before makeInstance");
                if (x != null) {
                    this.trace.writeTrace(3, "    object type is" + x.getClass().getName());
                }
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.trace.writeTrace(3, "    setObject() after makeInstance");
                val.setTrace(this.trace);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.trace.writeTrace(3, "    setObject() before set");
                this.set(i, val);
                this.trace.writeTrace(3, " after fromObject, val = " + val.toString());
                this.trace.writeTrace(3, "    setObject() after set");
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object) leaving");
    }

    public void IfxSetObject(int i, Object x, int scale, int ifxType) throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, scale, ifxType) entered");
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "IfxSetObject: obj reused");
                val.clear();
                val.fromObject(x, scale);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x, scale);
                val.setTrace(this.trace);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, scale, ifxType) exited");
    }

    public void IfxSetObject(int i, Object x, int ifxType) throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, ifxType) entered");
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = (IfxObject)this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                this.trace.writeTrace(2, "IfxSetObject: obj reused");
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x);
                val.setTrace(this.trace);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw e;
        }
        catch (Exception e) {
            this.trace.writeTrace(2, "IfxPreparedStatement:setObject() exception");
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.jconn);
        }
        this.trace.writeTrace(1, "IfxPreparedStatement:setObject(int, Object, ifxType) entered");
    }

    void set(int i, IfxObject v) throws SQLException {
        boolean hadvalue = false;
        int vectorsize = this.vector.size();
        int qmarkNum = 0;
        qmarkNum = this.getqmarks();
        if (i > qmarkNum) {
            this.trace.writeTrace(3, "IfxPreparedStatement: set() number of input values does not match qmarks");
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
        int index = i + this.BatchVector.size() * qmarkNum;
        if (index > vectorsize) {
            this.vector.setSize(vectorsize += qmarkNum);
        } else {
            Object obj = this.vector.elementAt(index - 1);
            if (!(obj == null || this.usePut && obj instanceof IfxBlob)) {
                obj = null;
                hadvalue = true;
            }
        }
        this.vector.setElementAt(v, index - 1);
        if (!hadvalue) {
            ++this.inputvals;
        }
        this.trace.writeTrace(3, "set, inputvals: " + this.inputvals);
        this.trace.writeTrace(3, "canUsePut: " + this.canUsePut);
        if (this.canUsePut && this.rsmd.needSvrConv(i)) {
            this.setIfxColumnInfo(i, v);
        }
    }

    private void checkParameterIndex(int i, int qmarks) throws SQLException {
        if (i > qmarks) {
            this.trace.writeTrace(3, "IfxPreparedStatement: set() index of input values exceeds qmarks");
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
    }

    private int cntqmarks(String s) {
        return this.cntqmarks(s, null);
    }

    private int cntqmarks(String s, String separator) {
        int sepIdx;
        int scanptr = 0;
        if (separator != null && (sepIdx = s.indexOf(separator)) != -1) {
            s = s.substring(sepIdx);
        }
        if ((scanptr = s.indexOf("?")) != -1) {
            int endptr = s.length();
            int qcnt = 1;
            ++scanptr;
            while (scanptr < endptr) {
                int i = 0;
                i = s.indexOf(63, scanptr);
                if (i < 0) break;
                ++qcnt;
                scanptr = i + 1;
            }
            return qcnt;
        }
        this.trace.writeTrace(2, "IfxPreparedStatement:cntqmarks(): is 0 ");
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.addBatch(String).", this.jconn);
    }

    public void addBatch() throws SQLException {
        this.trace.writeTrace(1, "IfxPreparedStatement:addBatch()");
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        if (!this.canUsePut) {
            if (this.savedResult != null) {
                this.savedResult.closePrev();
                this.savedResult = null;
            }
            this.commandString = this.commandString.trim();
            if (!this.commandString.endsWith(";")) {
                this.commandString = String.valueOf(this.commandString) + ";";
            }
            this.trace.writeTrace(2, "IfxPreparedStatement:commandString is " + this.commandString);
            this.BatchVector.addElement(this.commandString);
            this.inputcount = this.vector.size();
        } else {
            IfxObject ival;
            int i;
            if (!this.usePut) {
                this.trace.writeTrace(2, "initialize structures for usePut");
                this.usePut = true;
                this.bStream = new IfxByteArrayOutputStream(this.savedResult.getTupleBufferSize());
                this.batchCount = 0;
                if (this.rsmd.hasVariableLengthColumns || this.rsmd.textByteColumnCount > 0) {
                    this.putIndexArray = new int[1000];
                    this.putIndexArray[0] = 0;
                }
                if (this.rsmd.textByteColumnCount > 0) {
                    this.textObjArray.setSize(100);
                    this.textObjArrayIdx = 0;
                }
                i = 0;
                while (i < this.inputvals) {
                    int ifxTargetType;
                    ival = (IfxObject)this.vector.elementAt(i);
                    int ifxSourceType = ival.getIfxType();
                    if (ifxSourceType == 0 && ifxSourceType != (ifxTargetType = this.rsmd.getIfxColumnType(i + 1))) {
                        IfxObject newVal = IfxValue.makeInstance(this.jconn, ival.toString(), this.rsmd.getColumnInfo(i + 1));
                        if (this.rsmd.isDistinct(i + 1) && newVal.extendedID == 1) {
                            this.putRsmd.setExtendedOwnerName(i + 1, "informix");
                        }
                        this.set(i + 1, newVal);
                        this.vector.setElementAt(newVal, i);
                        ival = null;
                    }
                    ++i;
                }
            }
            if (this.inputvals != this.numqmarks) {
                this.trace.writeTrace(1, "IfxPrepStmt: number of input values(" + this.inputvals + ") does not match qmarks(" + this.numqmarks + ")");
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            i = 0;
            while (i < this.inputvals) {
                ival = (IfxObject)this.vector.elementAt(i);
                int type = this.putRsmd.getIfxColumnType(i + 1);
                this.trace.writeTrace(2, "Instance is: " + ival.getClass().getName());
                this.trace.writeTrace(2, "Column type is: " + type);
                switch (type) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        String s = ival.toString();
                        if (s == null) break;
                        ival.fromString(stringUtil.fixLength(s, this.putRsmd.getColumnLength(i + 1), ' '));
                        this.trace.writeTrace(1, "putRsmd.getColumnLength(i+1): " + this.putRsmd.getColumnLength(i + 1));
                        this.trace.writeTrace(1, "ival: " + ival.toString());
                        break;
                    }
                    case 11: 
                    case 12: {
                        if (this.textObjArray.size() <= this.textObjArrayIdx) {
                            this.textObjArray.setSize(this.textObjArrayIdx + 100);
                        }
                        if (((IfxBlob)ival).isBlobLoaded() || ival.isNull()) {
                            this.textObjArray.setElementAt(null, this.textObjArrayIdx++);
                            break;
                        }
                        this.textObjArray.setElementAt(ival, this.textObjArrayIdx++);
                        this.trace.writeTrace(2, "textObjArrayIdx: " + this.textObjArrayIdx);
                        break;
                    }
                }
                short len = (short)this.putRsmd.getEncodedLength(i + 1);
                ival.setEncodedLength(len);
                this.trace.writeTrace(1, "len: " + len);
                byte[] bData = ival.toIfxTuple();
                this.bStream.write(bData, 0, bData.length);
                this.trace.writeTrace(2, String.valueOf(bData.length) + " bytes written to put buffer");
                ++i;
            }
            if (this.putRsmd.hasVariableLengthColumns || this.putRsmd.textByteColumnCount > 0) {
                if (this.putIndexArray.length < this.batchCount) {
                    int[] temp = new int[this.putIndexArray.length + 1000];
                    System.arraycopy(this.putIndexArray, 0, temp, 0, this.putIndexArray.length);
                    this.putIndexArray = temp;
                }
                this.batchCount = (short)(this.batchCount + 1);
                this.putIndexArray[this.batchCount] = this.bStream.getCount();
            } else {
                if ((this.savedResult.getTupleSize() & 1) >= 1) {
                    this.bStream.write(0);
                    this.trace.writeTrace(2, "row padded");
                }
                this.batchCount = (short)(this.batchCount + 1);
            }
            this.inputvals = 0;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.trace.writeTrace(2, "IfxPreparedStatement:executeBatch()");
        this.trace.writeTrace(2, "usePut value: " + this.usePut + ", numqmarks: " + this.numqmarks + ", rsmd.getColumnCount(): " + this.rsmd.getColumnCount());
        if (!this.usePut) {
            this.commandString = "";
            this.BatchRowCount[0] = 0;
            if (this.BatchVector.size() == 0) {
                throw IfxErrMsg.getSQLException(-79726, this.jconn);
            }
            int i = 0;
            while (i < this.BatchVector.size()) {
                this.commandString = String.valueOf(this.commandString) + this.BatchVector.elementAt(i);
                ++i;
            }
            this.trace.writeTrace(2, "IfxStatement:commandString is " + this.commandString);
            this.setqmarks(this.cntqmarks(this.commandString));
            this.setupExecutePrepare();
        } else {
            this.curRow = 0;
        }
        this.BatchRowCount[0] = this.executeUpdateImpl();
        this.clearBatch();
        return this.BatchRowCount;
    }

    public void clearBatch() throws SQLException {
        this.trace.writeTrace(1, "IfxStatement:clearBatch()");
        if (this.usePut) {
            this.bStream.resetCount();
            this.batchCount = 0;
            this.curRow = 0;
            this.textObjArrayIdx = 0;
        } else {
            this.BatchVector.removeAllElements();
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setCharacterStream(int,Reader,int).", this.jconn);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal, int ifxType) throws SQLException {
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt, ifxType);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        long tm = x.getTime();
        Date gwt = new Date(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setDate(parameterIndex, gwt);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal, int ifxType) throws SQLException {
        long tm = x.getTime();
        Date gwt = new Date(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setDate(parameterIndex, gwt, ifxType);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        long tm = ((java.util.Date)x).getTime();
        Timestamp gwt = new Timestamp(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTimestamp(parameterIndex, gwt);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal, int ifxType) throws SQLException {
        long tm = ((java.util.Date)x).getTime();
        Timestamp gwt = new Timestamp(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTimestamp(parameterIndex, gwt, ifxType);
    }

    private IfxColumnInfo getColumnInfo(int colindex) throws SQLException {
        if (this.rsmd == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.getStatementType() != 6 && this.getStatementType() != 4) {
            this.trace.writeTrace(2, "IfxPreparedStatement.getColumnInfo: null returned");
            return null;
        }
        this.trace.writeTrace(2, "getColumnInfo, colindex is: " + colindex);
        this.trace.writeTrace(2, "command is: " + this.commandString);
        if (this.rsmd.getColumnCount() == 0) {
            return null;
        }
        if (colindex > this.rsmd.getColumnCount()) {
            return null;
        }
        try {
            if (this.canUsePut) {
                this.trace.writeTrace(2, "putRsmd used");
                IfxColumnInfo colinfo = this.putRsmd.getColumnInfo(colindex);
                if (colinfo == null) {
                    this.trace.writeTrace(2, " colinfo is null");
                } else {
                    this.trace.writeTrace(2, " colinfo is not null");
                }
                return this.putRsmd.getColumnInfo(colindex);
            }
            this.trace.writeTrace(2, "rsmd used");
            IfxColumnInfo colinfo = this.rsmd.getColumnInfo(colindex);
            if (colinfo == null) {
                this.trace.writeTrace(2, " colinfo is null");
            } else {
                this.trace.writeTrace(2, " colinfo is not null");
            }
            return this.rsmd.getColumnInfo(colindex);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    boolean usePut() {
        return this.usePut;
    }

    byte[] getAllRows() {
        return this.bStream.toByteArray();
    }

    byte[] getNextRow() {
        this.trace.writeTrace(2, "getNextRow() called: " + this.curRow);
        int begin = this.putIndexArray[this.curRow];
        int end = this.putIndexArray[this.curRow + 1];
        this.trace.writeTrace(2, "begin: " + begin + " end: " + end);
        ++this.curRow;
        return this.bStream.toByteArray(begin, end - begin);
    }

    IfxBlob getIfxBlobAt(int i) {
        return (IfxBlob)this.textObjArray.elementAt(i);
    }

    short getBatchCount() {
        return this.batchCount;
    }

    int getIfxBlobArraySize() {
        return this.textObjArray.size();
    }

    void setIfxColumnInfo(int column, IfxObject obj) throws SQLException {
        this.putRsmd.setIfxColumnType(column, obj.ifxType);
        this.putRsmd.setExtendedName(column, obj.extendedName);
        this.putRsmd.setColumnExtendedId(column, obj.extendedID);
        this.putRsmd.setEncodedLength(column, obj.encodedLength);
    }

    ResultSetMetaData getPutMetaData() throws SQLException {
        return this.putRsmd;
    }
}

