/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDecimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public abstract class IfxObject {
    protected IfxConnection conn;
    protected boolean isNull = true;
    protected Trace trace;
    protected int ifxType;
    protected String extendedName = "";
    protected String extendedOwner = "";
    protected int extendedID;
    protected int encodedLength;
    protected int sourceType;
    boolean isDistinct = false;
    boolean isNamedRow = false;
    DataTruncation warning;
    protected IfxMap typeMap;
    private static final int MAX_TYPES = 13;
    private static final int NO_SCALE = -1;
    static Hashtable objMap = null;

    IfxObject() throws SQLException {
    }

    IfxObject(Object obj) throws SQLException {
        this.fromObject(obj);
    }

    private Method findMethod(Object obj, int scale) throws SQLException {
        if (obj == null) {
            throw IfxErrMsg.getSQLException(-79755, this.conn);
        }
        Method method = null;
        try {
            Class[] classArgs;
            String className = obj.getClass().getName();
            String methodName = "from" + objMap.get(className);
            this.writeTrace(3, "IfxObject.fromObject(): className = " + className);
            this.writeTrace(3, "IfxObject.fromObject(): methodName = " + methodName);
            this.writeTrace(3, "IfxObject.fromObject(): thisObject = " + this.getClass().getName());
            Class<?> clsRef = Class.forName(this.getClass().getName());
            if (scale != -1) {
                Class[] args = new Class[]{obj.getClass(), Integer.TYPE};
                classArgs = args;
            } else {
                Class[] args;
                classArgs = args = new Class[]{obj.getClass()};
            }
            method = clsRef.getMethod(methodName, classArgs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return method;
    }

    public void fromObject(Object obj) throws SQLException {
        if (obj != null) {
            try {
                Method method = this.findMethod(obj, -1);
                Object[] objArgs = new Object[]{obj};
                method.invoke((Object)this, objArgs);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.nullify();
        }
    }

    public void fromObject(Object obj, int scale) throws SQLException {
        if (obj != null) {
            try {
                if (this instanceof IfxDecimal) {
                    Method method = this.findMethod(obj, scale);
                    Object[] objArgs = new Object[]{obj, new Integer(scale)};
                    method.invoke((Object)this, objArgs);
                }
                this.fromObject(obj);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.nullify();
        }
    }

    public void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        this.setTrace(conn.getTrace());
    }

    void setTypeMap(IfxMap map) {
        this.typeMap = map;
    }

    public final boolean isNull() {
        return this.isNull;
    }

    public final void nullify() {
        this.isNull = true;
    }

    public final void unnullify() {
        this.isNull = false;
    }

    void setIfxType(int ifxType) throws SQLException {
        this.ifxType = ifxType;
    }

    int getIfxType() {
        return this.ifxType;
    }

    void setExtendedTypeName(String name) {
        this.extendedName = name;
    }

    String getExtendedTypeName() {
        return this.extendedName;
    }

    void setExtendedOwner(String owner) {
        this.extendedOwner = owner;
    }

    String getExtendedOwner() {
        return this.extendedOwner;
    }

    void setExtendedId(int xid) {
        this.extendedID = xid;
    }

    int getExtendedId() {
        return this.extendedID;
    }

    void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    int getSourceType() {
        return this.sourceType;
    }

    public void clear() {
        this.nullify();
    }

    public short getEncodedLength() {
        return (short)this.encodedLength;
    }

    void setEncodedLength(int encodedLength) {
        this.encodedLength = encodedLength;
    }

    public DataTruncation getWarning() {
        return this.warning;
    }

    public void clearWarning() {
        this.warning = null;
    }

    void setTrace(Trace trace) {
        this.trace = trace;
    }

    void writeTrace(int level, String s) {
        if (this.trace != null) {
            this.trace.writeTrace(level, s);
        }
    }

    void writeTrace(int level, byte[] data, char format) {
        if (this.trace != null) {
            this.trace.writeTrace(level, data, format);
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxObject;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return super.toString();
    }

    public int toInt() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80008, this.conn);
    }

    public BigDecimal toDecimal() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80014, this.conn);
    }

    public byte toByte() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80015, this.conn);
    }

    public byte[] toBytes() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80016, this.conn);
    }

    public boolean toBoolean() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80018, this.conn);
    }

    public Date toDate() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80024, this.conn);
    }

    public float toFloat() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80020, this.conn);
    }

    public long toLong() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80010, this.conn);
    }

    public short toShort() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80012, this.conn);
    }

    public Time toTime() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80025, this.conn);
    }

    public double toDouble() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80022, this.conn);
    }

    public Timestamp toTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80026, this.conn);
    }

    public InputStream toInputStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80028, this.conn);
    }

    public InputStream toAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80029, this.conn);
    }

    public InputStream toBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80030, this.conn);
    }

    public byte[] toIfx() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    public byte[] toIfxTuple() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    public Object toObject() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80031, this.conn);
    }

    public Interval toInterval() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80038, this.conn);
    }

    public IntervalYM toIntervalYM() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80036, this.conn);
    }

    public IntervalDF toIntervalDF() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80037, this.conn);
    }

    public void fromIfx(byte[] b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b, short prec) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromInt(int i) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80008, this.conn);
    }

    public void fromInt(Integer I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80009, this.conn);
    }

    public void fromString(String newval) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80027, this.conn);
    }

    public void fromDecimal(BigDecimal B) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromDecimal(BigDecimal B, int scale) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromByte(byte b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80015, this.conn);
    }

    public void fromByte(Byte B) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80017, this.conn);
    }

    public void fromBytes(byte[] b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80016, this.conn);
    }

    public void fromBoolean(boolean b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80018, this.conn);
    }

    public void fromBoolean(Boolean b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80019, this.conn);
    }

    public void fromDate(Date D) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80024, this.conn);
    }

    public void fromFloat(float f) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80020, this.conn);
    }

    public void fromFloat(Float F) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80021, this.conn);
    }

    public void fromLong(long l) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80010, this.conn);
    }

    public void fromLong(Long L) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80011, this.conn);
    }

    public void fromShort(short s) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80012, this.conn);
    }

    public void fromShort(Short S) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80013, this.conn);
    }

    public void fromTime(Time T) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80025, this.conn);
    }

    public void fromDouble(double d) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80022, this.conn);
    }

    public void fromDouble(Double D) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80023, this.conn);
    }

    public void fromTimestamp(Timestamp T) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80026, this.conn);
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80029, this.conn);
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80030, this.conn);
    }

    public void fromInputStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public void fromIntervalYM(IntervalYM I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80036, this.conn);
    }

    public void fromIntervalDF(IntervalDF I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80037, this.conn);
    }

    static {
        if (objMap == null) {
            objMap = new Hashtable(13, 1.0f);
            objMap.put("java.lang.Boolean", "Boolean");
            objMap.put("java.lang.Byte", "Byte");
            objMap.put("java.lang.Short", "Short");
            objMap.put("java.lang.Integer", "Int");
            objMap.put("java.lang.Long", "Long");
            objMap.put("java.lang.Float", "Float");
            objMap.put("java.lang.Double", "Double");
            objMap.put("java.lang.Number", "Double");
            objMap.put("java.lang.String", "String");
            objMap.put("java.math.BigDecimal", "Decimal");
            objMap.put("java.sql.Date", "Date");
            objMap.put("java.sql.Time", "Time");
            objMap.put("java.sql.Timestamp", "Timestamp");
            objMap.put("[B", "Bytes");
            objMap.put("com.informix.lang.IntervalYM", "IntervalYM");
            objMap.put("com.informix.lang.IntervalDF", "IntervalDF");
        }
    }
}

