/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.dateUtil;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;

public class IfxNativeSQL {
    private final char LBRACE = (char)123;
    private final char RBRACE = (char)123;
    private final String SLBRACE = "{";
    private final String SRBRACE = "}";
    private final String SLPAREN = "(";
    private final String SRPAREN = ")";
    private final String SBPAREN = "()";
    private final char DQUOTE = (char)34;
    private final String SDQUOTE = "\"";
    private final String SQUOTE = "'";
    private final char LBRACK = (char)91;
    private final char RBRACK = (char)93;
    private final String SLBRACK = "[";
    private final String SRBRACK = "]";
    private final char COMMA = (char)44;
    private final String SCOMMA = ",";
    private final char SPACE = (char)32;
    private final String SSPACE = " ";
    private final char TAB = (char)9;
    private final String STAB = "\t";
    private String oldString;
    private String newString;
    private IfxConnection conn;
    private Trace trace;
    private static Hashtable funcTable = null;

    IfxNativeSQL(String sql, IfxConnection jconn) throws SQLException {
        if (sql == null) {
            this.oldString = null;
            this.newString = null;
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        this.oldString = sql;
        this.conn = jconn;
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
        }
        this.newString = this.parseSQLString(sql);
    }

    String getNewString() {
        this.trace.writeTrace(1, "IfxNativeSQL: getNewString() called");
        return this.newString;
    }

    /*
     * Unable to fully structure code
     */
    String parseSQLString(String sql) throws SQLException {
        resStr = "";
        isAStoredProcCall = 0;
        this.trace.writeTrace(1, "IfxNativeSQL:parseSQLString(): entered");
        if (sql.indexOf(123) == -1 || sql.indexOf(123) == -1) {
            return sql;
        }
        markers = "{} \t";
        strT = new StringTokenizer(sql, markers, true);
        oldToken = "";
        token = "";
        while (strT.hasMoreTokens()) {
            block62: {
                if (token.trim().length() > 0) {
                    oldToken = token.toLowerCase();
                }
                token = strT.nextToken();
                nativeString = "";
                if (!token.equals("{")) {
                    resStr = String.valueOf(resStr) + token;
                    continue;
                }
                if (oldToken.indexOf("list") < 0 && oldToken.indexOf("set") < 0 && oldToken.indexOf("multiset") < 0) ** GOTO lbl26
                this.trace.writeTrace(2, "IfxNativeSQL():'{' was a 9.x bracket");
                resStr = String.valueOf(resStr) + token;
                continue;
lbl-1000:
                // 1 sources

                {
                    oldToken = token;
                    token = strT.nextToken();
                    if (token.equals("}")) continue;
                    nativeString = String.valueOf(nativeString) + token;
lbl26:
                    // 3 sources

                    ** while (strT.hasMoreTokens() && !token.equals((Object)"}"))
                }
lbl27:
                // 1 sources

                str = new StringTokenizer(nativeString);
                kw = str.hasMoreTokens() != false ? str.nextToken() : "";
                this.trace.writeTrace(2, "IfxNativeSQL(): keyword = '" + kw + "'");
                if (kw.equals("call")) {
                    isAStoredProcCall = 1;
                } else {
                    checkT = new StringTokenizer(nativeString);
                    if (checkT.countTokens() < 4) {
                        isAStoredProcCall = 0;
                    } else {
                        checkT.nextToken();
                        isAStoredProcCall = checkT.nextToken().equals("=") == false ? 0 : (checkT.nextToken().equalsIgnoreCase("call") == false ? 0 : 2);
                    }
                }
                if (isAStoredProcCall > 0) {
                    this.trace.writeTrace(3, "IfxNativeSQL(): isAStoredProcCall =" + isAStoredProcCall);
                    if (!str.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLException(-79710, "{" + nativeString + "}", this.conn);
                    }
                    if (isAStoredProcCall == 1) {
                        f = str.nextToken("}").trim();
                        resStr = f.indexOf("(") == -1 ? String.valueOf(resStr) + "execute procedure " + f + "()" : String.valueOf(resStr) + "execute procedure " + f;
                        this.trace.writeTrace(3, "IfxNativeSQL(): resStr ='" + resStr + "'");
                        continue;
                    }
                    str.nextToken();
                    str.nextToken();
                    f = str.nextToken("}").trim();
                    resStr = f.indexOf("(") == -1 ? String.valueOf(resStr) + "execute procedure " + f + "()" : String.valueOf(resStr) + "execute procedure " + f;
                    this.trace.writeTrace(3, "IfxNativeSQL(): resStr ='" + resStr + "'");
                    continue;
                }
                if (kw.equals("d") && str.hasMoreTokens()) {
                    d = str.nextToken("}");
                    locdateStr = null;
                    firstChar = d.substring(0, 1);
                    lastChar = d.substring(d.length() - 1, d.length());
                    nativedateStr = d.substring(1, d.length() - 1);
                    if (!firstChar.equals("'") || !lastChar.equals("'")) {
                        throw IfxErrMsg.getSQLMinorException(-79710, "\"" + sql + "\"", -80004, "''' ", this.conn);
                    }
                    locdateStr = dateUtil.convertNativeSQLDate(nativedateStr, this.conn);
                    resStr = String.valueOf(resStr) + "'" + locdateStr + "'";
                    this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + resStr + "'");
                    continue;
                }
                if (kw.equals("t") && str.hasMoreTokens()) {
                    t = str.nextToken("}");
                    firstChar = t.substring(0, 1);
                    lastChar = t.substring(t.length() - 1, t.length());
                    s = t.substring(1, t.length() - 1);
                    if (!dateUtil.isValidTime(s)) {
                        throw IfxErrMsg.getSQLException(-79711, "\"" + t + "\"", this.conn);
                    }
                    if (!firstChar.equals("'") || !lastChar.equals("'")) {
                        throw IfxErrMsg.getSQLMinorException(-79710, "\"" + sql + "\"", -80004, "''' ", this.conn);
                    }
                    resStr = String.valueOf(resStr) + '\"' + s + '\"';
                    this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + resStr + "'");
                    continue;
                }
                if (kw.equals("ts") && str.hasMoreTokens()) {
                    ts = str.nextToken("}");
                    firstChar = ts.substring(0, 1);
                    lastChar = ts.substring(ts.length() - 1, ts.length());
                    s = ts.substring(1, ts.length() - 1);
                    if (!dateUtil.isValidTimeStamp(s)) {
                        throw IfxErrMsg.getSQLException(-79712, "\"" + ts + "\"", this.conn);
                    }
                    if (!firstChar.equals("'") || !lastChar.equals("'")) {
                        throw IfxErrMsg.getSQLMinorException(-79710, "\"" + sql + "\"", -80004, "''' ", this.conn);
                    }
                    s = dateUtil.IfxTimeStamp(s);
                    resStr = String.valueOf(resStr) + '\"' + s + '\"';
                    this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + resStr + "'");
                    continue;
                }
                if (kw.equals("fn") && str.hasMoreTokens()) {
                    f = str.nextToken("}");
                    fT = new StringTokenizer(f, "()");
                    if (!fT.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLException(-79710, "\"" + str + "\"", this.conn);
                    }
                    func = fT.nextToken();
                    this.trace.writeTrace(3, "IfxNativeSQL(): func = '" + func + "'");
                    args = fT.hasMoreTokens() != false ? fT.nextToken("()") : "";
                    this.trace.writeTrace(3, "IfxNativeSQL(): args = '" + args + "'");
                    ifxFunc = (String)IfxNativeSQL.funcTable.get(func.toLowerCase());
                    ifxFuncNA = (String)IfxNativeSQL.funcTable.get(func.toUpperCase());
                    if (ifxFunc != null) {
                        resStr = String.valueOf(resStr) + ifxFunc + "(" + args + ")";
                        continue;
                    }
                    if (ifxFuncNA != null) {
                        resStr = String.valueOf(resStr) + ifxFuncNA;
                        continue;
                    }
                    if (func.equalsIgnoreCase("cot")) {
                        resStr = String.valueOf(resStr) + "(" + "cos" + "(" + args + ")" + "/sin" + "(" + args + ")" + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("degrees")) {
                        resStr = String.valueOf(resStr) + "(" + args + " * 180 / " + 3.141592653589793 + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("pi")) {
                        resStr = String.valueOf(resStr) + 3.141592653589793;
                        continue;
                    }
                    if (func.equalsIgnoreCase("radians")) {
                        resStr = String.valueOf(resStr) + "(" + args + " * " + 3.141592653589793 + " / 180" + ")" + " ";
                        continue;
                    }
                    if (func.equalsIgnoreCase("rand")) {
                        r = new Random(stringUtil.stringToInt(args));
                        resStr = String.valueOf(resStr) + r.nextFloat();
                        this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                        continue;
                    }
                    if (func.equalsIgnoreCase("concat")) {
                        argsT = new StringTokenizer(args, ",");
                        arglist = "";
                        while (argsT.hasMoreTokens()) {
                            arglist = String.valueOf(arglist) + argsT.nextToken();
                            if (!argsT.hasMoreTokens()) continue;
                            arglist = String.valueOf(arglist) + " || ";
                        }
                        resStr = String.valueOf(resStr) + arglist;
                        this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                        continue;
                    }
                    if (func.equalsIgnoreCase("left")) {
                        leftT = new StringTokenizer(args, ",");
                        if (leftT.countTokens() == 2) {
                            arg1 = leftT.nextToken().trim();
                            countStr = leftT.nextToken().trim();
                            cnt = stringUtil.stringToInt(countStr) + 1;
                            resStr = String.valueOf(resStr) + ' ' + arg1 + '[' + "1, " + cnt + ']';
                        }
                        this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                        continue;
                    }
                    if (func.equalsIgnoreCase("ltrim")) {
                        resStr = String.valueOf(resStr) + "trim " + "(" + "LEADING FROM " + args + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("rtrim")) {
                        resStr = String.valueOf(resStr) + "trim " + "(" + "TRAILING FROM " + args + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("dayofweek")) {
                        resStr = String.valueOf(resStr) + "(" + "weekday" + "(" + args + ")" + "+1" + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("hour")) {
                        resStr = String.valueOf(resStr) + "extend" + "(" + args + ", hour to hour" + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("minute")) {
                        resStr = String.valueOf(resStr) + "extend" + "(" + args + ", minute to minute" + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("second")) {
                        resStr = String.valueOf(resStr) + "extend" + "(" + args + ", second to second" + ")";
                        continue;
                    }
                    if (func.equalsIgnoreCase("database")) {
                        db = this.conn.getDbName();
                        this.trace.writeTrace(3, "IfxNativeSQL: db == '" + db + "'");
                        if (db == null) continue;
                        resStr = String.valueOf(resStr) + db;
                        continue;
                    }
                    if (func.equalsIgnoreCase("ifnull")) {
                        argsT = new StringTokenizer(args, ",");
                        if (argsT.countTokens() != 2) {
                            throw IfxErrMsg.getSQLException(-79713, "\"" + f + "\"", this.conn);
                        }
                        expr = argsT.nextToken().trim();
                        value = argsT.nextToken().trim();
                        resStr = String.valueOf(resStr) + "ifnull('" + expr + "', " + value + ")";
                        this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                        continue;
                    }
                    if (func.equalsIgnoreCase("convert")) {
                        argsT = new StringTokenizer(args, ",");
                        if (argsT.countTokens() != 2) {
                            throw IfxErrMsg.getSQLException(-79713, "\"" + f + "\"", this.conn);
                        }
                        val = argsT.nextToken().trim();
                        type = argsT.nextToken().trim();
                        if (type.equalsIgnoreCase("BINARY") || type.equalsIgnoreCase("BIT") || type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("VARBINARY")) {
                            throw IfxErrMsg.getSQLException(-79714, ": " + type, this.conn);
                        }
                        resStr = String.valueOf(resStr) + val;
                        this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                        continue;
                    }
                    resStr = String.valueOf(resStr) + func + "(" + args + ")";
                    continue;
                }
                if (kw.equals("escape") && str.hasMoreTokens()) {
                    f = str.nextToken("}");
                    fT = new StringTokenizer(f, " ");
                    if (fT.hasMoreTokens()) {
                        resStr = String.valueOf(resStr) + "escape " + fT.nextToken();
                    }
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                    continue;
                }
                if (!kw.equals("oj") || !str.hasMoreTokens()) break block62;
                ojS = str.nextToken("}");
                ojT = new StringTokenizer(ojS, " ");
                tabList = new Stack<String>();
                searchCond = "";
                tmp = "";
                tab = "";
                ansiJoinSupp = this.conn.isANSIJoin();
                while (ojT.hasMoreTokens()) {
                    tmp = ojT.nextToken();
                    tab = "";
                    if (!tmp.equalsIgnoreCase("ON") && !tmp.equalsIgnoreCase("LEFT")) ** GOTO lbl216
                    throw IfxErrMsg.getSQLMinorException(-79715, -80005, "\"" + ojS + "\"", this.conn);
lbl-1000:
                    // 1 sources

                    {
                        tab = String.valueOf(tab) + ' ' + tmp;
                        tmp = ojT.nextToken();
lbl216:
                        // 2 sources

                        ** while (ojT.hasMoreTokens() && !tmp.equalsIgnoreCase((String)"LEFT") && !tmp.equalsIgnoreCase((String)"OUTER") && !tmp.equalsIgnoreCase((String)"JOIN") && !tmp.equalsIgnoreCase((String)"ON"))
                    }
lbl217:
                    // 1 sources

                    this.trace.writeTrace(3, "IfxNativeSQL: tab == '" + tab + "'");
                    if (ansiJoinSupp) {
                        resStr = String.valueOf(resStr) + tab;
                    } else {
                        tabList.push(tab);
                    }
                    if (!ojT.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, "\"" + ojS + "\"", this.conn);
                    }
                    tok = tmp;
                    if (tok.equalsIgnoreCase("ON")) {
                        while (ojT.hasMoreTokens()) {
                            searchCond = String.valueOf(searchCond) + ojT.nextToken();
                        }
                        this.trace.writeTrace(3, "IfxNativeSQL: searchCond == '" + searchCond + "'");
                        searchCond = ansiJoinSupp ? " on " + searchCond : " where " + searchCond;
                    } else if (tok.equalsIgnoreCase("LEFT")) {
                        if (ojT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, "\"" + ojS + "\"", this.conn);
                        }
                        if (!ojT.nextToken().equalsIgnoreCase("OUTER") || !ojT.nextToken().equalsIgnoreCase("JOIN")) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, "\"" + ojS + "\"", this.conn);
                        }
                        if (ansiJoinSupp) {
                            resStr = String.valueOf(resStr) + ", left outer join ";
                        }
                    } else {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, "\"" + ojS + "\"", this.conn);
                    }
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + resStr + "'");
                }
                if (!ansiJoinSupp) {
                    newJoin = "";
                    while (!tabList.empty()) {
                        newJoin = String.valueOf(newJoin) + tabList.pop();
                        if (tabList.empty()) continue;
                        newJoin = String.valueOf(newJoin) + ", outer";
                    }
                    resStr = String.valueOf(resStr) + newJoin;
                }
                if (searchCond.length() <= 0) continue;
                resStr = String.valueOf(resStr) + searchCond;
                continue;
            }
            resStr = String.valueOf(resStr) + "{" + nativeString + "}";
        }
        return resStr;
    }

    static {
        if (funcTable == null) {
            funcTable = new Hashtable();
            funcTable.put("abs", "abs");
            funcTable.put("acos", "acos");
            funcTable.put("asin", "asin");
            funcTable.put("atan", "atan");
            funcTable.put("atan2", "atan2");
            funcTable.put("ceiling", "round");
            funcTable.put("exp", "exp");
            funcTable.put("floor", "trunc");
            funcTable.put("log", "logn");
            funcTable.put("log10", "log10");
            funcTable.put("mod", "mod");
            funcTable.put("power", "pow");
            funcTable.put("round", "round");
            funcTable.put("sin", "sin");
            funcTable.put("sign", "sign");
            funcTable.put("sqrt", "sqrt");
            funcTable.put("tan", "tan");
            funcTable.put("truncate", "trunc");
            funcTable.put("length", "length");
            funcTable.put("dayofmonth", "day");
            funcTable.put("month", "month");
            funcTable.put("year", "year");
            funcTable.put("CURDATE", "today");
            funcTable.put("CURTIME", "current");
            funcTable.put("NOW", "current");
            funcTable.put("USER", "user");
        }
    }
}

