/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxLobInputStream
extends InputStream {
    IfxConnection conn;
    IfxLocator locator;
    long lobSize;
    private int loFd;
    private IfxLocator loPtr;
    private IfxSmartBlob smb;
    byte[] buffer;
    int pos;
    int count;

    public IfxLobInputStream(IfxConnection connection, IfxLocator loPtr) throws IOException {
        this.conn = connection;
        this.locator = loPtr;
        try {
            this.smb = new IfxSmartBlob(this.conn);
            this.loFd = this.smb.IfxLoOpen(this.locator, 4);
            this.lobSize = this.smb.IfxLoSize(this.loFd);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    public int read() throws IOException {
        if (this.buffer == null || this.pos == this.count) {
            this.buffer = new byte[4096];
            this.count = this.readLob(this.buffer, 4096);
            if (this.count == -1) {
                return -1;
            }
            this.pos = 0;
        }
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.readLob(b, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, off, 0);
            return this.readLob(b, len);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        try {
            return this.smb.IfxLoSeek(this.loFd, n, 1);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    public void reset() throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, 0L, 0);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return (int)this.lobSize;
    }

    public void close() throws IOException {
        try {
            this.smb.IfxLoClose(this.loFd);
            this.smb.IfxLoRelease(this.locator);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    protected void finalize() throws IOException {
    }

    private int readLob(byte[] b, int len) throws IOException {
        try {
            int i = this.smb.IfxLoRead(this.loFd, b, len);
            if (i == 0) {
                return -1;
            }
            return i;
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    protected InputStream getStream() throws SQLException {
        if (this.lobSize == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            this.reset();
        }
        catch (IOException iOException) {}
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.smb.IfxLoRead(this.loFd, (int)this.lobSize));
        return barrayIS;
    }
}

