/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxLobDescriptor {
    static final short LO_DESCRIPTOR_SIZE = 596;
    static final short PRE_LONG_ID_LO_DESCRIPTOR_SIZE = 164;
    static final short DISK_DESCRIPTOR_SIZE = 168;
    static final short PRE_LONG_ID_DISK_DESCRIPTOR_SIZE = 58;
    public static final short LO_LOG = 1;
    public static final short LO_NOLOG = 2;
    public static final short LO_DELAY_LOG = 4;
    public static final short LO_KEEP_LASTACCESS_TIME = 8;
    public static final short LO_NOKEEP_LASTACCESS_TIME = 16;
    public static final short LO_HIGH_INTEG = 32;
    public static final short LO_MODERATE_INTEG = 64;
    private int idSize = 18;
    private int MagicNumber;
    private int CreateTimeFlags;
    private int CreateTimeFlags1;
    private long estimatedNoBytes;
    private long sizeLimit;
    private int extentSize;
    private String spaceName;
    byte[] rawColDescriptor;
    private IfxConnection conn;

    public IfxLobDescriptor(Connection conn) throws SQLException {
        byte[] someName = null;
        this.conn = (IfxConnection)conn;
        IfxUDTOutput os2 = new IfxUDTOutput(this.conn);
        if (this.conn.isLongID()) {
            this.idSize = 128;
        }
        someName = new byte[this.idSize];
        this.MagicNumber = -623182099;
        this.CreateTimeFlags = 0;
        this.CreateTimeFlags1 = 0;
        this.estimatedNoBytes = -1L;
        this.sizeLimit = -1L;
        this.extentSize = -1;
        this.spaceName = "";
        try {
            os2.writeInt(0);
            os2.writeBytes(someName, someName.length);
            os2.writeInt(0);
            os2.writeBytes(someName, someName.length);
            os2.writeInt(0);
            os2.writeBytes(someName, someName.length);
            os2.writeShort((short)0);
            os2.writeShort((short)0);
            os2.writeInt(0);
            os2.writeInt(-1);
            os2.writeInt(-1);
            os2.writeInt(0);
            os2.writeInt(0);
            os2.writeInt(0);
            os2.writeInt(0);
            this.rawColDescriptor = os2.toByteArray();
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            this.rawColDescriptor = null;
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    IfxLobDescriptor(IfxConnection conn, byte[] loDesc) throws SQLException {
        int colDescLength;
        this.conn = conn;
        if (conn.isLongID()) {
            colDescLength = 428;
            this.idSize = 128;
        } else {
            colDescLength = 106;
        }
        try {
            IfxUDTInput is = new IfxUDTInput(this.conn, loDesc, 0, loDesc.length);
            this.MagicNumber = is.readInt();
            this.CreateTimeFlags = is.readInt();
            this.CreateTimeFlags1 = is.readInt();
            this.estimatedNoBytes = is.readLong();
            this.sizeLimit = is.readLong();
            this.extentSize = is.readInt();
            this.spaceName = is.readString(this.idSize);
            int i = this.spaceName.indexOf(0);
            if (i != -1) {
                this.spaceName = this.spaceName.substring(0, i);
            }
            this.rawColDescriptor = is.readBytes(colDescLength);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), conn);
        }
    }

    public void setCreateFlags(int flags) {
        this.CreateTimeFlags = flags;
    }

    public void setEstBytes(long estSize) {
        this.estimatedNoBytes = estSize;
    }

    public void setMaxBytes(long maxSize) {
        this.sizeLimit = maxSize;
    }

    public void setExtSize(int extSize) {
        this.extentSize = extSize;
    }

    public void setSbspace(String name) {
        this.spaceName = name;
    }

    public int getCreateFlags() {
        return this.CreateTimeFlags;
    }

    public long getEstSize() {
        return this.estimatedNoBytes;
    }

    public long getMaxBytes() {
        return this.sizeLimit;
    }

    public int getExtSize() {
        return this.extentSize;
    }

    public String getSbspace() {
        return this.spaceName;
    }

    int length() {
        return IfxLobDescriptor.size(this.conn);
    }

    static int size(IfxConnection conn) {
        if (conn.isLongID()) {
            return 596;
        }
        return 164;
    }

    byte[] getRawLobDescriptor() throws SQLException {
        IfxUDTOutput os2 = new IfxUDTOutput(this.conn);
        os2.writeInt(this.MagicNumber);
        os2.writeInt(this.CreateTimeFlags);
        os2.writeInt(this.CreateTimeFlags1);
        os2.writeLong(this.estimatedNoBytes);
        os2.writeShort((short)0);
        os2.writeLong(this.sizeLimit);
        os2.writeShort((short)0);
        os2.writeInt(this.extentSize);
        os2.writeString(this.spaceName, this.idSize);
        os2.writeBytes(this.rawColDescriptor);
        return os2.toByteArray();
    }
}

