/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected IfxConnection conn;
    protected boolean isBlob_loaded = false;
    protected IfxTmpFile tempBlobFile;
    protected IfxLocator locatorPointer;
    protected InputStream blobStream;
    protected byte[] blobBuffer;
    protected String BlobFileName;
    protected long blobSize;
    protected short ifxType;

    protected IfxLob() {
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        return this.locatorPointer;
    }

    protected void setLocator(IfxLocator locator) {
        this.locatorPointer = locator;
    }

    protected void setIfxLobType(short type) {
        this.ifxType = type;
    }

    protected void setSize(long size) {
        this.blobSize = size;
    }

    protected void setConnection(IfxConnection conn) {
        this.conn = conn;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPortion(long position, long len) {
        int length = (int)len;
        long pos = position - 1L;
        if (pos < 0L || length < 0) {
            return null;
        }
        if (pos + (long)length > this.blobSize) {
            return null;
        }
        byte[] b = new byte[length];
        try {
            if (!this.isBlob_loaded) {
                this.loadSmBlob();
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (this.tempBlobFile != null) {
            FileInputStream fd;
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                fd = new FileInputStream(this.tempBlobFile.getFileName());
            }
            catch (Exception exception) {
                return null;
            }
            try {
                if (pos > 0L) {
                    fd.skip(pos);
                }
                fd.read(b, 0, length);
                fd.close();
                if (this.ifxType != 3 && this.ifxType != 2) return b;
                this.isBlob_loaded = false;
                this.tempBlobFile.close();
                this.tempBlobFile = null;
                return b;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.blobBuffer == null) return null;
        System.arraycopy(this.blobBuffer, (int)pos, b, 0, length);
        return b;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream lobStream = new IfxLobInputStream(this.conn, this.locatorPointer);
                return lobStream;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                IfxInputStream fd = new IfxInputStream(this.tempBlobFile);
                return fd;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
        }
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.blobBuffer);
        return barrayIS;
    }

    protected void loadSmBlob() throws SQLException {
        FileOutputStream BlobFd = null;
        this.tempBlobFile = null;
        this.blobBuffer = null;
        if (this.blobSize == 0L) {
            this.blobBuffer = new byte[0];
            this.tempBlobFile = null;
            return;
        }
        int bufferSize = this.conn.getBlobCacheSize();
        if (bufferSize < 0 || bufferSize > 0 && this.blobSize <= (long)bufferSize) {
            try {
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79753, this.conn);
            }
            this.tempBlobFile = null;
        } else {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.createTempFile();
                BlobFd = new FileOutputStream(this.tempBlobFile.getFileName());
                this.blobBuffer = null;
            }
            catch (Exception exception) {
                if (bufferSize == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize);
                BlobFd = null;
                this.tempBlobFile = null;
            }
        }
        try {
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            int loFd = smb.IfxLoOpen(this.locatorPointer, 8);
            if (this.blobBuffer == null) {
                smb.IfxLoRead(loFd, BlobFd, (int)this.blobSize);
            } else {
                smb.IfxLoRead(loFd, this.blobBuffer, (int)this.blobSize);
            }
            smb.IfxLoClose(loFd);
        }
        catch (Exception exception) {}
        this.isBlob_loaded = true;
    }

    private void createTempFile() throws SQLException {
        String fileName = String.valueOf(System.currentTimeMillis());
        fileName = String.valueOf(this.conn.getJDBCTempDir()) + "ifxb_" + fileName.substring(4);
        this.tempBlobFile = new IfxTmpFile(fileName);
    }
}

