/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxUDTInput;
import java.sql.SQLException;

public class IfxLoStat {
    private static final short LO_STAT_SIZE = 644;
    private static final short PRE_LONG_ID_LO_STAT_SIZE = 212;
    private long lobSize;
    private int lobUID;
    private int lastAccessTime;
    private int lastModifyTimeS;
    private int lastModifyTimeM;
    private int lastStatusTime;
    private int refCount;
    private IfxLobDescriptor lobDescriptor;
    private IfxConnection conn;

    IfxLoStat() {
    }

    IfxLoStat(IfxConnection conn, byte[] loStat) throws SQLException {
        int loDescLength;
        this.conn = conn;
        if (conn.isLongID()) {
            int loStatLength = 644;
            loDescLength = 596;
        } else {
            int loStatLength = 212;
            loDescLength = 164;
        }
        IfxUDTInput is = new IfxUDTInput(conn, loStat, 0, loStat.length);
        is.readInt();
        this.lobSize = is.readLong();
        is.readShort();
        this.lobUID = is.readInt();
        this.lastAccessTime = is.readInt();
        this.lastModifyTimeS = is.readInt();
        this.lastModifyTimeM = is.readInt();
        this.lastStatusTime = is.readInt();
        this.refCount = is.readInt();
        this.lobDescriptor = new IfxLobDescriptor(conn, is.readBytes(loDescLength));
    }

    public long getSize() {
        return this.lobSize;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public int getLastStatusTime() {
        return this.lastStatusTime;
    }

    public int getLastModifyTimeS() {
        return this.lastModifyTimeS;
    }

    public int getLastModifyTimeM() {
        return this.lastModifyTimeM;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public IfxLobDescriptor getLobDescriptor() {
        return this.lobDescriptor;
    }

    int length() {
        return IfxLoStat.size(this.conn);
    }

    static int size(IfxConnection conn) {
        if (conn.isLongID()) {
            return 644;
        }
        return 212;
    }
}

