/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.sql.SQLException;

public class IfxIntervalYM
extends IfxObject {
    private IntervalYM value;

    public IfxIntervalYM() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalYM(IntervalYM YM) throws SQLException {
        this.setIfxType(14);
        this.value = YM;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public IntervalYM value() {
        return this.value;
    }

    public byte[] toIfx() {
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        this.trace.writeTrace(2, "   IfxIntervalYM.toIfx() data:");
        this.trace.writeTrace(2, b, 'H');
        return b;
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(b, (short)this.encodedLength);
    }

    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.trace.writeTrace(2, "   IfxIntervalYM.fromIfx() data:");
        this.trace.writeTrace(2, b, 'H');
        this.value = (IntervalYM)IfxToJavaType.IfxToJavaInterval(b, prec);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
    }

    public String toString() {
        this.writeTrace(1, "IfxIntervalYM.toString(): entered");
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String str) throws SQLException {
        this.writeTrace(1, "IfxIntervalYM.fromString(): entered");
        if (str == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalYM();
        }
        this.value.fromString(str);
        this.unnullify();
        this.writeTrace(1, "IfxIntervalYM.fromString(): exited");
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public Interval toInterval() throws SQLException {
        return this.toIntervalYM();
    }

    public IntervalYM toIntervalYM() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromIntervalYM(IntervalYM YM) throws SQLException {
        if (YM == null) {
            this.nullify();
        } else {
            this.value = YM;
            this.unnullify();
        }
    }

    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }
}

