/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.JavaToIfxType;
import java.sql.SQLException;

public class IfxIntervalDF
extends IfxObject {
    private IntervalDF value;

    public IfxIntervalDF() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalDF(IntervalDF DF) throws SQLException {
        this.setIfxType(14);
        this.value = DF;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public IntervalDF value() {
        return this.value;
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInterval(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(b, (short)this.encodedLength);
    }

    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.writeTrace(1, "IfxIntervalDF.fromIfx(): entered");
        this.trace.writeTrace(2, "   fromIfx() data:");
        this.trace.writeTrace(2, b, 'H');
        this.value = (IntervalDF)IfxToJavaType.IfxToJavaInterval(b, prec);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
        this.writeTrace(1, "IfxIntervalDF.fromIfx(): exited");
    }

    public String toString() {
        this.writeTrace(1, "IfxIntervalDF.toString(): entered");
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String str) throws SQLException {
        this.writeTrace(1, "IfxIntervalDF.fromString(): entered");
        if (str == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalDF();
        }
        this.value.fromString(str);
        this.unnullify();
        this.writeTrace(1, "IfxIntervalDF.fromString(): exited");
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public Interval toInterval() throws SQLException {
        return this.toIntervalDF();
    }

    public IntervalDF toIntervalDF() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromIntervalDF(IntervalDF DF) throws SQLException {
        if (DF == null) {
            this.nullify();
        } else {
            this.value = DF;
            this.unnullify();
        }
    }

    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }
}

