/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInteger
extends IfxObject {
    private int value;
    public static final int IFX_INT_NULL = Integer.MIN_VALUE;

    IfxInteger() throws SQLException {
        this.setIfxType(2);
    }

    IfxInteger(int i) throws SQLException {
        this.value = i;
        this.setIfxType(2);
        this.unnullify();
    }

    IfxInteger(Integer I) throws SQLException {
        this.value = I;
        this.setIfxType(2);
        this.unnullify();
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[]{-128, 0, 0, 0};
            return b;
        }
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    public void fromIfx(byte[] b) {
        this.value = IfxToJavaType.IfxToJavaInt(b, (short)0);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    public void fromInt(int val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromInt(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    public void fromLong(long val) throws SQLException {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    public void fromLong(Long val) throws SQLException {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(float val) throws SQLException {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    public void fromFloat(Float val) throws SQLException {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double val) {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    public void fromDouble(Double val) {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    public void fromBoolean(boolean val) throws SQLException {
        this.value = val ? 1 : 0;
        this.unnullify();
    }

    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val == true ? 1 : 0;
            this.unnullify();
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.value);
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Integer.valueOf(str.trim());
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxInteger && this.value == ((IfxInteger)other).value;
    }

    public short getEncodedLength() {
        short encodedLength = 2560;
        this.writeTrace(3, "IfxInteger ecodedLength = " + encodedLength);
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Integer.MIN_VALUE;
    }
}

