/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInt8
extends IfxObject {
    private long value;
    public static final long IFX_INT8_NULL = Long.MIN_VALUE;

    IfxInt8() throws SQLException {
        this.setIfxType(17);
    }

    IfxInt8(long l) throws SQLException {
        this.setIfxType(17);
        this.value = l;
        this.unnullify();
    }

    IfxInt8(Long L) throws SQLException {
        this.setIfxType(17);
        this.value = L;
        this.unnullify();
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxLongInt(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[10];
            memoryUtil.byfill(b, (byte)0);
            b[1] = 1;
            return b;
        }
        return JavaToIfxType.JavaToIfxLongInt(this.value);
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    public void fromIfx(byte[] b) {
        this.value = IfxToJavaType.IfxToJavaLongInt(b, (short)0);
        this.writeTrace(3, "IfxInt8: fromIfx = " + this.value);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public int toInt() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (int)this.value;
    }

    public void fromInt(int val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromShort(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    public void fromLong(long val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(float val) throws SQLException {
        this.value = (long)val;
        this.unnullify();
    }

    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double val) {
        this.value = (long)val;
        this.unnullify();
    }

    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.longValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0L;
    }

    public void fromBoolean(boolean val) throws SQLException {
        this.value = val ? 1 : 0;
        this.unnullify();
    }

    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val == true ? 1 : 0;
            this.unnullify();
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Long.valueOf(str.trim());
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxInt8 && this.value == ((IfxInt8)other).value;
    }

    public short getEncodedLength() {
        short encodedLength = 4864;
        this.writeTrace(3, "IfxInt8 ecodedLength = " + encodedLength);
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Long.MIN_VALUE;
    }
}

