/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxFloat
extends IfxObject {
    private double value;

    IfxFloat() throws SQLException {
        this.writeTrace(1, "IfxFloat() constructor called");
        this.writeTrace(1, "IfxFloat() constructor exited");
        this.setIfxType(3);
    }

    IfxFloat(double d) throws SQLException {
        this.writeTrace(1, "IfxFloat(double) constructor called");
        this.setIfxType(3);
        this.value = d;
        this.unnullify();
        this.writeTrace(1, "IfxFloat(double) constructor exited");
    }

    IfxFloat(Double D) throws SQLException {
        this.writeTrace(1, "IfxFloat(Double) constructor called");
        this.setIfxType(3);
        if (D != null) {
            this.value = D;
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat(Double) constructor exited");
    }

    IfxFloat(float f) throws SQLException {
        this.writeTrace(1, "IfxFloat(float) constructor called");
        this.setIfxType(3);
        this.value = f;
        this.unnullify();
        this.writeTrace(1, "IfxFloat(float) constructor exited");
    }

    IfxFloat(Float F) throws SQLException {
        this.writeTrace(1, "IfxFloat(Float) constructor called");
        this.setIfxType(3);
        if (F != null) {
            this.value = F.floatValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat(Float) constructor exited");
    }

    public byte[] toIfx() {
        this.writeTrace(1, "IfxFloat: toIfx called/exited");
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[8];
            memoryUtil.byfill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    public void fromIfx(byte[] b) {
        boolean null_flg = true;
        this.writeTrace(1, "IfxFloat: fromIfx called");
        null_flg = IfxFloat.isIfxNull(b);
        if (!null_flg) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(b, (short)0);
        } else {
            this.nullify();
        }
        this.writeTrace(1, "IfxFloat: fromIfx exited");
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxFloat) {
            IfxFloat floatOther = (IfxFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    public byte toByte() throws SQLException {
        this.writeTrace(1, "IfxFloat: toByte called");
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        this.writeTrace(1, "IfxFloat: toByte exited");
        return b;
    }

    public void fromByte(byte b) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromByte called");
        this.value = b;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromByte exited");
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.doubleValue();
            this.unnullify();
        }
    }

    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double d) throws SQLException {
        this.value = d;
        this.unnullify();
    }

    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = D;
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        this.writeTrace(1, "IfxFloat: toShort called");
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.value;
        this.writeTrace(1, "IfxFloat: toShort exited");
        return s;
    }

    public void fromShort(short s) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromShort called");
        this.value = s;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromShort exited");
    }

    public void fromShort(Short S) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromShort called");
        if (S == null) {
            this.nullify();
        } else {
            this.value = S.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromShort exited");
    }

    public int toInt() throws SQLException {
        this.writeTrace(1, "IfxFloat: toInt called");
        this.clearWarning();
        int i = this.isNull() ? 0 : (int)this.value;
        this.writeTrace(1, "IfxFloat: toInt exited");
        return i;
    }

    public void fromInt(int i) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromInt called");
        this.value = i;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromInt exited");
    }

    public void fromInt(Integer I) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromInt called");
        if (I == null) {
            this.nullify();
        } else {
            this.value = I.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromInt exited");
    }

    public long toLong() throws SQLException {
        this.writeTrace(1, "IfxFloat: toLong called");
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        this.writeTrace(1, "IfxFloat: toLong exited");
        return l;
    }

    public void fromLong(long l) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromLong called");
        this.value = l;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromLong exited");
    }

    public void fromLong(Long L) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromLong called");
        if (L == null) {
            this.nullify();
        } else {
            this.value = L.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromLong exited");
    }

    public float toFloat() throws SQLException {
        this.writeTrace(1, "IfxFloat: toFloat called");
        this.clearWarning();
        float f = this.isNull() ? 0.0f : (float)this.value;
        this.writeTrace(1, "IfxFloat: toFloat exited");
        return f;
    }

    public void fromFloat(float f) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromFloat called");
        this.value = f;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromFloat exited");
    }

    public void fromFloat(Float F) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromFloat called");
        if (F == null) {
            this.nullify();
        } else {
            this.value = F.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromFloat exited");
    }

    public BigDecimal toDecimal() throws SQLException {
        this.writeTrace(1, "IfxFloat: toDecimal called/exited");
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromBigDecimal called");
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.doubleValue();
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromBigDecimal exited");
    }

    public boolean toBoolean() throws SQLException {
        this.writeTrace(1, "IfxFloat: toBoolean called");
        boolean b = this.isNull() ? false : this.value != 0.0;
        this.writeTrace(1, "IfxFloat: toBoolean exited");
        return b;
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromBoolean called");
        this.value = b ? 1 : 0;
        this.unnullify();
        this.writeTrace(1, "IfxFloat: fromBoolean exited");
    }

    public void fromBoolean(Boolean b) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromBoolean called");
        if (b == null) {
            this.nullify();
        } else {
            this.value = b == true ? 1 : 0;
            this.unnullify();
        }
        this.writeTrace(1, "IfxFloat: fromBoolean exited");
    }

    public String toString() {
        this.writeTrace(1, "IfxFloat: toString called");
        String s = this.isNull() ? null : Double.toString(this.value);
        this.writeTrace(1, "IfxFloat: toString exited");
        return s;
    }

    public void fromString(String str) throws SQLException {
        this.writeTrace(1, "IfxFloat: fromString called");
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Double.valueOf(str.trim());
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        this.writeTrace(1, "IfxFloat: fromString exited");
    }

    static boolean isIfxNull(double d) {
        byte[] b = JavaToIfxType.JavaToIfxDouble(d);
        return IfxFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        int i = 0;
        while (i < 8) {
            if (b[i] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] b = new byte[8];
        double d = 0.0;
        int i = 0;
        while (i < 8) {
            b[i] = -1;
            d = IfxToJavaType.IfxToJavaDouble(b, (short)0);
            ++i;
        }
        return d;
    }
}

