/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class IfxDriver
implements Driver {
    private static Trace trace = null;
    private String errMsg;
    private int errNum;
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private String DbName;
    private String SubProtocol;
    private String OrigUrl;
    private String NewUrl;
    private String Proxy;
    private static final String JDBCRelVer = "1.50.J";

    public Connection connect(String url, Properties prop) throws SQLException {
        this.checkTracing(url, prop);
        if (this.checkURL(url)) {
            Properties newProp = new Properties();
            Connection conn = null;
            if (prop == null || ((Hashtable)prop).isEmpty()) {
                ((Hashtable)newProp).clear();
            } else {
                String key = null;
                Enumeration<?> e = prop.propertyNames();
                while (e.hasMoreElements()) {
                    key = e.nextElement().toString();
                    ((Hashtable)newProp).put(key.toUpperCase(), ((Hashtable)prop).get(key));
                }
                key = null;
            }
            this.getPropertiesFromUrl(url, newProp);
            try {
                Class[] classArgs = new Class[]{url.getClass(), newProp.getClass()};
                Class<?> clsRef = Class.forName(newProp.getProperty("CONNECTIONCLASS"));
                Constructor<?> cons = clsRef.getConstructor(classArgs);
                Object[] objs = new Object[]{this.NewUrl, newProp};
                conn = (Connection)cons.newInstance(objs);
            }
            catch (InvocationTargetException te) {
                throw (SQLException)te.getTargetException();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79704, e.toString(), null);
            }
            return conn;
        }
        return null;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.checkURL(url);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties prop) throws SQLException {
        String[] RequiredProperty = new String[]{"DATABASE", "INFORMIXSERVER", "USER", "PASSWORD"};
        Properties urlProp = new Properties();
        if (!this.checkURL(url)) {
            throw IfxErrMsg.getSQLException(-79705, this.errMsg, null);
        }
        this.getPropertiesFromUrl(url, urlProp);
        String key = null;
        Properties newProp = new Properties();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            ((Hashtable)newProp).put(key.toUpperCase(), ((Hashtable)prop).get(key));
        }
        key = null;
        DriverPropertyInfo[] inf = new DriverPropertyInfo[RequiredProperty.length];
        int j = 0;
        int i = 0;
        while (i < RequiredProperty.length) {
            if (((Hashtable)newProp).get(RequiredProperty[i]) == null && ((Hashtable)urlProp).get(RequiredProperty[i]) == null) {
                inf[j++] = new DriverPropertyInfo(RequiredProperty[i].toLowerCase(), null);
            }
            ++i;
        }
        DriverPropertyInfo[] infret = new DriverPropertyInfo[j];
        while (j-- > 0) {
            infret[j] = inf[j];
        }
        return infret;
    }

    public int getMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkURL(String url) throws SQLException {
        block28: {
            block29: {
                block30: {
                    block31: {
                        block27: {
                            checkSubprotocol = true;
                            this.DbName = null;
                            this.SubProtocol = null;
                            this.OrigUrl = null;
                            this.NewUrl = null;
                            IfxDriver.trace.writeTrace(1, "In IfxDriver:checkURL(" + url + ")");
                            if (url.indexOf(58) == -1) {
                                this.errNum = -80004;
                                this.errMsg = String.valueOf(IfxErrMsg.getMinorMsg(-80035, null)) + " '" + url + "'" + IfxErrMsg.getMinorMsg(-80004, null) + " ':'";
                                return false;
                            }
                            tok = new StringTokenizer(url, ":", true);
                            jdbc = tok.nextToken();
                            IfxDriver.trace.writeTrace(1, "  jdbc is " + jdbc);
                            if (!jdbc.equalsIgnoreCase("jdbc")) {
                                this.errNum = -79756;
                                this.errMsg = String.valueOf(IfxErrMsg.getMinorMsg(-80035, null)) + " '" + url + "' " + IfxErrMsg.getMessage(-79756, null);
                                IfxDriver.trace.writeTrace(2, "IfxDriver:checkURL(): " + this.errMsg);
                                return false;
                            }
                            delimchar = tok.nextToken();
                            addr = tok.nextToken();
                            IfxDriver.trace.writeTrace(1, "  addr: " + addr);
                            if (tok.hasMoreTokens()) {
                                delimchar = tok.nextToken();
                            }
                            if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
                                addr = addr.substring(2, addr.length());
                            }
                            if (addr.equals("informix-sqli")) {
                                jdkVersion = System.getProperty("java.version");
                                this.SubProtocol = new String("informix-sqli");
                                if (tok.hasMoreTokens()) {
                                    addr = tok.nextToken();
                                }
                                if (tok.hasMoreTokens()) {
                                    delimchar = tok.nextToken();
                                }
                            } else if (addr.equals("informix-direct")) {
                                this.SubProtocol = new String("informix-direct");
                                checkSubprotocol = false;
                                IfxDriver.trace.writeTrace(1, "  check tok for more tokens" + tok);
                                if (tok.hasMoreTokens()) {
                                    addr = tok.nextToken();
                                    IfxDriver.trace.writeTrace(1, "  has more " + addr);
                                    if (!addr.equals(":") && tok.hasMoreTokens()) {
                                        delimchar = tok.nextToken();
                                    }
                                } else {
                                    addr = null;
                                }
                            } else {
                                this.errNum = -79757;
                                this.errMsg = String.valueOf(IfxErrMsg.getMessage(-79757, null)) + ": '" + addr + "'";
                                IfxDriver.trace.writeTrace(2, "IfxDriver:checkURL(): " + this.errMsg);
                                return false;
                            }
                            if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
                                addr = addr.substring(2, addr.length());
                            }
                            if (checkSubprotocol) break block27;
                            if (addr != null && addr.length() > 0 && addr.charAt(0) == '/') {
                                dbAndOptionals = addr;
                                IfxDriver.trace.writeTrace(1, "  !checkSub " + addr);
                                portT = new StringTokenizer(dbAndOptionals, "/");
                                dbName = portT.nextToken();
                                IfxDriver.trace.writeTrace(1, "  valid dbname? " + dbName);
                                if (!this.validDatabaseIdentifier(dbName)) {
                                    this.errNum = -79760;
                                    this.errMsg = String.valueOf(IfxErrMsg.getMessage(-79760, null)) + ": '" + dbName + "'";
                                    IfxDriver.trace.writeTrace(2, "IfxDriver:checkURL(): " + this.errMsg);
                                    return false;
                                }
                                this.DbName = new String(dbName);
                                this.NewUrl = null;
                            }
                            break block28;
                        }
                        addrT = new StringTokenizer(addr, ".");
                        token1 = addrT.nextToken();
                        if (token1.indexOf("=") != -1) break block29;
                        if (token1.indexOf("/") != -1) break block30;
                        if (!this.isANum(token1)) ** GOTO lbl83
                        if (addrT.countTokens() == 3 && this.isAIPNum(token1)) ** GOTO lbl78
                        throw IfxErrMsg.getSQLException(-79758, ": '" + addr + "'", null);
lbl-1000:
                        // 1 sources

                        {
                            token1 = addrT.nextToken();
                            if (this.isAIPNum(token1)) continue;
                            throw IfxErrMsg.getSQLException(-79758, ": '" + addr + "'", null);
lbl78:
                            // 2 sources

                            ** while (addrT.hasMoreTokens())
                        }
lbl79:
                        // 1 sources

                        break block31;
lbl-1000:
                        // 1 sources

                        {
                            token1 = addrT.nextToken();
                            if (!this.isANum(token1)) continue;
                            throw IfxErrMsg.getSQLException(-79758, ": '" + addr + "'", null);
lbl83:
                            // 2 sources

                            ** while (addrT.hasMoreTokens())
                        }
                    }
                    if (!tok.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLException(-79705, null);
                    }
                    port = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        delimchar = tok.nextToken();
                    }
                    if (port != null && port.indexOf(47) == -1) {
                        if (!this.isANum(port)) {
                            throw IfxErrMsg.getSQLException(-79759, ": '" + port + "'", null);
                        }
                        this.NewUrl = new String(String.valueOf(addr) + ":" + port);
                    } else if (port != null) {
                        portT = new StringTokenizer(port, "/");
                        if (!this.isANum(port = portT.nextToken())) {
                            throw IfxErrMsg.getSQLException(-79759, ": '" + port + "'", null);
                        }
                        this.NewUrl = new String(String.valueOf(addr) + ":" + port);
                        dbName = portT.nextToken(":").substring(1);
                        if (dbName.charAt(0) == '/') {
                            dbName = dbName.substring(1, dbName.length());
                            portT = new StringTokenizer(dbName, "/");
                            portT.nextToken();
                            dbName = portT.nextToken();
                        }
                        if (!this.validDatabaseIdentifier(dbName)) {
                            throw IfxErrMsg.getSQLException(-79760, ": '" + dbName + "'", null);
                        }
                        this.DbName = new String(dbName);
                    }
                    break block28;
                }
                this.DbName = token1.substring(1, token1.length());
                this.NewUrl = null;
                break block28;
            }
            this.NewUrl = null;
        }
        this.OrigUrl = new String(url);
        IfxDriver.trace.writeTrace(1, "  OrigUrl" + this.OrigUrl);
        return true;
    }

    private boolean isAIPNum(String s) {
        try {
            int ip = Integer.parseInt(s);
            return ip >= 0 && ip <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isANum(String s) {
        try {
            Integer i = new Integer(s);
            return i >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void getPropertiesFromUrl(String url, Properties prop) {
        int a;
        int lastColon = -1;
        String propertiesStr = null;
        String propStr = null;
        StringTokenizer tok = null;
        StringTokenizer propT = null;
        if (((Hashtable)prop).get("DATABASE") == null && this.DbName != null) {
            ((Hashtable)prop).put("DATABASE", this.DbName);
        }
        if ((a = url.indexOf(61)) != -1) {
            int b = -1;
            while ((b = url.indexOf(58, (lastColon = b) + 1)) != -1 && b < a) {
            }
            if (lastColon == -1) {
                return;
            }
        }
        if ((propertiesStr = url.substring(lastColon + 1)) != null) {
            tok = new StringTokenizer(propertiesStr, ";");
        }
        if (propertiesStr != null && propertiesStr.indexOf(61) != -1 && tok.hasMoreTokens()) {
            while (tok.hasMoreTokens()) {
                propStr = tok.nextToken(";");
                propT = new StringTokenizer(propStr, "=");
                String key = propT.nextToken();
                String value = propT.nextToken(";").substring(1);
                trace.writeTrace(3, "IfxDriver:GetPropertiesfromUrl(): key = '" + key + "'  value = '" + value + "'");
                ((Hashtable)prop).put(key.toUpperCase(), value);
            }
        }
        if (this.SubProtocol.equals("informix-direct")) {
            if (((Hashtable)prop).get("PROTOCOLCLASS") == null) {
                ((Hashtable)prop).put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
                trace.writeTrace(3, "IfxDriver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.informix.jdbc.IfxDirectProtocol'");
            }
            if (((Hashtable)prop).get("CONNECTIONCLASS") == null) {
                ((Hashtable)prop).put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
                trace.writeTrace(3, "IfxDriver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.informix.jdbc.IfxDirectConnection'");
            }
            trace.writeTrace(3, "IfxDriver:database is " + ((Hashtable)prop).get("DATABASE"));
        } else {
            if (((Hashtable)prop).get("PROTOCOLCLASS") == null) {
                ((Hashtable)prop).put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (((Hashtable)prop).get("CONNECTIONCLASS") == null) {
                ((Hashtable)prop).put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
            trace.writeTrace(3, "IfxDriver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.informix.jdbc.IfxSqli'");
            trace.writeTrace(3, "IfxDriver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.informix.jdbc.IfxSqliConnect'");
        }
        this.Proxy = prop.getProperty("PROXY");
        if (this.Proxy != null) {
            this.formatProxy(this.Proxy);
            ((Hashtable)prop).put("PROXY", this.Proxy);
            trace.writeTrace(3, "IfxDriver:getPropertiesFromUrl(): PROXY set to '" + this.Proxy + "'");
        }
        ((Hashtable)prop).put("USERURL", this.OrigUrl);
        if (this.NewUrl == null && this.SubProtocol.equals("informix-direct")) {
            this.NewUrl = this.OrigUrl;
        }
    }

    private void checkTracing(String url, Properties prop) {
        short traceLevel;
        int index;
        String traceFile = prop.getProperty("TRACEFILE");
        String traceLevelString = prop.getProperty("TRACE");
        if ((traceFile == null || traceLevelString == null) && (index = url.indexOf("trace")) != -1) {
            String propStr = null;
            propStr = url.substring(index, url.length());
            StringTokenizer tok = new StringTokenizer(propStr, ";");
            while (tok.hasMoreTokens()) {
                String entry = tok.nextToken(";");
                if (entry.indexOf(61) == -1) continue;
                StringTokenizer propT = new StringTokenizer(entry, "=");
                String key = propT.nextToken();
                String value = propT.hasMoreTokens() ? propT.nextToken() : null;
                if (key.equals("tracefile")) {
                    traceFile = value;
                    continue;
                }
                if (!key.equals("trace")) continue;
                traceLevelString = value;
            }
        }
        try {
            Integer i = new Integer(traceLevelString);
            traceLevel = i.shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            traceLevel = 0;
        }
        if (traceFile != null && traceLevel > 0) {
            trace.setNewTraceFile(traceLevel, traceFile);
        }
    }

    private boolean validDatabaseIdentifier(String dbName) {
        int i = 1;
        int index = 0;
        String dbnam = null;
        index = dbName.lastIndexOf("/");
        dbnam = index != -1 ? dbName.substring(index + 1) : dbName;
        int len = dbnam.length();
        char c = dbnam.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        i = 1;
        while (i < len) {
            c = dbnam.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String calcReleaseNum() {
        return null;
    }

    public static String getJDBCVersion() throws SQLException {
        return "1.50.JC1";
    }

    static int getJDBCMajorVersion() throws SQLException {
        Integer major;
        String vers;
        try {
            vers = IfxDriver.getJDBCVersion();
        }
        catch (SQLException e) {
            trace.writeTrace(2, "IfxDriver:getJDBCMajorVersion(): caught exception: " + e.toString());
            throw e;
        }
        StringTokenizer tok = new StringTokenizer(vers, ".");
        String majorString = tok.nextToken();
        try {
            major = new Integer(majorString);
        }
        catch (NumberFormatException e) {
            trace.writeTrace(2, "IfxDriver:getJDBCMajorVersion(): caught exception: " + e.toString());
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        return major;
    }

    static int getJDBCMinorVersion() throws SQLException {
        Integer minor;
        String vers;
        try {
            vers = IfxDriver.getJDBCVersion();
        }
        catch (SQLException e) {
            trace.writeTrace(2, "IfxDriver:getJDBCMinorVersion(): caught exception: " + e.toString());
            throw e;
        }
        StringTokenizer tok = new StringTokenizer(vers, ".");
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        String minorString = tok.nextToken();
        try {
            minor = new Integer(minorString);
        }
        catch (NumberFormatException e) {
            trace.writeTrace(2, "IfxSqlConnect:getJDBCMinorVersion(): caught exception: " + e.toString());
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        return minor;
    }

    private boolean formatProxy(String s) {
        String strT = null;
        String defHost = null;
        StringBuffer sb = new StringBuffer("http://");
        try {
            defHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(s, "/");
        while (st.hasMoreTokens()) {
            strT = st.nextToken();
            if (strT.toUpperCase().indexOf("HTTP") != -1 || strT.toUpperCase().indexOf("SERVLET") != -1 || strT.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            defHost = strT;
        }
        sb.append(defHost);
        sb.append("/servlet/IfxJDBCProxy");
        this.Proxy = new String(sb.toString());
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException sQLException) {
            System.out.println(String.valueOf(IfxErrMsg.getMinorMsg(-80034, null)) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, null));
        }
        trace = new Trace();
    }
}

