/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxDistinctInput;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinct
extends IfxObject {
    IfxObject data;
    private static final short NO_SCALE = -1;
    private IfxDistinctInput inputStream;
    private IfxDistinctOutput outputStream;

    IfxDistinct() throws SQLException {
    }

    public void fromObject(Object obj) throws SQLException {
        this.fromObject(obj, -1);
    }

    public void fromObject(Object obj, int scale) throws SQLException {
        this.checkObject();
        if (obj == null || this.data == null) {
            this.nullify();
        } else {
            if (this.typeMap != null) {
                this.data.setTypeMap(this.typeMap);
            }
            if (this.outputStream == null) {
                this.outputStream = new IfxDistinctOutput(this.data);
            } else {
                this.outputStream.reset();
            }
            if (!(obj instanceof IfmxSQLData)) {
                if (scale == -1) {
                    this.data.fromObject(obj);
                } else {
                    this.data.fromObject(obj, scale);
                }
            } else {
                ((IfmxSQLData)obj).writeSQL(this.outputStream);
                String ename = ((IfmxSQLData)obj).getSQLTypeName();
                if (ename != null) {
                    this.setExtendedTypeName(ename);
                }
            }
            this.unnullify();
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.data instanceof IfxObject) {
            Class cls;
            if (this.typeMap == null || (cls = (Class)this.typeMap.get(this.extendedName)) == null) {
                return this.data.toObject();
            }
            IfmxSQLData obj = null;
            try {
                obj = (IfmxSQLData)cls.newInstance();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
            this.data.setTypeMap(this.typeMap);
            this.inputStream = new IfxDistinctInput(this.data);
            obj.readSQL(this.inputStream, this.extendedName);
            return obj;
        }
        throw IfxErrMsg.getSQLException(-79716, this.conn);
    }

    public void fromIfx(byte[] b) throws SQLException {
        this.checkObject();
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        this.data.fromIfx(b);
        this.checkNull();
    }

    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.checkObject();
        this.data = IfxValue.makeInstanceFromIfxType(this.conn, this.ifxType);
        this.data.fromIfx(b, prec);
        this.checkNull();
    }

    public byte[] toIfx() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfxTuple();
    }

    private void checkNull() {
        if (this.data == null || this.data.isNull()) {
            this.writeTrace(99, "IfxDistinct: data is null");
            this.nullify();
        } else {
            this.writeTrace(99, "IfxDistinct: data is not null");
            this.unnullify();
        }
    }

    private void checkObject() throws SQLException {
        if (this.data == null) {
            IfxColumnInfo colinfo = new IfxColumnInfo();
            colinfo.SQLtype = this.ifxType;
            colinfo.ExtendedOwner = this.extendedOwner;
            colinfo.ExtendedId = this.sourceType;
            colinfo.ExtendedName = this.ifxType == 40 || this.ifxType == 41 || this.ifxType == 44 || this.ifxType == 19 || this.ifxType == 20 || this.ifxType == 21 || this.ifxType == 22 ? this.conn.getXnameByXid(colinfo.ExtendedId) : this.extendedName;
            this.data = IfxValue.makeInstance(this.conn, colinfo);
            if (this.data == null) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.setIfxType(this.data.getIfxType());
        }
    }

    public int toInt() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toInt();
    }

    public void fromInt(int x) throws SQLException {
        this.checkObject();
        this.data.fromInt(x);
        this.checkNull();
    }

    public short toShort() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toShort();
    }

    public void fromShort(short x) throws SQLException {
        this.checkObject();
        this.data.fromShort(x);
        this.checkNull();
    }

    public String toString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    public void fromString(String x) throws SQLException {
        this.checkObject();
        this.data.fromString(x);
        this.checkNull();
    }

    public long toLong() throws SQLException {
        if (this.data == null) {
            return 0L;
        }
        return this.data.toLong();
    }

    public void fromLong(long x) throws SQLException {
        this.checkObject();
        this.data.fromLong(x);
        this.checkNull();
    }

    public void fromLong(Long x) throws SQLException {
        this.checkObject();
        this.data.fromLong(x);
        this.checkNull();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDecimal();
    }

    public void fromDecimal(BigDecimal x) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(x);
        this.checkNull();
    }

    public void fromDecimal(BigDecimal x, int scale) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(x, scale);
        this.checkNull();
    }

    public byte toByte() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toByte();
    }

    public void fromByte(Byte x) throws SQLException {
        this.checkObject();
        this.data.fromByte(x);
        this.checkNull();
    }

    public void fromByte(byte x) throws SQLException {
        this.checkObject();
        this.data.fromByte(x);
        this.checkNull();
    }

    public float toFloat() throws SQLException {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.toFloat();
    }

    public void fromFloat(Float x) throws SQLException {
        this.checkObject();
        this.data.fromFloat(x);
        this.checkNull();
    }

    public void fromFloat(float x) throws SQLException {
        this.checkObject();
        this.data.fromFloat(x);
        this.checkNull();
    }

    public double toDouble() throws SQLException {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.toDouble();
    }

    public void fromDouble(Double x) throws SQLException {
        this.checkObject();
        this.data.fromDouble(x);
        this.checkNull();
    }

    public void fromDouble(double x) throws SQLException {
        this.checkObject();
        this.data.fromDouble(x);
        this.checkNull();
    }

    public boolean toBoolean() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.data.toBoolean();
    }

    public void fromBoolean(Boolean x) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(x);
        this.checkNull();
    }

    public void fromBoolean(boolean x) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(x);
        this.checkNull();
    }

    public Time toTime() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTime();
    }

    public void fromTime(Time x) throws SQLException {
        this.checkObject();
        this.data.fromTime(x);
        this.checkNull();
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTimestamp();
    }

    public void fromTimestamp(Timestamp x) throws SQLException {
        this.checkObject();
        this.data.fromTimestamp(x);
        this.checkNull();
    }

    public Date toDate() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDate();
    }

    public void fromDate(Date x) throws SQLException {
        this.checkObject();
        this.data.fromDate(x);
        this.checkNull();
    }

    public InputStream toInputStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toInputStream();
    }

    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromInputStream(x, length);
        this.checkNull();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toAsciiStream();
    }

    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromAsciiStream(x, length);
        this.checkNull();
    }

    public InputStream toBinaryStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBinaryStream();
    }

    public void fromBinaryStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromBinaryStream(x, length);
        this.checkNull();
    }

    public IntervalYM toIntervalYM() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalYM();
    }

    public void fromIntervalYM(IntervalYM x) throws SQLException {
        this.checkObject();
        this.data.fromIntervalYM(x);
        this.checkNull();
    }

    public IntervalDF toIntervalDF() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalDF();
    }

    public void fromIntervalDF(IntervalDF x) throws SQLException {
        this.checkObject();
        this.data.fromIntervalDF(x);
        this.checkNull();
    }
}

