/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxDecimal
extends IfxObject {
    private BigDecimal value;
    private short encodedLength;
    protected short dec_exp;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts;
    protected byte[] dec_dgts;
    public static final String digChar = "0123456789";
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    public static final short BYTESHIFT = 8;
    public static final short BYTEMASK = 255;
    public static final short BYTESIGNED = 128;
    public static final short BYTEMASK7 = 127;
    private static final short DEFAULT_DOUBLE_SCALE = 15;
    private static final short DEFAULT_FLOAT_SCALE = 6;

    public IfxDecimal() throws SQLException {
        this.setIfxType(5);
    }

    public IfxDecimal(BigDecimal n) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        if (n == null) {
            this.nullify();
        } else {
            this.value = n;
            this.unnullify();
        }
    }

    public IfxDecimal(byte[] b) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        this.convBigDecimal(b);
    }

    public byte[] toIfx() {
        if (this.value == null) {
            byte[] cp = new byte[4];
            IfxDecimal.byfill(cp, (byte)0);
            this.nullify();
            this.writeTrace(3, "toIfx(): value is null");
            this.writeTrace(3, cp, 'H');
            return cp;
        }
        this.writeTrace(3, "toIfx(): value is not null and it is " + this.value);
        this.convFromString(this.value.toString());
        this.unnullify();
        return this.convIfx(true);
    }

    public byte[] toIfxTuple() {
        if (this.value == null) {
            int len = ((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
            byte[] b = new byte[len];
            IfxDecimal.byfill(b, (byte)0);
            this.nullify();
            return b;
        }
        this.convFromString(this.value.toString());
        this.unnullify();
        return this.convIfx(false);
    }

    public void fromIfx(byte[] b, short prec) {
        this.writeTrace(1, "IfxDecimal.toIfx() entering method");
        this.writeTrace(3, "   prec: " + prec);
        this.encodedLength = prec;
        this.convBigDecimal(b);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value.doubleValue();
    }

    public void fromByte(Byte val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromByte((byte)val);
        }
    }

    public void fromByte(Byte val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromByte((byte)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromByte(byte val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value.doubleValue();
    }

    public void fromShort(Short val) throws SQLException {
        this.encodedLength = (short)1280;
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
        }
    }

    public void fromShort(Short val, int scale) throws SQLException {
        this.encodedLength = (short)(1280 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromShort(short val) throws SQLException {
        this.encodedLength = (short)1280;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value.intValue();
    }

    public void fromInt(Integer val) throws SQLException {
        this.encodedLength = (short)2560;
        if (val == null) {
            this.nullify();
        } else {
            this.fromInt((int)val);
        }
    }

    public void fromInt(Integer val, int scale) throws SQLException {
        this.encodedLength = (short)(2560 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromInt((int)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromInt(int val) throws SQLException {
        this.encodedLength = (short)2560;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.longValue();
    }

    public void fromLong(Long val) throws SQLException {
        this.encodedLength = (short)4864;
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
        }
    }

    public void fromLong(Long val, int scale) throws SQLException {
        this.encodedLength = (short)(4864 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromLong(long val) throws SQLException {
        this.encodedLength = (short)4864;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public void fromFloat(Float val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromFloat(val.floatValue());
        }
    }

    public void fromFloat(Float val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(val.doubleValue());
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromFloat(float val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(val);
        this.value = this.value.setScale(6, 4);
        this.unnullify();
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    public void fromDouble(Double val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromDouble((double)val);
        }
    }

    public void fromDouble(Double val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromDouble(double val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(val);
        this.value = this.value.setScale(15, 4);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromDecimal(BigDecimal val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.setScale(scale, 4);
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal val, int scale, short encodedLength) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.setScale(scale, 4);
            this.encodedLength = encodedLength;
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.intValue() != 0;
    }

    public void fromBoolean(Boolean val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)val);
        }
    }

    public void fromBoolean(Boolean val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    public void fromBoolean(boolean val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)(val ? 1 : 0));
        this.unnullify();
    }

    public String toString() {
        this.writeTrace(1, "IfxDecimal.toString() called");
        if (this.value != null) {
            this.writeTrace(2, "   value.getScale(): " + this.value.scale());
        }
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String str) throws SQLException {
        this.encodedLength = 0;
        if (str == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(str.trim());
            this.unnullify();
        }
    }

    public void fromString(String str, int scale) throws SQLException {
        this.encodedLength = 0;
        if (str == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(str.trim());
            this.value = this.value.setScale(scale, 4);
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxDecimal && this.value.equals(((IfxDecimal)other).value);
    }

    public short getEncodedLength() {
        if (this.encodedLength == 0 && !this.isNull) {
            this.computeEncodedLength();
            return this.encodedLength;
        }
        return this.encodedLength;
    }

    public void setEncodedLength(int encodedLength) {
        this.encodedLength = (short)encodedLength;
    }

    private void convBigDecimal(byte[] b) {
        int scale;
        int start = 0;
        if (b[start] == 0 && b[start + 1] == 0) {
            this.value = null;
            return;
        }
        this.dec_ndgts = this.encodedLength == 0 ? (short)(b.length - start - 1) : (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        this.dec_dgts = new byte[this.dec_ndgts];
        IfxDecimal.bycopy(b, start + 1, this.dec_dgts, 0);
        short expon = b[start];
        this.dec_pos = 1;
        if ((expon & 0x80) == 0) {
            this.writeTrace(3, "decComplement(): before = {");
            this.writeTrace(3, this.dec_dgts, 'H');
            this.writeTrace(3, "}");
            IfxDecimal.decComplement(this.dec_dgts, 0);
            this.writeTrace(3, "decComplement(): after = {");
            this.writeTrace(3, this.dec_dgts, 'H');
            this.writeTrace(3, "}");
            expon = (short)(expon ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = expon = (short)((expon & 0x7F) - 64);
        this.writeTrace(3, "convBigDecimal(): encodedLength = " + this.encodedLength + " Internal network format = { ");
        this.writeTrace(3, b, 'H');
        this.writeTrace(3, "}");
        this.value = new BigDecimal(this.stringValue());
        if (this.encodedLength != 0 && (scale = IfxDecimal.precDec(this.encodedLength)) != 255) {
            this.value = this.value.setScale(scale, 4);
        }
        this.writeTrace(3, "convBigDecimal(): value = " + this.value);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    private void convFromString(String str) {
        int first = 0;
        int exp = 0;
        int buflen = str.length();
        boolean decPt = false;
        int upnxt = 0;
        this.dec_pos = 1;
        char nxt = str.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
        } else if (nxt == '+') {
            ++first;
        }
        if (first > 0) {
            --buflen;
        }
        int i = first;
        while (i < str.length() && str.charAt(i) != '.') {
            ++exp;
            ++i;
        }
        if (i != str.length()) {
            decPt = true;
            --buflen;
            exp += this.extractExponent(str, i);
        }
        if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        byte[] unpack = new byte[buflen];
        IfxDecimal.byfill(unpack, (byte)0);
        String adjustStr = upnxt == 1 ? "0" : "";
        i = 0;
        while (i < str.length() && str.charAt(i) != 'E') {
            int ind = digChar.indexOf(str.charAt(i));
            if (ind != -1) {
                unpack[upnxt] = (byte)ind;
                adjustStr = String.valueOf(adjustStr) + str.charAt(i);
                ++upnxt;
            }
            ++i;
        }
        unpack = this.adjust(unpack, adjustStr);
        buflen = unpack.length;
        this.dec_ndgts = (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int j = 0;
        while (j < this.dec_dgts.length) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
            ++j;
        }
        if (this.encodedLength == 0) {
            this.computeEncodedLength();
        } else {
            this.dec_ndgts = (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        }
        this.writeTrace(3, "convFromString(): " + str);
        this.writeTrace(3, "convFromString(): dec_pos = " + this.dec_pos);
        this.writeTrace(3, "convFromString(): dec_exp = " + this.dec_exp);
        this.writeTrace(3, "convFromString(): dec_ndgts = " + this.dec_ndgts);
        this.writeTrace(3, "dec_dgts = {");
        this.writeTrace(3, this.dec_dgts, 'H');
        this.writeTrace(3, "}");
    }

    private byte[] adjust(byte[] unpack, String s) {
        int ndgtsGood;
        int totalDigits;
        this.writeTrace(1, "IfxDecimal.adjust() entering");
        int scale = 0;
        if (this.encodedLength != 0) {
            totalDigits = IfxDecimal.precTot(this.encodedLength);
            ndgtsGood = totalDigits / 2;
            if (totalDigits % 2 == 1) {
                ++ndgtsGood;
            }
            scale = IfxDecimal.precDec(this.encodedLength) / 2;
        } else {
            totalDigits = 32;
            ndgtsGood = 16;
        }
        this.writeTrace(3, "  adjust() totalDigits: " + totalDigits);
        this.writeTrace(3, "  adjust() ndgtsGood: " + ndgtsGood);
        this.writeTrace(3, "  adjust() unpack.length: " + unpack.length);
        this.writeTrace(3, "  adjust() s: " + s);
        String x = "--";
        int i = 0;
        while (i < unpack.length) {
            x = String.valueOf(x) + unpack[i];
            ++i;
        }
        x = String.valueOf(x) + "--";
        this.writeTrace(3, "  adjust() unpack to string: " + x);
        byte[] b = unpack;
        if (unpack.length > totalDigits) {
            BigInteger bi = new BigInteger(s);
            BigInteger biTen = new BigInteger("10");
            BigInteger biDivide = new BigInteger("1");
            this.writeTrace(3, "  adjust() bi : " + bi);
            this.writeTrace(3, "  adjust() biTen : " + biTen);
            this.writeTrace(3, "  adjust() biDivide : " + biTen);
            this.writeTrace(3, "  adjust() unpack.length : " + unpack.length);
            this.writeTrace(3, "  adjust() unpack.length - totalDigits: " + (unpack.length - totalDigits));
            int i2 = 0;
            while (i2 < unpack.length - totalDigits) {
                biDivide = biDivide.multiply(biTen);
                ++i2;
            }
            BigInteger[] biAndRemainder = bi.divideAndRemainder(biDivide);
            this.writeTrace(3, "  adjust() biDivide : " + biDivide);
            this.writeTrace(3, "  adjust() biAndRemainder[0] : " + biAndRemainder[0]);
            this.writeTrace(3, "  adjust() biAndRemainder[1] : " + biAndRemainder[1]);
            int remainder = 0;
            if (unpack.length > totalDigits + 1) {
                remainder = unpack[totalDigits];
            }
            if (unpack.length > totalDigits + 2) {
                remainder *= 10;
                remainder += unpack[totalDigits + 1];
            }
            if (remainder >= 50) {
                biAndRemainder[0] = biAndRemainder[0].add(new BigInteger("1"));
            }
            String tmpStr = biAndRemainder[0].toString();
            this.writeTrace(3, "  new string: " + tmpStr);
            int index = 0;
            if (s.charAt(0) == '0') {
                ++index;
                tmpStr = String.valueOf(tmpStr) + "0";
            }
            byte[] newB = new byte[totalDigits];
            IfxDecimal.byfill(newB, (byte)0);
            int i3 = 0;
            while (index < totalDigits && i3 < tmpStr.length()) {
                int ind = digChar.indexOf(tmpStr.charAt(i3));
                if (ind != -1) {
                    newB[index] = (byte)ind;
                }
                ++i3;
                ++index;
            }
            b = newB;
        } else if (unpack.length < totalDigits && scale != 0 && this.encodedLength != 0) {
            b = new byte[totalDigits];
            IfxDecimal.byfill(b, (byte)0);
            System.arraycopy(unpack, 0, b, 0, unpack.length);
        }
        this.writeTrace(1, "IfxDecimal.adjust() leaving");
        return b;
    }

    protected void computeEncodedLength() {
        if (this.dec_ndgts == 0 || this.dec_pos == -1) {
            this.encodedLength = 0;
            return;
        }
        int scale = 2 * (this.dec_ndgts - this.dec_exp);
        int prec = 2 * this.dec_ndgts;
        if (this.dec_dgts[this.dec_ndgts - 1] % 10 == 0) {
            --scale;
            --prec;
        }
        if (this.dec_dgts[0] < 10) {
            --prec;
        }
        if (scale < 0) {
            prec += -scale;
            scale = 0;
        }
        this.encodedLength = (short)(((byte)prec << 8) + scale);
        this.writeTrace(3, "computeEncodedLength(): encodedLength = " + this.encodedLength);
        this.writeTrace(3, "computeEncodedLength(): scale = " + scale);
        this.writeTrace(3, "computeEncodedLength(): prec = " + prec);
    }

    protected int extractExponent(String num, int start) {
        int exp = 0;
        boolean sign = true;
        int i = start;
        while (i < num.length() && num.charAt(i) != 'E') {
            ++i;
        }
        if (i == num.length()) {
            return exp;
        }
        if (num.charAt(++i) == '+') {
            ++i;
        } else if (num.charAt(i) == '-') {
            ++i;
            sign = false;
        }
        int j = i;
        while (j < num.length()) {
            exp = exp * 10 + digChar.indexOf(num.charAt(j));
            ++j;
        }
        return sign ? exp : -exp;
    }

    private byte[] convIfx(boolean prependLength) {
        int prep = prependLength ? 2 : 0;
        byte[] cp = new byte[this.dec_ndgts + 1 + prep];
        boolean bp = false;
        IfxDecimal.byfill(cp, (byte)0);
        if (prependLength) {
            int len = this.dec_ndgts + 1;
            cp[0] = (byte)(len >> 8 & 0xFF);
            cp[1] = (byte)(len & 0xFF);
        }
        if (this.dec_pos == -1) {
            return cp;
        }
        cp[prep] = (byte)(this.dec_exp + 64 & 0x7F);
        IfxDecimal.bycopy(this.dec_dgts, 0, cp, prep + 1);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                int n = prep;
                cp[n] = (byte)(cp[n] | 0x80);
            } else {
                IfxDecimal.decComplement(cp, 1 + prep);
                int n = prep;
                cp[n] = (byte)(cp[n] ^ 0x7F);
            }
        } else {
            int n = prep;
            cp[n] = (byte)(cp[n] | 0x80);
        }
        this.writeTrace(3, "convIfx(): dec_pos = " + this.dec_pos);
        this.writeTrace(3, "convIfx(): dec_exp = " + this.dec_exp);
        this.writeTrace(3, "convIfx(): dec_ndgts = " + this.dec_ndgts);
        this.writeTrace(3, "dec_dgts = {");
        this.writeTrace(3, this.dec_dgts, 'H');
        this.writeTrace(3, "}");
        this.writeTrace(3, "Infromix network format = {");
        this.writeTrace(3, cp, 'H');
        this.writeTrace(3, "}");
        return cp;
    }

    private static byte[] byfill(byte[] b, byte f) {
        int i = 0;
        while (i < b.length) {
            b[i] = f;
            ++i;
        }
        return b;
    }

    private static char[] charfill(char[] b, int from, int to, char f) {
        int i = from;
        while (i <= to && i < b.length) {
            b[i] = f;
            ++i;
        }
        return b;
    }

    private static void bycopy(byte[] from, int fromStart, byte[] to, int toStart) {
        int j = toStart;
        int i = fromStart;
        while (i < from.length && j < to.length) {
            to[j] = from[i];
            ++i;
            ++j;
        }
    }

    private static void charcopy(char[] from, int fromStart, int fromEnd, char[] to, int toStart) {
        int j = toStart;
        int i = fromStart;
        while (i < from.length && i <= fromEnd && j < to.length) {
            to[j] = from[i];
            ++i;
            ++j;
        }
    }

    private static byte[] decComplement(byte[] b, int start) {
        int digit = 100;
        int bp = b.length - 1;
        while (bp >= start) {
            if (b[bp] != 0 || digit != 100) {
                b[bp] = (byte)(digit - b[bp]);
                digit = 99;
            }
            --bp;
        }
        return b;
    }

    private char[] sigdigToChar() {
        char[] digits = new char[this.dec_ndgts * 2];
        int i = 0;
        while (i < this.dec_ndgts) {
            digits[i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            digits[i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
            ++i;
        }
        this.writeTrace(3, "sigdigToChar(): digits = " + new String(digits));
        return digits;
    }

    private String stringValue() {
        char[] buf;
        if (this.dec_pos == -1) {
            return "";
        }
        int exp = this.dec_exp * 2;
        int whereDot = -1;
        if (this.dec_ndgts <= 0 && this.dec_exp == 0) {
            return "0.0";
        }
        char[] sigDig = this.sigdigToChar();
        if (exp > 0) {
            if (exp <= sigDig.length) {
                buf = new char[sigDig.length + 2];
                IfxDecimal.charcopy(sigDig, 0, exp - 1, buf, 1);
                buf[exp + 1] = 46;
                if (exp != sigDig.length) {
                    IfxDecimal.charcopy(sigDig, exp, sigDig.length - 1, buf, exp + 2);
                }
            } else {
                buf = new char[exp + 2];
                IfxDecimal.charcopy(sigDig, 0, sigDig.length - 1, buf, 1);
                IfxDecimal.charfill(buf, sigDig.length + 1, exp, '0');
                buf[exp + 1] = 46;
            }
        } else {
            buf = new char[(exp *= -1) + sigDig.length + 3];
            buf[1] = 48;
            buf[2] = 46;
            IfxDecimal.charfill(buf, 3, exp + 2, '0');
            IfxDecimal.charcopy(sigDig, 0, sigDig.length, buf, exp + 3);
        }
        this.writeTrace(3, "stringValue(): dec_pos = " + this.dec_pos);
        this.writeTrace(3, "stringValue(): dec_exp = " + this.dec_exp);
        this.writeTrace(3, "stringValue(): dec_ndgts = " + this.dec_ndgts);
        this.writeTrace(3, "stringValue(): buf = " + buf);
        this.writeTrace(3, "dec_dgts = {");
        this.writeTrace(3, this.dec_dgts, 'H');
        this.writeTrace(3, "}");
        char[] tbuf = IfxDecimal.trimZerosFB(buf, 1);
        tbuf[0] = this.dec_pos == 1 ? 48 : 45;
        return new String(tbuf);
    }

    private static char[] trimZerosFB(char[] ibuf, int start) {
        int left = start;
        while (left < ibuf.length && ibuf[left] == '0') {
            ++left;
        }
        if (left == ibuf.length) {
            char[] obuf2 = new char[2];
            obuf2[1] = 48;
            return obuf2;
        }
        int right = ibuf.length - 1;
        while (right >= left && ibuf[right] == '0') {
            --right;
        }
        char[] obuf = new char[right - left + 2];
        int j = 1;
        int i = left;
        while (i <= right) {
            obuf[j] = ibuf[i];
            ++i;
            ++j;
        }
        return obuf;
    }

    protected static int precTot(int length) {
        return length >> 8 & 0xFF;
    }

    protected static int precDec(int length) {
        return length & 0xFF;
    }

    protected static String getIfxTypeName(int length) {
        int precdec = IfxDecimal.precDec(length);
        if (precdec == 255) {
            return "decimal(16)";
        }
        return "decimal(" + IfxDecimal.precTot(length) + ", " + precdec + ")";
    }
}

