/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class IfxDateTime
extends IfxObject {
    private long value;
    private int nanos;
    private boolean isTime = false;
    private short qualifier;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    IfxDateTime(Time time) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        if (time != null) {
            this.value = time.getTime();
            this.isTime = true;
            this.unnullify();
        }
    }

    IfxDateTime(Timestamp timestamp) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        if (timestamp != null) {
            this.value = ((Date)timestamp).getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        if (this.isTime) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.value));
        }
        Timestamp ts = new Timestamp(this.value);
        ts.setNanos(this.nanos);
        return JavaToIfxType.JavaToIfxDateTime(ts);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] bindFormat = this.toIfx();
        return Decimal.fromBindToTuple(bindFormat, (short)this.encodedLength);
    }

    public void fromIfx(byte[] b, short prec) {
        if (b[0] == 0 && b[1] == 0) {
            this.nullify();
        } else {
            this.qualifier = prec;
            Timestamp ts = IfxToJavaType.IfxToJavaDateTime(b, prec);
            this.value = ((Date)ts).getTime();
            if (IfxDateTime.getStartCode(this.qualifier) >= 6) {
                this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
                this.nanos = 0;
                this.isTime = true;
            } else {
                this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
                this.nanos = ts.getNanos();
                this.isTime = false;
            }
            this.unnullify();
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            return new Time(this.value);
        }
        Timestamp ts = new Timestamp(this.value);
        ts.setNanos(this.nanos);
        return ts;
    }

    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.value);
    }

    public void fromDate(java.sql.Date date) throws SQLException {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date.getTime();
            this.nanos = 0;
            this.isTime = false;
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp ts = new Timestamp(this.value);
        ts.setNanos(this.nanos);
        return ts;
    }

    public void fromTimestamp(Timestamp ts) throws SQLException {
        if (ts == null) {
            this.nullify();
        } else {
            this.value = ((Date)ts).getTime();
            this.nanos = ts.getNanos();
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
            this.unnullify();
        }
    }

    public void fromTimestamp(Timestamp ts, short qual) throws SQLException {
        if (ts == null) {
            this.nullify();
        } else {
            this.value = ((Date)ts).getTime();
            this.nanos = ts.getNanos();
            this.isTime = false;
            this.qualifier = qual;
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.value);
    }

    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            this.value = time.getTime();
            this.isTime = true;
            this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
            this.unnullify();
        }
    }

    public String toString() {
        String s = null;
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            Time time = new Time(this.value);
            s = time.toString();
        } else {
            try {
                Timestamp ts = this.toTimestamp();
                s = ts.toString();
            }
            catch (Exception exception) {
                s = null;
            }
        }
        return s;
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            String nstr = str.trim();
            try {
                Timestamp ts = Timestamp.valueOf(nstr);
                this.value = ((Date)ts).getTime();
                this.nanos = ts.getNanos();
                this.isTime = false;
                this.unnullify();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    Time t = Time.valueOf(nstr);
                    this.value = t.getTime();
                    this.nanos = 0;
                    this.isTime = true;
                    this.unnullify();
                }
                catch (Exception ee) {
                    this.nullify();
                    this.value = 0L;
                    this.nanos = 0;
                    throw IfxErrMsg.getSQLException(-79716, ee.toString(), this.conn);
                }
            }
            catch (Exception e) {
                this.nullify();
                this.value = 0L;
                this.nanos = 0;
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxDateTime) {
            IfxDateTime dtOther = (IfxDateTime)other;
            if (dtOther.isNull()) {
                return false;
            }
            if (dtOther.value == this.value && dtOther.nanos == this.nanos) {
                return true;
            }
        }
        return false;
    }

    static short getQualifier(byte startCode, byte endCode) {
        short length = (short)(endCode - startCode + (startCode == 0 ? 4 : 2));
        short qual = (short)((byte)length << 8 | startCode << 4 | endCode);
        return qual;
    }

    static byte getStartCode(short qual) {
        byte startCode = (byte)(qual >> 4 & 0xF);
        return startCode;
    }

    static byte getEndCode(short qualifier) {
        byte endCode = (byte)(qualifier & 0xF);
        return endCode;
    }

    public short getEncodedLength() {
        if (this.qualifier == 0) {
            byte startCode = 0;
            byte endCode = 15;
            this.qualifier = IfxDateTime.getQualifier(startCode, endCode);
        }
        return this.qualifier;
    }

    static String getQualifierName(short qual) {
        if (qual == 0) {
            return null;
        }
        byte startCode = IfxDateTime.getStartCode(qual);
        byte endCode = IfxDateTime.getEndCode(qual);
        String s = IfxDateTime.getFieldName(startCode);
        s = String.valueOf(s) + " to ";
        s = String.valueOf(s) + IfxDateTime.getFieldName(endCode);
        return s;
    }

    static String getFieldName(byte x) {
        switch (x) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.isTime;
    }
}

