/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class IfxDate
extends IfxObject {
    private java.sql.Date value;
    public static final int IFX_DATE_NULL = Integer.MIN_VALUE;

    IfxDate() throws SQLException {
        this.setIfxType(7);
    }

    IfxDate(java.sql.Date date) throws SQLException {
        this.setIfxType(7);
        this.value = date;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public java.sql.Date value() {
        return this.value;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] ret = new byte[4];
            memoryUtil.byfill(ret, (byte)0);
            ret[0] = -128;
            return ret;
        }
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    public void fromIfx(byte[] b) {
        this.value = IfxToJavaType.IfxToJavaDate(b, (short)0);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public String toString() {
        String dateStr = null;
        if (this.isNull()) {
            return null;
        }
        try {
            dateStr = dateUtil.convertDateStr(this.value, this.conn);
        }
        catch (SQLException sQLException) {
            dateStr = null;
            return null;
        }
        return dateStr;
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
            return;
        }
        try {
            this.value = dateUtil.convertDateObj(str.trim(), this.conn);
            this.unnullify();
        }
        catch (IllegalArgumentException e) {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.value.getTime());
    }

    public void fromTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = new java.sql.Date(((Date)timestamp).getTime());
            this.unnullify();
        }
    }

    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromDate(java.sql.Date date) {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date;
            this.unnullify();
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxDate)) {
            return false;
        }
        IfxDate otherDate = (IfxDate)other;
        if (otherDate.isNull()) {
            return false;
        }
        return this.value.equals(otherDate.value);
    }
}

