/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDbMetaDataResultSet;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.mdinfo;
import com.informix.jdbc.rowinfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Stack;
import java.util.Vector;

public class IfxDatabaseMetaData
implements DatabaseMetaData {
    private IfxConnection conn;
    private Trace trace;
    private Stack stmtStack;
    private static int nextTempTableId;
    private static int nMdInfoRows;
    private static int nStdRowTypes;
    private static int nXtdRowTypes;
    private static int nXtdRowTypesSupported;
    private static mdinfo[] lmd;
    private static rowinfo[] lrow;

    private synchronized String nextTempTableName() {
        String s = "dbmd" + nextTempTableId;
        ++nextTempTableId;
        return s;
    }

    IfxDatabaseMetaData(IfxConnection thisconn) {
        this.conn = thisconn;
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getURL(): call IfxConnection:getURL()");
        if (this.conn != null) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getURL(): call IfxConnection:getURL()");
            return this.conn.getURL();
        }
        return null;
    }

    public String getUserName() throws SQLException {
        if (this.conn != null) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getUserName(): call IfxConnection:getUserName()");
            return this.conn.getUserName();
        }
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    public String getDatabaseProductName() throws SQLException {
        if (this.conn != null) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseProductVersion(): call IfxConnection:getDbVersion()");
            return this.conn.getDbProductName();
        }
        return "Informix Dynamic Server";
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.conn != null) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseProductVersion(): call IfxConnection:getDbVersion()");
            return this.conn.getDbVersion();
        }
        return null;
    }

    public String getDriverName() throws SQLException {
        return "Informix JDBC Driver for Informix Dynamic Server";
    }

    public String getDriverVersion() throws SQLException {
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getDriverVersion(): call IfxDriver:getJDBCVersion()");
        return IfxDriver.getJDBCVersion();
    }

    public int getDriverMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getDriverMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        return !this.conn.isOnLine();
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return !this.conn.isOnLine();
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn == null || !this.conn.isDelimIdentSet()) {
            return " ";
        }
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "after,ansi,append,attach,audit,before,bitmap,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload";
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,mod,pow,root,round,sqrt,exp,logn,log10,cos,sin,tan,asin,acos,atan,atan2";
    }

    public String getStringFunctions() throws SQLException {
        return "trunc,length";
    }

    public String getSystemFunctions() throws SQLException {
        return "avg,max,min,sum,count,range,stdev,variance,trim,hex,filetoblob,filetoclob,lotofile,lotocopy";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "date,day,month,weekday,year,extend,mdy";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        if (this.conn == null) {
            return "";
        }
        if (this.conn.isLongID()) {
            return "$";
        }
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "user";
    }

    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ":";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 256;
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxIndexLength() throws SQLException {
        return 255;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxRowSize() throws SQLException {
        return Short.MAX_VALUE;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 32;
        }
        return 8;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn == null) {
            return 0;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getDefaultTransactionIsolation(): call IfxConnection:getDatabaseType()");
        int type = this.conn.getDatabaseType();
        if (type == 1) {
            return 4;
        }
        if (type == 2) {
            return 2;
        }
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.conn == null) {
            return false;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:supportsTransactionIsolationLevel(): call IfxConnection:getDatabaseType()");
        int type = this.conn.getDatabaseType();
        return type == 1 || type == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedures() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (schemaPattern == null || schemaPattern == "") {
            schemaPattern = "%";
        }
        if (procedureNamePattern == null || procedureNamePattern == "") {
            procedureNamePattern = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            schemaPattern = schemaPattern.toLowerCase();
            procedureNamePattern = procedureNamePattern.toLowerCase();
        }
        IfxStatement procedureStatement = (IfxStatement)this.conn.createStatement();
        procedureStatement.setAutoFree(true);
        String dbName = "'" + this.conn.getDbName() + "'";
        String query = "select unique " + dbName + " as PROCEDURE_CAT, " + "owner" + " as PROCEDURE_SCHEMA, " + "procname as PROCEDURE_NAME, " + "'' as RESERVED1, " + "'' as RESERVED2, " + "'' as RESERVED3, " + "'' as REMARKS, " + "0 as PROCEDURE_TYPE from informix.sysprocedures where " + "procname like '" + procedureNamePattern + "' " + "and owner like '" + schemaPattern + "'" + " order by 2, 3";
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedures() : call IfxStatement:executeQuery(" + query + ")");
        ResultSet results = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? procedureStatement.executeQuery(query, true) : procedureStatement.executeQuery(query, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(results, this.conn);
        return RS;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String tempTable = this.nextTempTableName();
        boolean t = false;
        boolean v = false;
        boolean s = false;
        boolean p = false;
        int cnt = 0;
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTables() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaPattern == null || schemaPattern == "") {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern == "") {
            tableNamePattern = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            tableNamePattern = tableNamePattern.toLowerCase();
            schemaPattern = schemaPattern.toLowerCase();
        }
        if (types != null) {
            int i = 0;
            while (i < types.length && types[i] != null) {
                if (types[i].equalsIgnoreCase("TABLE")) {
                    t = true;
                    ++cnt;
                } else if (types[i].equalsIgnoreCase("VIEW")) {
                    v = true;
                    ++cnt;
                } else if (types[i].equalsIgnoreCase("SYNONYM") && isModeAnsi) {
                    p = true;
                    ++cnt;
                } else if (types[i].equalsIgnoreCase("SYNONYM")) {
                    s = true;
                    ++cnt;
                }
                ++i;
            }
        }
        String dbName = "'" + this.conn.getDbName() + "'";
        IfxStatement getTablesStatement1 = null;
        IfxStatement getTablesStatement2 = null;
        try {
            getTablesStatement1 = (IfxStatement)this.conn.createStatement();
            getTablesStatement2 = (IfxStatement)this.conn.createStatement();
            getTablesStatement1.setAutoFree(true);
            getTablesStatement2.setAutoFree(true);
            if (this.conn.isOnLine()) {
                getTablesStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat    varchar(129), " + "  table_schem  varchar(129), " + "  table_name   varchar(129), " + "  table_type   varchar(129), " + "  remarks      varchar(129)) ");
            } else {
                getTablesStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat    char(18), " + "  table_schem  char(18), " + "  table_name   char(40), " + "  table_type   char(18), " + "  remarks      char(18)) ");
            }
            String sql = "select tabname, tabtype, owner from informix.systables where tabid > 99 ";
            int origCnt = cnt;
            if (cnt > 0) {
                sql = String.valueOf(sql) + "and tabtype in (";
            }
            if (t) {
                sql = String.valueOf(sql) + "'T'";
                if (--cnt > 0) {
                    sql = String.valueOf(sql) + ",";
                }
            }
            if (v) {
                sql = String.valueOf(sql) + "'V'";
                if (--cnt > 0) {
                    sql = String.valueOf(sql) + ",";
                }
            }
            if (s) {
                sql = String.valueOf(sql) + "'S'";
                if (--cnt > 0) {
                    sql = String.valueOf(sql) + ",";
                }
            }
            if (p) {
                sql = String.valueOf(sql) + "'P'";
            }
            if (origCnt > 0) {
                sql = String.valueOf(sql) + ")";
            }
            if (tableNamePattern != null) {
                sql = String.valueOf(sql) + " and tabname like '" + tableNamePattern + "'";
            }
            if (schemaPattern != null) {
                sql = String.valueOf(sql) + " and owner like " + "'" + schemaPattern + "'";
            }
            ResultSet rs = getTablesStatement1.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                String typ;
                String tabname = rs.getString(1);
                String tabtype = rs.getString(2);
                String owner = rs.getString(3);
                switch (tabtype.charAt(0)) {
                    case 'T': {
                        typ = "TABLE";
                        break;
                    }
                    case 'V': {
                        typ = "VIEW";
                        break;
                    }
                    case 'P': 
                    case 'S': {
                        typ = "SYNONYM";
                        break;
                    }
                    case 'L': {
                        typ = "LOG";
                        break;
                    }
                    default: {
                        typ = "UNKNOWN";
                    }
                }
                getTablesStatement2.executeUpdate("insert into " + tempTable + " values( " + dbName + ", '" + owner + "', '" + tabname + "', '" + typ + "', null )");
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 4, 2, 3";
        ResultSet results = origAC && isModeAnsi ? getTablesStatement1.executeQuery(qry, true) : getTablesStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(results, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        tempTable = null;
        return RS;
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getSchemas() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        IfxStatement schemaStatement = (IfxStatement)this.conn.createStatement();
        schemaStatement.setAutoFree(true);
        String query = "select unique owner as TABLE_SCHEM from informix.systables where tabtype != \"\" order by 1";
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getSchemas() : call IfxStatement:executeQuery(" + query + ")");
        ResultSet results = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? schemaStatement.executeQuery(query, true) : schemaStatement.executeQuery(query, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(results, this.conn);
        return RS;
    }

    public ResultSet getCatalogs() throws SQLException {
        IfxClientResultSet dbCrs;
        IfxProtocol prot;
        int numDbs = 0;
        this.trace.writeTrace(2, "getCatalogs called");
        if (this.conn == null) {
            return null;
        }
        try {
            Class[] classArgs = new Class[]{this.conn.getClass()};
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Constructor<?> cons = classRef.getConstructor(classArgs);
            Object[] objs = new Object[]{this.conn};
            prot = (IfxProtocol)cons.newInstance(objs);
            if (prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
        try {
            prot.executeGetDBList();
            IfxResultSetMetaData dbRsmd = new IfxResultSetMetaData(1, this.conn);
            dbRsmd.setEncodedLength(1, 128);
            dbRsmd.setNullable(1, false);
            dbRsmd.setMaxWidth(1, 128);
            dbRsmd.setColtitle(1, "DB Name");
            dbRsmd.setColumnName(1, "Database");
            dbRsmd.setIfxColumnType(1, 0);
            dbCrs = new IfxClientResultSet(this.conn, dbRsmd);
            Vector tDBlist = prot.getDBList();
            numDbs = tDBlist.size();
            this.trace.writeTrace(2, "Number of databases is " + numDbs);
            if (numDbs > 0) {
                dbCrs.newRow(numDbs);
                int i = 0;
                while (i < numDbs) {
                    dbCrs.updateString(i + 1, 1, (String)tDBlist.elementAt(i) != null ? stringUtil.trimTrailings((String)tDBlist.elementAt(i)) : null);
                    this.trace.writeTrace(3, "dbname put in resultset " + (String)tDBlist.elementAt(i));
                    ++i;
                }
                dbCrs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            this.trace.writeTrace(2, "Error in accessing vector of db names");
            throw ex;
        }
        this.trace.writeTrace(2, " getCatalogs exitted ");
        return dbCrs;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTableTypes() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        IfxStatement tableTypeStatement = (IfxStatement)this.conn.createStatement();
        tableTypeStatement.setAutoFree(true);
        String q1 = this.conn.getDatabaseType() == 1 ? "select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'" : "select unique 'PRIVATE_SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'";
        String query = "select unique 'TABLE' as TABLE_TYPE from informix.systables where tabtype = 'T' union select unique 'VIEW' as TABLE_TYPE from informix.systables where tabtype = 'V' union select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'S' union " + q1;
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTableTypes() : call IfxStatement:executeQuery(" + query + ")");
        ResultSet rs = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? tableTypeStatement.executeQuery(query, true) : tableTypeStatement.executeQuery(query, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, this.conn);
        return RS;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getColumns() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaPattern == null || schemaPattern == "") {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern == "") {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null || columnNamePattern == "") {
            columnNamePattern = "%";
        }
        IfxStatement columnStatement1 = null;
        IfxStatement columnStatement2 = null;
        try {
            columnStatement1 = (IfxStatement)this.conn.createStatement();
            columnStatement2 = (IfxStatement)this.conn.createStatement();
            columnStatement1.setAutoFree(true);
            columnStatement2.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isOnLine()) {
                columnStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat          char(50), " + "  table_schem        char(50), " + "  table_name         char(50), " + "  column_name        char(50), " + "  data_type          smallint, " + "  type_name          char(50), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         char(18), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) )");
            } else {
                columnStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat          varchar(129), " + "  table_schem        varchar(129), " + "  table_name         varchar(129), " + "  column_name        varchar(129), " + "  data_type          smallint, " + "  type_name          varchar(129), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         char(18), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) )");
            }
            if (tableNamePattern != null) {
                if (!this.conn.isDelimIdentSet()) {
                    tableNamePattern = tableNamePattern.toLowerCase();
                }
                tableNamePattern = tableNamePattern.trim();
            } else {
                tableNamePattern = "*";
            }
            if (columnNamePattern != null) {
                if (!this.conn.isDelimIdentSet()) {
                    columnNamePattern = columnNamePattern.toLowerCase();
                }
                columnNamePattern = columnNamePattern.trim();
            } else {
                columnNamePattern = "";
            }
            if (!this.conn.isDelimIdentSet()) {
                schemaPattern = schemaPattern.toLowerCase();
            }
            String sql = null;
            sql = this.conn.isUSVER() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner, sx.name from informix.systables st, informix.syscolumns sc,  outer informix.sysxtdtypes sx where st.tabname like '" + tableNamePattern + "' and st.owner like " + "'" + schemaPattern + "' and st.tabid = sc.tabid " + "  and sc.extended_id = sx.extended_id " : (this.conn.isOnLine() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner from informix.systables st, informix.syscolumns sc where st.tabname like '" + tableNamePattern + "' and st.owner like " + "'" + schemaPattern + "' and st.tabid = sc.tabid " : "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength, st.owner from informix.systables st, informix.syscolumns sc where st.tabname like '" + tableNamePattern + "' and st.owner like " + "'" + schemaPattern + "' and st.tabid = sc.tabid ");
            if (columnNamePattern.length() > 0) {
                sql = String.valueOf(sql) + " and sc.colname like '" + columnNamePattern + "'";
            }
            rs = columnStatement1.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                short coltype = rs.getShort(4);
                short umaskcoltype = (short)(coltype & 0xFF);
                short collength = rs.getShort(5);
                int colsize = umaskcoltype == 5 || umaskcoltype == 8 ? collength / 256 : (int)collength;
                String tabOwner = this.conn.isOnLine() ? rs.getString(8) : rs.getString(6);
                String ifxTypeName = IfxTypes.IfxTypeToName(umaskcoltype);
                if (this.conn.isUSVER()) {
                    if (umaskcoltype == 41 || umaskcoltype == 40) {
                        ifxTypeName = rs.getString(9);
                    }
                    if ((coltype & 0x800) == 2048) {
                        ifxTypeName = rs.getString(9);
                    }
                }
                ifxTypeName = ifxTypeName.trim();
                int jdbcType = IfxTypes.FromIfxToJDBCType(umaskcoltype);
                if (this.conn.isUSVER()) {
                    if ((coltype & 0x800) == 2048) {
                        jdbcType = 2001;
                    }
                    if (ifxTypeName.equals("boolean")) {
                        jdbcType = 1111;
                    } else if (ifxTypeName.equals("lvarchar")) {
                        jdbcType = -1;
                    } else if (ifxTypeName.equals("blob")) {
                        jdbcType = 2004;
                    } else if (ifxTypeName.equals("clob")) {
                        jdbcType = 2005;
                    }
                }
                int numPrecRad = 0;
                int decDig = 0;
                if (umaskcoltype == 1 || umaskcoltype == 2 || umaskcoltype == 6) {
                    decDig = 2;
                    numPrecRad = 10;
                } else if (this.conn.isUSVER() && (umaskcoltype == 17 || umaskcoltype == 18)) {
                    numPrecRad = 10;
                } else if (umaskcoltype == 5 || umaskcoltype == 8) {
                    decDig = collength - collength / 256 * 256;
                    numPrecRad = 10;
                } else if (umaskcoltype == 3) {
                    decDig = 15;
                    numPrecRad = 10;
                } else if (umaskcoltype == 4) {
                    decDig = 7;
                    numPrecRad = 10;
                } else if (this.conn.isUSVER() && umaskcoltype == 41 && (ifxTypeName.equals("boolean") || (coltype & 0x4000) == 16384)) {
                    numPrecRad = 2;
                }
                int nullable = 1;
                String isnullable = "YES";
                if ((coltype & 0x100) == 256) {
                    nullable = 0;
                    isnullable = "NO";
                }
                short octetlen = 0;
                if (umaskcoltype == 0) {
                    octetlen = collength;
                }
                columnStatement2.executeUpdate("insert into " + tempTable + " values( " + dbName + ", '" + tabOwner + "', " + "'" + rs.getString(1) + "', '" + rs.getString(2) + "'," + jdbcType + ", '" + ifxTypeName + "', " + colsize + "," + "0," + decDig + "," + numPrecRad + "," + nullable + "," + "null," + "null," + "0," + "0," + octetlen + "," + rs.getShort(3) + ", '" + isnullable + "' )");
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 2,3,17";
        rs = origAC && isModeAnsi ? columnStatement1.executeQuery(qry, true) : columnStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getColumnPrivileges(String catalog, String schemaName, String table, String column) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        String grantable = "NO";
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getColumnPrivileges() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaName == null || schemaName == "") {
            schemaName = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        if (column == null || column == "") {
            column = "%";
        }
        IfxStatement columnPrivStatement1 = null;
        IfxStatement columnPrivStatement2 = null;
        try {
            columnPrivStatement1 = (IfxStatement)this.conn.createStatement();
            columnPrivStatement2 = (IfxStatement)this.conn.createStatement();
            columnPrivStatement1.setAutoFree(true);
            columnPrivStatement2.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (this.conn.isOnLine()) {
                columnPrivStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  column_name   varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            } else {
                columnPrivStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat     char(50), " + "  table_schem   char(50), " + "  table_name    char(50), " + "  column_name   char(18), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            if (table != null && !this.conn.isDelimIdentSet()) {
                table = table.toLowerCase();
            }
            if (column != null && !this.conn.isDelimIdentSet()) {
                column = column.toLowerCase();
            }
            if (schemaName != null && !this.conn.isDelimIdentSet()) {
                schemaName = schemaName.toLowerCase();
            }
            rs = columnPrivStatement1.executeQuery("select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from informix.systables st, informix.syscolumns sc, informix.syscolauth sa where st.tabname = '" + table + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + column + "' and sc.colno = sa.colno " + "and st.owner like '" + schemaName + "'" + "union " + "select sc.colname, sa.grantor, sa.grantee, sa.tabauth, " + "st.tabname, st.owner from informix.systables st, " + "informix.syscolumns sc, informix.systabauth sa where " + "st.tabname = '" + table + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + column + "' and st.owner like '" + schemaName + "'" + " order by 1");
            String colname = "";
            String privList = "";
            while (rs.next()) {
                String prevcolname = colname;
                colname = rs.getString(1);
                String colauth = rs.getString(4);
                if (colname != null) {
                    colname = colname.trim();
                }
                if (colauth != null) {
                    colauth = colauth.trim();
                }
                if (!colname.equals(prevcolname)) {
                    privList = "";
                }
                int i = 0;
                while (i < colauth.length()) {
                    String priv = null;
                    char c = colauth.charAt(i);
                    switch (c) {
                        case 'R': 
                        case 'r': {
                            if (privList.indexOf(c) != -1) break;
                            privList = String.valueOf(privList) + "r";
                            priv = "REFERENCES";
                            break;
                        }
                        case 'S': 
                        case 's': {
                            if (privList.indexOf(c) != -1) break;
                            privList = String.valueOf(privList) + "s";
                            priv = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            if (privList.indexOf(c) != -1) break;
                            privList = String.valueOf(privList) + "u";
                            priv = "UPDATE";
                            break;
                        }
                    }
                    if (priv != null) {
                        grantable = Character.isUpperCase(c) ? "YES" : "NO";
                        String grantor = rs.getString(2);
                        grantor = rs.wasNull() || grantor.length() < 1 ? "null" : "'" + grantor + "'";
                        columnPrivStatement2.executeUpdate("insert into " + tempTable + " values( " + dbName + ", '" + rs.getString(6) + "', '" + rs.getString(5) + "', '" + rs.getString(1) + "', " + grantor + ", '" + rs.getString(3) + "', '" + priv + "', '" + grantable + "' )");
                    }
                    ++i;
                }
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 4, 7";
        rs = origAC && isModeAnsi ? columnPrivStatement1.executeQuery(qry, true) : columnPrivStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        String grantable = "NO";
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTablePrivileges() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaPattern == null || schemaPattern == "") {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern == "") {
            tableNamePattern = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            tableNamePattern = tableNamePattern.toLowerCase();
            schemaPattern = schemaPattern.toLowerCase();
        }
        IfxStatement privilegeStatement1 = null;
        IfxStatement privilegeStatement2 = null;
        try {
            privilegeStatement1 = (IfxStatement)this.conn.createStatement();
            privilegeStatement2 = (IfxStatement)this.conn.createStatement();
            privilegeStatement1.setAutoFree(true);
            privilegeStatement2.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                tableNamePattern = tableNamePattern.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                privilegeStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            } else {
                privilegeStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat     char(18), " + "  table_schem   char(18), " + "  table_name    char(40), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            rs = privilegeStatement1.executeQuery("select st.tabname,  sa.grantor, sa.grantee, sa.tabauth, st.owner from informix.systables st, informix.systabauth sa where st.tabname like '" + tableNamePattern + "' and " + "st.tabid = sa.tabid and st.owner like '" + schemaPattern + "'");
            while (rs.next()) {
                String tabname = rs.getString(1);
                String grantor = rs.getString(3);
                String grantee = rs.getString(3);
                String tabauth = rs.getString(4);
                int i = 0;
                while (i < tabauth.length()) {
                    String priv = null;
                    char c = tabauth.charAt(i);
                    switch (c) {
                        case 'S': 
                        case 's': {
                            priv = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            priv = "UPDATE";
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            priv = "INSERT";
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            priv = "DELETE";
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            priv = "INDEX";
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            priv = "ALTER";
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            priv = "REFERENCES";
                            break;
                        }
                        case 'N': 
                        case 'n': {
                            priv = "UNDER";
                            break;
                        }
                    }
                    if (priv != null) {
                        grantable = Character.isUpperCase(c) ? "YES" : "NO";
                        privilegeStatement2.executeUpdate("insert into " + tempTable + " values( " + dbName + ", '" + rs.getString(5) + "', '" + tabname + "', '" + grantor + "', '" + grantee + "', '" + priv + "', '" + grantable + "' )");
                    }
                    ++i;
                }
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 3, 6, 4, 5, 7";
        rs = origAC && isModeAnsi ? privilegeStatement1.executeQuery(qry, true) : privilegeStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getBestRowIdentifier() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schema == null || schema == "") {
            schema = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        IfxStatement rowIDStatement1 = null;
        IfxStatement rowIDStatement2 = null;
        try {
            String tableLower;
            rowIDStatement1 = (IfxStatement)this.conn.createStatement();
            rowIDStatement2 = (IfxStatement)this.conn.createStatement();
            rowIDStatement1.setAutoFree(true);
            rowIDStatement2.setAutoFree(true);
            if (!this.conn.isDelimIdentSet()) {
                tableLower = table.toLowerCase();
                schema = schema.toLowerCase();
            } else {
                tableLower = table;
            }
            if (this.conn.isOnLine()) {
                rowIDStatement1.executeUpdate("create temp table " + tempTable + "( " + "  scope          smallint, " + "  column_name    varchar(129), " + "  data_type      smallint, " + "  type_name      varchar(129), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint )");
            } else {
                rowIDStatement1.executeUpdate("create temp table " + tempTable + "( " + "  scope          smallint, " + "  column_name    char(18), " + "  data_type      smallint, " + "  type_name      char(18), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint )");
            }
            String sql = "select sc.colname, sc.colno, sc.coltype, sc.collength from informix.systables st, informix.sysconstraints so, informix.sysindexes si, informix.syscolumns sc where (st.tabname like '" + table + "' or " + "st.tabname like '" + tableLower + "' ) and " + "st.tabid = so.tabid and " + "so.constrtype = 'P' and " + "so.idxname = si.idxname and " + "sc.tabid = st.tabid and " + "st.owner like '" + schema + "' and " + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                sql = String.valueOf(sql) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            sql = String.valueOf(sql) + ")";
            rs = rowIDStatement1.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                String colname = rs.getString(1);
                short coltype = rs.getShort(3);
                short umaskcoltype = (short)(coltype & 0xFF);
                umaskcoltype = (short)(coltype & 0xFF);
                short data_type = (short)IfxTypes.FromIfxToJDBCType(umaskcoltype);
                rowIDStatement2.executeUpdate("insert into " + tempTable + " values( " + 2 + ", '" + colname + "', " + data_type + ", '" + IfxTypes.IfxTypeToName(umaskcoltype) + "', " + rs.getShort(4) + ", " + "0, " + "0, " + 1 + ") ");
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by scope";
        rs = origAC && isModeAnsi ? rowIDStatement1.executeQuery(qry, true) : rowIDStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getVersionColumns() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (schema == null || schema == "") {
            schema = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            table = table.toLowerCase();
            schema = schema.toLowerCase();
        }
        IfxStatement versionColumnStatement = (IfxStatement)this.conn.createStatement();
        versionColumnStatement.setAutoFree(true);
        String query = "select '' as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, '' as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from informix.systables t, informix.syscolumns c where t.tabid = c.tabid and t.owner like '" + schema + "' " + "and t.tabname like '" + table + "' " + "and mod(c.coltype,256) = 6";
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getVersionColumns() : call IfxStatement:executeQuery(" + query + ")");
        ResultSet results = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? versionColumnStatement.executeQuery(query, true) : versionColumnStatement.executeQuery(query, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(results, this.conn);
        return RS;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String tempTable = this.nextTempTableName();
        String tableLower = null;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schema == null || schema == "") {
            schema = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            tableLower = table.toLowerCase();
            schema = schema.toLowerCase();
        } else {
            tableLower = table;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getPrimaryKeys() : call IfxConnection:isDbOpen()");
        if (table == null || table == "") {
            table = "%";
        }
        IfxStatement primaryKey1Statement = null;
        IfxStatement primaryKey2Statement = null;
        IfxStatement primaryKey3Statement = null;
        try {
            primaryKey1Statement = (IfxStatement)this.conn.createStatement();
            primaryKey2Statement = (IfxStatement)this.conn.createStatement();
            primaryKey3Statement = (IfxStatement)this.conn.createStatement();
            primaryKey1Statement.setAutoFree(true);
            primaryKey2Statement.setAutoFree(true);
            primaryKey3Statement.setAutoFree(true);
            if (this.conn.isOnLine()) {
                primaryKey1Statement.executeUpdate("  create temp table " + tempTable + "( " + "  table_cat      varchar(129), " + "  table_schem    varchar(129), " + "  table_name     varchar(129), " + "  column_name    varchar(129), " + "  key_seq        smallint, " + "  pk_name        varchar(129)) ");
            } else {
                primaryKey1Statement.executeUpdate("  create temp table " + tempTable + "( " + "  table_cat      char(18), " + "  table_schem    char(18), " + "  table_name     char(18), " + "  column_name    char(18), " + "  key_seq        smallint, " + "  pk_name        char(18) ) ");
            }
            String sql = "  select   sc.colname,  so.constrname,   st.tabname,   st.owner  from  informix.systables st,  informix.sysconstraints so,  informix.sysindexes si,  informix.syscolumns sc    where   ( st.tabname like '" + table + "' or " + "  st.tabname like '" + tableLower + "' ) and" + "  st.tabid = so.tabid and" + "  so.constrtype = 'P' and" + "  so.idxname = si.idxname and" + "  sc.tabid = st.tabid and" + "  st.owner like '" + schema + "' and" + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                sql = String.valueOf(sql) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            sql = String.valueOf(sql) + ")";
            ResultSet rs = primaryKey1Statement.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            String prevConstrname = "";
            int keySeq = 1;
            String dbName = "'" + this.conn.getDbName() + "'";
            while (rs.next()) {
                String colname = rs.getString(1);
                String constrname = rs.getString(2);
                String tabname = rs.getString(3);
                String owner = rs.getString(4);
                if (colname != null) {
                    colname = colname.trim();
                }
                if (constrname != null) {
                    constrname = constrname.trim();
                }
                if (tabname != null) {
                    tabname = tabname.trim();
                }
                if (owner != null) {
                    owner = owner.trim();
                }
                keySeq = !prevConstrname.equals(constrname) ? 1 : (int)((short)(keySeq + 1));
                prevConstrname = constrname;
                primaryKey2Statement.executeUpdate(" insert into " + tempTable + " values( " + dbName + ", '" + owner + "', '" + tabname + "', '" + colname + "', " + keySeq + ", '" + constrname + "' )");
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = " select table_cat as TABLE_CAT,  table_schem as TABLE_SCHEM,  table_name as TABLE_NAME,  column_name as COLUMN_NAME,  key_seq  as KEY_SEQ,  pk_name as PK_NAME  from " + tempTable + " order by column_name";
        ResultSet results = origAC && isModeAnsi ? primaryKey3Statement.executeQuery(qry, true) : primaryKey3Statement.executeQuery(qry, false);
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getPrimaryKeys() : call IfxStatement:executeQuery()");
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(results, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        tempTable = null;
        return RS;
    }

    public ResultSet getImportedKeys(String catalog, String schemaName, String table) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaName == null || schemaName == "") {
            schemaName = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        IfxStatement importedKeyStatement1 = null;
        IfxStatement importedKeyStatement2 = null;
        try {
            importedKeyStatement1 = (IfxStatement)this.conn.createStatement();
            importedKeyStatement2 = (IfxStatement)this.conn.createStatement();
            importedKeyStatement1.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                table = table.toLowerCase();
                schemaName = schemaName.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                importedKeyStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                importedKeyStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            String sqlStr = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pt.owner like '" + schemaName + "' and " + "(pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or " + "pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or " + "pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or " + "pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or " + "pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or " + "pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or " + "pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or " + "pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)";
            if (this.conn.isOnLine()) {
                sqlStr = String.valueOf(sqlStr) + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16))";
            }
            sqlStr = String.valueOf(sqlStr) + "and ft.owner like '" + schemaName + "' " + "and ft.tabname like '" + table + "' ;";
            rs = importedKeyStatement1.executeQuery(sqlStr);
            while (rs.next()) {
                String ptabname = rs.getString(1);
                String pcolname = rs.getString(2);
                String fowner = rs.getString(3);
                String ftabname = rs.getString(4);
                String fcolname = rs.getString(5);
                String fconstrname = rs.getString(6);
                String pconstrname = rs.getString(7);
                String delrule = rs.getString(8);
                String powner = rs.getString(9);
                int drule = delrule.equals("C") ? 0 : 1;
                importedKeyStatement2.executeUpdate("insert into " + tempTable + " values(" + dbName + ", '" + powner + "', '" + ptabname + "', '" + pcolname + "', " + dbName + ", '" + fowner + "', '" + ftabname + "', '" + fcolname + "', " + "1, 1, " + drule + ", '" + fconstrname + "', '" + pconstrname + "', " + "7)");
            }
            importedKeyStatement2.close();
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 1,2,3,9";
        rs = origAC && isModeAnsi ? importedKeyStatement1.executeQuery(qry, true) : importedKeyStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getExportedKeys(String catalog, String schemaName, String table) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaName == null || schemaName == "") {
            schemaName = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        IfxStatement exportedKeyStatement1 = null;
        IfxStatement exportedKeyStatement2 = null;
        try {
            exportedKeyStatement1 = (IfxStatement)this.conn.createStatement();
            exportedKeyStatement2 = (IfxStatement)this.conn.createStatement();
            exportedKeyStatement1.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                table = table.toLowerCase();
                schemaName = schemaName.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                exportedKeyStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                exportedKeyStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            String sqlStr = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) ";
            if (this.conn.isOnLine()) {
                sqlStr = String.valueOf(sqlStr) + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            sqlStr = String.valueOf(sqlStr) + "and pt.owner like '" + schemaName + "' " + "and pt.tabname like '" + table + "' ;";
            rs = exportedKeyStatement1.executeQuery(sqlStr);
            while (rs.next()) {
                String ptabname = rs.getString(1);
                String pcolname = rs.getString(2);
                String fowner = rs.getString(3);
                String ftabname = rs.getString(4);
                String fcolname = rs.getString(5);
                String fconstrname = rs.getString(6);
                String pconstrname = rs.getString(7);
                String delrule = rs.getString(8);
                String powner = rs.getString(9);
                int drule = delrule.equals("C") ? 0 : 1;
                exportedKeyStatement2.executeUpdate("insert into " + tempTable + " values(" + dbName + ", '" + powner + "', '" + ptabname + "', '" + pcolname + "', " + dbName + ", '" + fowner + "', '" + ftabname + "', '" + fcolname + "', " + "1, 1, " + drule + ", '" + fconstrname + "', '" + pconstrname + "', " + "7)");
            }
            exportedKeyStatement2.close();
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 1,2,3,9";
        rs = origAC && isModeAnsi ? exportedKeyStatement1.executeQuery(qry, true) : exportedKeyStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (primarySchema == null || primarySchema == "") {
            primarySchema = "%";
        }
        if (foreignSchema == null || foreignSchema == "") {
            foreignSchema = "%";
        }
        if (primaryTable == null || primaryTable == "") {
            primaryTable = "%";
        }
        if (foreignTable == null || foreignTable == "") {
            foreignTable = "%";
        }
        IfxStatement crossRefStatement1 = null;
        IfxStatement crossRefStatement2 = null;
        try {
            crossRefStatement1 = (IfxStatement)this.conn.createStatement();
            crossRefStatement2 = (IfxStatement)this.conn.createStatement();
            crossRefStatement1.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                primaryTable = primaryTable.toLowerCase();
                foreignTable = foreignTable.toLowerCase();
                primarySchema = primarySchema.toLowerCase();
                foreignSchema = foreignSchema.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                crossRefStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                crossRefStatement1.executeUpdate("create temp table " + tempTable + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            rs = crossRefStatement1.executeQuery("select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) and pt.owner like '" + primarySchema + "' " + "and ft.owner like '" + foreignSchema + "' " + "and pt.tabname like '" + primaryTable + "' " + "and ft.tabname like '" + foreignTable + "' ;");
            while (rs.next()) {
                String ptabname = rs.getString(1);
                String pcolname = rs.getString(2);
                String fowner = rs.getString(3);
                String ftabname = rs.getString(4);
                String fcolname = rs.getString(5);
                String fconstrname = rs.getString(6);
                String pconstrname = rs.getString(7);
                String delrule = rs.getString(8);
                String powner = rs.getString(9);
                int drule = delrule.equals("C") ? 0 : 1;
                crossRefStatement2.executeUpdate("insert into " + tempTable + " values(" + dbName + ", '" + powner + "', '" + ptabname + "', '" + pcolname + "', " + "'', '" + fowner + "', '" + ftabname + "', '" + fcolname + "', " + "1, 1, " + drule + ", '" + fconstrname + "', '" + pconstrname + "', " + "7)");
            }
            crossRefStatement2.close();
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by 1,2,3,9";
        rs = origAC && isModeAnsi ? crossRefStatement1.executeQuery(qry, true) : crossRefStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    public ResultSet getTypeInfo() throws SQLException {
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTypeInfo() : create the ResultSetMetaData object");
        IfxResultSetMetaData md = new IfxResultSetMetaData(lmd.length, this.conn);
        int i = 0;
        while (i < lmd.length) {
            int j = i + 1;
            md.setTableName(j, "SQL_TYPES");
            md.setColumnName(j, IfxDatabaseMetaData.lmd[i].colname);
            md.setIfxColumnType(j, IfxDatabaseMetaData.lmd[i].coltype & 0xFF);
            md.setEncodedLength(j, IfxDatabaseMetaData.lmd[i].collen);
            md.setNullable(j, IfxDatabaseMetaData.lmd[i].nullable);
            md.setColumnStartPosition(j, IfxDatabaseMetaData.lmd[i].stpos);
            ++i;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getTypeInfo() : create the ClientResultSet object");
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, md);
        int nRows = this.conn.isUSVER() ? nXtdRowTypesSupported : nStdRowTypes;
        crs.newRow(nRows);
        int i2 = 0;
        while (i2 < nRows) {
            int j = i2 + 1;
            crs.updateString(j, 1, IfxDatabaseMetaData.lrow[i2].tname);
            crs.updateShort(j, 2, (short)IfxDatabaseMetaData.lrow[i2].jsqltype);
            crs.updateInt(j, 3, IfxDatabaseMetaData.lrow[i2].precision);
            crs.updateString(j, 4, IfxDatabaseMetaData.lrow[i2].lprefix);
            crs.updateString(j, 5, IfxDatabaseMetaData.lrow[i2].lsuffix);
            crs.updateString(j, 6, IfxDatabaseMetaData.lrow[i2].cparams);
            crs.updateShort(j, 7, (short)IfxDatabaseMetaData.lrow[i2].nullable);
            crs.updateBoolean(j, 8, IfxDatabaseMetaData.lrow[i2].casesen);
            crs.updateShort(j, 9, (short)IfxDatabaseMetaData.lrow[i2].searchable);
            crs.updateBoolean(j, 10, IfxDatabaseMetaData.lrow[i2].unsign);
            crs.updateBoolean(j, 11, IfxDatabaseMetaData.lrow[i2].money);
            crs.updateBoolean(j, 12, IfxDatabaseMetaData.lrow[i2].autoincrement);
            crs.updateString(j, 13, IfxDatabaseMetaData.lrow[i2].ltname);
            crs.updateShort(j, 14, (short)IfxDatabaseMetaData.lrow[i2].minscale);
            crs.updateShort(j, 15, (short)IfxDatabaseMetaData.lrow[i2].maxscale);
            crs.updateInt(j, 16, IfxDatabaseMetaData.lrow[i2].sqldatatype);
            crs.updateInt(j, 17, IfxDatabaseMetaData.lrow[i2].sqldatetime);
            crs.updateInt(j, 18, IfxDatabaseMetaData.lrow[i2].numradix);
            ++i2;
        }
        crs.beforeFirst();
        return crs;
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet rs;
        String tempTable = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        this.trace.writeTrace(2, "IfxDatabaseMetaData:getIndexInfo() : call IfxConnection:isDbOpen()");
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schema == null || schema == "") {
            schema = "%";
        }
        if (table == null || table == "") {
            table = "%";
        }
        IfxStatement indexInfoStatement1 = null;
        IfxStatement indexInfoStatement2 = null;
        try {
            String tableLower;
            indexInfoStatement1 = (IfxStatement)this.conn.createStatement();
            indexInfoStatement2 = (IfxStatement)this.conn.createStatement();
            indexInfoStatement1.setAutoFree(true);
            indexInfoStatement2.setAutoFree(true);
            String dbName = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                tableLower = table.toLowerCase();
                schema = schema.toLowerCase();
            } else {
                tableLower = table;
            }
            if (this.conn.isOnLine()) {
                indexInfoStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat        varchar(129), " + "  table_schem      varchar(129), " + "  table_name       varchar(129), " + "  non_unique       smallint, " + "  index_qualifier  varchar(129), " + "  index_name       varchar(129), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      varchar(129), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filer_condition  varchar(129) )");
            } else {
                indexInfoStatement1.executeUpdate("create temp table " + tempTable + "( " + "  table_cat        char(18), " + "  table_schem      char(18), " + "  table_name       char(18), " + "  non_unique       smallint, " + "  index_qualifier  char(18), " + "  index_name       char(18), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      char(18), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filer_condition  char(18) )");
            }
            String sql = "select sc.colname, si.idxname, si.clustered, si.idxtype, st.tabname, st.owner from informix.systables st, informix.sysindexes si, informix.syscolumns sc where (st.tabname like '" + table + "' or st.tabname like '" + tableLower + "') and " + "st.tabid = si.tabid and " + "sc.tabid = st.tabid and " + "st.owner like '" + schema + "' and " + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                sql = String.valueOf(sql) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            sql = String.valueOf(sql) + ") order by si.idxname";
            rs = indexInfoStatement1.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            String prevIdxname = "";
            int keySeq = 1;
            while (rs.next()) {
                String colname = rs.getString(1);
                String idxname = rs.getString(2);
                String clustered = rs.getString(3);
                String idxtype = rs.getString(4);
                String tabname = rs.getString(5);
                String owner = rs.getString(6);
                keySeq = !prevIdxname.equals(idxname) ? 1 : (int)((short)(keySeq + 1));
                prevIdxname = idxname;
                indexInfoStatement2.executeUpdate("insert into " + tempTable + " values( " + dbName + ", '" + owner + "', '" + tabname + "', " + (idxtype.equals("D") ? "1" : "0") + ", " + "null, '" + idxname + "', " + 3 + ", " + keySeq + ", '" + colname + "', null, " + "0, 0, null )");
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select * from " + tempTable + " order by non_unique, index_name, ordinal_position";
        rs = origAC && isModeAnsi ? indexInfoStatement1.executeQuery(qry, true) : indexInfoStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(rs, tempTable, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        return RS;
    }

    void close() throws SQLException {
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        this.trace.writeTrace(2, "IfxDatabaseMetaData:supportsResultSetType()");
        return type == 1004 || type == 1003;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.trace.writeTrace(2, "IfxDatabaseMetaData:supportResultSetConcurrency()");
        return concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isUSVER() && !this.conn.isDbOpen()) {
            return null;
        }
        String dbName = this.conn.getDbName();
        if (catalog == null || catalog.equals("")) {
            catalog = dbName;
        } else if (!catalog.equals(dbName)) {
            return null;
        }
        boolean origAC = this.conn.getAutoCommit();
        boolean isModeAnsi = this.conn.isANSI();
        if (isModeAnsi && origAC) {
            this.conn.setAutoCommit(false);
        }
        if (schemaPattern == null || schemaPattern.equals("")) {
            schemaPattern = "%";
        }
        if (typeNamePattern == null || typeNamePattern.equals("")) {
            typeNamePattern = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            typeNamePattern = typeNamePattern.toLowerCase();
            schemaPattern = schemaPattern.toLowerCase();
        }
        boolean b = false;
        boolean r = false;
        boolean d = false;
        String modelist = "";
        if (types != null) {
            int count = 0;
            int i = 0;
            while (i < types.length) {
                switch (types[i]) {
                    case 2000: {
                        if (b) break;
                        b = true;
                        if (++count == 1) {
                            modelist = String.valueOf(modelist) + "'B'";
                            break;
                        }
                        modelist = String.valueOf(modelist) + ",'B'";
                        break;
                    }
                    case 2002: {
                        if (r) break;
                        r = true;
                        if (++count == 1) {
                            modelist = String.valueOf(modelist) + "'R'";
                            break;
                        }
                        modelist = String.valueOf(modelist) + ",'R'";
                        break;
                    }
                    case 2001: {
                        if (d) break;
                        d = true;
                        modelist = ++count == 1 ? String.valueOf(modelist) + "'D'" : String.valueOf(modelist) + ",'D'";
                    }
                }
                ++i;
            }
        }
        IfxStatement getUDTsStatement1 = null;
        String tempTable1 = null;
        try {
            getUDTsStatement1 = (IfxStatement)this.conn.createStatement();
            getUDTsStatement1.setAutoFree(true);
            IfxStatement getUDTsStatement2 = (IfxStatement)this.conn.createStatement();
            IfxStatement getUDTsStatement3 = (IfxStatement)this.conn.createStatement();
            String procQuery = "create procedure mode_decode (mode char(1)) returns varchar(26);   if mode = 'B' then      return 'java.sql.Types.JAVA_OBJECT';   elif mode = 'R' then      return 'java.sql.Types.STRUCT';   elif mode = 'D' then      return 'java.sql.Types.DISTINCT';   else      return 'unknown mode';   end if; end procedure; ";
            getUDTsStatement3.executeUpdate(procQuery);
            tempTable1 = this.nextTempTableName();
            if (this.conn.isOnLine()) {
                getUDTsStatement1.executeUpdate("create temp table " + tempTable1 + " ( " + "TYPE_CAT varchar(129), " + "TYPE_SCHEM varchar(129), " + "TYPE_NAME varchar(129), " + "CLASS_NAME varchar(129), " + "DATA_TYPE varchar(129), " + "REMARKS varchar(129) " + " ) ");
            } else {
                getUDTsStatement1.executeUpdate("create temp table " + tempTable1 + " ( " + "TYPE_CAT char(18), " + "TYPE_SCHEM char(18), " + "TYPE_NAME char(18), " + "CLASS_NAME char(25), " + "DATA_TYPE char(30), " + "REMARKS char(255) " + " ) ");
            }
            String selQuery = "select owner, name, mode, type, source from informix.sysxtdtypes where owner != 'informix' and owner like '" + schemaPattern + "' " + "and name like '" + typeNamePattern + "' ";
            if (!modelist.equals("")) {
                selQuery = String.valueOf(selQuery) + "and mode in (" + modelist + ") ";
            }
            ResultSet rs = getUDTsStatement1.executeQuery(selQuery);
            while (rs.next()) {
                String owner = rs.getString("owner");
                String name = rs.getString("name");
                String mode = rs.getString("mode");
                int ifxType = rs.getInt("type");
                int sourceType = rs.getInt("source");
                String className = null;
                if (!(mode = mode.trim()).equals("D")) {
                    className = "java.sql.SQLData";
                } else if (sourceType == 0) {
                    className = IfxTypes.FromIfxTypeToJava(ifxType & 0xFF);
                } else {
                    boolean breakWhile = false;
                    block15: while (!breakWhile) {
                        switch (sourceType) {
                            case 1: {
                                className = "java.lang.String";
                                breakWhile = true;
                                break;
                            }
                            case 5: {
                                className = "java.lang.Boolean";
                                breakWhile = true;
                                break;
                            }
                            case 11: {
                                className = "java.sql.Clob";
                                breakWhile = true;
                                break;
                            }
                            case 10: {
                                className = "java.sql.Blob";
                                breakWhile = true;
                                break;
                            }
                            default: {
                                ResultSet rs2 = getUDTsStatement2.executeQuery("select type, source from informix.sysxtdtypes where extended_id = " + sourceType);
                                if (!rs2.next()) {
                                    breakWhile = true;
                                    className = "unknown";
                                    break;
                                }
                                int innertype = rs2.getInt("type");
                                sourceType = rs2.getInt("source");
                                if (sourceType != 0) continue block15;
                                className = innertype == 40 || innertype == 41 ? "java.sql.SQLData" : IfxTypes.FromIfxTypeToJava(ifxType & 0xFF);
                                breakWhile = true;
                                break;
                            }
                        }
                    }
                }
                String insQuery = "insert into " + tempTable1 + " values ( " + "'" + dbName + "', " + "'" + owner + "', " + "'" + name + "', " + "'" + className + "', " + "mode_decode(" + "'" + mode + "'), " + "'' )";
                getUDTsStatement2.executeUpdate(insQuery);
            }
            rs.close();
            procQuery = "drop procedure mode_decode";
            getUDTsStatement3.executeUpdate(procQuery);
            getUDTsStatement2.close();
            getUDTsStatement3.close();
        }
        catch (SQLException ex) {
            this.restoreTransMode(this.conn, isModeAnsi, origAC);
            throw ex;
        }
        String qry = "select TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS from " + tempTable1 + " " + "order by DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        ResultSet result = null;
        result = origAC && isModeAnsi ? getUDTsStatement1.executeQuery(qry, true) : getUDTsStatement1.executeQuery(qry, false);
        IfxDbMetaDataResultSet RS = new IfxDbMetaDataResultSet(result, tempTable1, this.conn);
        this.restoreTransMode(this.conn, isModeAnsi, origAC);
        tempTable1 = null;
        return RS;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private void restoreTransMode(Connection conn, boolean isModeAnsi, boolean origAC) throws SQLException {
        if (isModeAnsi && origAC) {
            conn.commit();
            conn.setAutoCommit(origAC);
        }
    }

    static {
        int i;
        nextTempTableId = 1;
        nMdInfoRows = 18;
        nStdRowTypes = 19;
        nXtdRowTypes = 29;
        nXtdRowTypesSupported = 25;
        lmd = null;
        lrow = null;
        if (lmd == null) {
            i = 0;
            lmd = new mdinfo[nMdInfoRows];
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("TYPE_NAME", 0, 128, true, 0);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("DATA_TYPE", 1, 2, true, 128);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("PRECISION", 2, 4, true, 130);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LITERAL_PREFIX", 0, 128, true, 134);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LITERAL_SUFFIX", 0, 128, true, 262);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("CREATE_PARAMS", 0, 128, true, 390);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("NULLABLE", 1, 2, true, 518);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("CASE_SENSITIVE", 1, 2, true, 520);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SEARCHABLE", 2, 4, true, 522);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("UNSIGNED_ATTRIBUTE", 1, 2, true, 526);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("FIXED_PREC_SCALE", 1, 2, true, 528);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("AUTO_INCREMENT", 1, 2, true, 530);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LOCAL_TYPE_NAME", 0, 128, true, 532);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("MINIMUM_SCALE", 1, 2, true, 660);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("MAXIMUM_SCALE", 1, 2, true, 662);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SQL_DATA_TYPE", 2, 4, true, 664);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SQL_DATETIME_SUB", 2, 4, true, 668);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("NUM_PREC_RADIX", 2, 4, true, 672);
        }
        if (lrow == null) {
            i = 0;
            lrow = new rowinfo[nXtdRowTypes];
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("byte", -4, Short.MAX_VALUE, "", "", 1, false, 0, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("char", 1, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("character varying", 12, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("date", 91, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("datetime year to fraction(5)", 93, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("decimal", 3, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("double precision", 3, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("float", 6, 8, "'", "'", 1, false, 2, false, false, 1, 8, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("integer", 4, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("interval", 1, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("nchar", 1, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("nvarchar", 12, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("money", 3, 32, "'", "'", 1, false, 2, true, false, 16, 32, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("numeric", 2, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("serial", 4, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("smallint", 5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("smallfloat", 7, 6, "'", "'", 1, false, 2, false, false, 1, 6, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("text", -1, 0, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("varchar", 12, 255, "'", "'", 1, true, 3, false, false, 0, 255, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("boolean", 1111, 0, "'", "'", 1, false, 2, false, false, 0, 0, 2);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("int8", -5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("serial8", -5, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("clob", 2005, 72, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("blob", 2004, 72, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("lvarchar", -1, 2048, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("list", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("multiset", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("set", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[i++] = new rowinfo("unnamed row", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
        }
    }
}

