/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxScrollableResultSet;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxClientResultSet
extends IfxScrollableResultSet {
    private int rowIndex = -1;
    private Vector rowVector = new Vector();

    public IfxClientResultSet() throws SQLException {
    }

    public IfxClientResultSet(Connection conn, ResultSetMetaData md) throws SQLException {
        this.rsmd = (IfxResultSetMetaData)md;
        this.conn = (IfxConnection)conn;
        this.insertMode = true;
        this.rowVector.setSize(20);
        if (conn != null) {
            this.setTrace(((IfxConnection)conn).getTrace());
        }
    }

    public void executeQuery() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeQuery().", this.conn);
    }

    public int executeUpdate() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeUpdate().", this.conn);
    }

    public void execute() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.execute().", this.conn);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    public boolean next() throws SQLException {
        this.trace.writeTrace(1, "IfxClientResultSet.next() called");
        if (this.rowVector == null) {
            this.trace.writeTrace(2, "  rowVector is null.");
        } else {
            this.trace.writeTrace(2, "  rowVector is not null.");
            this.trace.writeTrace(2, "  rowVector.size(): " + this.rowVector.size());
            this.trace.writeTrace(2, "  CurRowID: " + this.curRowID);
            this.trace.writeTrace(2, "  rowIndex: " + this.rowIndex);
        }
        if (this.rowVector == null) {
            return false;
        }
        if (this.curRowID >= this.rowIndex + 1) {
            return false;
        }
        ++this.curRowID;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        this.trace.writeTrace(1, "IfxClientResultSet.next() exited");
        return true;
    }

    public void newRow() throws SQLException {
        if (this.trace != null) {
            this.trace.writeTrace(1, "IfxClientResultSet.newRow() called");
        }
        if (this.rowVector == null) {
            this.insertMode = true;
            this.rowVector = new Vector();
            this.rowVector.setSize(20);
            this.rowIndex = -1;
        }
        super.moveToInsertRow();
        this.add();
        Vector tmpVector = new Vector();
        tmpVector.setSize(this.rsmd.getColumnCount());
        this.rowVector.setElementAt(tmpVector, this.rowIndex);
        this.curRowID = this.rowIndex + 1;
    }

    public void newRow(int nrows) throws SQLException {
        int savedRowID = this.curRowID;
        int i = 0;
        while (i < nrows) {
            this.newRow();
            ++i;
        }
        this.curRowID = savedRowID + 1;
    }

    public int getRow() throws SQLException {
        return this.rowIndex + 1;
    }

    public boolean absolute(int row) throws SQLException {
        if (this.rowIndex == -1) {
            return false;
        }
        if (row > this.rowIndex + 1) {
            this.curRowID = this.rowIndex + 1 + 1;
            return false;
        }
        if (row < 0) {
            this.curRowID = this.rowIndex - (Math.abs(row) - 1) - 1;
            if (this.curRowID < 0) {
                this.curRowID = -1;
                return false;
            }
        } else {
            this.curRowID = row;
        }
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.curRowID <= 0) {
            return false;
        }
        --this.curRowID;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean relative(int count) throws SQLException {
        int newRowID = this.curRowID + count;
        if (newRowID > this.rowIndex + 1 || newRowID < 0) {
            return false;
        }
        this.curRowID = newRowID;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public void beforeFirst() throws SQLException {
        this.curRowID = 0;
    }

    public boolean first() throws SQLException {
        if (this.curRowID < 0) {
            return false;
        }
        this.curRowID = 1;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean last() throws SQLException {
        if (this.curRowID < 0) {
            return false;
        }
        this.curRowID = this.rowIndex + 1;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public void updateNull(int rowIdx, int colIdx) throws SQLException {
        this.trace.writeTrace(1, "IfxClientResultSet.updateNull() called");
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateNull(colIdx);
    }

    public void updateNull(int rowIdx, String column) throws SQLException {
        this.updateNull(rowIdx, this.findColumn(column));
    }

    public void updateBoolean(int rowIdx, int colIdx, boolean x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateBoolean(colIdx, x);
    }

    public void updateBoolean(int rowIdx, String column, boolean x) throws SQLException {
        this.updateBoolean(rowIdx, this.findColumn(column), x);
    }

    public void updateByte(int rowIdx, int colIdx, byte x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateByte(colIdx, x);
    }

    public void updateByte(int rowIdx, String column, byte x) throws SQLException {
        this.updateByte(rowIdx, this.findColumn(column), x);
    }

    public void updateShort(int rowIdx, int colIdx, short x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateShort(colIdx, x);
    }

    public void updateShort(int rowIdx, String column, short x) throws SQLException {
        this.updateShort(rowIdx, this.findColumn(column), x);
    }

    public void updateInt(int rowIdx, int colIdx, int x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateInt(colIdx, x);
    }

    public void updateInt(int rowIdx, String column, int x) throws SQLException {
        this.updateInt(rowIdx, this.findColumn(column), x);
    }

    public void updateLong(int rowIdx, int colIdx, long x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateLong(colIdx, x);
    }

    public void updateLong(int rowIdx, String column, long x) throws SQLException {
        this.updateLong(rowIdx, this.findColumn(column), x);
    }

    public void updateFloat(int rowIdx, int colIdx, float x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateFloat(colIdx, x);
    }

    public void updateFloat(int rowIdx, String column, float x) throws SQLException {
        this.updateFloat(rowIdx, this.findColumn(column), x);
    }

    public void updateDouble(int rowIdx, int colIdx, double x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateDouble(colIdx, x);
    }

    public void updateDouble(int rowIdx, String column, double x) throws SQLException {
        this.updateDouble(rowIdx, this.findColumn(column), x);
    }

    public void updateBigDecimal(int rowIdx, int colIdx, BigDecimal x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateBigDecimal(colIdx, x);
    }

    public void updateBigDecimal(int rowIdx, String column, BigDecimal x) throws SQLException {
        this.updateBigDecimal(rowIdx, this.findColumn(column), x);
    }

    public void updateString(int rowIdx, int colIdx, String x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateString(colIdx, x);
    }

    public void updateString(int rowIdx, String column, String x) throws SQLException {
        this.updateString(rowIdx, this.findColumn(column), x);
    }

    public void updateBytes(int rowIdx, int colIdx, byte[] x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateBytes(colIdx, x);
    }

    public void updateBytes(int rowIdx, String column, byte[] x) throws SQLException {
        this.updateBytes(rowIdx, this.findColumn(column), x);
    }

    public void updateDate(int rowIdx, int colIdx, Date x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateDate(colIdx, x);
    }

    public void updateDate(int rowIdx, String column, Date x) throws SQLException {
        this.updateDate(rowIdx, this.findColumn(column), x);
    }

    public void updateTime(int rowIdx, int colIdx, Time x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateTime(colIdx, x);
    }

    public void updateTime(int rowIdx, String column, Time x) throws SQLException {
        this.updateTime(rowIdx, this.findColumn(column), x);
    }

    public void updateTimestamp(int rowIdx, int colIdx, Timestamp x) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateTimestamp(colIdx, x);
    }

    public void updateTimestamp(int rowIdx, String column, Timestamp x) throws SQLException {
        this.updateTimestamp(rowIdx, this.findColumn(column), x);
    }

    public void updateAsciiStream(int rowIdx, int colIdx, InputStream x, int length) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateAsciiStream(colIdx, x, length);
    }

    public void updateAsciiStream(int rowIdx, String column, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(rowIdx, this.findColumn(column), x, length);
    }

    public void updateBinaryStream(int rowIdx, int colIdx, InputStream x, int length) throws SQLException {
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateBinaryStream(colIdx, x, length);
    }

    public void updateBinaryStream(int rowIdx, String column, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(rowIdx, this.findColumn(column), x, length);
    }

    public void updateObject(int rowIdx, int colIdx, Object x) throws SQLException {
        this.trace.writeTrace(1, "IfxClientResultSet.updateObject() called");
        this.trace.writeTrace(2, " rowIndex: " + rowIdx);
        this.trace.writeTrace(2, " colIdx: " + colIdx);
        if (!this.absolute(rowIdx)) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        this.updateObject(colIdx, x);
    }

    public void updateObject(int rowIdx, String column, Object x) throws SQLException {
        this.updateObject(rowIdx, this.findColumn(column), x);
    }

    public void deleteRow(int row) throws SQLException {
        this.rowVector.removeElementAt(row - 1);
        --this.rowIndex;
    }

    public void deleteAllRows() {
        if (this.rowVector != null) {
            int i = 0;
            while (i < this.rowIndex) {
                Vector tmpVector = (Vector)this.rowVector.elementAt(i);
                tmpVector.removeAllElements();
                ++i;
            }
            this.rowVector.removeAllElements();
            this.rowVector = null;
        }
    }

    private void add() {
        this.trace.writeTrace(1, "IfxClientResultSet.add() called");
        this.trace.writeTrace(1, "    rowVector.size(): " + this.rowVector.size());
        this.trace.writeTrace(1, "    rowIndex: " + this.rowIndex);
        if (this.rowIndex + 1 >= this.rowVector.size()) {
            this.trace.writeTrace(1, "IfxClientResultSet().add(): rowSize ", this.rowVector.size());
            this.rowVector.setSize(this.rowIndex + 20);
            this.trace.writeTrace(1, "IfxClientResultSet().add(): rowSize ", this.rowVector.size());
        }
        ++this.rowIndex;
        this.trace.writeTrace(1, "IfxClientResultSet().add(): rowIndex ", this.rowIndex);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return "ClientResultCurs";
    }

    public void close() {
        this.deleteAllRows();
        this.insertRowVector = null;
        this.colVector = null;
    }

    protected void finalize() {
        this.close();
    }
}

