/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxChar
extends IfxObject {
    private String value;
    private String valueTrimmed;

    public IfxChar() throws SQLException {
        this.setIfxType(0);
    }

    public IfxChar(char[] c) throws SQLException {
        this.writeTrace(3, "IfxChar(char[] c) constructor called, c = " + new String(c));
        this.setIfxType(0);
        try {
            this.value = new String(c);
            this.trimIfxChar(this.value);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79702, this.conn);
        }
    }

    public IfxChar(String S) throws SQLException {
        this.setIfxType(0);
        if (S != null) {
            this.writeTrace(3, "IfxChar(String) constructor called, c = " + S);
            this.trimIfxChar(S);
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxChar)) {
            return false;
        }
        IfxChar otherChar = (IfxChar)other;
        if (otherChar.isNull()) {
            return false;
        }
        return this.value.equals(otherChar.value);
    }

    public byte[] toIfx() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            if (this.isNull()) {
                return null;
            }
            return JavaToIfxType.JavaToIfxChar(this.value, dbEnc);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public byte[] toIfxTuple() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            if (this.isNull()) {
                byte[] b = new byte[this.getEncodedLength()];
                memoryUtil.byfill(b, (byte)32);
                b[0] = 0;
                return b;
            }
            byte[] b = null;
            b = dbEnc != null ? this.value.getBytes(dbEnc) : this.value.getBytes();
            return b;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public void fromIfx(byte[] b) throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            if (b == null || b[0] == 0) {
                this.nullify();
            } else {
                this.value = IfxToJavaType.IfxToJavaChar(b, (short)0, dbEnc);
                this.trimIfxChar(this.value);
                this.writeTrace(3, "IfxChar.fromIfx(): value - " + this.value + ", b.length" + b.length);
            }
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromString(String str) throws SQLException {
        this.writeTrace(99, "IfxChar.fromString() called");
        if (str == null) {
            this.nullify();
        } else {
            this.trimIfxChar(str);
        }
        this.writeTrace(99, "IfxChar.fromString() exited");
    }

    public int toInt() throws SQLException {
        int i = 0;
        if (!this.isNull()) {
            try {
                i = Integer.parseInt(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return i;
    }

    public void fromInt(int i) throws SQLException {
        this.value = Integer.toString(i);
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.value = I.toString();
            this.unnullify();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigD;
        if (this.isNull()) {
            return null;
        }
        try {
            bigD = new BigDecimal(this.valueTrimmed);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return bigD;
    }

    public void fromDecimal(BigDecimal B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    public byte toByte() throws SQLException {
        byte b = 0;
        if (!this.isNull()) {
            try {
                b = Byte.parseByte(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return b;
    }

    public void fromByte(byte b) throws SQLException {
        this.value = Byte.toString(b);
        this.unnullify();
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.valueTrimmed.equalsIgnoreCase("t") || this.valueTrimmed.equalsIgnoreCase("true");
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.value = String.valueOf(b);
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    public Date toDate() throws SQLException {
        Date D = null;
        if (!this.isNull()) {
            try {
                D = dateUtil.convertDateObj(this.valueTrimmed, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return D;
    }

    public void fromDate(Date D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(D, this.conn);
            this.unnullify();
        }
    }

    public float toFloat() throws SQLException {
        float f = 0.0f;
        if (!this.isNull()) {
            try {
                Float F = Float.valueOf(this.valueTrimmed);
                f = F.floatValue();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return f;
    }

    public void fromFloat(float f) throws SQLException {
        this.value = String.valueOf(f);
        this.unnullify();
    }

    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.nullify();
        } else {
            this.value = F.toString();
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        long l = 0L;
        if (!this.isNull()) {
            try {
                l = Long.parseLong(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return l;
    }

    public void fromLong(long l) throws SQLException {
        this.value = String.valueOf(l);
        this.unnullify();
    }

    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.nullify();
        } else {
            this.value = L.toString();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        short s = 0;
        if (!this.isNull()) {
            try {
                s = Short.parseShort(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return s;
    }

    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.nullify();
        } else {
            this.value = S.toString();
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        Time T = null;
        if (!this.isNull()) {
            try {
                T = Time.valueOf(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return T;
    }

    public void fromTime(Time T) throws SQLException {
        if (T == null) {
            this.nullify();
        } else {
            this.value = T.toString();
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        double d = 0.0;
        if (!this.isNull()) {
            try {
                Double D = Double.valueOf(this.valueTrimmed);
                d = D;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return d;
    }

    public void fromDouble(double d) throws SQLException {
        this.value = String.valueOf(d);
        this.unnullify();
    }

    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = D.toString();
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp T = null;
        if (!this.isNull()) {
            try {
                T = Timestamp.valueOf(this.valueTrimmed);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        return T;
    }

    public void fromTimestamp(Timestamp T) throws SQLException {
        if (T == null) {
            this.nullify();
        } else {
            this.value = T.toString();
            this.unnullify();
        }
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(99, "IfxChar: toAsciiStream()");
        this.writeTrace(3, "IfxChar: toAsciiStream(): value = " + this.value);
        byte[] byteArray = this.value.getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        this.writeTrace(3, "IfxChar: fromAsciiStream()");
        if (x != null) {
            this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + length);
            if (length == 0) {
                this.value = "";
            } else {
                byte[] b = new byte[length];
                int offset = 0;
                try {
                    do {
                        int readLen = x.read(b, offset, length);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): readLen = " + readLen);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + (length -= readLen));
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): offset = " + (offset += readLen));
                    } while (length > 0);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.value = new String(b);
                this.writeTrace(3, "IfxChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    private void trimIfxChar(String s) {
        if (s == null) {
            this.value = s;
            this.valueTrimmed = s;
            this.nullify();
            return;
        }
        this.value = s;
        int length = s.length();
        int i = length - 1;
        while (i >= 0 && s.charAt(i) == ' ') {
            --i;
        }
        this.valueTrimmed = i != length - 1 ? s.substring(0, ++i) : s;
        length = this.valueTrimmed.length();
        i = 0;
        while (i < length && s.charAt(i) == ' ') {
            ++i;
        }
        if (i != 0) {
            this.valueTrimmed = this.valueTrimmed.substring(i, length);
        }
        this.unnullify();
    }
}

