/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.sql.SQLException;

class IfxBoolean
extends IfxBaseType {
    boolean value;
    public static final byte IFX_BOOL_NULL = -1;

    IfxBoolean() throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
    }

    IfxBoolean(boolean b) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = b;
    }

    IfxBoolean(Boolean B) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = B;
    }

    public void fromIfx(byte[] x) throws SQLException {
        super.fromIfx(x);
        if (!this.isNull()) {
            byte b = this.inputStream.readByte();
            if (b == 1) {
                this.value = true;
            } else if (b == 0) {
                this.value = false;
            } else if (b == 255) {
                this.nullify();
            }
        }
    }

    public byte[] toIfx() throws SQLException {
        this.writeTrace(1, "IfxBoolean: enter method");
        this.outputStream.reset();
        if (!this.isNull()) {
            byte b = this.value ? (byte)1 : 0;
            this.outputStream.writeByte(b);
        }
        this.writeTrace(2, "IfxBoolean: calling super.toIfx()");
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        byte[] b;
        if (this.isNull()) {
            b = new byte[5];
            memoryUtil.byfill(b, (byte)0);
            b[0] = 1;
        } else {
            b = new byte[6];
            b[0] = 0;
            byte[] x = this.toIfx();
            int i = 0;
            while (i < x.length) {
                b[i + 1] = x[i];
                ++i;
            }
        }
        return b;
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxBoolean)) {
            return false;
        }
        IfxBoolean otherBoolean = (IfxBoolean)other;
        if (otherBoolean.isNull()) {
            return false;
        }
        return this.value == otherBoolean.value;
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    public int toInt() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    public void fromInt(int i) throws SQLException {
        this.value = i == 1;
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.fromInt((int)I);
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.value = false;
        if (b == 1) {
            this.value = true;
        } else if (b == 255) {
            this.nullify();
        }
    }

    public void fromByte(Byte B) throws SQLException {
        this.fromByte((byte)B);
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.value = b;
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)B);
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "t";
        }
        return "f";
    }

    public void fromString(String S) throws SQLException {
        if (S == null) {
            this.nullify();
        } else {
            String str = S.trim();
            if (str.equalsIgnoreCase("t") || str.equalsIgnoreCase("true")) {
                this.value = true;
            } else if (str.equalsIgnoreCase("f") || str.equalsIgnoreCase("false")) {
                this.value = false;
            } else {
                throw IfxErrMsg.getSQLException(-79771, this.conn);
            }
            this.unnullify();
        }
    }
}

