/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxBlob
extends IfxObject {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc;
    protected int tb_start;
    protected int tb_end;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
    }

    public IfxBlob(byte[] blobBuffer) throws SQLException {
        this.fromBytes(blobBuffer);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        this.writeTrace(99, "IfxBlob() : - 3");
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        this.writeTrace(99, "IfxBlob() : - 3");
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] buffer) {
        this.blobBuffer = buffer;
    }

    protected int getBlobLength() {
        return this.tb_size;
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected String getBlobFileName() {
        return this.tempBlobFile.getFileName();
    }

    protected void setBlobFileName() {
        this.tempBlobFile.close();
        this.tempBlobFile = null;
    }

    protected boolean isBlobLoaded() {
        this.writeTrace(99, "IfxBlob() : - 4");
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        this.writeTrace(99, "IfxBlob() : - 5");
        this.isBlob_loaded = true;
    }

    public void fromIfx(byte[] b) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(b, 0, this.blobDesc, 0, 56);
        byte[] bShort = new byte[2];
        byte[] bInt = new byte[4];
        System.arraycopy(b, 8, bInt, 0, 4);
        this.tb_start = IfxToJavaType.IfxToJavaInt(bInt, (short)0);
        System.arraycopy(b, 12, bInt, 0, 4);
        this.tb_end = IfxToJavaType.IfxToJavaInt(bInt, (short)0);
        this.tb_size = this.tb_end - this.tb_start + 1;
        System.arraycopy(b, 38, bShort, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(bShort, (short)0);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.createTempFile();
            this.unnullify();
        }
        this.writeTrace(99, "IfxBlob() : - 6");
    }

    public byte[] toIfx() {
        byte[] bint = new byte[4];
        bint = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(bint, 0, this.blobDesc, 16, 4);
        this.writeTrace(99, "IfxBlob() : - 7");
        return this.blobDesc;
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            memoryUtil.byfill(this.blobDesc, (byte)0);
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    public InputStream toAsciiStream() throws SQLException {
        this.writeTrace(99, "IfxBlob() : - 8");
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            this.writeTrace(99, "IfxBlob() : - 8_1");
            try {
                IfxInputStream fd = new IfxInputStream(this.tempBlobFile);
                return fd;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
        }
        this.writeTrace(99, "IfxBlob() : - 8_2");
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.blobBuffer);
        return barrayIS;
    }

    public void fromInputStream(InputStream fin, int length) throws SQLException {
        this.tb_size = length;
        this.BlobInputStream = fin instanceof IfxLobInputStream ? ((IfxLobInputStream)fin).getStream() : fin;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
        this.dumpTblob();
        this.writeTrace(99, "IfxBlob.fromInputStream() : - 1");
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.ifxType = 1;
    }

    public InputStream toBinaryStream() throws SQLException {
        this.writeTrace(99, "IfxBlob() : - 9");
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.ifxType = 0;
    }

    public String toString() {
        int size;
        FileInputStream fd;
        this.writeTrace(99, "IfxBlob() : - 10");
        if (this.tempBlobFile == null) {
            return new String(this.blobBuffer);
        }
        if (System.getProperty("java.vendor").startsWith("Netscape")) {
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            catch (Exception exception) {}
        }
        try {
            fd = new FileInputStream(this.tempBlobFile.getFileName());
            size = fd.available();
        }
        catch (Exception exception) {
            return null;
        }
        FileInputStream in = fd;
        byte[] ary = new byte[size];
        int count = 0;
        try {
            byte buf = (byte)((InputStream)in).read();
            while (buf != -1) {
                ary[count] = buf;
                ++count;
                buf = (byte)((InputStream)in).read();
            }
            fd.close();
        }
        catch (Exception exception) {
            return null;
        }
        return new String(ary);
    }

    public void fromString(String S) throws SQLException {
        this.writeTrace(99, "IfxBlob() : - 10");
        if (S == null) {
            this.tb_size = 0;
            this.blobBuffer = null;
        } else {
            this.tb_size = S.length();
            this.blobBuffer = S.getBytes();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
        this.writeTrace(99, "IfxBlob.fromString() : - 2");
    }

    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    public byte[] toBytes() throws SQLException {
        int size;
        FileInputStream fd;
        this.writeTrace(99, "IfxBlob() : - 11");
        if (this.tempBlobFile == null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (System.getProperty("java.vendor").startsWith("Netscape")) {
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            catch (Exception exception) {}
        }
        try {
            fd = new FileInputStream(this.tempBlobFile.getFileName());
            size = fd.available();
        }
        catch (Exception exception) {
            return null;
        }
        byte[] b = new byte[size];
        try {
            fd.read(b, 0, size);
            fd.close();
        }
        catch (Exception exception) {
            return null;
        }
        return b;
    }

    public void fromBytes(byte[] blobBuffer) {
        if (blobBuffer == null) {
            this.tb_size = 0;
            this.blobBuffer = null;
        } else {
            this.tb_size = blobBuffer.length;
            this.blobBuffer = blobBuffer;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.writeTrace(99, "IfxBlob.fromBytes() : - 2");
    }

    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {}
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void dumpTblob() {
        this.writeTrace(3, "    tb_size: " + this.tb_size);
        this.writeTrace(3, "    tb_flags: " + this.tb_flags);
    }

    private void createTempFile() throws SQLException {
        String fileName = String.valueOf(System.currentTimeMillis());
        fileName = String.valueOf(this.conn.getJDBCTempDir()) + "ifxb_" + fileName.substring(4);
        this.tempBlobFile = new IfxTmpFile(fileName);
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {}
    }
}

