/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private OutputStream os;
    static final int one = 1;

    public IfxDataOutputStream(OutputStream s) {
        super(s);
        this.os = s;
    }

    public final void write(int i) throws IOException {
        this.os.write(i);
        ++this.written;
    }

    public final void write(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.written += length;
    }

    public final void writePadded(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.written += length;
        if ((length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void writePadded(byte[] b) throws IOException {
        this.write(b, 0, b.length);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInt(int i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInt(i);
        this.write(b);
    }

    public final void flush() throws IOException {
        this.os.flush();
    }

    public final void writeByte(int i) throws IOException {
        this.write(i);
    }

    public final void writeBytes(String s) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxChar(s);
        this.write(b, 2, b.length - 2);
    }

    public final void writeBytes(String s, String dbEnc) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxChar(s, dbEnc);
        this.write(b, 2, b.length - 2);
    }

    public final void writeChar(String s) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxChar(s);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeChar(String s, String dbEnc) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxChar(s, dbEnc);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeChars(String s) throws IOException {
        this.writeChar(s);
    }

    public final void writeDate(Date d) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDate(d);
        this.write(b);
    }

    public final void writeDateTime(Timestamp t) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDateTime(t);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInterval(IntervalDF i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInterval(i);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInterval(IntervalYM i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInterval(i);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeDecimal(BigDecimal n) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDecimal(n);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeDouble(double d) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDouble(d);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeReal(float f) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxReal(f);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeSmallInt(short s) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxSmallInt(s);
        this.write(b);
    }

    public final void writeShort(int i) throws IOException {
        short s = (short)i;
        this.writeSmallInt(s);
    }

    public final void writeShort(short s) throws IOException {
        this.writeSmallInt(s);
    }

    public final void writeLongInt(long s) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxLongInt(s);
        this.write(b);
    }

    public final void writeLong(long s) throws IOException {
        this.writeLongInt(s);
    }
}

