/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends FilterInputStream {
    private InputStream is;
    private final int one = 1;
    private final short DEF_PREC = 0;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];

    public IfxDataInputStream(InputStream i) {
        super(i);
        this.is = i;
    }

    public final int read() throws IOException {
        return this.is.read();
    }

    public final int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public final byte readByte() throws IOException {
        int ch = this.is.read();
        return (byte)ch;
    }

    public final int readFully(byte[] b) throws IOException {
        return this.readFully(b, 0, b.length);
    }

    public final int read(byte[] b, int offset, int length) throws IOException {
        return this.is.read(b, offset, length);
    }

    public final int readFully(byte[] b, int offset, int length) throws IOException {
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (totalBytesRead < length) {
            bytesRead = this.is.read(b, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead < 0) {
                throw new IOException();
            }
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public final int readPadded(byte[] b, int offset, int length) throws IOException {
        int bytesRead = 0;
        bytesRead = this.readFully(b, offset, length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public final int readPadded(byte[] b) throws IOException {
        int bytesRead = this.readFully(b, 0, b.length);
        if ((b.length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public final int skipBytes(int n) throws IOException {
        int i = 0;
        while ((i += (int)this.is.skip(n - i)) < n) {
        }
        return n;
    }

    public final int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf, (short)0);
    }

    public final String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (length < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] b1 = new byte[length];
        int rdlen = 0;
        int offset = 0;
        int newlen = b1.length;
        rdlen = this.readFully(b1, offset, newlen);
        newlen -= rdlen;
        offset += rdlen;
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaChar(b1, (short)0);
    }

    public final String readChar(String dbEnc) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (length < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] b1 = new byte[length];
        int rdlen = 0;
        int offset = 0;
        int newlen = b1.length;
        rdlen = this.readFully(b1, offset, newlen);
        newlen -= rdlen;
        offset += rdlen;
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaChar(b1, (short)0, dbEnc);
    }

    public final Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf, (short)0);
    }

    public final Timestamp readDateTime(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (length < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(b1, prec);
    }

    public final Interval readInterval(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (length < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaInterval(b1, prec);
    }

    public final BigDecimal readDecimal(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (length < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(b1, prec);
    }

    public final double readDouble(short prec) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf, prec);
    }

    public final float readReal(short prec) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf, prec);
    }

    public final short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
    }

    public final short readShort() throws IOException {
        return this.readSmallInt();
    }

    public final long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf, (short)0);
    }

    public final long readLong() throws IOException {
        return this.readLongInt();
    }
}

