/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpBufferedOutputStream
extends BufferedOutputStream {
    private ByteArrayOutputStream os;
    private URLConnection conn;
    private URL url;
    private String id;
    private StringBuffer sendStr;
    private boolean debug = false;

    public HttpBufferedOutputStream(ByteArrayOutputStream os2, URL url, String id) {
        super(os2);
        this.os = os2;
        this.url = url;
        this.id = id;
        this.sendStr = new StringBuffer();
        this.sendStr.append("JDBC_SESSION=" + id + "&" + "JDBC_REQUEST" + "=SEND&");
    }

    public final void write(int i) throws IOException {
        this.os.write(i);
        if (this.debug) {
            this.traceOut("write(" + i + ")");
        }
    }

    public final void write(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        if (this.debug) {
            this.traceOut("write(byte b," + offset + "," + length + ")");
        }
    }

    public final void flush() throws IOException {
        String strT = null;
        if (this.debug) {
            this.traceOut("flush(): sending servlet= " + this.sendStr.toString());
        }
        if (this.debug) {
            this.traceOut("flush(): os.size= " + this.os.size());
        }
        this.openConnection(false, true, true);
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            dos.writeShort(this.sendStr.toString().length());
            dos.writeBytes(this.sendStr.toString());
            if (this.os.size() > 0) {
                this.os.writeTo(dos);
            }
            dos.close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            short len = dis.readShort();
            if (len == -1) {
                throw new IOException("Unexpected EOF error reading from proxy server.");
            }
            byte[] msgbuf = new byte[len];
            dis.readFully(msgbuf, 0, len);
            dis.close();
            strT = new String(msgbuf, 0, (int)len);
            StringTokenizer tok1 = new StringTokenizer(strT, "=");
            tok1.nextToken();
            StringTokenizer tok2 = new StringTokenizer(tok1.nextToken(), ";");
            String status = tok2.nextToken();
            String session = tok1.nextToken();
            if (this.debug) {
                this.traceOut("flush(): servlet response= " + strT);
            }
            if (!status.equals("SEND_OK") || !session.equals(this.id)) {
                throw new IOException(session);
            }
        }
        catch (IOException ioe) {
            throw new IOException(ioe.toString());
        }
        if (this.debug) {
            this.traceOut("flush(): end ");
        }
        this.os = new ByteArrayOutputStream();
    }

    private final void openConnection(boolean useCaches, boolean doOutput, boolean doInput) throws IOException {
        try {
            this.conn = this.url.openConnection();
            this.conn.setUseCaches(useCaches);
            this.conn.setRequestProperty("Content-Type", "application/binary");
            this.conn.setDoOutput(doOutput);
            this.conn.setDoInput(doInput);
        }
        catch (IOException ioe) {
            throw new IOException(ioe.toString());
        }
    }

    public final void close() throws IOException {
        if (this.debug) {
            this.traceOut("close() start ");
        }
        String strT = null;
        StringBuffer closeStr = new StringBuffer();
        closeStr.append("JDBC_SESSION=" + this.id + "&" + "JDBC_REQUEST" + "=CLOSE&");
        this.openConnection(false, true, true);
        if (this.debug) {
            this.traceOut("close() sending proxy: " + closeStr);
        }
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            dos.writeShort(closeStr.toString().length());
            dos.writeBytes(closeStr.toString());
            dos.flush();
            dos.close();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            short len = dis.readShort();
            byte[] msgbuf = new byte[len];
            dis.readFully(msgbuf, 0, len);
            dis.close();
            strT = new String(msgbuf, 0, (int)len);
            if (this.debug) {
                this.traceOut("close() received from proxy: " + strT);
            }
        }
        catch (IOException iOException) {}
    }

    private void traceOut(String msg) {
        System.out.println("HttpBufferedOutputStream: " + msg + " - data bytes= " + this.os.size());
    }
}

