/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpBufferedInputStream
extends BufferedInputStream {
    private BufferedInputStream is;
    private URLConnection conn;
    private URL url;
    private String id;
    private StringBuffer recvStr;
    private boolean debug = false;

    public HttpBufferedInputStream(InputStream i, URL url, String id) {
        super(i);
        this.url = url;
        this.id = id;
        this.recvStr = new StringBuffer();
        this.recvStr.append("JDBC_SESSION=" + id + "&" + "JDBC_REQUEST" + "=RECV&");
        this.is = new BufferedInputStream(new ByteArrayInputStream(new byte[0]));
    }

    public final int read() throws IOException {
        if (this.debug) {
            this.traceOut("read()");
        }
        int byteRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        byteRead = this.is.read();
        return byteRead;
    }

    public final int read(byte[] b) throws IOException {
        if (this.debug) {
            this.traceOut("read(byte b[])");
        }
        int bytesRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        bytesRead = this.is.read(b);
        return bytesRead;
    }

    public final int read(byte[] b, int offset, int length) throws IOException {
        if (this.debug) {
            this.traceOut("read(byte b[], " + offset + "," + length + ")");
        }
        int bytesRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        bytesRead = this.is.read(b, offset, length);
        return bytesRead;
    }

    public final int skip(int n) throws IOException {
        if (this.debug) {
            this.traceOut("skip(" + n + ")");
        }
        if (this.is.available() <= 0) {
            this.getMoreData(false, true, true);
        }
        int i = 0;
        while ((i += (int)this.is.skip(n - i)) < n) {
        }
        return n;
    }

    private final void getMoreData(boolean useCaches, boolean doOutput, boolean doInput) throws IOException {
        if (this.debug) {
            this.traceOut("getMoreData(" + useCaches + "," + doOutput + "," + doInput + ")");
        }
        short msgLen = 0;
        String strT = null;
        byte[] dataBytes = null;
        short dataLen = 0;
        try {
            this.conn = this.url.openConnection();
            this.conn.setUseCaches(useCaches);
            this.conn.setRequestProperty("Content-Type", "application/binary");
            this.conn.setDoOutput(doOutput);
            this.conn.setDoInput(doInput);
        }
        catch (IOException ioe) {
            throw new IOException(ioe.toString());
        }
        if (this.debug) {
            this.traceOut("getMoreData(): sending proxy " + this.recvStr.toString());
        }
        try {
            DataOutputStream os2 = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            os2.writeShort(this.recvStr.toString().length());
            os2.writeBytes(this.recvStr.toString());
            os2.close();
        }
        catch (IOException ioe) {
            throw new IOException(ioe.toString());
        }
        if (this.debug) {
            this.traceOut("getMoreData(): opening inputstream from proxy ");
        }
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
            msgLen = dis.readShort();
            if (msgLen == -1) {
                throw new IOException("Unexpected EOF error reading from proxy server.");
            }
            byte[] msgBytes = new byte[msgLen];
            dis.readFully(msgBytes, 0, msgLen);
            strT = new String(msgBytes, 0, (int)msgLen);
            StringTokenizer tok1 = new StringTokenizer(strT, "=");
            tok1.nextToken();
            StringTokenizer tok2 = new StringTokenizer(tok1.nextToken(), ";");
            String status = tok2.nextToken();
            String session = tok1.nextToken();
            if (this.debug) {
                this.traceOut("getMoreData(): proxy response= " + strT);
            }
            if (!status.equals("RECV_OK")) {
                if (this.debug) {
                    this.traceOut("getMoreData(): NOT RECV_OK");
                }
                throw new IOException("Error from proxy: " + session);
            }
            dataLen = dis.readShort();
            dataBytes = new byte[dataLen];
            dis.readFully(dataBytes);
            if (this.debug) {
                this.traceOut("getMoreData(): received " + dataLen + " data bytes from proxy.");
            }
            dis.close();
        }
        catch (IOException ioe) {
            if (this.debug) {
                this.traceOut("getMoreData(): throwing EXCEPTION " + ioe.toString());
            }
            throw new IOException(ioe.toString());
        }
        this.is = new BufferedInputStream(new ByteArrayInputStream(dataBytes));
    }

    private void traceOut(String msg) {
        try {
            System.out.println("HttpBufferedInputStream." + msg + ": Data length= " + this.is.available());
        }
        catch (IOException iOException) {}
    }
}

