/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.IMeasureViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.IllegalContentInfo;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class MeasureViewHandle
extends AbstractCrosstabItemHandle
implements IMeasureViewConstants,
ICrosstabConstants {
    MeasureViewHandle(DesignElementHandle handle) {
        super(handle);
    }

    public MeasureHandle getCubeMeasure() {
        return (MeasureHandle)this.handle.getElementProperty("measure");
    }

    public String getCubeMeasureName() {
        return this.handle.getStringProperty("measure");
    }

    public String getDataType() {
        MeasureHandle cubeMeasure = this.getCubeMeasure();
        return cubeMeasure == null ? null : cubeMeasure.getDataType();
    }

    PropertyHandle getAggregationsProperty() {
        return this.handle.getPropertyHandle("aggregations");
    }

    PropertyHandle getDetailProperty() {
        return this.handle.getPropertyHandle("detail");
    }

    PropertyHandle getHeaderProperty() {
        return this.handle.getPropertyHandle("header");
    }

    public AggregationCellHandle getCell() {
        PropertyHandle propHandle = this.getDetailProperty();
        return propHandle.getContentCount() == 0 ? null : (AggregationCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "AggregationCell");
    }

    public AggregationCellHandle addAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle aggregation = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (aggregation != null) {
            logger.log(Level.INFO, Messages.getString("MeasureViewHandle.info.aggregation.already.exist"));
            return aggregation;
        }
        ExtendedItemHandle aggregationCell = CrosstabExtendedItemFactory.createAggregationCell(this.moduleHandle);
        if (aggregationCell != null) {
            CommandStack stack = this.getCommandStack();
            stack.startTrans(Messages.getString("MeasureViewHandle.msg.add.aggregation"));
            try {
                aggregationCell.setProperty("aggregationOnRow", (Object)rowLevel);
                aggregationCell.setProperty("aggregationOnColumn", (Object)colLevel);
                this.getAggregationsProperty().add((DesignElementHandle)aggregationCell);
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem((DesignElementHandle)aggregationCell);
    }

    public void removeAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle cell = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (cell != null) {
            cell.handle.drop();
        }
    }

    public AggregationCellHandle getAggregationCell(String rowDimension, String rowLevel, String colDimension, String colLevel) {
        int count = this.getAggregationCount();
        if (count == 0) {
            return null;
        }
        DesignElementHandle found = null;
        int i = 0;
        while (i < count) {
            DesignElementHandle element = this.getAggregationsProperty().getContent(i);
            String row = element.getStringProperty("aggregationOnRow");
            String column = element.getStringProperty("aggregationOnColumn");
            if ((rowLevel != null && rowLevel.equals(row) || rowLevel == null && row == null) && (colLevel != null && colLevel.equals(column) || colLevel == null && column == null)) {
                found = element;
                break;
            }
            ++i;
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem(found, "AggregationCell");
    }

    public int getAggregationCount() {
        return this.getAggregationsProperty().getContentCount();
    }

    public AggregationCellHandle getAggregationCell(int index) {
        DesignElementHandle element = this.getAggregationsProperty().getContent(index);
        return (AggregationCellHandle)CrosstabUtil.getReportItem(element, "AggregationCell");
    }

    public void removeAggregation(int index) throws SemanticException {
        this.getAggregationsProperty().drop(index);
    }

    public int getIndex() {
        return this.handle.getIndex();
    }

    public CrosstabCellHandle getHeader() {
        DesignElementHandle headerCell = this.getHeaderCell();
        return (CrosstabCellHandle)(headerCell == null ? null : CrosstabUtil.getReportItem(headerCell, "CrosstabCell"));
    }

    private DesignElementHandle getHeaderCell() {
        PropertyHandle propHandle = this.getHeaderProperty();
        if (propHandle.getContentCount() <= 0) {
            return null;
        }
        return propHandle.getContent(0);
    }

    public void removeHeader() throws SemanticException {
        DesignElementHandle headerCell = this.getHeaderCell();
        if (headerCell != null) {
            headerCell.drop();
        }
    }

    public void addHeader() throws SemanticException {
        PropertyHandle propHandle = this.getHeaderProperty();
        if (propHandle.getContentCount() > 0) {
            logger.log(Level.INFO, "Measure header is set, need not add another");
            return;
        }
        ExtendedItemHandle headerCell = CrosstabExtendedItemFactory.createCrosstabCell(this.moduleHandle);
        propHandle.add((DesignElementHandle)headerCell);
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("filter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.getListValue().iterator();
    }

    private LevelHandle getInnerestLevel(CrosstabReportItemHandle crosstab, int axisType) {
        int dimCount = crosstab.getDimensionCount(axisType);
        if (dimCount > 0) {
            DimensionViewHandle dv = crosstab.getDimension(axisType, dimCount - 1);
            LevelViewHandle lv = dv.getLevel(dv.getLevelCount() - 1);
            return lv.getCubeLevel();
        }
        return null;
    }

    public CompatibilityStatus checkCompatibility() {
        IllegalContentInfo detailInfo;
        ExtendedItemHandle oldDetail;
        List detailInfoList;
        ExtendedItemHandle exhandle;
        Map illegalContents;
        CrosstabReportItemHandle crosstab = this.getCrosstab();
        if (crosstab.compStatus < 0 && (illegalContents = (exhandle = (ExtendedItemHandle)this.getModelHandle()).getIllegalContents()).containsKey("detail") && (detailInfoList = (List)illegalContents.get("detail")).size() > 0 && (oldDetail = (ExtendedItemHandle)(detailInfo = (IllegalContentInfo)detailInfoList.get(0)).getContent()) != null) {
            CompatibilityStatus status = new CompatibilityStatus();
            try {
                status.setStatusType(2);
                ExtendedItemHandle newDetail = CrosstabExtendedItemFactory.createAggregationCell(this.getModuleHandle());
                this.handle.getPropertyHandle("detail").setValue((Object)newDetail);
                Iterator itr = oldDetail.getPropertyIterator();
                while (itr.hasNext()) {
                    PropertyHandle propHandle = (PropertyHandle)itr.next();
                    String propName = propHandle.getPropertyDefn().getName();
                    if (!propHandle.isLocal() || "name".equals(propName) || "extends".equals(propName) || "extensionName".equals(propName) || "extensionVersion".equals(propName) || "content".equals(propName)) continue;
                    try {
                        oldDetail.copyPropertyTo(propName, (DesignElementHandle)newDetail);
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "The old property [" + propName + "] is not converted properly to the new Crosstab model.");
                    }
                }
                LevelHandle rowLevel = this.getInnerestLevel(crosstab, 0);
                LevelHandle columnLevel = this.getInnerestLevel(crosstab, 1);
                if (rowLevel != null) {
                    newDetail.setProperty("aggregationOnRow", (Object)rowLevel);
                }
                if (columnLevel != null) {
                    newDetail.setProperty("aggregationOnColumn", (Object)columnLevel);
                }
                List contents = oldDetail.getContents("content");
                int i = 0;
                while (i < contents.size()) {
                    ((DesignElementHandle)contents.get(i)).moveTo((DesignElementHandle)newDetail, "content");
                    ++i;
                }
            }
            catch (SemanticException e) {
                ArrayList<SemanticException> errorList = new ArrayList<SemanticException>(1);
                errorList.add(e);
                status.setErrors(errorList);
            }
            return status;
        }
        return COMP_OK_STATUS;
    }
}

