/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.logging.Logger;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.ReportItem;

public class AbstractCrosstabItemHandle
extends ReportItem
implements ICrosstabConstants {
    protected ExtendedItemHandle handle;
    protected ModuleHandle moduleHandle;
    protected static final Logger logger = Logger.getLogger(AbstractCrosstabItemHandle.class.getName());
    protected static final CompatibilityStatus COMP_OK_STATUS = new CompatibilityStatus();

    protected AbstractCrosstabItemHandle(DesignElementHandle element) {
        if (!(element instanceof ExtendedItemHandle)) {
            throw new IllegalArgumentException("the element is not valid ExtendedItemHandle!");
        }
        this.handle = (ExtendedItemHandle)element;
        this.moduleHandle = element.getModuleHandle();
    }

    public DesignElementHandle getModelHandle() {
        return this.handle;
    }

    protected IReportItem findExtendedItem(String name, String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name can not be null");
        }
        DesignElementHandle element = this.moduleHandle.findElement(name);
        return CrosstabUtil.getReportItem(element, extensionName);
    }

    public CommandStack getCommandStack() {
        return this.moduleHandle.getCommandStack();
    }

    public DesignElementHandle getCrosstabHandle() {
        ExtendedItemHandle e = this.handle;
        while (e != null) {
            if ("Crosstab".equals(e.getStringProperty("extensionName"))) {
                return e;
            }
            e = e.getContainer();
        }
        return null;
    }

    public CrosstabReportItemHandle getCrosstab() {
        return (CrosstabReportItemHandle)CrosstabUtil.getReportItem(this.getCrosstabHandle());
    }

    public AbstractCrosstabItemHandle getContainer() {
        if (this.handle != null) {
            DesignElementHandle deh = this.handle.getContainer();
            if (!(deh instanceof ExtendedItemHandle)) {
                return null;
            }
            String exName = deh.getStringProperty("extensionName");
            if ("Crosstab".equals(exName) || "CrosstabView".equals(exName) || "DimensionView".equals(exName) || "LevelView".equals(exName) || "MeasureView".equals(exName) || "ComputedMeasureView".equals(exName)) {
                try {
                    return (AbstractCrosstabItemHandle)((ExtendedItemHandle)deh).getReportItem();
                }
                catch (ExtendedElementException extendedElementException) {
                    return null;
                }
            }
        }
        return null;
    }

    public IReportItem copy() {
        return null;
    }

    public Logger getLogger() {
        return logger;
    }

    public ModuleHandle getModuleHandle() {
        return this.moduleHandle;
    }

    protected static int checkVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return -1;
        }
        if (!"2.3.0".equals(version)) {
            String[] ver = version.trim().split("\\.");
            int major = Integer.parseInt(ver[0]);
            int minor = Integer.parseInt(ver[1]);
            int update = Integer.parseInt(ver[2]);
            if (major != 2) {
                return major - 2;
            }
            if (minor != 3) {
                return minor - 3;
            }
            return update - 0;
        }
        return 0;
    }
}

