/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.IconPool;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonUI;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertySheetPanel
extends JPanel
implements PropertySheet {
    private PropertySheetTable table;
    private PropertySheetTableModel model;
    private JScrollPane tableScroll;
    private ListSelectionListener selectionListener;
    private JPanel actionPanel;
    private JToggleButton sortButton;
    private JToggleButton asCategoryButton;
    private JToggleButton descriptionButton;
    private JEditorPane descriptionPanel;
    private JScrollPane descriptionScrollPane;
    static /* synthetic */ Class class$com$l2fprod$common$propertysheet$PropertySheet;

    public PropertySheetPanel() {
        this(new PropertySheetTable());
    }

    public PropertySheetPanel(PropertySheetTable table) {
        this.buildUI();
        this.setTable(table);
    }

    public void setTable(PropertySheetTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        this.model = (PropertySheetTableModel)table.getModel();
        table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.tableScroll.getViewport().setView(table);
        this.tableScroll.getViewport().setBackground(table.getBackground());
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        }
        this.table = table;
    }

    public PropertySheetTable getTable() {
        return this.table;
    }

    public void setDescriptionVisible(boolean visible) {
        this.descriptionScrollPane.setVisible(visible);
        this.descriptionButton.setSelected(visible);
        this.revalidate();
    }

    public void setToolBarVisible(boolean visible) {
        this.actionPanel.setVisible(visible);
        this.revalidate();
    }

    public void setMode(int mode) {
        this.model.setMode(mode);
        this.asCategoryButton.setSelected(1 == mode);
    }

    public void setProperties(Property[] properties) {
        this.model.setProperties(properties);
    }

    public Property[] getProperties() {
        return this.model.getProperties();
    }

    public void addProperty(Property property) {
        this.model.addProperty(property);
    }

    public void addProperty(int index, Property property) {
        this.model.addProperty(index, property);
    }

    public void removeProperty(Property property) {
        this.model.removeProperty(property);
    }

    public int getPropertyCount() {
        return this.model.getPropertyCount();
    }

    public Iterator propertyIterator() {
        return this.model.propertyIterator();
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.setProperties(beanInfo.getPropertyDescriptors());
    }

    public void setProperties(PropertyDescriptor[] descriptors) {
        Property[] properties = new Property[descriptors.length];
        int c = descriptors.length;
        for (int i = 0; i < c; ++i) {
            properties[i] = new PropertyDescriptorAdapter(descriptors[i]);
        }
        this.model.setProperties(properties);
    }

    public void readFromObject(Object data) {
        Property[] properties = this.model.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(data);
        }
        this.repaint();
    }

    public void writeToObject(Object data) {
        Property[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].writeToObject(data);
        }
    }

    public void addPropertySheetChangeListener(PropertyChangeListener listener) {
        this.model.addPropertyChangeListener(listener);
    }

    public void removePropertySheetChangeListener(PropertyChangeListener listener) {
        this.model.removePropertyChangeListener(listener);
    }

    public final void setEditorRegistry(PropertyEditorRegistry registry) {
        this.table.setEditorRegistry(registry);
    }

    public final PropertyEditorRegistry getEditorRegistry() {
        return this.table.getEditorRegistry();
    }

    public final void setRendererRegistry(PropertyRendererRegistry registry) {
        this.table.setRendererRegistry(registry);
    }

    public final PropertyRendererRegistry getRendererRegistry() {
        return this.table.getRendererRegistry();
    }

    public void setSortingCategories(boolean value) {
        this.model.setSortingCategories(value);
    }

    public boolean isSortingCategories() {
        return this.model.isSortingCategories();
    }

    public void setSortingProperties(boolean value) {
        this.model.setSortingProperties(value);
    }

    public boolean isSortingProperties() {
        return this.model.isSortingProperties();
    }

    public void setCategorySortingComparator(Comparator comp) {
        this.model.setCategorySortingComparator(comp);
    }

    public void setPropertySortingComparator(Comparator comp) {
        this.model.setPropertySortingComparator(comp);
    }

    private void buildUI() {
        LookAndFeelTweaks.setBorderLayout(this);
        LookAndFeelTweaks.setBorder(this);
        this.actionPanel = new JPanel(new FlowLayout(0, 2, 0));
        this.actionPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.add("North", this.actionPanel);
        this.sortButton = new JToggleButton(new ToggleSortingAction());
        this.sortButton.setUI(new BlueishButtonUI());
        this.sortButton.setText(null);
        this.actionPanel.add(this.sortButton);
        this.asCategoryButton = new JToggleButton(new ToggleModeAction());
        this.asCategoryButton.setUI(new BlueishButtonUI());
        this.asCategoryButton.setText(null);
        this.actionPanel.add(this.asCategoryButton);
        this.descriptionButton = new JToggleButton(new ToggleDescriptionAction());
        this.descriptionButton.setUI(new BlueishButtonUI());
        this.descriptionButton.setText(null);
        this.actionPanel.add(this.descriptionButton);
        this.tableScroll = new JScrollPane();
        this.add("Center", this.tableScroll);
        this.descriptionPanel = new JEditorPane("text/html", "<html>");
        this.descriptionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.descriptionPanel.setEditable(false);
        this.descriptionPanel.setBackground(UIManager.getColor("Panel.background"));
        this.descriptionPanel.setPreferredSize(new Dimension(50, 50));
        LookAndFeelTweaks.htmlize(this.descriptionPanel);
        this.selectionListener = new SelectionListener();
        this.descriptionScrollPane = new JScrollPane(this.descriptionPanel);
        this.descriptionScrollPane.setBorder(LookAndFeelTweaks.addMargin(BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow"))));
        this.descriptionScrollPane.getViewport().setBackground(this.descriptionPanel.getBackground());
        this.descriptionScrollPane.setPreferredSize(new Dimension(50, 50));
        this.add("South", this.descriptionScrollPane);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ToggleSortingAction
    extends AbstractAction {
        public ToggleSortingAction() {
            super("toggleSorting", IconPool.shared().get((class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getResource("icons/sort.gif")));
            this.putValue("ShortDescription", ResourceManager.get(class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getString("PropertySheetPanel.sort.shortDescription"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertySheetPanel.this.setSortingCategories(PropertySheetPanel.this.sortButton.isSelected());
            PropertySheetPanel.this.setSortingProperties(PropertySheetPanel.this.sortButton.isSelected());
        }
    }

    class ToggleDescriptionAction
    extends AbstractAction {
        public ToggleDescriptionAction() {
            super("toggleDescription", IconPool.shared().get((class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getResource("icons/description.gif")));
            this.putValue("ShortDescription", ResourceManager.get(class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getString("PropertySheetPanel.description.shortDescription"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertySheetPanel.this.setDescriptionVisible(PropertySheetPanel.this.descriptionButton.isSelected());
        }
    }

    class ToggleModeAction
    extends AbstractAction {
        public ToggleModeAction() {
            super("toggle", IconPool.shared().get((class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getResource("icons/category.gif")));
            this.putValue("ShortDescription", ResourceManager.get(class$com$l2fprod$common$propertysheet$PropertySheet == null ? (class$com$l2fprod$common$propertysheet$PropertySheet = PropertySheetPanel.class$("com.l2fprod.common.propertysheet.PropertySheet")) : class$com$l2fprod$common$propertysheet$PropertySheet).getString("PropertySheetPanel.category.shortDescription"));
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertySheetPanel.this.asCategoryButton.isSelected()) {
                PropertySheetPanel.this.model.setMode(1);
            } else {
                PropertySheetPanel.this.model.setMode(0);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = PropertySheetPanel.this.table.getSelectedRow();
            if (row >= 0 && PropertySheetPanel.this.table.getRowCount() > row) {
                Object o = PropertySheetPanel.this.model.getPropertySheetElement(row);
                if (o instanceof Property) {
                    Property prop = (Property)o;
                    PropertySheetPanel.this.descriptionPanel.setText("<html><b>" + (prop.getDisplayName() == null ? "" : prop.getDisplayName()) + "</b><br>" + (prop.getShortDescription() == null ? "" : prop.getShortDescription()));
                } else {
                    PropertySheetPanel.this.descriptionPanel.setText("<html>");
                }
            } else {
                PropertySheetPanel.this.descriptionPanel.setText("<html>");
            }
            PropertySheetPanel.this.descriptionPanel.setCaretPosition(0);
        }
    }
}

